/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.bpmn.model.basedata;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.util.StringUtils;
import kd.bos.workflow.bpmn.model.BaseElement;
import kd.bos.workflow.bpmn.model.Process;
import kd.bos.workflow.bpmn.model.basedata.AutoCoordinateProcessor;
import kd.bos.workflow.bpmn.model.basedata.BaseDataRecord;
import kd.bos.workflow.bpmn.model.basedata.CirculateProcessor;
import kd.bos.workflow.bpmn.model.basedata.ConditionRuleProcessor;
import kd.bos.workflow.bpmn.model.basedata.ExpireOperationProcessor;
import kd.bos.workflow.bpmn.model.basedata.IBaseDataProcessor;
import kd.bos.workflow.bpmn.model.basedata.KeyAuditProcessor;
import kd.bos.workflow.bpmn.model.basedata.MessageSendProcessor;
import kd.bos.workflow.bpmn.model.basedata.ParticipantProcessor;
import kd.bos.workflow.bpmn.model.basedata.ParticipantRangeProcessor;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.context.Context;
import kd.bos.workflow.engine.impl.db.BatchSQLInfo;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.basedata.BaseDataRefRecordManager;
import kd.bos.workflow.engine.impl.persistence.entity.design.ResourceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.ConditionalEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.ConditionalRuleEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.ConditionalRuleEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.management.DynamicConfigSchemeEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.DynamicConfigSchemeEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.management.ParticipantModelEntityImpl;
import kd.bos.workflow.engine.impl.persistence.entity.management.ProcessDefinitionEntity;
import kd.bos.workflow.engine.impl.util.BpmnModelUtil;

public class BaseDataHelper {
    private static Map<String, IBaseDataProcessor> processorMap = new HashMap<String, IBaseDataProcessor>();
    private static Log log = LogFactory.getLog(BaseDataHelper.class);

    private BaseDataHelper() {
    }

    public static void recordBaseDataRef(Process process, Long procDefId, Long schemeId) {
        try {
            CommandContext commandContext = Context.getCommandContext();
            commandContext.getBaseDataRefRecordManager().clearBaseDataRefRecord(procDefId, schemeId);
            Map<String, List<BaseDataRecord>> baseDataRecordsMap = process.getBaseData();
            for (Map.Entry<String, List<BaseDataRecord>> entry : baseDataRecordsMap.entrySet()) {
                String baseDataType = entry.getKey();
                List<BaseDataRecord> baseDataRecords = entry.getValue();
                for (BaseDataRecord baseDataRecord : baseDataRecords) {
                    IBaseDataProcessor processor = processorMap.get(baseDataType);
                    processor.process(baseDataRecord, procDefId, schemeId);
                }
            }
        }
        catch (Exception e) {
            log.warn(WfUtils.getExceptionStacktrace(e));
        }
    }

    public static void recordKeyAudit(List<Long> ids, BaseDataRecord baseDataRecord, Long procDefId, Long schemeId) {
        try {
            CommandContext commandContext = Context.getCommandContext();
            String activityId = null;
            String property = null;
            if (baseDataRecord != null) {
                activityId = baseDataRecord.getFlowElement().getId();
                property = baseDataRecord.getKey();
            }
            StringBuilder batchSql = new StringBuilder();
            batchSql.append("insert into t_wf_basedatarefrecord").append(" (fid,fprocnum,fprocdefid,fschemeid,fvalue,ftype,factivityid,fproperty)").append(" values").append(" (?,?,?,?,?,?,?,?)");
            ArrayList<Object[]> insertParamsList = new ArrayList<Object[]>(16);
            String procNum = BaseDataHelper.getProcNumByProcDefId(procDefId, commandContext);
            for (long roleId : ids) {
                BaseDataHelper.genParamsForKeyAuditBatchInsert(roleId, insertParamsList, procDefId, schemeId, activityId, property, procNum);
            }
            BatchSQLInfo batchSQLInfo = new BatchSQLInfo(batchSql.toString(), insertParamsList, 1000);
            commandContext.getBaseDataRefRecordManager().addBatchSQLInfo(batchSQLInfo);
        }
        catch (Exception e) {
            log.warn(WfUtils.getExceptionStacktrace(e));
        }
    }

    public static void recordParticipants(List<ParticipantModelEntityImpl> participants, BaseDataRecord baseDataRecord, Long procDefId, Long schemeId) {
        try {
            CommandContext commandContext = Context.getCommandContext();
            String activityId = null;
            String property = null;
            ILocaleString activityName = null;
            if (baseDataRecord != null) {
                activityId = baseDataRecord.getFlowElement().getId();
                activityName = BaseDataHelper.getActivityName(baseDataRecord.getFlowElement(), procDefId, schemeId);
                property = baseDataRecord.getKey();
            }
            ArrayList<Long> roleIds = new ArrayList<Long>(16);
            for (ParticipantModelEntityImpl participant : participants) {
                if (participant.getType() == null || !participant.getType().equals("role")) continue;
                long roleId = participant.getRoleId();
                roleIds.add(roleId);
            }
            BaseDataHelper.batchInsert(roleIds, commandContext, procDefId, schemeId, activityId, activityName, property);
        }
        catch (Exception e) {
            log.warn(WfUtils.getExceptionStacktrace(e));
        }
    }

    public static ILocaleString getActivityName(BaseElement flowElement, Long procDefId, Long schemeId) {
        ProcessDefinitionEntity procDef;
        DynamicConfigSchemeEntity scheme;
        CommandContext commandContext = Context.getCommandContext();
        Long resourceId = 0L;
        if (WfUtils.isNotEmpty(schemeId) && (scheme = (DynamicConfigSchemeEntity)commandContext.getDynamicConfigSchemeEntityManager().findById(schemeId, "jsonresourceid")) != null) {
            resourceId = scheme.getJsonResourceId();
        }
        if (WfUtils.isNotEmpty(resourceId) && (procDef = (ProcessDefinitionEntity)commandContext.getProcessDefinitionEntityManager().findById(procDefId, "resourceid")) != null) {
            resourceId = procDef.getResourceId();
        }
        if (WfUtils.isNotEmpty(resourceId)) {
            ResourceEntity resource = (ResourceEntity)commandContext.getResourceEntityManager().findById(resourceId);
            String multiKey = BpmnModelUtil.getActivityNameMultiKey(flowElement.getId());
            return BpmnModelUtil.getMultiLangFieldValueFromResource(resource, multiKey, flowElement.getName());
        }
        return new LocaleString(flowElement.getName());
    }

    public static void recordConditionRule(List<ConditionalEntity> conditionalEntities, BaseDataRecord baseDataRecord, Long procDefId, Long schemeId) {
        try {
            CommandContext commandContext = Context.getCommandContext();
            String activityId = null;
            ILocaleString activityName = null;
            String property = null;
            if (baseDataRecord != null) {
                activityId = baseDataRecord.getFlowElement().getId();
                activityName = BaseDataHelper.getActivityName(baseDataRecord.getFlowElement(), procDefId, schemeId);
                property = baseDataRecord.getKey();
            } else {
                property = "startUpCondition";
            }
            List<Long> roleIds = BaseDataHelper.getConditionRuleRoleIds(conditionalEntities);
            if (WfUtils.isEmptyForCollection(roleIds)) {
                return;
            }
            BaseDataHelper.batchInsert(roleIds, commandContext, procDefId, schemeId, activityId, activityName, property);
        }
        catch (Exception e) {
            log.warn(WfUtils.getExceptionStacktrace(e));
        }
    }

    public static List<Long> getConditionRuleRoleIds(List<ConditionalEntity> conditionalEntities) {
        ArrayList<Long> roleIds = new ArrayList<Long>(16);
        try {
            for (ConditionalEntity condEntity : conditionalEntities) {
                String value;
                List<Long> roleId;
                String operation = condEntity.getOperation();
                if ("BXWF".equals(operation) || "NBWF".equals(operation)) {
                    String value2 = condEntity.getValue();
                    List<Long> roleId2 = BaseDataHelper.getRoleId(value2);
                    if (WfUtils.isNullObject(roleId2)) continue;
                    roleIds.addAll(roleId2);
                    continue;
                }
                String paramNum = condEntity.getParamnumber();
                if (paramNum.indexOf("mc_wfRole") == -1 || WfUtils.isNullObject(roleId = BaseDataHelper.getRoleId(value = condEntity.getValue()))) continue;
                roleIds.addAll(roleId);
            }
        }
        catch (Exception e) {
            log.warn(WfUtils.getExceptionStacktrace(e));
            return Collections.emptyList();
        }
        return roleIds;
    }

    private static List<Long> getRoleId(String value) {
        ArrayList<Long> list = new ArrayList<Long>(16);
        Object obj = JSON.parse((String)value);
        String roleIdStr = null;
        if (obj instanceof JSONArray) {
            JSONArray array = (JSONArray)obj;
            for (int i = 0; i < array.size(); ++i) {
                JSONObject valueObj = array.getJSONObject(i);
                roleIdStr = (String)valueObj.get((Object)"value");
                try {
                    list.add(Long.parseLong(roleIdStr));
                    continue;
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
        }
        return list;
    }

    public static void recordBaseDataRefForStartUpCond(ConditionalRuleEntity conditionalRule, Long procDefId, Long schemeId) {
        try {
            CommandContext commandContext = Context.getCommandContext();
            ProcessDefinitionEntity procEntity = (ProcessDefinitionEntity)commandContext.getProcessDefinitionEntityManager().findById(procDefId, "key");
            String procNum = null;
            if (procEntity != null) {
                procNum = procEntity.getKey();
            }
            BaseDataRefRecordManager manager = commandContext.getBaseDataRefRecordManager();
            manager.clearSchemeCondRuleBaseDataRefRecord(procDefId, schemeId, "workflowRole");
            List<Long> roles = BaseDataHelper.getConditionRuleRoleIds(conditionalRule.getEntryentity());
            for (long role : roles) {
                String property = WfUtils.isNotEmpty(schemeId) ? "schemaCondition" : "startUpCondition";
                manager.insertBaseDataRefRecord(procDefId, schemeId, "workflowRole", role, null, property, procNum);
            }
        }
        catch (Exception e) {
            log.warn(WfUtils.getExceptionStacktrace(e));
        }
    }

    public static void deleteBaseDataRefForStartUpCond(Long procDefId, Long schemeId) {
        CommandContext commandContext = Context.getCommandContext();
        BaseDataRefRecordManager manager = commandContext.getBaseDataRefRecordManager();
        manager.clearSchemeCondRuleBaseDataRefRecord(procDefId, schemeId, "workflowRole");
    }

    public static void recordProcStartUpCondForInit(long procDefId) {
        try {
            CommandContext commandContext = Context.getCommandContext();
            BaseDataRefRecordManager bDRRManager = commandContext.getBaseDataRefRecordManager();
            ConditionalRuleEntityManager cRManager = commandContext.getConditionRuleEntityManager();
            bDRRManager.clearSchemeCondRuleBaseDataRefRecord(procDefId, 0L, "workflowRole");
            QFilter q1 = new QFilter("procdefid", "=", (Object)procDefId);
            QFilter q2 = new QFilter("type", "=", (Object)"processStartUp");
            List conRuleEntities = cRManager.findByQueryFilters(new QFilter[]{q1, q2});
            if (conRuleEntities.isEmpty()) {
                return;
            }
            ConditionalRuleEntity conRuleEntity = (ConditionalRuleEntity)conRuleEntities.get(0);
            BaseDataHelper.recordConditionRule(conRuleEntity.getEntryentity(), null, procDefId, 0L);
        }
        catch (Exception e) {
            log.warn(WfUtils.getExceptionStacktrace(e));
        }
    }

    public static void recordSchemeStartUpCondForInit(long procDefId, long schemeId) {
        try {
            CommandContext commandContext = Context.getCommandContext();
            BaseDataRefRecordManager bDRRManager = commandContext.getBaseDataRefRecordManager();
            ConditionalRuleEntityManager cRManager = commandContext.getConditionRuleEntityManager();
            DynamicConfigSchemeEntityManager dCSManager = commandContext.getDynamicConfigSchemeEntityManager();
            bDRRManager.clearSchemeCondRuleBaseDataRefRecord(procDefId, schemeId, "workflowRole");
            DynamicConfigSchemeEntity dynaEntity = (DynamicConfigSchemeEntity)dCSManager.findById(schemeId);
            long conditionId = dynaEntity.getConditionId();
            ConditionalRuleEntity conRuleEntity = (ConditionalRuleEntity)cRManager.findById(conditionId);
            if (conRuleEntity == null) {
                return;
            }
            BaseDataHelper.recordConditionRule(conRuleEntity.getEntryentity(), null, procDefId, schemeId);
        }
        catch (Exception e) {
            log.warn(WfUtils.getExceptionStacktrace(e));
        }
    }

    private static void batchInsert(List<Long> roleIds, CommandContext commandContext, Long procDefId, Long schemeId, String activityId, ILocaleString activityName, String property) {
        if (roleIds.isEmpty()) {
            return;
        }
        StringBuilder batchSql = new StringBuilder();
        batchSql.append("insert into t_wf_basedatarefrecord").append(" (fid,fprocnum,fprocdefid,fschemeid,fvalue,ftype,factivityid,factivityname,fproperty)").append(" values").append(" (?,?,?,?,?,?,?,?,?)");
        StringBuilder batchLangSql = new StringBuilder();
        batchLangSql.append("insert into t_wf_basedatarefrecord_l").append(" (fid, fpkid, flocaleid, factivityname)").append(" values").append(" (?,?,?,?)");
        ArrayList<Object[]> insertParamsList = new ArrayList<Object[]>(16);
        ArrayList<Object[]> insertLangParamsList = new ArrayList<Object[]>(16);
        String procNum = BaseDataHelper.getProcNumByProcDefId(procDefId, commandContext);
        for (long roleId : roleIds) {
            BaseDataHelper.genParamsForBatchInsert(roleId, insertParamsList, insertLangParamsList, procDefId, schemeId, activityId, activityName, property, procNum);
        }
        BatchSQLInfo batchSQLInfo = new BatchSQLInfo(batchSql.toString(), insertParamsList, 1000);
        commandContext.getBaseDataRefRecordManager().addBatchSQLInfo(batchSQLInfo);
        BatchSQLInfo batchLangSQLInfo = new BatchSQLInfo(batchLangSql.toString(), insertLangParamsList, 1000);
        commandContext.getBaseDataRefRecordManager().addBatchSQLInfo(batchLangSQLInfo);
    }

    private static void genParamsForBatchInsert(long roleId, List<Object[]> insertParamsList, List<Object[]> insertLangParamsList, Long procDefId, Long schemeId, String activityId, ILocaleString activityName, String property, String procNum) {
        long id = ORM.create().genLongId("wf_basedatarefrecord");
        procDefId = procDefId == null ? Long.valueOf(0L) : procDefId;
        schemeId = schemeId == null ? Long.valueOf(0L) : schemeId;
        activityId = activityId == null ? StringUtils.getEmpty() : activityId;
        property = property == null ? " " : property;
        procNum = procNum == null ? " " : procNum;
        Object[] paramArr = new Object[]{id, procNum, procDefId, schemeId, roleId, "workflowRole", activityId, activityName.getDefaultItem(), property};
        if (WfUtils.isNotEmpty(activityId) && WfUtils.isNotEmpty(activityName)) {
            ORM orm = ORM.create();
            for (String key : activityName.keySet()) {
                String entryId = orm.genStringId("wf_basedatarefrecord");
                Object[] langParamArr = new Object[]{id, entryId, key, WfUtils.subStringForMax((String)activityName.get((Object)key), 255)};
                insertLangParamsList.add(langParamArr);
            }
        }
        insertParamsList.add(paramArr);
    }

    private static void genParamsForKeyAuditBatchInsert(long roleId, List<Object[]> insertParamsList, Long procDefId, Long schemeId, String activityId, String property, String procNum) {
        long id = ORM.create().genLongId("wf_basedatarefrecord");
        procDefId = procDefId == null ? Long.valueOf(0L) : procDefId;
        schemeId = schemeId == null ? Long.valueOf(0L) : schemeId;
        activityId = activityId == null ? StringUtils.getEmpty() : activityId;
        property = property == null ? " " : property;
        procNum = procNum == null ? " " : procNum;
        Object[] paramArr = new Object[]{id, procNum, procDefId, schemeId, roleId, "WorkflowKeyAuditor", activityId, property};
        insertParamsList.add(paramArr);
    }

    private static String getProcNumByProcDefId(Long procDefId, CommandContext commandContext) {
        ProcessDefinitionEntity procEntity = (ProcessDefinitionEntity)commandContext.getProcessDefinitionEntityManager().findById(procDefId, "key");
        String procnum = null;
        if (procEntity != null) {
            procnum = procEntity.getKey();
        }
        return procnum;
    }

    static {
        processorMap.put("participant", new ParticipantProcessor());
        processorMap.put("conditionRule", new ConditionRuleProcessor());
        processorMap.put("circulate", new CirculateProcessor());
        processorMap.put("autoCoordinate", new AutoCoordinateProcessor());
        processorMap.put("messageSend", new MessageSendProcessor());
        processorMap.put("participantRange", new ParticipantRangeProcessor());
        processorMap.put("expireOperation", new ExpireOperationProcessor());
        processorMap.put("keyAuditor", new KeyAuditProcessor());
    }
}

