/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.bpmn.model.basedata;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.workflow.engine.ManagementService;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.service.WorkflowService;
import kd.bos.workflow.service.impl.ServiceFactory;

public class BaseDataRefRecordInitTask
extends AbstractTask {
    private Log log = LogFactory.getLog(((Object)((Object)this)).getClass());

    public void execute(RequestContext arg0, Map<String, Object> arg1) throws KDException {
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT a.FID schemeid,a.FPROCDEFID procdefid ").append("FROM t_wf_dynconfscheme a ").append("INNER JOIN t_wf_procdef b ").append("ON a.FPROCDEFID = b.FID ").append("WHERE b.FENABLE = 'enable';");
        WorkflowService wfService = (WorkflowService)ServiceFactory.getService(WorkflowService.class);
        ManagementService mService = wfService.getManagementService();
        ArrayList<DataInfo> dataInfos = new ArrayList<DataInfo>(16);
        try (DataSet ds = DB.queryDataSet((String)"InitBaseDataRefRecordCmd", (DBRoute)DBRoute.workflow, (String)sql.toString());){
            for (Row row : ds) {
                Long procDefId = (Long)row.get("procdefid");
                Long schemeId = (Long)row.get("schemeid");
                DataInfo dataInfo = new DataInfo();
                dataInfo.setProcDefId(procDefId);
                dataInfo.setSchemeId(schemeId);
                dataInfos.add(dataInfo);
            }
        }
        if (dataInfos.isEmpty()) {
            return;
        }
        int progress = 0;
        int success = 0;
        int fail = 0;
        StringBuilder failedMsg = new StringBuilder();
        int size = dataInfos.size();
        for (int i = 0; i < size; ++i) {
            String desc = String.format(ResManager.loadKDString((String)"\u521d\u59cb\u5316\u57fa\u7840\u8d44\u6599\u5f15\u7528\u6570\u636e  %1$s / %2$s", (String)"BaseDataRefRecordInitTask_0", (String)"bos-wf-engine", (Object[])new Object[0]), i + 1, size);
            progress = 100 * i / size;
            this.feedbackProgress(progress, desc, null);
            if (this.isStop()) {
                this.stop();
            }
            DataInfo dataInfo = (DataInfo)dataInfos.get(i);
            Long procDefId = dataInfo.getProcDefId();
            Long schemeId = dataInfo.getSchemeId();
            try {
                mService.initBaseDataRef(procDefId, schemeId);
                ++success;
                continue;
            }
            catch (Exception e) {
                failedMsg.append(String.format(ResManager.loadKDString((String)"\u57fa\u7840\u8d44\u6599\u5f15\u7528\u8bb0\u5f55\u521d\u59cb\u5316\u4efb\u52a1\u5931\u8d25\uff0c\u6d41\u7a0b\uff1a%1$s\uff0c\u65b9\u6848\uff1a%2$s\uff0c\u539f\u56e0\uff1a%3$s\u3002", (String)"BaseDataRefRecordInitTask_1", (String)"bos-wf-engine", (Object[])new Object[0]), procDefId, schemeId, e.getMessage()));
                this.log.warn(String.format("%s %s", procDefId, WfUtils.getExceptionStacktrace(e)));
                ++fail;
            }
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("success", success);
        result.put("failed", fail);
        result.put("failedMessage", failedMsg.toString());
        this.feedbackCustomdata(result);
    }

    private static class DataInfo {
        private Long procDefId;
        private Long schemeId;

        private DataInfo() {
        }

        public Long getProcDefId() {
            return this.procDefId;
        }

        public void setProcDefId(Long procDefId) {
            this.procDefId = procDefId;
        }

        public Long getSchemeId() {
            return this.schemeId;
        }

        public void setSchemeId(Long schemeId) {
            this.schemeId = schemeId;
        }
    }
}

