/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.bpmn.model.basedata;

import com.fasterxml.jackson.databind.JsonNode;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.workflow.bpmn.diff.util.BpmnDiffUtil;
import kd.bos.workflow.bpmn.model.ExpireOperation;
import kd.bos.workflow.bpmn.model.basedata.BaseDataHelper;
import kd.bos.workflow.bpmn.model.basedata.BaseDataRecord;
import kd.bos.workflow.bpmn.model.basedata.IBaseData;
import kd.bos.workflow.bpmn.model.basedata.IBaseDataProcessor;
import kd.bos.workflow.service.WorkflowService;
import kd.bos.workflow.service.impl.ServiceFactory;

public class ExpireOperationProcessor
implements IBaseDataProcessor {
    private static final String ROLE_ID = "roleId";

    @Override
    public void process(BaseDataRecord baseDataRecord, Long procDefId, Long schemeId) {
        IBaseData iBaseData = baseDataRecord.getBaseData();
        if (iBaseData instanceof ExpireOperation) {
            String config = ((ExpireOperation)iBaseData).getConfig();
            JsonNode configNode = BpmnDiffUtil.getNode(config);
            if (configNode == null) {
                return;
            }
            JsonNode roleIdNode = configNode.get(ROLE_ID);
            if (roleIdNode == null) {
                return;
            }
            long roleId = Long.parseLong(roleIdNode.asText());
            if (roleId == 0L) {
                return;
            }
            String acticityId = baseDataRecord.getFlowElement().getId();
            String property = baseDataRecord.getKey();
            ILocaleString activityName = BaseDataHelper.getActivityName(baseDataRecord.getFlowElement(), procDefId, schemeId);
            WorkflowService service = (WorkflowService)ServiceFactory.getService(WorkflowService.class);
            service.getManagementService().recordBaseDataRef(procDefId, schemeId, "workflowRole", roleId, acticityId, activityName, property);
        }
    }
}

