/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.bpmn.model.property;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.workflow.bpmn.graph.codec.GraphCodecUtils;
import kd.bos.workflow.bpmn.model.CancelEventDefinition;
import kd.bos.workflow.bpmn.model.ErrorEventDefinition;
import kd.bos.workflow.bpmn.model.Event;
import kd.bos.workflow.bpmn.model.EventDefinition;
import kd.bos.workflow.bpmn.model.MessageEventDefinition;
import kd.bos.workflow.bpmn.model.SequenceFlow;
import kd.bos.workflow.bpmn.model.SignalEventDefinition;
import kd.bos.workflow.bpmn.model.StartEvent;
import kd.bos.workflow.bpmn.model.TerminateEventDefinition;
import kd.bos.workflow.bpmn.model.TimerEventDefinition;
import kd.bos.workflow.bpmn.model.property.ISpecialPropertyProcessor;
import kd.bos.workflow.bpmn.model.property.SequenceFlowPropertyProcessor;
import kd.bos.workflow.bpmn.model.property.StartEventPropertyProcessor;
import org.apache.commons.beanutils.PropertyUtils;

public class SpecialPropertyUtil {
    protected static Map<Class<?>, ISpecialPropertyProcessor> processors = new HashMap();

    private SpecialPropertyUtil() {
    }

    public static Object getProperty(Object obj, String key) {
        ISpecialPropertyProcessor converter = processors.get(obj.getClass());
        if (converter != null) {
            try {
                return converter.getProperty(obj, key);
            }
            catch (Exception e) {
                return null;
            }
        }
        return SpecialPropertyUtil.getObjectProperty(obj, key);
    }

    public static Object getObjectProperty(Object obj, String key) {
        try {
            Object value = null;
            if (!PropertyUtils.isReadable((Object)obj, (String)key)) {
                if (key.indexOf(46) >= 0) {
                    Object parent;
                    String parentKey = key.substring(0, key.lastIndexOf(46));
                    if (PropertyUtils.isReadable((Object)obj, (String)parentKey) && (parent = PropertyUtils.getProperty((Object)obj, (String)parentKey)) instanceof ILocaleString) {
                        return ((ILocaleString)parent).get((Object)key.substring(key.lastIndexOf(46) + 1, key.length()));
                    }
                    return SpecialPropertyUtil.getProperty(obj, key.replaceFirst("\\w+\\.(.+)", "$1"));
                }
                throw new NoSuchMethodException(String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u6ca1\u6709\u201c%2$s\u201d\u7684\u5c5e\u6027\u3002", (String)"SpecialPropertyUtil_1", (String)"bos-wf-engine", (Object[])new Object[0]), obj.getClass(), key));
            }
            value = GraphCodecUtils.safeGetPropertyValue(obj, key);
            return value;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String getStartEventType(Event event) {
        if (event.getEventDefinitions().size() > 0) {
            EventDefinition eventDefinition = event.getEventDefinitions().get(0);
            if (eventDefinition instanceof TimerEventDefinition) {
                return "StartTimerEvent";
            }
            if (eventDefinition instanceof ErrorEventDefinition) {
                return "StartErrorEvent";
            }
            if (eventDefinition instanceof MessageEventDefinition) {
                return "StartMessageEvent";
            }
            if (eventDefinition instanceof SignalEventDefinition) {
                return "StartSignalEvent";
            }
        }
        return "StartNoneEvent";
    }

    public static String getEndEventType(Event endEvent) {
        List<EventDefinition> eventDefinitions = endEvent.getEventDefinitions();
        if (eventDefinitions.size() != 1) {
            return "EndNoneEvent";
        }
        EventDefinition eventDefinition = eventDefinitions.get(0);
        if (eventDefinition instanceof ErrorEventDefinition) {
            return "EndErrorEvent";
        }
        if (eventDefinition instanceof CancelEventDefinition) {
            return "EndCancelEvent";
        }
        if (eventDefinition instanceof TerminateEventDefinition) {
            return "EndTerminateEvent";
        }
        return "EndNoneEvent";
    }

    static {
        processors.put(StartEvent.class, new StartEventPropertyProcessor());
        processors.put(SequenceFlow.class, new SequenceFlowPropertyProcessor());
    }
}

