/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.bpmn.model.property.semantic;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.workflow.bpmn.diff.util.BpmnDiffUtil;
import kd.bos.workflow.bpmn.model.property.semantic.Semanticizer;

public class AllowNextPersonSemanticizer
implements Semanticizer {
    private String path;
    private static final String ALLOW_NEXT_PERSON_WAY_ASSIGN = "allowNextPersonWayAssign";
    private static final String ALLOW_NEXT_PERSON_SCENE = "allowNextPersonScene";
    private static final String REASSIGNPERSON = "reAssignPerson";
    private static final String SCENENEXTNODEASSIGNVALUE = "sceneNextNodeAssignValue";

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public AllowNextPersonSemanticizer(String path) {
        this.path = path;
    }

    @Override
    public String convert(String value, String elementType) {
        JsonNode valueNode = BpmnDiffUtil.getNode(value);
        JsonNode sceneNode = valueNode.get(ALLOW_NEXT_PERSON_SCENE);
        String scene = null;
        if (sceneNode != null) {
            scene = sceneNode.asText();
        }
        JsonNode wayAssignNode = valueNode.get(ALLOW_NEXT_PERSON_WAY_ASSIGN);
        String wayAssign = null;
        if (wayAssignNode != null) {
            wayAssign = wayAssignNode.asText();
        }
        JsonNode assignNodes = valueNode.get(SCENENEXTNODEASSIGNVALUE);
        String assignNode = null;
        StringBuilder nodeNameBuilder = new StringBuilder();
        if (assignNodes != null) {
            assignNode = assignNodes.asText();
            Map nextNodeObject = (Map)SerializationUtils.fromJsonString((String)assignNode, Map.class);
            for (Map.Entry entry : nextNodeObject.entrySet()) {
                String nodeName = (String)entry.getValue();
                nodeNameBuilder.append(nodeName);
                nodeNameBuilder.append("\u3001");
            }
        }
        JsonNode reAssignPersonNodes = valueNode.get(REASSIGNPERSON);
        String reAssignPerson = null;
        if (reAssignPersonNodes != null) {
            reAssignPerson = reAssignPersonNodes.asText();
            Boolean reAssignPersonFlag = Boolean.valueOf(reAssignPerson);
            reAssignPerson = reAssignPersonFlag != false ? ResManager.loadKDString((String)"\u5f00", (String)"ModelModifyLogEntityImpl_0", (String)"bos-wf-engine", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5173", (String)"ModelModifyLogEntityImpl_1", (String)"bos-wf-engine", (Object[])new Object[0]);
        }
        StringBuilder sb = new StringBuilder();
        sb.append(this.translate(ALLOW_NEXT_PERSON_SCENE)).append("\uff1a").append(this.translate(scene)).append("\n");
        if (nodeNameBuilder.length() > 0) {
            String finalNodeName = nodeNameBuilder.substring(0, nodeNameBuilder.length() - 1);
            sb.append(finalNodeName);
            sb.append("\n");
        }
        sb.append(this.translate(ALLOW_NEXT_PERSON_WAY_ASSIGN)).append("\uff1a").append(this.translate(wayAssign));
        sb.append("\n");
        if (reAssignPerson != null) {
            sb.append(this.translate(REASSIGNPERSON)).append("\uff1a").append(this.translate(reAssignPerson));
        }
        return sb.toString();
    }

    @Override
    public String translate(String prop) {
        if (prop == null) {
            return null;
        }
        switch (prop) {
            case "allowNextPersonScene": {
                return ResManager.loadKDString((String)"\u573a\u666f", (String)"AllowNextPersonSemanticizer_6", (String)"bos-wf-engine", (Object[])new Object[0]);
            }
            case "allowNextPersonWayAssign": {
                return ResManager.loadKDString((String)"\u65b9\u5f0f", (String)"AllowNextPersonSemanticizer_7", (String)"bos-wf-engine", (Object[])new Object[0]);
            }
            case "only": {
                return ResManager.loadKDString((String)"\u4ec5\u4e0b\u4e00\u6b65\u8282\u70b9", (String)"AllowNextPersonSemanticizer_0", (String)"bos-wf-engine", (Object[])new Object[0]);
            }
            case "assign": {
                return ResManager.loadKDString((String)"\u540e\u7eed\u8282\u70b9\uff08\u4ec5\u652f\u6301PC\u7aef\uff09", (String)"AllowNextPersonSemanticizer_1", (String)"bos-wf-engine", (Object[])new Object[0]);
            }
            case "allow": {
                return ResManager.loadKDString((String)"\u603b\u662f\u6307\u5b9a", (String)"AllowNextPersonSemanticizer_2", (String)"bos-wf-engine", (Object[])new Object[0]);
            }
            case "empty": {
                return ResManager.loadKDString((String)"\u53c2\u4e0e\u4eba\u4e3a\u7a7a\u65f6\u6307\u5b9a", (String)"AllowNextPersonSemanticizer_3", (String)"bos-wf-engine", (Object[])new Object[0]);
            }
            case "mul": {
                return ResManager.loadKDString((String)"\u53c2\u4e0e\u4eba\u662f\u591a\u4eba\u65f6\u6307\u5b9a", (String)"AllowNextPersonSemanticizer_4", (String)"bos-wf-engine", (Object[])new Object[0]);
            }
            case "multiorempty": {
                return ResManager.loadKDString((String)"\u53c2\u4e0e\u4eba\u662f\u591a\u4eba\u6216\u4e3a\u7a7a\u65f6\u6307\u5b9a", (String)"AllowNextPersonSemanticizer_5", (String)"bos-wf-engine", (Object[])new Object[0]);
            }
            case "reAssignPerson": {
                return ResManager.loadKDString((String)"\u518d\u6b21\u8fdb\u5165\u672c\u8282\u70b9\u65e0\u9700\u6307\u5b9a\u4e0b\u4e00\u6b65\uff08\u540e\u7eed\uff09\u8282\u70b9\u53c2\u4e0e\u4eba", (String)"AllowNextPersonSemanticizer_8", (String)"bos-wf-engine", (Object[])new Object[0]);
            }
        }
        return prop;
    }
}

