/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.bpmn.model.property.semantic;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.Iterator;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.workflow.bpmn.diff.util.BpmnDiffUtil;
import kd.bos.workflow.bpmn.model.property.semantic.Semanticizer;
import kd.bos.workflow.engine.WfUtils;

public class AuditCommentsSemanticizer
implements Semanticizer {
    private String path;
    private static final String DECISION = "decision";
    private static final String CONTENT = "content";

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public AuditCommentsSemanticizer(String path) {
        this.path = path;
    }

    @Override
    public String convert(String value, String elementType) {
        String showValue;
        JsonNode valueNode = BpmnDiffUtil.getNode(value);
        StringBuilder sb = new StringBuilder();
        if (valueNode != null && valueNode.isArray()) {
            Iterator valueIt = valueNode.iterator();
            int size = valueNode.size();
            int index = 0;
            while (valueIt.hasNext()) {
                JsonNode auditCommentsNode = (JsonNode)valueIt.next();
                JsonNode decisionNode = auditCommentsNode.get(DECISION);
                String decision = null;
                if (decisionNode != null) {
                    decision = decisionNode.asText();
                }
                JsonNode contentNode = auditCommentsNode.get(CONTENT);
                String content = null;
                if (contentNode != null) {
                    content = contentNode.asText();
                }
                sb.append(this.translate(DECISION)).append("\uff1a").append(this.translate(decision)).append("\uff1b").append(this.translate(CONTENT)).append("\uff1a").append(content).append("\uff1b");
                if (index++ == size - 1) continue;
                sb.append("\n");
            }
        }
        return WfUtils.isEmpty(showValue = sb.toString()) ? value : showValue;
    }

    @Override
    public String translate(String prop) {
        if (prop == null) {
            return null;
        }
        switch (prop) {
            case "decision": {
                return ResManager.loadKDString((String)"\u51b3\u7b56\u9879", (String)"AuditCommentsSemanticizer_0", (String)"bos-wf-engine", (Object[])new Object[0]);
            }
            case "content": {
                return ResManager.loadKDString((String)"\u5ba1\u6279\u610f\u89c1", (String)"AuditCommentsSemanticizer_1", (String)"bos-wf-engine", (Object[])new Object[0]);
            }
            case "Consent": {
                return ResManager.loadKDString((String)"\u540c\u610f", (String)"AuditCommentsSemanticizer_2", (String)"bos-wf-engine", (Object[])new Object[0]);
            }
            case "Reject": {
                return ResManager.loadKDString((String)"\u9a73\u56de", (String)"AuditCommentsSemanticizer_3", (String)"bos-wf-engine", (Object[])new Object[0]);
            }
        }
        return prop;
    }
}

