/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.bpmn.model.property.semantic;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.Iterator;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.workflow.bpmn.diff.util.BpmnDiffUtil;
import kd.bos.workflow.bpmn.model.property.semantic.Semanticizer;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.util.ModelModifyLogUtils;

public class AuditPointSemanticizer
implements Semanticizer {
    private String path;
    private static final String TYPE = "type";
    private static final String RULE = "rule";
    private static final String DISPLAYNAME = "displayname";
    private static final String INSTRUCTION = "instruction";

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public AuditPointSemanticizer(String path) {
        this.path = path;
    }

    @Override
    public String convert(String value, String elementType) {
        String showValue;
        JsonNode valueNode = BpmnDiffUtil.getNode(value);
        StringBuilder sb = new StringBuilder();
        if (valueNode != null && valueNode.isArray()) {
            Iterator valueIt = valueNode.iterator();
            int size = valueNode.size();
            int index = 0;
            while (valueIt.hasNext()) {
                JsonNode auditPointNode = (JsonNode)valueIt.next();
                JsonNode typeNode = auditPointNode.get(TYPE);
                String type = null;
                if (typeNode != null) {
                    type = typeNode.asText();
                }
                JsonNode ruleNode = auditPointNode.get(RULE);
                String ruleExpression = ModelModifyLogUtils.getRuleExpression(ruleNode);
                JsonNode displayNameNode = auditPointNode.get(DISPLAYNAME);
                String displayName = null;
                if (displayNameNode != null) {
                    displayName = displayNameNode.asText();
                }
                JsonNode instructionNode = auditPointNode.get(INSTRUCTION);
                String instruction = null;
                if (instructionNode != null) {
                    instruction = instructionNode.asText();
                }
                sb.append(this.translate(TYPE)).append("\uff1a").append(this.translate(type)).append("\uff1b").append(this.translate(RULE)).append("\uff1a").append(ruleExpression).append("\uff1b").append(this.translate(DISPLAYNAME)).append("\uff1a").append(displayName).append("\uff1b").append(this.translate(INSTRUCTION)).append("\uff1a").append(instruction).append("\uff1b");
                if (index++ == size - 1) continue;
                sb.append("\n");
            }
        }
        return WfUtils.isEmpty(showValue = sb.toString()) ? value : showValue;
    }

    @Override
    public String translate(String prop) {
        if (prop == null) {
            return null;
        }
        switch (prop) {
            case "type": {
                return ResManager.loadKDString((String)"\u7c7b\u578b", (String)"AuditPointSemanticizer_0", (String)"bos-wf-engine", (Object[])new Object[0]);
            }
            case "rule": {
                return ResManager.loadKDString((String)"\u6761\u4ef6", (String)"AuditPointSemanticizer_1", (String)"bos-wf-engine", (Object[])new Object[0]);
            }
            case "displayname": {
                return ResManager.loadKDString((String)"\u663e\u793a\u540d\u79f0", (String)"AuditPointSemanticizer_2", (String)"bos-wf-engine", (Object[])new Object[0]);
            }
            case "instruction": {
                return ResManager.loadKDString((String)"\u8be6\u7ec6\u8bf4\u660e", (String)"AuditPointSemanticizer_3", (String)"bos-wf-engine", (Object[])new Object[0]);
            }
            case "textreminder": {
                return ResManager.loadKDString((String)"\u6587\u5b57\u63d0\u793a", (String)"AuditPointSemanticizer_4", (String)"bos-wf-engine", (Object[])new Object[0]);
            }
            case "automaticchecks": {
                return ResManager.loadKDString((String)"\u81ea\u52a8\u68c0\u67e5\u9879", (String)"AuditPointSemanticizer_5", (String)"bos-wf-engine", (Object[])new Object[0]);
            }
            case "manualchecks": {
                return ResManager.loadKDString((String)"\u624b\u52a8\u68c0\u67e5\u9879", (String)"AuditPointSemanticizer_6", (String)"bos-wf-engine", (Object[])new Object[0]);
            }
        }
        return prop;
    }
}

