/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.bpmn.model.property.semantic;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.Iterator;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.workflow.bpmn.diff.util.BpmnDiffUtil;
import kd.bos.workflow.bpmn.model.property.semantic.Semanticizer;
import kd.bos.workflow.engine.WfUtils;

public class BackNodeSemanticizer
implements Semanticizer {
    private String path;
    private static final String ERRORCODE = "errorcode";
    private static final String BACKNODENAME = "backnodename";
    private static final String BACKNODE = "backnode";
    private static final String RETRY = "retry";

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public BackNodeSemanticizer(String path) {
        this.path = path;
    }

    @Override
    public String convert(String value, String elementType) {
        String showValue;
        JsonNode valueNode = BpmnDiffUtil.getNode(value);
        StringBuilder sb = new StringBuilder();
        if (valueNode != null && valueNode.isArray()) {
            Iterator valueIt = valueNode.iterator();
            int size = valueNode.size();
            int index = 0;
            while (valueIt.hasNext()) {
                JsonNode backNode = (JsonNode)valueIt.next();
                JsonNode errorCodeNode = backNode.get(ERRORCODE);
                String errorCode = null;
                if (errorCodeNode != null) {
                    errorCode = errorCodeNode.asText();
                }
                JsonNode backNodeNameNode = backNode.get(BACKNODENAME);
                String backNodeName = null;
                if (backNodeNameNode != null) {
                    backNodeName = backNodeNameNode.asText();
                }
                JsonNode backNodeNode = backNode.get(BACKNODE);
                String val = null;
                if (backNodeNode != null) {
                    val = backNodeNode.asText();
                }
                JsonNode retryNode = backNode.get(RETRY);
                boolean retry = true;
                if (retryNode != null) {
                    retry = retryNode.asBoolean();
                }
                sb.append(this.translate(ERRORCODE)).append("\uff1a").append(errorCode).append("\uff1b").append(this.translate(BACKNODENAME)).append("\uff1a").append(backNodeName).append("\uff1b").append(this.translate(BACKNODE)).append("\uff1a").append(val).append("\uff1b").append(this.translate(RETRY)).append("\uff1a").append(retry).append("\uff1b");
                if (index++ == size - 1) continue;
                sb.append("\n");
            }
        }
        return WfUtils.isEmpty(showValue = sb.toString()) ? value : showValue;
    }

    @Override
    public String translate(String prop) {
        if (prop == null) {
            return null;
        }
        switch (prop) {
            case "errorcode": {
                return ResManager.loadKDString((String)"\u5f53\u5f02\u5e38\u53d1\u751f\u65f6", (String)"BackNodeSemanticizer_0", (String)"bos-wf-engine", (Object[])new Object[0]);
            }
            case "backnodename": {
                return ResManager.loadKDString((String)"\u56de\u9000\u5230\u6b64\u8282\u70b9", (String)"BackNodeSemanticizer_1", (String)"bos-wf-engine", (Object[])new Object[0]);
            }
            case "backnode": {
                return ResManager.loadKDString((String)"\u56de\u9000\u5230\u6b64\u8282\u70b9\u7f16\u7801", (String)"BackNodeSemanticizer_2", (String)"bos-wf-engine", (Object[])new Object[0]);
            }
            case "retry": {
                return ResManager.loadKDString((String)"\u91cd\u8bd5\u4e09\u6b21\u540e\u518d\u6267\u884c\u8865\u507f", (String)"BackNodeSemanticizer_3", (String)"bos-wf-engine", (Object[])new Object[0]);
            }
        }
        return prop;
    }
}

