/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.bpmn.model.property.semantic;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.Iterator;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.workflow.bpmn.diff.util.BpmnDiffUtil;
import kd.bos.workflow.bpmn.model.property.semantic.Semanticizer;
import kd.bos.workflow.engine.WfUtils;

public class BillExceptionOpSemanticizer
implements Semanticizer {
    private String path;
    private static final String OPERNAME = "opername";
    private static final String PROCACTION = "procaction";

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public BillExceptionOpSemanticizer(String path) {
        this.path = path;
    }

    @Override
    public String convert(String value, String elementType) {
        String showValue;
        JsonNode valueNode = BpmnDiffUtil.getNode(value);
        StringBuilder sb = new StringBuilder();
        if (valueNode != null && valueNode.isArray()) {
            Iterator valueIt = valueNode.iterator();
            int size = valueNode.size();
            int index = 0;
            while (valueIt.hasNext()) {
                JsonNode billExcNode = (JsonNode)valueIt.next();
                JsonNode operNameNode = billExcNode.get(OPERNAME);
                JsonNode procactionNode = billExcNode.get(PROCACTION);
                if (operNameNode == null || procactionNode == null) continue;
                String operName = operNameNode.asText();
                String procAction = procactionNode.asText();
                sb.append(this.translate(OPERNAME)).append("\uff1a").append(operName).append("\uff1b");
                sb.append(this.translate(PROCACTION)).append("\uff1a").append(this.translate(procAction));
                if (index++ == size - 1) continue;
                sb.append("\n");
            }
        }
        return WfUtils.isEmpty(showValue = sb.toString()) ? value : showValue;
    }

    @Override
    public String translate(String prop) {
        switch (prop) {
            case "opername": {
                return ResManager.loadKDString((String)"\u975e\u6b63\u5e38\u5916\u90e8\u64cd\u4f5c", (String)"BillExceptionOpSemanticizer_0", (String)"bos-wf-engine", (Object[])new Object[0]);
            }
            case "procaction": {
                return ResManager.loadKDString((String)"\u6d41\u7a0b\u52a8\u4f5c", (String)"BillExceptionOpSemanticizer_1", (String)"bos-wf-engine", (Object[])new Object[0]);
            }
            case "terminate": {
                return ResManager.loadKDString((String)"\u6d41\u7a0b\u7ec8\u6b62", (String)"BillExceptionOpSemanticizer_2", (String)"bos-wf-engine", (Object[])new Object[0]);
            }
            case "processdelete": {
                return ResManager.loadKDString((String)"\u6d41\u7a0b\u5220\u9664", (String)"BillExceptionOpSemanticizer_3", (String)"bos-wf-engine", (Object[])new Object[0]);
            }
        }
        return prop;
    }
}

