/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.bpmn.model.property.semantic;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Iterator;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.workflow.bpmn.diff.util.BpmnDiffUtil;
import kd.bos.workflow.bpmn.model.property.semantic.Semanticizer;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.util.ParticipantHelper;

public class CirculateSemanticizer
implements Semanticizer {
    private String path;
    private static final String SHOW_TEXT = "showtext";
    private static final String TRIGGER = "trigger";
    private static final String PARTICIPANT = "participant";
    private static final String RADIOGROUP_PARTICIPANT = "radiogroup_participant";
    private static final String START = "start";
    private static final String END = "end";
    private static final String TYPE = "type";
    private static final String CONDRULE = "condrule";
    private static final String EXPRESSION = "expression";
    private static final String ALL = "all";
    private static final String CONDITION = "condition";

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public CirculateSemanticizer(String path) {
        this.path = path;
    }

    @Override
    public String convert(String value, String elementType) {
        String lang;
        JsonNode showTextValue;
        JsonNode circulateNode = BpmnDiffUtil.getNode(value);
        StringBuilder sb = new StringBuilder();
        JsonNode showTextNode = circulateNode.get(SHOW_TEXT);
        String showText = null;
        if (showTextNode != null && (showTextValue = showTextNode.get(lang = RequestContext.get().getLang().toString())) != null) {
            showText = showTextValue.asText();
        }
        JsonNode triggerNode = circulateNode.get(TRIGGER);
        String trigger = null;
        if (triggerNode != null) {
            trigger = triggerNode.asText();
        }
        JsonNode participantNode = circulateNode.get(PARTICIPANT);
        StringBuilder partsb = new StringBuilder();
        if (participantNode != null && participantNode.isArray()) {
            Iterator pvalueIt = participantNode.iterator();
            int psize = participantNode.size();
            int pindex = 0;
            while (pvalueIt.hasNext()) {
                JsonNode pNode = (JsonNode)pvalueIt.next();
                String pshowText = this.resolveParticipant(pNode);
                partsb.append(pshowText);
                if (pindex++ == psize - 1) continue;
                partsb.append("\n");
            }
        }
        String participantStr = partsb.toString();
        JsonNode radioNode = circulateNode.get(RADIOGROUP_PARTICIPANT);
        String radio = null;
        if (radioNode != null) {
            radio = radioNode.asText();
        }
        sb.append(this.translate(SHOW_TEXT)).append("\uff1a").append(showText).append("\uff1b").append(this.translate(TRIGGER)).append("\uff1a").append(this.translate(trigger)).append("\uff1b").append(this.translate(PARTICIPANT)).append("\uff1a").append(participantStr).append("\uff1b").append(this.translate(RADIOGROUP_PARTICIPANT)).append("\uff1a").append(this.translate(radio)).append("\uff1b");
        String showValue = sb.toString();
        return WfUtils.isEmpty(showValue) ? value : showValue;
    }

    @Override
    public String translate(String prop) {
        if (prop == null) {
            return null;
        }
        if ("properties.circulateModel.circulate".equals(this.path)) {
            return this.translateForCircluate(prop);
        }
        if ("properties.autoCoordinateModel.autoCoordinate".equals(this.path)) {
            return this.translateForAutoCoordinate(prop);
        }
        return prop;
    }

    private String translateForCircluate(String prop) {
        switch (prop) {
            case "showtext": {
                return ResManager.loadKDString((String)"\u663e\u793a\u6587\u5b57", (String)"CirculateSemanticizer_0", (String)"bos-wf-engine", (Object[])new Object[0]);
            }
            case "trigger": {
                return ResManager.loadKDString((String)"\u89e6\u53d1\u65f6\u673a", (String)"CirculateSemanticizer_1", (String)"bos-wf-engine", (Object[])new Object[0]);
            }
            case "participant": {
                return ResManager.loadKDString((String)"\u53c2\u4e0e\u4eba", (String)"CirculateSemanticizer_2", (String)"bos-wf-engine", (Object[])new Object[0]);
            }
            case "radiogroup_participant": {
                return ResManager.loadKDString((String)"\u4efb\u52a1\u4f1a\u4f20\u9605\u7ed9\u54ea\u4e9b\u4eba", (String)"CirculateSemanticizer_3", (String)"bos-wf-engine", (Object[])new Object[0]);
            }
            case "start": {
                return ResManager.loadKDString((String)"\u6b63\u5e38\u8fdb\u5165\u65f6", (String)"CirculateSemanticizer_4", (String)"bos-wf-engine", (Object[])new Object[0]);
            }
            case "end": {
                return ResManager.loadKDString((String)"\u79bb\u5f00\u8282\u70b9\u65f6", (String)"CirculateSemanticizer_5", (String)"bos-wf-engine", (Object[])new Object[0]);
            }
            case "all": {
                return ResManager.loadKDString((String)"\u6240\u6709\u53c2\u4e0e\u4eba\u90fd\u4f1a\u6536\u5230\u4f20\u9605\u4fe1\u606f", (String)"CirculateSemanticizer_6", (String)"bos-wf-engine", (Object[])new Object[0]);
            }
            case "condition": {
                return ResManager.loadKDString((String)"\u5f53\u6ee1\u8db3\u6761\u4ef6\u65f6\u4f20\u9605\u7ed9\u5bf9\u5e94\u7684\u53c2\u4e0e\u4eba", (String)"CirculateSemanticizer_7", (String)"bos-wf-engine", (Object[])new Object[0]);
            }
        }
        return prop;
    }

    private String translateForAutoCoordinate(String prop) {
        switch (prop) {
            case "showtext": {
                return ResManager.loadKDString((String)"\u663e\u793a\u6587\u5b57", (String)"CirculateSemanticizer_0", (String)"bos-wf-engine", (Object[])new Object[0]);
            }
            case "trigger": {
                return ResManager.loadKDString((String)"\u89e6\u53d1\u65f6\u673a", (String)"CirculateSemanticizer_1", (String)"bos-wf-engine", (Object[])new Object[0]);
            }
            case "participant": {
                return ResManager.loadKDString((String)"\u53c2\u4e0e\u4eba", (String)"CirculateSemanticizer_2", (String)"bos-wf-engine", (Object[])new Object[0]);
            }
            case "radiogroup_participant": {
                return ResManager.loadKDString((String)"\u4efb\u52a1\u4f1a\u534f\u529e\u7ed9\u54ea\u4e9b\u4eba", (String)"CirculateSemanticizer_8", (String)"bos-wf-engine", (Object[])new Object[0]);
            }
            case "start": {
                return ResManager.loadKDString((String)"\u6b63\u5e38\u8fdb\u5165\u65f6", (String)"CirculateSemanticizer_4", (String)"bos-wf-engine", (Object[])new Object[0]);
            }
            case "end": {
                return ResManager.loadKDString((String)"\u79bb\u5f00\u8282\u70b9\u65f6", (String)"CirculateSemanticizer_5", (String)"bos-wf-engine", (Object[])new Object[0]);
            }
            case "all": {
                return ResManager.loadKDString((String)"\u6240\u6709\u53c2\u4e0e\u4eba\u90fd\u4f1a\u6536\u5230\u534f\u529e\u4efb\u52a1", (String)"CirculateSemanticizer_9", (String)"bos-wf-engine", (Object[])new Object[0]);
            }
            case "condition": {
                return ResManager.loadKDString((String)"\u5f53\u6ee1\u8db3\u6761\u4ef6\u65f6\u534f\u529e\u7ed9\u5bf9\u5e94\u7684\u53c2\u4e0e\u4eba", (String)"CirculateSemanticizer_10", (String)"bos-wf-engine", (Object[])new Object[0]);
            }
        }
        return prop;
    }

    private String resolveParticipant(JsonNode participantNode) {
        JsonNode expressionNode;
        StringBuilder sb = new StringBuilder();
        JsonNode typeNode = participantNode.get(TYPE);
        String type = null;
        if (typeNode != null) {
            type = typeNode.asText();
        }
        String prefix = ParticipantHelper.receiverPrefix(type);
        ObjectMapper mapper = new ObjectMapper();
        Map valueMap = (Map)mapper.convertValue((Object)participantNode, Map.class);
        String participant = ParticipantHelper.getTextFromParams(valueMap);
        sb.append(prefix).append(participant);
        String expression = null;
        JsonNode condruleNode = participantNode.get(CONDRULE);
        if (condruleNode != null && (expressionNode = condruleNode.get(EXPRESSION)) != null) {
            expression = expressionNode.asText();
            sb.append(ResManager.loadKDString((String)"\uff1b\u6761\u4ef6\uff1a", (String)"ParticipantSemanticizer_0", (String)"bos-wf-engine", (Object[])new Object[0])).append(expression);
        }
        return sb.toString();
    }
}

