/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.bpmn.model.property.semantic;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.workflow.bpmn.model.property.semantic.Semanticizer;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.extitf.ExternalInterfaceUtil;
import kd.bos.workflow.engine.impl.model.ServiceInfo;
import kd.bos.workflow.engine.impl.util.AutoTaskUtil;

public class CompensateOperationsSemanticizer
implements Semanticizer {
    private String path;

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public CompensateOperationsSemanticizer(String path) {
        this.path = path;
    }

    @Override
    public String convert(String value, String elementType) {
        JSONArray jsonArray = JSON.parseArray((String)value);
        if (jsonArray == null || jsonArray.isEmpty()) {
            return value;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < jsonArray.size(); ++i) {
            Object obj = jsonArray.get(i);
            if (obj instanceof JSONObject) {
                ServiceInfo info;
                JSONObject jsonObj = (JSONObject)obj;
                String errorCode = jsonObj.getString("errorcode");
                sb.append(this.translate("errorcode")).append(":").append(errorCode).append("\uff1b");
                Object operation = jsonObj.get((Object)"operation");
                if (operation instanceof String && (info = AutoTaskUtil.getServiceInfoFromString((String)operation)) != null) {
                    String extItf = info.getExtItf();
                    if ("operation".equals(info.getType())) {
                        HashMap<String, Object> m = ExternalInterfaceUtil.castJSONToMap(ExternalInterfaceUtil.getExtItfValue(extItf));
                        Object number = m.get("forward");
                        Object name = m.get("forward_name");
                        sb.append(name).append("(").append(number).append(")");
                    } else {
                        Map valMap;
                        Object params;
                        sb.append(ExternalInterfaceUtil.getFormattedShowValue(extItf));
                        if ("class".equals(info.getType()) && (params = (valMap = (Map)SerializationUtils.fromJsonString((String)extItf, Map.class)).get("params")) instanceof List) {
                            for (Map item : (List)params) {
                                String numberDesc = ResManager.loadKDString((String)"\uff1b\u53c2\u6570\u7f16\u7801\uff1a", (String)"CompensateOperationsSemanticizer_0", (String)"bos-wf-engine", (Object[])new Object[0]);
                                String typeDesc = ResManager.loadKDString((String)"\uff1b\u53c2\u6570\u7c7b\u578b\uff1a", (String)"CompensateOperationsSemanticizer_1", (String)"bos-wf-engine", (Object[])new Object[0]);
                                String valDesc = ResManager.loadKDString((String)"\uff1b\u53c2\u6570\u503c\uff1a", (String)"CompensateOperationsSemanticizer_2", (String)"bos-wf-engine", (Object[])new Object[0]);
                                sb.append(numberDesc).append(item.get("number")).append(typeDesc).append(item.get("type")).append(valDesc).append(item.get("value"));
                                Object pName = item.get("name");
                                if (!(pName instanceof Map)) continue;
                                String nameDesc = ResManager.loadKDString((String)"\uff1b\u53c2\u6570\u540d\u79f0\uff1a", (String)"CompensateOperationsSemanticizer_3", (String)"bos-wf-engine", (Object[])new Object[0]);
                                sb.append(nameDesc).append(((Map)pName).get("zh_CN"));
                            }
                        }
                    }
                }
            }
            if (i == jsonArray.size() - 1) continue;
            sb.append("\n");
        }
        String showValue = sb.toString();
        return WfUtils.isEmpty(showValue) ? value : showValue;
    }

    @Override
    public String translate(String prop) {
        return ResManager.loadKDString((String)"\u5f53\u5f02\u5e38\u53d1\u751f\u65f6", (String)"BackNodeSemanticizer_0", (String)"bos-wf-engine", (Object[])new Object[0]);
    }
}

