/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.bpmn.model.property.semantic;

import com.fasterxml.jackson.databind.JsonNode;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.workflow.bpmn.diff.util.BpmnDiffUtil;
import kd.bos.workflow.bpmn.model.property.semantic.Semanticizer;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.util.ModelModifyLogUtils;

public class CustomClassNameSemanticizer
implements Semanticizer {
    private String path;
    private static final String TYPE = "type";
    private static final String VALUE = "value";
    private static final String NUMBER = "number";

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public CustomClassNameSemanticizer(String path) {
        this.path = path;
    }

    @Override
    public String convert(String value, String elementType) {
        if (!ModelModifyLogUtils.isJsonStr(value)) {
            return value;
        }
        JsonNode valueNode = BpmnDiffUtil.getNode(value);
        StringBuilder sb = new StringBuilder();
        JsonNode typeNode = valueNode.get(TYPE);
        String type = null;
        if (typeNode != null) {
            type = typeNode.asText();
        }
        JsonNode valNode = valueNode.get(VALUE);
        String val = null;
        if (valNode != null) {
            if (valNode.isObject()) {
                JsonNode numberNode = valNode.get(NUMBER);
                if (numberNode != null) {
                    val = numberNode.asText();
                }
            } else {
                val = valNode.asText();
            }
        }
        sb.append(this.translate(TYPE)).append("\uff1a").append(this.translate(type)).append("\uff1b").append(this.translate(VALUE)).append("\uff1a").append(val).append("\uff1b");
        String showValue = sb.toString();
        return WfUtils.isEmpty(showValue) ? value : showValue;
    }

    @Override
    public String translate(String prop) {
        if (WfUtils.isEmpty(prop)) {
            return null;
        }
        switch (prop) {
            case "type": {
                return ResManager.loadKDString((String)"\u7c7b\u578b", (String)"FlowRecordFormatterSemanticizer_0", (String)"bos-wf-engine", (Object[])new Object[0]);
            }
            case "value": {
                return ResManager.loadKDString((String)"\u503c", (String)"FlowRecordFormatterSemanticizer_1", (String)"bos-wf-engine", (Object[])new Object[0]);
            }
            case "class": {
                return ResManager.loadKDString((String)"Java\u63d2\u4ef6", (String)"FlowRecordFormatterSemanticizer_3", (String)"bos-wf-engine", (Object[])new Object[0]);
            }
            case "script": {
                return ResManager.loadKDString((String)"\u811a\u672c", (String)"FlowRecordFormatterSemanticizer_4", (String)"bos-wf-engine", (Object[])new Object[0]);
            }
        }
        return prop;
    }
}

