/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.bpmn.model.property.semantic;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.Iterator;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.workflow.bpmn.diff.util.BpmnDiffUtil;
import kd.bos.workflow.bpmn.model.property.semantic.Semanticizer;
import kd.bos.workflow.engine.WfUtils;

public class DecisionOptionsSemanticizer
implements Semanticizer {
    private String path;
    private static final String NAME = "name";
    private static final String NUMBER = "number";
    private static final String AUDITTYPE = "auditType";
    private static final String REJECTOPTIONS = "rejectOptions";
    private static final String DEFAULTDECISION = "defaultDecision";

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public DecisionOptionsSemanticizer(String path) {
        this.path = path;
    }

    @Override
    public String convert(String value, String elementType) {
        if ("UserTask".equals(elementType)) {
            return this.convertForUserTask(value);
        }
        return this.convertForAudit(value);
    }

    private String convertForUserTask(String value) {
        String showValue;
        JsonNode valueNode = BpmnDiffUtil.getNode(value);
        StringBuilder sb = new StringBuilder();
        if (valueNode != null && valueNode.isArray()) {
            Iterator valueIt = valueNode.iterator();
            int size = valueNode.size();
            int index = 0;
            while (valueIt.hasNext()) {
                JsonNode decisionNode = (JsonNode)valueIt.next();
                JsonNode nameNode = decisionNode.get(NAME);
                if (nameNode == null) continue;
                String name = nameNode.asText();
                sb.append(name);
                if (index++ == size - 1) continue;
                sb.append("\n");
            }
        }
        return WfUtils.isEmpty(showValue = sb.toString()) ? value : showValue;
    }

    private String convertForAudit(String value) {
        String showValue;
        JsonNode valueNode = BpmnDiffUtil.getNode(value);
        StringBuilder sb = new StringBuilder();
        if (valueNode != null && valueNode.isArray()) {
            Iterator valueIt = valueNode.iterator();
            int size = valueNode.size();
            int index = 0;
            while (valueIt.hasNext()) {
                JsonNode decisionOptionNode = (JsonNode)valueIt.next();
                JsonNode numberNode = decisionOptionNode.get(NUMBER);
                String number = null;
                if (numberNode != null) {
                    number = numberNode.asText();
                }
                JsonNode nameNode = decisionOptionNode.get(NAME);
                String name = null;
                if (nameNode != null) {
                    name = nameNode.asText();
                }
                JsonNode auditTypeNode = decisionOptionNode.get(AUDITTYPE);
                String audittype = null;
                if (auditTypeNode != null) {
                    audittype = auditTypeNode.asText();
                }
                JsonNode rejectOptionsNode = decisionOptionNode.get(REJECTOPTIONS);
                String optionNames = this.resolveRejectOptionsNode(rejectOptionsNode);
                JsonNode defaultDecisionNode = decisionOptionNode.get(DEFAULTDECISION);
                String defaultDecision = null;
                if (defaultDecisionNode != null) {
                    defaultDecision = defaultDecisionNode.asText();
                }
                sb.append(this.translate(NUMBER)).append("\uff1a").append(this.translate(number)).append("\uff1b").append(this.translate(NAME)).append("\uff1a").append(name).append("\uff1b").append(this.translate(AUDITTYPE)).append("\uff1a").append(this.translate(audittype)).append("\uff1b").append(this.translate(REJECTOPTIONS)).append("\uff1a").append(optionNames).append("\uff1b").append(this.translate(DEFAULTDECISION)).append("\uff1a").append(defaultDecision).append("\uff1b");
                if (index++ == size - 1) continue;
                sb.append("\n");
            }
        }
        return WfUtils.isEmpty(showValue = sb.toString()) ? value : showValue;
    }

    private String resolveRejectOptionsNode(JsonNode rejectOptionsNode) {
        StringBuilder names = new StringBuilder();
        if (rejectOptionsNode != null && rejectOptionsNode.isArray()) {
            for (JsonNode optionNode : rejectOptionsNode) {
                JsonNode nameNode = optionNode.get(NAME);
                String name = null;
                if (nameNode != null) {
                    name = nameNode.asText();
                }
                names.append(name).append("\uff1b");
            }
        }
        return names.toString();
    }

    @Override
    public String translate(String prop) {
        if (prop == null) {
            return null;
        }
        switch (prop) {
            case "number": {
                return ResManager.loadKDString((String)"\u7f16\u7801", (String)"DecisionOptionsSemanticizer_0", (String)"bos-wf-engine", (Object[])new Object[0]);
            }
            case "name": {
                return ResManager.loadKDString((String)"\u540d\u79f0", (String)"DecisionOptionsSemanticizer_1", (String)"bos-wf-engine", (Object[])new Object[0]);
            }
            case "auditType": {
                return ResManager.loadKDString((String)"\u51b3\u7b56\u7c7b\u578b", (String)"DecisionOptionsSemanticizer_2", (String)"bos-wf-engine", (Object[])new Object[0]);
            }
            case "rejectOptions": {
                return ResManager.loadKDString((String)"\u53ef\u9009\u8282\u70b9", (String)"DecisionOptionsSemanticizer_3", (String)"bos-wf-engine", (Object[])new Object[0]);
            }
            case "defaultDecision": {
                return ResManager.loadKDString((String)"\u9ed8\u8ba4\u51b3\u7b56", (String)"DecisionOptionsSemanticizer_4", (String)"bos-wf-engine", (Object[])new Object[0]);
            }
            case "approve": {
                return ResManager.loadKDString((String)"\u540c\u610f", (String)"DecisionOptionsSemanticizer_5", (String)"bos-wf-engine", (Object[])new Object[0]);
            }
            case "reject": {
                return ResManager.loadKDString((String)"\u9a73\u56de", (String)"DecisionOptionsSemanticizer_6", (String)"bos-wf-engine", (Object[])new Object[0]);
            }
            case "terminate": {
                return ResManager.loadKDString((String)"\u7ec8\u6b62", (String)"DecisionOptionsSemanticizer_7", (String)"bos-wf-engine", (Object[])new Object[0]);
            }
        }
        return prop;
    }
}

