/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.bpmn.model.property.semantic;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.Iterator;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.workflow.bpmn.diff.util.BpmnDiffUtil;
import kd.bos.workflow.bpmn.model.property.semantic.Semanticizer;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.extitf.ExternalInterfaceUtil;

public class ExecutionListenerSemanticizer
implements Semanticizer {
    private String path;
    private static final String EVENT = "event";
    private static final String IMPLEMENTATION = "implementation";
    private static final String OPERATION = "operation";
    private static final String PLUGINPARAMS = "pluginParams";

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public ExecutionListenerSemanticizer(String path) {
        this.path = path;
    }

    @Override
    public String convert(String value, String elementType) {
        String showValue;
        JsonNode valueNode = BpmnDiffUtil.getNode(value);
        StringBuilder sb = new StringBuilder();
        if (valueNode != null && valueNode.isArray()) {
            Iterator valueIt = valueNode.iterator();
            int size = valueNode.size();
            int index = 0;
            while (valueIt.hasNext()) {
                JsonNode exlistenerNode = (JsonNode)valueIt.next();
                JsonNode operationNode = exlistenerNode.get(OPERATION);
                JsonNode eventNode = exlistenerNode.get(EVENT);
                JsonNode implementationNode = exlistenerNode.get(IMPLEMENTATION);
                if (eventNode == null || implementationNode == null) continue;
                String event = operationNode == null ? eventNode.asText() : operationNode.asText();
                String implementation = implementationNode.asText();
                sb.append(this.translate(EVENT)).append("\uff1a").append(this.translate(event)).append("\uff1b");
                sb.append(this.translate(IMPLEMENTATION)).append("\uff1a").append(ExternalInterfaceUtil.getFormattedShowValue(implementation));
                String params = ExternalInterfaceUtil.getExtItfParams(implementation);
                if (WfUtils.isNotEmpty(params)) {
                    sb.append("\uff1b").append(this.translate(PLUGINPARAMS)).append("\uff1a").append(params);
                }
                if (index++ == size - 1) continue;
                sb.append("\n");
            }
        }
        return WfUtils.isEmpty(showValue = sb.toString()) ? value : showValue;
    }

    @Override
    public String translate(String prop) {
        if (WfUtils.isEmpty(prop)) {
            return null;
        }
        switch (prop) {
            case "event": {
                return ResManager.loadKDString((String)"\u6267\u884c\u65f6\u673a", (String)"ExecutionListenerSemanticizer_0", (String)"bos-wf-engine", (Object[])new Object[0]);
            }
            case "implementation": {
                return ResManager.loadKDString((String)"\u5916\u90e8\u63a5\u53e3", (String)"ExecutionListenerSemanticizer_1", (String)"bos-wf-engine", (Object[])new Object[0]);
            }
            case "implementationType": {
                return ResManager.loadKDString((String)"\u7c7b\u578b", (String)"ExecutionListenerSemanticizer_2", (String)"bos-wf-engine", (Object[])new Object[0]);
            }
            case "start": {
                return ResManager.loadKDString((String)"\u6d41\u7a0b\u5b9e\u4f8b\u542f\u52a8\u65f6", (String)"ExecutionListenerSemanticizer_3", (String)"bos-wf-engine", (Object[])new Object[0]);
            }
            case "end": {
                return ResManager.loadKDString((String)"\u6d41\u7a0b\u5b9e\u4f8b\u5b8c\u6210\u65f6", (String)"ExecutionListenerSemanticizer_4", (String)"bos-wf-engine", (Object[])new Object[0]);
            }
            case "terminate": {
                return ResManager.loadKDString((String)"\u6d41\u7a0b\u5b9e\u4f8b\u7ec8\u6b62\u65f6", (String)"ExecutionListenerSemanticizer_5", (String)"bos-wf-engine", (Object[])new Object[0]);
            }
            case "node_audit_start": {
                return ResManager.loadKDString((String)"\u6240\u6709\u5ba1\u6279\u8282\u70b9\u8fdb\u5165\u65f6", (String)"ExecutionListenerSemanticizer_6", (String)"bos-wf-engine", (Object[])new Object[0]);
            }
            case "node_audit_end": {
                return ResManager.loadKDString((String)"\u6240\u6709\u5ba1\u6279\u8282\u70b9\u79bb\u5f00\u65f6", (String)"ExecutionListenerSemanticizer_7", (String)"bos-wf-engine", (Object[])new Object[0]);
            }
            case "withdraw_audited_proc": {
                return ResManager.loadKDString((String)"\u6574\u5355\u64a4\u56de\u65f6", (String)"ExecutionListenerSemanticizer_8", (String)"bos-wf-engine", (Object[])new Object[0]);
            }
            case "calculate_participant": {
                return ResManager.loadKDString((String)"\u8ba1\u7b97\u4efb\u52a1\u53c2\u4e0e\u4eba\u65f6", (String)"ExecutionListenerSemanticizer_17", (String)"bos-wf-engine", (Object[])new Object[0]);
            }
            case "process_restart": {
                return ResManager.loadKDString((String)"\u6d41\u7a0b\u9a73\u56de\u91cd\u65b0\u63d0\u4ea4", (String)"ExecutionListenerSemanticizer_18", (String)"bos-wf-engine", (Object[])new Object[0]);
            }
            case "normal": {
                return ResManager.loadKDString((String)"\u6b63\u5e38\u8fdb\u5165\u65f6", (String)"ExecutionListenerSemanticizer_9", (String)"bos-wf-engine", (Object[])new Object[0]);
            }
            case "reject": {
                return ResManager.loadKDString((String)"\u9a73\u56de\u8fdb\u5165\u65f6", (String)"ExecutionListenerSemanticizer_10", (String)"bos-wf-engine", (Object[])new Object[0]);
            }
            case "jump": {
                return ResManager.loadKDString((String)"\u8df3\u8f6c\u8fdb\u5165\u65f6", (String)"ExecutionListenerSemanticizer_11", (String)"bos-wf-engine", (Object[])new Object[0]);
            }
            case "approverModify": {
                return ResManager.loadKDString((String)"\u5904\u7406\u4eba\u6539\u53d8\u4e4b\u540e", (String)"ExecutionListenerSemanticizer_15", (String)"bos-wf-engine", (Object[])new Object[0]);
            }
            case "operation": {
                return ResManager.loadKDString((String)"\u64cd\u4f5c", (String)"ExecutionListenerSemanticizer_12", (String)"bos-wf-engine", (Object[])new Object[0]);
            }
            case "class": {
                return ResManager.loadKDString((String)"Java\u63d2\u4ef6", (String)"ExecutionListenerSemanticizer_13", (String)"bos-wf-engine", (Object[])new Object[0]);
            }
            case "script": {
                return ResManager.loadKDString((String)"\u811a\u672c", (String)"ExecutionListenerSemanticizer_14", (String)"bos-wf-engine", (Object[])new Object[0]);
            }
            case "pluginParams": {
                return ResManager.loadKDString((String)"\u63d2\u4ef6\u53c2\u6570", (String)"ExecutionListenerSemanticizer_16", (String)"bos-wf-engine", (Object[])new Object[0]);
            }
        }
        return prop;
    }
}

