/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.bpmn.model.property.semantic;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.Map;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.workflow.bpmn.model.property.semantic.Semanticizer;
import kd.bos.workflow.engine.WfMultiLangUtils;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.bpmn.helper.nodetemplate.NodeTemplateUtil;

public class ExpendAttributeSemanticizer
implements Semanticizer {
    private static Log logger = LogFactory.getLog(ExpendAttributeSemanticizer.class);
    private static final String ATTRIBUTENUMBER = "attributeNumber";
    private static final String ATTRIBUTENAME = "attributeName";
    private String path;

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public ExpendAttributeSemanticizer(String path) {
        this.path = path;
    }

    @Override
    public String convert(String value, String elementType) {
        String name = this.translate(elementType);
        return WfUtils.isEmpty(name) ? value : name + "\uff1a" + value;
    }

    @Override
    public String translate(String stencilType) {
        String result = null;
        String[] paths = this.path.split("\\.");
        if (paths.length != 4) {
            return result;
        }
        JSONArray attributes = NodeTemplateUtil.getExtAttributesByNodeNumber(stencilType, null, paths[2]);
        if (attributes == null || attributes.isEmpty()) {
            logger.info("ExpendAttributeSemanticizer.translate is error;attributes is null");
            return result;
        }
        for (Object object : attributes) {
            JSONObject attribute = (JSONObject)object;
            if (!paths[3].equals(attribute.getString(ATTRIBUTENUMBER))) continue;
            result = WfMultiLangUtils.getMultiLangValue((Map)SerializationUtils.fromJsonString((String)attribute.getString(ATTRIBUTENAME), Map.class)).toString();
        }
        return result;
    }
}

