/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.bpmn.model.property.semantic;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.Iterator;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.workflow.bpmn.diff.util.BpmnDiffUtil;
import kd.bos.workflow.bpmn.model.property.semantic.Semanticizer;
import kd.bos.workflow.engine.WfUtils;

public class ExtendBtnsSemanticizer
implements Semanticizer {
    private String path;
    private static final String OPERATIONNAME = "operationName";
    private static final String BTNNAME = "btnName";
    private static final String BTNNUMBER = "btnNumber";
    private static final String DISPLAYTYPE = "displaytype";

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public ExtendBtnsSemanticizer(String path) {
        this.path = path;
    }

    @Override
    public String convert(String value, String elementType) {
        String showValue;
        JsonNode valueNode = BpmnDiffUtil.getNode(value);
        StringBuilder sb = new StringBuilder();
        if (valueNode != null && valueNode.isArray()) {
            Iterator valueIt = valueNode.iterator();
            int size = valueNode.size();
            int index = 0;
            while (valueIt.hasNext()) {
                JsonNode extBtnNode = (JsonNode)valueIt.next();
                JsonNode operationNameNode = extBtnNode.get(OPERATIONNAME);
                String operationName = null;
                if (operationNameNode != null) {
                    operationName = operationNameNode.asText();
                }
                JsonNode btnNameNode = extBtnNode.get(BTNNAME);
                String btnName = null;
                if (btnNameNode != null) {
                    btnName = btnNameNode.asText();
                }
                JsonNode btnNumberNode = extBtnNode.get(BTNNUMBER);
                String btnNumber = null;
                if (btnNumberNode != null) {
                    btnNumber = btnNumberNode.asText();
                }
                JsonNode displayTypeNode = extBtnNode.get(DISPLAYTYPE);
                String displayType = null;
                if (displayTypeNode != null) {
                    displayType = displayTypeNode.asText();
                }
                sb.append(this.translate(OPERATIONNAME)).append("\uff1a").append(operationName).append("\uff1b").append(this.translate(BTNNAME)).append("\uff1a").append(btnName).append("\uff1b").append(this.translate(BTNNUMBER)).append("\uff1a").append(btnNumber).append("\uff1b").append(this.translate(DISPLAYTYPE)).append("\uff1a").append(this.translate(displayType)).append("\uff1b");
                if (index++ == size - 1) continue;
                sb.append("\n");
            }
        }
        return WfUtils.isEmpty(showValue = sb.toString()) ? value : showValue;
    }

    @Override
    public String translate(String prop) {
        if (prop == null) {
            return null;
        }
        switch (prop) {
            case "operationName": {
                return ResManager.loadKDString((String)"\u64cd\u4f5c", (String)"ExtendBtnsSemanticizer_0", (String)"bos-wf-engine", (Object[])new Object[0]);
            }
            case "btnName": {
                return ResManager.loadKDString((String)"\u6309\u94ae\u540d\u79f0", (String)"ExtendBtnsSemanticizer_1", (String)"bos-wf-engine", (Object[])new Object[0]);
            }
            case "btnNumber": {
                return ResManager.loadKDString((String)"\u6309\u94ae\u7f16\u7801", (String)"ExtendBtnsSemanticizer_2", (String)"bos-wf-engine", (Object[])new Object[0]);
            }
            case "displaytype": {
                return ResManager.loadKDString((String)"\u5c55\u73b0\u7ec8\u7aef", (String)"ExtendBtnsSemanticizer_3", (String)"bos-wf-engine", (Object[])new Object[0]);
            }
            case "all": {
                return ResManager.loadKDString((String)"PC\u7aef\u4e0e\u79fb\u52a8\u7aef", (String)"ExtendBtnsSemanticizer_4", (String)"bos-wf-engine", (Object[])new Object[0]);
            }
            case "pc": {
                return ResManager.loadKDString((String)"\u4ec5PC\u7aef", (String)"ExtendBtnsSemanticizer_5", (String)"bos-wf-engine", (Object[])new Object[0]);
            }
            case "mobile": {
                return ResManager.loadKDString((String)"\u4ec5\u79fb\u52a8\u7aef", (String)"ExtendBtnsSemanticizer_6", (String)"bos-wf-engine", (Object[])new Object[0]);
            }
        }
        return prop;
    }
}

