/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.bpmn.model.property.semantic;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.Iterator;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.workflow.bpmn.diff.util.BpmnDiffUtil;
import kd.bos.workflow.bpmn.model.property.semantic.Semanticizer;
import kd.bos.workflow.engine.WfUtils;

public class InParametersSemanticizer
implements Semanticizer {
    private String path;
    private static final String PARAMNAME = "paramname";
    private static final String PARAMNUMBER = "paramnumber";
    private static final String PARAMVALUE = "paramvalue";
    private static final String DESC = "desc";

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public InParametersSemanticizer(String path) {
        this.path = path;
    }

    @Override
    public String convert(String value, String elementType) {
        String showValue;
        JsonNode valueNode = BpmnDiffUtil.getNode(value);
        StringBuilder sb = new StringBuilder();
        if (valueNode != null && valueNode.isArray()) {
            Iterator valueIt = valueNode.iterator();
            int size = valueNode.size();
            int index = 0;
            while (valueIt.hasNext()) {
                JsonNode inParamNode = (JsonNode)valueIt.next();
                JsonNode nameNode = inParamNode.get(PARAMNAME);
                String name = null;
                if (nameNode != null) {
                    name = nameNode.asText();
                }
                JsonNode numberNode = inParamNode.get(PARAMNUMBER);
                String number = null;
                if (numberNode != null) {
                    number = numberNode.asText();
                }
                JsonNode valNode = inParamNode.get(PARAMVALUE);
                String val = null;
                if (valNode != null) {
                    val = valNode.asText();
                }
                JsonNode descNode = inParamNode.get(DESC);
                String desc = null;
                if (descNode != null) {
                    desc = descNode.asText();
                }
                sb.append(this.translate(PARAMNAME)).append("\uff1a").append(name).append("\uff1b").append(this.translate(PARAMNUMBER)).append("\uff1a").append(number).append("\uff1b").append(this.translate(PARAMVALUE)).append("\uff1a").append(val).append("\uff1b").append(this.translate(DESC)).append("\uff1a").append(desc).append("\uff1b");
                if (index++ == size - 1) continue;
                sb.append("\n");
            }
        }
        return WfUtils.isEmpty(showValue = sb.toString()) ? value : showValue;
    }

    @Override
    public String translate(String prop) {
        if (prop == null) {
            return null;
        }
        switch (prop) {
            case "paramname": {
                return ResManager.loadKDString((String)"\u540d\u79f0", (String)"InParametersSemanticizer_0", (String)"bos-wf-engine", (Object[])new Object[0]);
            }
            case "paramnumber": {
                return ResManager.loadKDString((String)"\u7f16\u7801", (String)"InParametersSemanticizer_1", (String)"bos-wf-engine", (Object[])new Object[0]);
            }
            case "paramvalue": {
                return ResManager.loadKDString((String)"\u503c", (String)"InParametersSemanticizer_2", (String)"bos-wf-engine", (Object[])new Object[0]);
            }
            case "desc": {
                return ResManager.loadKDString((String)"\u63cf\u8ff0", (String)"InParametersSemanticizer_3", (String)"bos-wf-engine", (Object[])new Object[0]);
            }
        }
        return prop;
    }
}

