/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.bpmn.model.property.semantic;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Iterator;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.workflow.bpmn.diff.util.BpmnDiffUtil;
import kd.bos.workflow.bpmn.model.property.semantic.Semanticizer;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.util.ParticipantHelper;

public class OutMsgSemanticizer
implements Semanticizer {
    private String path;
    private Map<String, String> channelMap = null;
    private static final String SENDEVT = "sendevt";
    private static final String RULE = "rule";
    private static final String EXPRESSION = "expression";
    private static final String NOTIFYTYPE = "notifytype";
    private static final String NOTIFY = "notify";
    private static final String CONTENT = "content";
    private static final String RECEIVER = "receiver";
    private static final String MSGURL = "msgurl";

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public OutMsgSemanticizer(String path, Map<String, String> channelMap) {
        this.path = path;
        this.channelMap = channelMap;
    }

    @Override
    public String convert(String value, String elementType) {
        String showValue;
        JsonNode valueNode = BpmnDiffUtil.getNode(value);
        StringBuilder sb = new StringBuilder();
        if (valueNode != null && valueNode.isArray()) {
            Iterator valueIt = valueNode.iterator();
            int size = valueNode.size();
            int index = 0;
            while (valueIt.hasNext()) {
                JsonNode msgNode = (JsonNode)valueIt.next();
                JsonNode sendevtNode = msgNode.get(SENDEVT);
                String sendevt = null;
                if (sendevtNode != null) {
                    sendevt = sendevtNode.asText();
                }
                JsonNode ruleNode = msgNode.get(RULE);
                String ruleExpression = null;
                if (ruleNode != null && ruleNode.get(EXPRESSION) != null) {
                    ruleExpression = ruleNode.get(EXPRESSION).asText();
                }
                JsonNode notifyTypeNode = msgNode.get(NOTIFYTYPE);
                String notifyType = null;
                if (notifyTypeNode != null) {
                    notifyType = notifyTypeNode.asText();
                }
                JsonNode notifyNode = msgNode.get(NOTIFY);
                String notify = null;
                if (notifyNode != null) {
                    notify = notifyNode.asText();
                }
                JsonNode contentNode = msgNode.get(CONTENT);
                String content = null;
                if (contentNode != null) {
                    content = contentNode.asText();
                }
                JsonNode receiverNode = msgNode.get(RECEIVER);
                String receivers = this.resolveReceiver(receiverNode);
                JsonNode msgUrlNode = msgNode.get(MSGURL);
                String msgUrl = null;
                if (msgUrlNode != null) {
                    msgUrl = msgUrlNode.asText();
                }
                sb.append(this.translate(SENDEVT)).append("\uff1a").append(this.translate(sendevt)).append("\uff1b").append(this.translate(RULE)).append("\uff1a").append(ruleExpression).append("\uff1b").append(this.translate(NOTIFYTYPE)).append("\uff1a").append(this.translateNotifyType(notifyType)).append("\uff1b").append(this.translate(NOTIFY)).append("\uff1a").append(this.translate(notify)).append("\uff1b").append(this.translate(CONTENT)).append("\uff1a").append(content).append("\uff1b").append(this.translate(RECEIVER)).append("\uff1a").append(receivers).append("\uff1b").append(this.translate(MSGURL)).append("\uff1a").append(msgUrl).append("\uff1b");
                if (index++ == size - 1) continue;
                sb.append("\n");
            }
        }
        return WfUtils.isEmpty(showValue = sb.toString()) ? value : showValue;
    }

    private String translateNotifyType(String notifyType) {
        if (notifyType == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        String[] types = notifyType.split(",");
        for (int i = 0; i < types.length; ++i) {
            String type = types[i].trim();
            if ("".equals(type)) continue;
            sb.append(this.channelMap.get(type));
            if (i >= types.length - 1) continue;
            sb.append(",");
        }
        return sb.toString();
    }

    private String resolveReceiver(JsonNode receiversNode) {
        StringBuilder sb = new StringBuilder();
        if (receiversNode != null && receiversNode.isArray()) {
            for (JsonNode receiverNode : receiversNode) {
                if (receiverNode == null) continue;
                JsonNode typeNode = receiverNode.get("type");
                String type = null;
                if (typeNode != null) {
                    type = typeNode.asText();
                }
                String prefix = ParticipantHelper.receiverPrefix(type);
                ObjectMapper mapper = new ObjectMapper();
                Map valueMap = (Map)mapper.convertValue((Object)receiverNode, Map.class);
                String participant = ParticipantHelper.getTextFromParams(valueMap);
                sb.append(prefix).append(participant).append("\uff1b");
            }
        }
        return sb.toString();
    }

    @Override
    public String translate(String prop) {
        if (prop == null) {
            return null;
        }
        switch (prop) {
            case "sendevt": {
                return ResManager.loadKDString((String)"\u53d1\u9001\u65f6\u673a", (String)"OutMsgSemanticizer_0", (String)"bos-wf-engine", (Object[])new Object[0]);
            }
            case "rule": {
                return ResManager.loadKDString((String)"\u6761\u4ef6", (String)"OutMsgSemanticizer_1", (String)"bos-wf-engine", (Object[])new Object[0]);
            }
            case "notifytype": {
                return ResManager.loadKDString((String)"\u6e20\u9053", (String)"OutMsgSemanticizer_2", (String)"bos-wf-engine", (Object[])new Object[0]);
            }
            case "notify": {
                return ResManager.loadKDString((String)"\u5f00\u542f", (String)"OutMsgSemanticizer_3", (String)"bos-wf-engine", (Object[])new Object[0]);
            }
            case "content": {
                return ResManager.loadKDString((String)"\u5185\u5bb9", (String)"OutMsgSemanticizer_4", (String)"bos-wf-engine", (Object[])new Object[0]);
            }
            case "receiver": {
                return ResManager.loadKDString((String)"\u6d88\u606f\u63a5\u6536\u4eba", (String)"OutMsgSemanticizer_5", (String)"bos-wf-engine", (Object[])new Object[0]);
            }
            case "msgurl": {
                return ResManager.loadKDString((String)"\u53d1\u9001\u94fe\u63a5", (String)"OutMsgSemanticizer_6", (String)"bos-wf-engine", (Object[])new Object[0]);
            }
            case "end": {
                return ResManager.loadKDString((String)"\u79bb\u5f00\u8282\u70b9\u65f6", (String)"OutMsgSemanticizer_7", (String)"bos-wf-engine", (Object[])new Object[0]);
            }
            case "Consent": {
                return ResManager.loadKDString((String)"\u540c\u610f", (String)"OutMsgSemanticizer_8", (String)"bos-wf-engine", (Object[])new Object[0]);
            }
            case "Reject": {
                return ResManager.loadKDString((String)"\u9a73\u56de", (String)"OutMsgSemanticizer_9", (String)"bos-wf-engine", (Object[])new Object[0]);
            }
            case "yunzhijia": {
                return ResManager.loadKDString((String)"\u4e91\u4e4b\u5bb6", (String)"OutMsgSemanticizer_10", (String)"bos-wf-engine", (Object[])new Object[0]);
            }
            case "dingding": {
                return ResManager.loadKDString((String)"\u9489\u9489", (String)"OutMsgSemanticizer_11", (String)"bos-wf-engine", (Object[])new Object[0]);
            }
        }
        return prop;
    }
}

