/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.bpmn.model.property.semantic;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.workflow.bpmn.model.property.semantic.Semanticizer;
import kd.bos.workflow.engine.impl.persistence.entity.management.BillPageAttributeConfigEntity;

public class PageAttrConfigSemanticizer
implements Semanticizer {
    private static final String MODIFY = "modify";
    private static final String FIELDNAME = "fieldname";
    private String path;

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public PageAttrConfigSemanticizer(String path) {
        this.path = path;
    }

    @Override
    public String convert(String value, String elementType) {
        List opsList = SerializationUtils.fromJsonStringToList((String)value, Map.class);
        return this.resolve(opsList);
    }

    @Override
    public String translate(String prop) {
        return null;
    }

    private String resolve(Object value) {
        if (value instanceof List) {
            StringBuilder alias = new StringBuilder();
            Map<String, Object> map = null;
            List list = (List)value;
            for (int i = 0; i < list.size(); ++i) {
                if (list.get(i) instanceof Map) {
                    map = this.getParamsByMap((Map)list.get(i));
                } else if (list.get(i) instanceof BillPageAttributeConfigEntity) {
                    map = this.getParamsByEntity(list.get(i));
                }
                if (map == null) continue;
                this.getAliasByParams(alias, map);
            }
            return alias.toString();
        }
        return null;
    }

    private Map<String, Object> getParamsByEntity(Object item) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (item instanceof BillPageAttributeConfigEntity) {
            BillPageAttributeConfigEntity entity = (BillPageAttributeConfigEntity)item;
            map.put(FIELDNAME, entity.getFieldname());
            map.put("hide", entity.isHide());
            map.put(MODIFY, entity.isModify());
        }
        return map;
    }

    private Map<String, Object> getParamsByMap(Map<String, Object> item) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(FIELDNAME, item.get(FIELDNAME));
        Object hide = item.get("hide");
        if (null != hide) {
            if (this.getBooleanValue(item.get("hide"))) {
                map.put("hide", Boolean.TRUE);
            } else {
                map.put("hide", Boolean.FALSE);
            }
        } else {
            map.put("hide", null);
        }
        if (this.getBooleanValue(item.get(MODIFY))) {
            map.put(MODIFY, Boolean.TRUE);
        } else {
            map.put(MODIFY, Boolean.FALSE);
        }
        return map;
    }

    private StringBuilder getAliasByParams(StringBuilder alias, Map<String, Object> map) {
        alias.append(map.get(FIELDNAME)).append(':');
        Object hide = map.get("hide");
        boolean haveHideName = true;
        if (null != hide) {
            if (((Boolean)hide).booleanValue()) {
                alias.append(ResManager.loadKDString((String)"\u9690\u85cf", (String)"PageAttrConfigSemanticizer_0", (String)"bos-wf-engine", (Object[])new Object[0]));
            }
        } else {
            haveHideName = false;
        }
        if (((Boolean)map.get(MODIFY)).booleanValue()) {
            if (haveHideName) {
                alias.append(',');
            }
            alias.append(ResManager.loadKDString((String)"\u53ef\u4fee\u6539", (String)"PageAttrConfigSemanticizer_1", (String)"bos-wf-engine", (Object[])new Object[0]));
        }
        alias.append(';');
        return alias;
    }

    private boolean getBooleanValue(Object value) {
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        return false;
    }
}

