/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.bpmn.model.property.semantic;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Iterator;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.workflow.bpmn.diff.util.BpmnDiffUtil;
import kd.bos.workflow.bpmn.model.property.semantic.Semanticizer;
import kd.bos.workflow.engine.WfRoleDimensionUtil;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.util.ParticipantHelper;

public class ParticipantSemanticizer
implements Semanticizer {
    private String path;
    private static final String TYPE = "type";
    private static final String CONDRULE = "condrule";
    private static final String EXPRESSION = "expression";

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public ParticipantSemanticizer(String path) {
        this.path = path;
    }

    @Override
    public String convert(String value, String elementType) {
        if ("properties.participant.participant".equals(this.path) || "properties.participantRangeSetting.participantAllow".equals(this.path) || "properties.participantRangeSetting.participantBlackList".equals(this.path)) {
            String showValue;
            JsonNode valueNode = BpmnDiffUtil.getNode(value);
            StringBuilder sb = new StringBuilder();
            if (valueNode != null && valueNode.isArray()) {
                Iterator valueIt = valueNode.iterator();
                int size = valueNode.size();
                int index = 0;
                while (valueIt.hasNext()) {
                    JsonNode participantNode = (JsonNode)valueIt.next();
                    String showText = this.resolveParticipant(participantNode);
                    sb.append(showText);
                    if (index++ == size - 1) continue;
                    sb.append("\n");
                }
            }
            return WfUtils.isEmpty(showValue = sb.toString()) ? value : showValue;
        }
        if ("properties.participant.radiogroup_participant".equals(this.path)) {
            return this.translate(value);
        }
        return value;
    }

    private String resolveParticipant(JsonNode participantNode) {
        JsonNode expressionNode;
        StringBuilder sb = new StringBuilder();
        JsonNode typeNode = participantNode.get(TYPE);
        String type = null;
        if (typeNode != null) {
            type = typeNode.asText();
        }
        String prefix = ParticipantHelper.receiverPrefix(type);
        ObjectMapper mapper = new ObjectMapper();
        Map valueMap = (Map)mapper.convertValue((Object)participantNode, Map.class);
        String participant = ParticipantHelper.getTextFromParams(valueMap);
        sb.append(prefix).append(participant);
        String expression = null;
        JsonNode condruleNode = participantNode.get(CONDRULE);
        if (condruleNode != null && (expressionNode = condruleNode.get(EXPRESSION)) != null) {
            expression = expressionNode.asText();
            sb.append(ResManager.loadKDString((String)"\uff1b\u6761\u4ef6\uff1a", (String)"ParticipantSemanticizer_0", (String)"bos-wf-engine", (Object[])new Object[0])).append(expression);
        }
        if ("role".equals(type)) {
            Object dimensionField;
            Object businessOrgField = valueMap.get("businessOrgField");
            if (WfUtils.isNotEmptyString(businessOrgField)) {
                sb.append(ResManager.loadKDString((String)"\uff1b\u53c2\u7167\u7ec4\u7ec7\uff1a", (String)"ParticipantSemanticizer_6", (String)"bos-wf-engine", (Object[])new Object[0])).append(businessOrgField);
            }
            if (WfUtils.isNotEmptyString(dimensionField = valueMap.get("dimensionField"))) {
                Map infoMap = (Map)SerializationUtils.fromJsonString((String)dimensionField.toString(), Map.class);
                for (Map.Entry entry : infoMap.entrySet()) {
                    String entityNumber = (String)entry.getKey();
                    DynamicObject dynObject = WfRoleDimensionUtil.getObjectType(entityNumber);
                    if (WfUtils.isNullObject(dynObject)) {
                        sb.append(String.format(ResManager.loadKDString((String)"\uff1b\u53c2\u7167\u7ef4\u5ea6\u3010number\u4e3a%s\u7684\u5143\u6570\u636e\u4e0d\u5b58\u5728\u3011", (String)"ParticipantSemanticizer_8", (String)"bos-wf-engine", (Object[])new Object[0]), entityNumber));
                        continue;
                    }
                    DynamicObjectType dynType = dynObject.getDynamicObjectType();
                    sb.append(String.format(ResManager.loadKDString((String)"\uff1b\u53c2\u7167\u7ef4\u5ea6\u3010%1$s\u3011:%2$s", (String)"ParticipantSemanticizer_7", (String)"bos-wf-engine", (Object[])new Object[0]), dynType.getDisplayName(), entry.getValue()));
                }
            }
        }
        return sb.toString();
    }

    @Override
    public String translate(String prop) {
        if (WfUtils.isEmpty(prop)) {
            return null;
        }
        switch (prop) {
            case "all": {
                return ResManager.loadKDString((String)"\u6240\u6709\u53c2\u4e0e\u4eba\u90fd\u4f1a\u6536\u5230\u4efb\u52a1", (String)"ParticipantSemanticizer_1", (String)"bos-wf-engine", (Object[])new Object[0]);
            }
            case "condition": {
                return ResManager.loadKDString((String)"\u5f53\u6ee1\u8db3\u6761\u4ef6\u65f6\u5206\u914d\u5bf9\u5e94\u7684\u53c2\u4e0e\u4eba", (String)"ParticipantSemanticizer_2", (String)"bos-wf-engine", (Object[])new Object[0]);
            }
            case "conditionExpression": {
                return ResManager.loadKDString((String)"\u6761\u4ef6\u8868\u8fbe\u5f0f", (String)"ParticipantSemanticizer_3", (String)"bos-wf-engine", (Object[])new Object[0]);
            }
            case "condruleshowtext": {
                return ResManager.loadKDString((String)"\u663e\u793a\u6587\u5b57", (String)"ParticipantSemanticizer_4", (String)"bos-wf-engine", (Object[])new Object[0]);
            }
            case "defaultCondition": {
                return ResManager.loadKDString((String)"\u9ed8\u8ba4\u6761\u4ef6", (String)"ParticipantSemanticizer_5", (String)"bos-wf-engine", (Object[])new Object[0]);
            }
        }
        return prop;
    }
}

