/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.bpmn.model.property.semantic;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.BooleanNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Iterator;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.workflow.bpmn.diff.util.BpmnDiffUtil;
import kd.bos.workflow.bpmn.model.property.semantic.Semanticizer;
import kd.bos.workflow.engine.WfUtils;

public class RPAProcParamsSemanticizer
implements Semanticizer {
    public RPAProcParamsSemanticizer(String path) {
    }

    @Override
    public String convert(String value, String elementType) {
        StringBuilder ret = new StringBuilder();
        if (WfUtils.isEmpty(value)) {
            return ret.toString();
        }
        JsonNode jsonNode = BpmnDiffUtil.getNode(value);
        if (jsonNode.isEmpty() || !(jsonNode instanceof ArrayNode)) {
            return ret.toString();
        }
        ArrayNode params = (ArrayNode)jsonNode;
        int size = params.size();
        for (int i = 0; i < size; ++i) {
            ObjectNode param = (ObjectNode)params.get(i);
            Iterator fields = param.fields();
            while (fields.hasNext()) {
                Map.Entry field = (Map.Entry)fields.next();
                JsonNode fieldValue = (JsonNode)field.getValue();
                String key = this.translate((String)field.getKey());
                if ("".equals(key)) continue;
                ret.append(String.format("%s\uff1a%s\uff1b", key, this.getFieldStringValue(fieldValue)));
            }
            if (i >= size - 1) continue;
            ret.append("\n");
        }
        return ret.toString();
    }

    private String getFieldStringValue(JsonNode fieldValue) {
        String val = "";
        val = fieldValue instanceof BooleanNode ? (fieldValue.booleanValue() ? ResManager.loadKDString((String)"\u662f", (String)"RPAProcParamsSemanticizer_1", (String)"bos-wf-engine", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5426", (String)"RPAProcParamsSemanticizer_2", (String)"bos-wf-engine", (Object[])new Object[0])) : (fieldValue != null ? fieldValue.textValue() : "");
        return val;
    }

    @Override
    public String translate(String prop) {
        switch (prop) {
            case "name": {
                return ResManager.loadKDString((String)"\u540d\u79f0", (String)"RPAProcParamsSemanticizer_3", (String)"bos-wf-engine", (Object[])new Object[0]);
            }
            case "desc": {
                return ResManager.loadKDString((String)"\u63cf\u8ff0", (String)"RPAProcParamsSemanticizer_4", (String)"bos-wf-engine", (Object[])new Object[0]);
            }
            case "type": {
                return ResManager.loadKDString((String)"\u53c2\u6570\u7c7b\u578b", (String)"RPAProcParamsSemanticizer_5", (String)"bos-wf-engine", (Object[])new Object[0]);
            }
            case "required": {
                return ResManager.loadKDString((String)"\u662f\u5426\u5fc5\u586b", (String)"RPAProcParamsSemanticizer_6", (String)"bos-wf-engine", (Object[])new Object[0]);
            }
            case "constant": {
                return ResManager.loadKDString((String)"\u5e38\u91cf", (String)"RPAProcParamsSemanticizer_7", (String)"bos-wf-engine", (Object[])new Object[0]);
            }
            case "exprtext": {
                return ResManager.loadKDString((String)"\u8868\u8fbe\u5f0f", (String)"RPAProcParamsSemanticizer_8", (String)"bos-wf-engine", (Object[])new Object[0]);
            }
        }
        return "";
    }
}

