/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.bpmn.model.property.semantic;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.workflow.bpmn.diff.util.BpmnDiffUtil;
import kd.bos.workflow.bpmn.model.property.semantic.Semanticizer;
import kd.bos.workflow.engine.impl.context.Context;
import kd.bos.workflow.engine.impl.persistence.entity.management.KeyAuditorEntity;

public class RepeaterModelSemanticizer
implements Semanticizer {
    private String path;

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public RepeaterModelSemanticizer(String path) {
        this.path = path;
    }

    @Override
    public String convert(String value, String elementType) {
        switch (this.path) {
            case "properties.afterAudit.keyAuditor": {
                JsonNode valueNode = BpmnDiffUtil.getNode(value);
                if (valueNode == null || !valueNode.isArray()) break;
                Iterator valueIt = valueNode.iterator();
                ArrayList<Long> idList = new ArrayList<Long>(valueNode.size());
                while (valueIt.hasNext()) {
                    JsonNode keyAuditorNode = (JsonNode)valueIt.next();
                    idList.add(keyAuditorNode.asLong());
                }
                QFilter f = new QFilter("id", "in", idList);
                List entityList = Context.getCommandContext().getKeyAuditorEntityManager().findByQueryFilters(new QFilter[]{f});
                StringBuilder sb = new StringBuilder();
                for (KeyAuditorEntity entity : entityList) {
                    sb.append(entity.getName().getLocaleValue()).append(";");
                }
                return sb.toString();
            }
            default: {
                return this.translate(value);
            }
        }
        return this.translate(value);
    }

    @Override
    public String translate(String prop) {
        if (prop == null) {
            return null;
        }
        switch (prop) {
            case "skip": {
                return ResManager.loadKDString((String)"\u8df3\u8fc7\uff1a\u672c\u8282\u70b9\u4e0d\u505a\u5ba1\u6279\uff0c\u76f4\u63a5\u7565\u8fc7", (String)"RepeaterModelSemanticizer_0", (String)"bos-wf-engine", (Object[])new Object[0]);
            }
            case "manual": {
                return ResManager.loadKDString((String)"\u4eba\u5de5\u5ba1\u6279", (String)"RepeaterModelSemanticizer_1", (String)"bos-wf-engine", (Object[])new Object[0]);
            }
            case "auto": {
                return ResManager.loadKDString((String)"\u81ea\u52a8\u5ba1\u6279", (String)"RepeaterModelSemanticizer_2", (String)"bos-wf-engine", (Object[])new Object[0]);
            }
            case "all": {
                return ResManager.loadKDString((String)"\u9002\u7528\u4e8e\u6240\u6709\u5ba1\u6279\u4eba", (String)"RepeaterModelSemanticizer_3", (String)"bos-wf-engine", (Object[])new Object[0]);
            }
            case "auditor": {
                return ResManager.loadKDString((String)"\u9002\u7528\u4e8e\u5173\u952e\u5ba1\u6279\u4eba", (String)"RepeaterModelSemanticizer_4", (String)"bos-wf-engine", (Object[])new Object[0]);
            }
        }
        return prop;
    }
}

