/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.bpmn.model.property.semantic;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.workflow.bpmn.model.property.semantic.AllowNextPersonSemanticizer;
import kd.bos.workflow.bpmn.model.property.semantic.AuditCommentsSemanticizer;
import kd.bos.workflow.bpmn.model.property.semantic.AuditPointSemanticizer;
import kd.bos.workflow.bpmn.model.property.semantic.BackNodeSemanticizer;
import kd.bos.workflow.bpmn.model.property.semantic.BillExceptionOpSemanticizer;
import kd.bos.workflow.bpmn.model.property.semantic.BusinessModelSemanticizer;
import kd.bos.workflow.bpmn.model.property.semantic.CirculateSemanticizer;
import kd.bos.workflow.bpmn.model.property.semantic.CompensateOperationsSemanticizer;
import kd.bos.workflow.bpmn.model.property.semantic.ConditionalRuleSemanticizer;
import kd.bos.workflow.bpmn.model.property.semantic.CustomClassNameSemanticizer;
import kd.bos.workflow.bpmn.model.property.semantic.DecisionOptionsSemanticizer;
import kd.bos.workflow.bpmn.model.property.semantic.EndTypeSemanticizer;
import kd.bos.workflow.bpmn.model.property.semantic.ExecutionListenerSemanticizer;
import kd.bos.workflow.bpmn.model.property.semantic.ExpendAttributeSemanticizer;
import kd.bos.workflow.bpmn.model.property.semantic.ExpireTypeSemanticizer;
import kd.bos.workflow.bpmn.model.property.semantic.ExtendBtnsSemanticizer;
import kd.bos.workflow.bpmn.model.property.semantic.FlowRecordFormatterSemanticizer;
import kd.bos.workflow.bpmn.model.property.semantic.InParametersSemanticizer;
import kd.bos.workflow.bpmn.model.property.semantic.OperationSemanticizer;
import kd.bos.workflow.bpmn.model.property.semantic.OutMsgSemanticizer;
import kd.bos.workflow.bpmn.model.property.semantic.OutSetSemanticizer;
import kd.bos.workflow.bpmn.model.property.semantic.PageAttrConfigSemanticizer;
import kd.bos.workflow.bpmn.model.property.semantic.ParticipantSemanticizer;
import kd.bos.workflow.bpmn.model.property.semantic.PassTypeAfterInnerRejectSemanticizer;
import kd.bos.workflow.bpmn.model.property.semantic.PassTypeSemanticizer;
import kd.bos.workflow.bpmn.model.property.semantic.ProcessingPageSemanticizer;
import kd.bos.workflow.bpmn.model.property.semantic.RPAProcParamsSemanticizer;
import kd.bos.workflow.bpmn.model.property.semantic.RepeaterModelSemanticizer;
import kd.bos.workflow.bpmn.model.property.semantic.Semanticizer;
import kd.bos.workflow.bpmn.model.property.semantic.ServiceExecutorSemanticizer;
import kd.bos.workflow.bpmn.model.property.semantic.ServiceExtitfSemanticizer;
import kd.bos.workflow.bpmn.model.property.semantic.SignTypeSemanticizer;
import kd.bos.workflow.bpmn.model.property.semantic.SubProcCalledWaySemanticizer;
import kd.bos.workflow.bpmn.model.property.semantic.SubjectSemanticizer;
import kd.bos.workflow.bpmn.model.property.semantic.TimeControlsSemanticizer;
import kd.bos.workflow.bpmn.model.property.semantic.TimeUnitSemanticizer;
import kd.bos.workflow.bpmn.model.property.semantic.TimingModelTypeSemanticizer;
import kd.bos.workflow.bpmn.model.property.semantic.UseSameAuditMsgSemanticizer;
import kd.bos.workflow.bpmn.model.property.semantic.VariablesSemanticizer;
import kd.bos.workflow.bpmn.model.property.semantic.WaitActionsSemanticizer;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.context.Context;
import kd.bos.workflow.engine.msg.MessageServiceConfig;

public class SemanticizerFactory {
    public static final String PARTICIPANT_PARTICIPANT = "properties.participant.participant";
    public static final String PARTICIPANT_RADIOGROUP_PARTICIPANT = "properties.participant.radiogroup_participant";
    public static final String PARTICIPANTRANGESETTING_PARTICIPANTALLOW = "properties.participantRangeSetting.participantAllow";
    public static final String PARTICIPANTRANGESETTING_PARTICIPANTBLACKLIST = "properties.participantRangeSetting.participantBlackList";
    public static final String DECISIONOPTIONS = "properties.decisionOptions";
    public static final String EXECUTIONLISTENERS = "properties.executionListeners";
    public static final String TASKLISTENERS = "properties.taskListeners";
    public static final String BILLEXCEPTIONOP = "properties.billExceptionOp";
    public static final String OUT_MSG = "properties.outMsg";
    public static final String IN_MSG = "properties.inMsg";
    public static final String AUDITPOINTMODEL_AUDITPOINTS = "properties.auditPointModel.auditPoints";
    public static final String BTNMODEL_EXTENDBTNS = "properties.btnModel.extendBtns";
    public static final String AUDITCOMMENTMODEL_AUDITCOMMENTS = "properties.auditCommentModel.auditComments";
    public static final String SUBJECT = "properties.subject";
    public static final String EXPIREMODEL_TIMECONTROLS = "properties.expireModel.timeControls";
    public static final String VARIABLEGROUP_VARIABLES = "properties.variableGroup.variables";
    public static final String DOUNTERSIGN_BUSINESSMODEL = "properties.dountersign.businessModel";
    public static final String DOUNTERSIGN_SIGNTYPE = "properties.dountersign.signType";
    public static final String DOUNTERSIGN_CUSTOMCLASSNAMEMODEL = "properties.dountersign.customClassName";
    public static final String BILLSETTING_PAGEATTRCONFIG = "properties.billSetting.pageAttrConfig";
    public static final String BILLSETTING_MOBILEPAGEATTRCONFIG = "properties.billSetting.mobilePageAttrConfig";
    public static final String FLOWRECORDFORMATTER = "properties.flowRecordFormatter";
    public static final String CONDITIONALRULE = "properties.conditionalRule";
    public static final String OUTSET = "properties.outSet";
    public static final String REPEATER_MODEL = "properties.repeaterModel";
    public static final String CIRCULATEMODEL_CIRCULATE = "properties.circulateModel.circulate";
    public static final String AUTOCOORDINATEMODEL_AUTOCOORDINATE = "properties.autoCoordinateModel.autoCoordinate";
    public static final String EXPIREMODEL_EXPIRETIME = "properties.expireModel.expireTime";
    public static final String EXPIREMODEL_TIMEUNIT = "properties.expireModel.timeUnit";
    public static final String EXPIREMODEL_EXPIRETYPE = "properties.expireModel.expireType";
    public static final String SKIPCONDITION = "properties.skipCondition";
    public static final String DOUNTERSIGN_PASSTYPE = "properties.dountersign.passtype";
    public static final String PASSTYPEAFTERINNERREJECT = "properties.passTypeAfterInnerReject";
    public static final String USE_SAME_AUDITMSG = "properties.useSameAuditMsg";
    public static final String ALLOW_NEXT_PERSON = "properties.allowNextPersonSettingModel.allowNextPersonSetting";
    public static final String SUBPROCESS_CALLEDWAY = "properties.calledWay";
    public static final String TIMING_MODEL_CONDITION = "properties.timingModel.condition";
    public static final String TIMING_MODEL_TYPE = "properties.timingModel.type";
    public static final String TIMING_MODEL_UNIT = "properties.timingModel.unit";
    public static final String BATCH_REJECT_COND = "properties.batchReject.batchRejectCond";
    public static final String IN_PARAMETERS = "properties.inParameters";
    public static final String OPERATION_WHEN_REJECT = "properties.billSetting.operationWhenReject";
    public static final String OPERATION_WHEN_SUBMIT = "properties.billSetting.operationWhenSubmit";
    public static final String SERVICE_EXTITF = "properties.service.extItf";
    public static final String SERVICE_EXECUTOR = "properties.serviceExecutor";
    public static final String RPAPROCPARAMS = "properties.rpaProcParams";
    public static final String BILLCLOSECONFIG_BILLCLOSECONDITION = "properties.billCloseConfig.billCloseCondition";
    public static final String BACKSET = "properties.backSet";
    public static final String COMPENSATE_OPERATIONS = "properties.operations";
    public static final String BILLCLOSECONFIG_WAITACTIONS = "properties.billCloseConfig.waitActions";
    public static final String AFTERAUDIT_KEYAUDITOR = "properties.afterAudit.keyAuditor";
    public static final String AFTERAUDIT_PERSONRANGE = "properties.afterAudit.personRange";
    public static final String ENDTYPE = "properties.endType";
    public static final String EXTENDATTRIBUTEGROUP = "properties.extAttrGroup";
    public static final String PROCESSING_PAGE = "properties.processingPage";
    public static final String PROCESSING_MOBILE_PAGE = "properties.processingMobilePage";
    private static Log log = LogFactory.getLog(SemanticizerFactory.class);

    private SemanticizerFactory() {
    }

    private static Map<String, String> getMessageChannelMap() {
        HashMap<String, String> messageChannelMap = new HashMap<String, String>(16);
        try {
            List<MessageServiceConfig> messageConfigs = Context.getCommandContext().getProcessEngineConfiguration().getMessageServiceConfigs();
            if (messageConfigs == null || messageConfigs.isEmpty()) {
                return messageChannelMap;
            }
            for (MessageServiceConfig config : messageConfigs) {
                messageChannelMap.put(config.getServiceKey(), config.getServiceName());
            }
        }
        catch (Exception e) {
            log.info("init messageChannelMap Error! " + WfUtils.getExceptionStacktrace(e));
        }
        return messageChannelMap;
    }

    public static Semanticizer createSemanticizer(String path) {
        if (path == null) {
            return null;
        }
        if (path.startsWith(EXTENDATTRIBUTEGROUP)) {
            return new ExpendAttributeSemanticizer(path);
        }
        switch (path) {
            case "properties.participant.participant": 
            case "properties.participant.radiogroup_participant": 
            case "properties.participantRangeSetting.participantAllow": 
            case "properties.participantRangeSetting.participantBlackList": {
                return new ParticipantSemanticizer(path);
            }
            case "properties.decisionOptions": {
                return new DecisionOptionsSemanticizer(path);
            }
            case "properties.executionListeners": 
            case "properties.taskListeners": {
                return new ExecutionListenerSemanticizer(path);
            }
            case "properties.billExceptionOp": {
                return new BillExceptionOpSemanticizer(path);
            }
            case "properties.outMsg": 
            case "properties.inMsg": {
                return new OutMsgSemanticizer(path, SemanticizerFactory.getMessageChannelMap());
            }
            case "properties.auditPointModel.auditPoints": {
                return new AuditPointSemanticizer(path);
            }
            case "properties.btnModel.extendBtns": {
                return new ExtendBtnsSemanticizer(path);
            }
            case "properties.auditCommentModel.auditComments": {
                return new AuditCommentsSemanticizer(path);
            }
            case "properties.subject": {
                return new SubjectSemanticizer(path);
            }
            case "properties.expireModel.timeControls": {
                return new TimeControlsSemanticizer(path);
            }
            case "properties.variableGroup.variables": {
                return new VariablesSemanticizer(path);
            }
            case "properties.dountersign.businessModel": {
                return new BusinessModelSemanticizer(path);
            }
            case "properties.dountersign.customClassName": {
                return new CustomClassNameSemanticizer(path);
            }
            case "properties.dountersign.signType": {
                return new SignTypeSemanticizer(path);
            }
            case "properties.billSetting.pageAttrConfig": 
            case "properties.billSetting.mobilePageAttrConfig": {
                return new PageAttrConfigSemanticizer(path);
            }
            case "properties.flowRecordFormatter": 
            case "properties.expireModel.expireTime": {
                return new FlowRecordFormatterSemanticizer(path);
            }
            case "properties.conditionalRule": 
            case "properties.skipCondition": 
            case "properties.timingModel.condition": 
            case "properties.batchReject.batchRejectCond": 
            case "properties.billCloseConfig.billCloseCondition": {
                return new ConditionalRuleSemanticizer(path);
            }
            case "properties.billCloseConfig.waitActions": {
                return new WaitActionsSemanticizer(path);
            }
            case "properties.rpaProcParams": {
                return new RPAProcParamsSemanticizer(path);
            }
            case "properties.outSet": {
                return new OutSetSemanticizer(path);
            }
            case "properties.circulateModel.circulate": 
            case "properties.autoCoordinateModel.autoCoordinate": {
                return new CirculateSemanticizer(path);
            }
            case "properties.expireModel.timeUnit": 
            case "properties.timingModel.unit": {
                return new TimeUnitSemanticizer(path);
            }
            case "properties.expireModel.expireType": {
                return new ExpireTypeSemanticizer(path);
            }
            case "properties.dountersign.passtype": {
                return new PassTypeSemanticizer(path);
            }
            case "properties.repeaterModel": 
            case "properties.afterAudit.keyAuditor": 
            case "properties.afterAudit.personRange": {
                return new RepeaterModelSemanticizer(path);
            }
            case "properties.passTypeAfterInnerReject": {
                return new PassTypeAfterInnerRejectSemanticizer(path);
            }
            case "properties.useSameAuditMsg": {
                return new UseSameAuditMsgSemanticizer(path);
            }
            case "properties.allowNextPersonSettingModel.allowNextPersonSetting": {
                return new AllowNextPersonSemanticizer(path);
            }
            case "properties.calledWay": {
                return new SubProcCalledWaySemanticizer(path);
            }
            case "properties.timingModel.type": {
                return new TimingModelTypeSemanticizer(path);
            }
            case "properties.inParameters": {
                return new InParametersSemanticizer(path);
            }
            case "properties.billSetting.operationWhenReject": 
            case "properties.billSetting.operationWhenSubmit": {
                return new OperationSemanticizer(path);
            }
            case "properties.service.extItf": {
                return new ServiceExtitfSemanticizer(path);
            }
            case "properties.serviceExecutor": {
                return new ServiceExecutorSemanticizer(path);
            }
            case "properties.backSet": {
                return new BackNodeSemanticizer(path);
            }
            case "properties.operations": {
                return new CompensateOperationsSemanticizer(path);
            }
            case "properties.endType": {
                return new EndTypeSemanticizer(path);
            }
            case "properties.processingPage": 
            case "properties.processingMobilePage": {
                return new ProcessingPageSemanticizer(path);
            }
        }
        return null;
    }
}

