/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.bpmn.model.property.semantic;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.Iterator;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.workflow.bpmn.diff.util.BpmnDiffUtil;
import kd.bos.workflow.bpmn.model.property.semantic.Semanticizer;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.util.ModelModifyLogUtils;

public class SubjectSemanticizer
implements Semanticizer {
    private String path;
    private static final String TIMING = "timing";
    private static final String RULE = "rule";
    private static final String TYPE = "type";
    private static final String CUSTOMSUBJECT = "customSubject";

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public SubjectSemanticizer(String path) {
        this.path = path;
    }

    @Override
    public String convert(String value, String elementType) {
        String showValue;
        JsonNode valueNode = BpmnDiffUtil.getNode(value);
        StringBuilder sb = new StringBuilder();
        if (valueNode != null && valueNode.isArray()) {
            Iterator valueIt = valueNode.iterator();
            int size = valueNode.size();
            int index = 0;
            while (valueIt.hasNext()) {
                JsonNode auditPointNode = (JsonNode)valueIt.next();
                JsonNode timingNode = auditPointNode.get(TIMING);
                String timing = null;
                if (timingNode != null) {
                    timing = timingNode.asText();
                }
                JsonNode ruleNode = auditPointNode.get(RULE);
                String ruleExpression = ModelModifyLogUtils.getRuleExpression(ruleNode);
                JsonNode typeNode = auditPointNode.get(TYPE);
                String type = null;
                if (typeNode != null) {
                    type = typeNode.asText();
                }
                JsonNode customSubjectNode = auditPointNode.get(CUSTOMSUBJECT);
                String customSubject = null;
                if (customSubjectNode != null) {
                    customSubject = customSubjectNode.asText();
                }
                sb.append(this.translate(TIMING)).append("\uff1a").append(this.translate(timing)).append("\uff1b").append(this.translate(RULE)).append("\uff1a").append(ruleExpression).append("\uff1b").append(this.translate(TYPE)).append("\uff1a").append(type).append("\uff1b").append(this.translate(CUSTOMSUBJECT)).append("\uff1a").append(customSubject).append("\uff1b");
                if (index++ == size - 1) continue;
                sb.append("\n");
            }
        }
        return WfUtils.isEmpty(showValue = sb.toString()) ? value : showValue;
    }

    @Override
    public String translate(String prop) {
        if (prop == null) {
            return null;
        }
        switch (prop) {
            case "timing": {
                return ResManager.loadKDString((String)"\u65f6\u673a", (String)"SubjectSemanticizer_0", (String)"bos-wf-engine", (Object[])new Object[0]);
            }
            case "rule": {
                return ResManager.loadKDString((String)"\u6761\u4ef6", (String)"SubjectSemanticizer_1", (String)"bos-wf-engine", (Object[])new Object[0]);
            }
            case "type": {
                return ResManager.loadKDString((String)"\u7c7b\u578b", (String)"SubjectSemanticizer_2", (String)"bos-wf-engine", (Object[])new Object[0]);
            }
            case "customSubject": {
                return ResManager.loadKDString((String)"\u5185\u5bb9", (String)"SubjectSemanticizer_3", (String)"bos-wf-engine", (Object[])new Object[0]);
            }
            case "normal": {
                return ResManager.loadKDString((String)"\u6b63\u5e38\u8fdb\u5165\u65f6", (String)"SubjectSemanticizer_4", (String)"bos-wf-engine", (Object[])new Object[0]);
            }
            case "reject": {
                return ResManager.loadKDString((String)"\u9a73\u56de\u8fdb\u5165\u65f6", (String)"SubjectSemanticizer_5", (String)"bos-wf-engine", (Object[])new Object[0]);
            }
            case "coordinate": {
                return ResManager.loadKDString((String)"\u53d1\u8d77\u534f\u529e\u65f6", (String)"SubjectSemanticizer_6", (String)"bos-wf-engine", (Object[])new Object[0]);
            }
        }
        return prop;
    }
}

