/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.bpmn.model.property.semantic;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.Iterator;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.workflow.bpmn.diff.util.BpmnDiffUtil;
import kd.bos.workflow.bpmn.model.property.semantic.Semanticizer;
import kd.bos.workflow.engine.WfUtils;

public class TimeControlsSemanticizer
implements Semanticizer {
    private String path;
    private static final String CONTROL_TYPE = "controltype";
    private static final String DURATION = "duration";
    private static final String TIME_TYPE = "timetype";
    private static final String OPERATION = "operation";
    private static final String NAME = "name";

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public TimeControlsSemanticizer(String path) {
        this.path = path;
    }

    @Override
    public String convert(String value, String elementType) {
        String showValue;
        JsonNode valueNode = BpmnDiffUtil.getNode(value);
        StringBuilder sb = new StringBuilder();
        if (valueNode != null && valueNode.isArray()) {
            Iterator valueIt = valueNode.iterator();
            int size = valueNode.size();
            int index = 0;
            while (valueIt.hasNext()) {
                JsonNode auditPointNode = (JsonNode)valueIt.next();
                JsonNode controlTypeNode = auditPointNode.get(CONTROL_TYPE);
                String controlType = null;
                if (controlTypeNode != null) {
                    controlType = controlTypeNode.asText();
                }
                JsonNode durationNode = auditPointNode.get(DURATION);
                Integer duration = null;
                if (durationNode != null) {
                    duration = durationNode.asInt();
                }
                JsonNode timeTypeNode = auditPointNode.get(TIME_TYPE);
                String timeType = null;
                if (timeTypeNode != null) {
                    timeType = timeTypeNode.asText();
                }
                JsonNode operationNode = auditPointNode.get(OPERATION);
                String operation = this.getOperationName(operationNode);
                sb.append(this.translate(CONTROL_TYPE)).append("\uff1a").append(this.translate(controlType)).append("\uff1b").append(this.translate(DURATION)).append("\uff1a").append(duration).append("\uff1b").append(this.translate(TIME_TYPE)).append("\uff1a").append(this.translate(timeType)).append("\uff1b").append(this.translate(OPERATION)).append("\uff1a").append(operation).append("\uff1b");
                if (index++ == size - 1) continue;
                sb.append("\n");
            }
        }
        return WfUtils.isEmpty(showValue = sb.toString()) ? value : showValue;
    }

    private String getOperationName(JsonNode operationNode) {
        JsonNode nameNode;
        String name = "";
        if (operationNode != null && operationNode.isObject() && (nameNode = operationNode.get(NAME)) != null) {
            name = nameNode.asText();
        }
        return name;
    }

    @Override
    public String translate(String prop) {
        if (prop == null) {
            return prop;
        }
        switch (prop) {
            case "controltype": {
                return ResManager.loadKDString((String)"\u63a7\u5236\u5185\u5bb9", (String)"TimeControlsSemanticizer_0", (String)"bos-wf-engine", (Object[])new Object[0]);
            }
            case "duration": {
                return ResManager.loadKDString((String)"\u65f6\u957f", (String)"TimeControlsSemanticizer_1", (String)"bos-wf-engine", (Object[])new Object[0]);
            }
            case "timetype": {
                return ResManager.loadKDString((String)"\u5355\u4f4d", (String)"TimeControlsSemanticizer_2", (String)"bos-wf-engine", (Object[])new Object[0]);
            }
            case "operation": {
                return ResManager.loadKDString((String)"\u64cd\u4f5c", (String)"TimeControlsSemanticizer_3", (String)"bos-wf-engine", (Object[])new Object[0]);
            }
            case "beforeDuration": {
                return ResManager.loadKDString((String)"\u9650\u671f\u4e4b\u524d", (String)"TimeControlsSemanticizer_4", (String)"bos-wf-engine", (Object[])new Object[0]);
            }
            case "onDuration": {
                return ResManager.loadKDString((String)"\u9650\u671f\u65f6", (String)"TimeControlsSemanticizer_5", (String)"bos-wf-engine", (Object[])new Object[0]);
            }
            case "afterDuration": {
                return ResManager.loadKDString((String)"\u9650\u671f\u4e4b\u540e", (String)"TimeControlsSemanticizer_6", (String)"bos-wf-engine", (Object[])new Object[0]);
            }
            case "hour": {
                return ResManager.loadKDString((String)"\u5c0f\u65f6", (String)"TimeControlsSemanticizer_7", (String)"bos-wf-engine", (Object[])new Object[0]);
            }
            case "day": {
                return ResManager.loadKDString((String)"\u5929", (String)"TimeControlsSemanticizer_8", (String)"bos-wf-engine", (Object[])new Object[0]);
            }
            case "minute": {
                return ResManager.loadKDString((String)"\u5206\u949f", (String)"TimeControlsSemanticizer_9", (String)"bos-wf-engine", (Object[])new Object[0]);
            }
        }
        return prop;
    }
}

