/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.bpmn.model.property.semantic;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.Iterator;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.workflow.bpmn.diff.util.BpmnDiffUtil;
import kd.bos.workflow.bpmn.model.property.semantic.Semanticizer;
import kd.bos.workflow.engine.WfUtils;

public class VariablesSemanticizer
implements Semanticizer {
    private String path;
    private static final String NAME = "name";
    private static final String DESCRIPTION = "description";
    private static final String DEFAULTVALUE = "defaultvalue";
    private static final String TYPE = "type";

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public VariablesSemanticizer(String path) {
        this.path = path;
    }

    @Override
    public String convert(String value, String elementType) {
        String showValue;
        JsonNode valueNode = BpmnDiffUtil.getNode(value);
        StringBuilder sb = new StringBuilder();
        if (valueNode != null && valueNode.isArray()) {
            Iterator valueIt = valueNode.iterator();
            int size = valueNode.size();
            int index = 0;
            while (valueIt.hasNext()) {
                JsonNode varNode = (JsonNode)valueIt.next();
                JsonNode nameNode = varNode.get(NAME);
                String name = null;
                if (nameNode != null) {
                    name = nameNode.asText();
                }
                JsonNode descNode = varNode.get(DESCRIPTION);
                String desc = null;
                if (descNode != null) {
                    desc = descNode.asText();
                }
                JsonNode defValNode = varNode.get(DEFAULTVALUE);
                String defVal = null;
                if (defValNode != null) {
                    defVal = defValNode.asText();
                }
                JsonNode typeNode = varNode.get(TYPE);
                String type = null;
                if (typeNode != null) {
                    type = typeNode.asText();
                }
                sb.append(this.translate(NAME)).append("\uff1a").append(name).append("\uff1b").append(this.translate(DESCRIPTION)).append("\uff1a").append(desc).append("\uff1b").append(this.translate(DEFAULTVALUE)).append("\uff1a").append(defVal).append("\uff1b").append(this.translate(TYPE)).append("\uff1a").append(this.translate(type)).append("\uff1b");
                if (index++ == size - 1) continue;
                sb.append("\n");
            }
        }
        return WfUtils.isEmpty(showValue = sb.toString()) ? value : showValue;
    }

    @Override
    public String translate(String prop) {
        if (prop == null) {
            return null;
        }
        switch (prop) {
            case "name": {
                return ResManager.loadKDString((String)"\u540d\u79f0", (String)"VariablesSemanticizer_0", (String)"bos-wf-engine", (Object[])new Object[0]);
            }
            case "description": {
                return ResManager.loadKDString((String)"\u63cf\u8ff0", (String)"VariablesSemanticizer_1", (String)"bos-wf-engine", (Object[])new Object[0]);
            }
            case "defaultvalue": {
                return ResManager.loadKDString((String)"\u9ed8\u8ba4\u503c", (String)"VariablesSemanticizer_2", (String)"bos-wf-engine", (Object[])new Object[0]);
            }
            case "type": {
                return ResManager.loadKDString((String)"\u7c7b\u578b", (String)"VariablesSemanticizer_3", (String)"bos-wf-engine", (Object[])new Object[0]);
            }
            case "string": {
                return ResManager.loadKDString((String)"\u6587\u672c", (String)"VariablesSemanticizer_4", (String)"bos-wf-engine", (Object[])new Object[0]);
            }
            case "date": {
                return ResManager.loadKDString((String)"\u65e5\u671f", (String)"VariablesSemanticizer_5", (String)"bos-wf-engine", (Object[])new Object[0]);
            }
            case "number": {
                return ResManager.loadKDString((String)"\u6570\u5b57", (String)"VariablesSemanticizer_6", (String)"bos-wf-engine", (Object[])new Object[0]);
            }
            case "boolean": {
                return ResManager.loadKDString((String)"\u5e03\u5c14", (String)"VariablesSemanticizer_7", (String)"bos-wf-engine", (Object[])new Object[0]);
            }
            case "collection": {
                return ResManager.loadKDString((String)"\u96c6\u5408", (String)"VariablesSemanticizer_8", (String)"bos-wf-engine", (Object[])new Object[0]);
            }
        }
        return prop;
    }
}

