/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.bpmn.model.property.semantic;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.workflow.bpmn.diff.util.BpmnDiffUtil;
import kd.bos.workflow.bpmn.model.property.semantic.ConditionalRuleSemanticizer;
import kd.bos.workflow.bpmn.model.property.semantic.Semanticizer;
import kd.bos.workflow.engine.WfUtils;

public class WaitActionsSemanticizer
implements Semanticizer {
    private String path;

    public WaitActionsSemanticizer(String path) {
        this.path = path;
    }

    @Override
    public String convert(String value, String elementType) {
        JsonNode closeEvent;
        if (WfUtils.isEmpty(value)) {
            return "";
        }
        StringBuilder ret = new StringBuilder();
        JsonNode waitActions = BpmnDiffUtil.getNode(value);
        JsonNode operations = waitActions.get("operations");
        if (operations instanceof ArrayNode && !operations.isEmpty()) {
            this.translateOperations((ArrayNode)operations, ret);
        }
        if ((closeEvent = waitActions.get("closeEvent")) != null && !closeEvent.isEmpty()) {
            this.translateCloseEvent(elementType, closeEvent, ret);
        }
        return ret.toString();
    }

    private void translateOperations(ArrayNode operations, StringBuilder ret) {
        int size = operations.size();
        ret.append(ResManager.loadKDString((String)"\u7b49\u5f85\u6267\u884c\u64cd\u4f5c\uff1a", (String)"WaitActionsSemanticizer_1", (String)"bos-wf-engine", (Object[])new Object[0]));
        for (int i = 0; i < size; ++i) {
            ret.append(operations.get(i).get("name").textValue());
            if (i >= size - 1) continue;
            ret.append("\u3001");
        }
    }

    private void translateCloseEvent(String elementType, JsonNode closeEvent, StringBuilder ret) {
        JsonNode condition;
        String NAME = "name";
        String NUMBER = "number";
        if (ret.length() > 0) {
            ret.append("\uff1b");
        }
        ret.append(String.format(ResManager.loadKDString((String)"\u7b49\u5f85\u6267\u884c\u4e8b\u4ef6\uff1a%1$s(%2$s)", (String)"WaitActionsSemanticizer_2", (String)"bos-wf-engine", (Object[])new Object[0]), closeEvent.get("name").textValue(), closeEvent.get("number").textValue()));
        JsonNode evtParams = closeEvent.get("params");
        if (evtParams instanceof ArrayNode && !evtParams.isEmpty()) {
            ret.append(ResManager.loadKDString((String)"\uff1b \u53c2\u6570\uff1a", (String)"WaitActionsSemanticizer_3", (String)"bos-wf-engine", (Object[])new Object[0]));
            ArrayNode params = (ArrayNode)evtParams;
            int size = params.size();
            for (int i = 0; i < size; ++i) {
                JsonNode param = params.get(i);
                ret.append(String.format("%s(%s)", param.get("name").textValue(), param.get("number").textValue()));
                if (i >= size - 1) continue;
                ret.append("\u3001");
            }
        }
        if ((condition = closeEvent.get("condition")) != null) {
            ret.append(ResManager.loadKDString((String)"\uff1b \u6761\u4ef6\uff1a", (String)"WaitActionsSemanticizer_4", (String)"bos-wf-engine", (Object[])new Object[0]));
            ret.append(new ConditionalRuleSemanticizer(this.path).convert(condition.toString(), elementType));
        }
    }

    @Override
    public String translate(String prop) {
        return null;
    }
}

