/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.devopos;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.workflow.devopos.ProcessNotExistPoJo;
import kd.bos.workflow.devopos.ProcessNotExistReasonEnum;
import kd.bos.workflow.devopos.ReasonPayload;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.bpmn.behavior.TaskBehaviorUtil;
import kd.bos.workflow.engine.impl.cmd.system.entity.HandlerConfig;
import kd.bos.workflow.engine.impl.persistence.entity.job.JobEntity;
import kd.bos.workflow.engine.pojo.AddressProcedure;
import kd.bos.workflow.engine.pojo.record.AlternativeProcess;

public class ProcessNotExistPoJoBuilder {
    private static final Log logger = LogFactory.getLog(ProcessNotExistPoJoBuilder.class);
    private DynamicObject businessModel;
    private String entityNumber;
    private JobEntity job;
    private AddressProcedure addressProcedure;
    private Map<String, Object> variables;
    private String op;

    public static ProcessNotExistPoJo build(DynamicObject businessModel, String entityNumber, JobEntity job, AddressProcedure addressProcedure, Map<String, Object> variables, String op) {
        ProcessNotExistPoJoBuilder builder = new ProcessNotExistPoJoBuilder();
        builder.businessModel = businessModel;
        builder.entityNumber = entityNumber;
        builder.job = job;
        builder.addressProcedure = addressProcedure;
        builder.variables = variables;
        builder.op = op;
        return builder.build();
    }

    private ProcessNotExistPoJo build() {
        if (this.businessModel == null) {
            return new ProcessNotExistPoJo();
        }
        if (this.addressProcedure == null) {
            return new ProcessNotExistPoJo();
        }
        AlternativeProcess enteredProcess = this.addressProcedure.getEnteredProcess();
        if (enteredProcess != null && enteredProcess.getProcessDefinitionId() != null && enteredProcess.getProcessDefinitionId() != 0L) {
            return new ProcessNotExistPoJo();
        }
        ProcessNotExistPoJo processNotExistPoJo = this.fillFromModelAndJob();
        if (!Boolean.TRUE.equals(this.addressProcedure.getFindTheOnlyProcessStatus())) {
            return this.buildNotFind(processNotExistPoJo);
        }
        List<AlternativeProcess> alternativeProcesses = this.addressProcedure.getAlternativeProcesses();
        if (alternativeProcesses == null || alternativeProcesses.isEmpty()) {
            return this.buildNotFind(processNotExistPoJo);
        }
        return this.buildConflict(processNotExistPoJo, alternativeProcesses);
    }

    private ProcessNotExistPoJo fillFromModelAndJob() {
        ProcessNotExistPoJo poJo = new ProcessNotExistPoJo();
        try {
            poJo.setEntityNumber(this.entityNumber);
            poJo.setOperate(this.op);
            poJo.setBusinessKey(this.businessModel.getPkValue().toString());
            if (this.businessModel.containsProperty("creator")) {
                DynamicObject creator = (DynamicObject)this.businessModel.get("creator");
                poJo.setSubmitterId((Long)creator.getPkValue());
            } else {
                Long initiator = HandlerConfig.build(this.job).acquireInitiator();
                poJo.setSubmitterId(initiator);
            }
            String billNo = TaskBehaviorUtil.getTaskBillNo(this.entityNumber, this.businessModel);
            poJo.setBillno(billNo);
            poJo.setSubmitTime(WfUtils.now());
            poJo.setEntraBillName((ILocaleString)this.businessModel.getDataEntityType().getDisplayName());
            poJo.setVariables(SerializationUtils.toJsonString(this.variables));
        }
        catch (Exception e) {
            logger.info("I have been try my best to build it......" + e.getMessage());
        }
        return poJo;
    }

    private ProcessNotExistPoJo buildNotFind(ProcessNotExistPoJo poJo) {
        poJo.setErrorReason(ProcessNotExistReasonEnum.NOT_FIND);
        return poJo;
    }

    private ProcessNotExistPoJo buildConflict(ProcessNotExistPoJo poJo, List<AlternativeProcess> alternativeProcesses) {
        List payload;
        ArrayList<AlternativeProcess> hasConditionProcessList = new ArrayList<AlternativeProcess>();
        ArrayList<AlternativeProcess> noConditionProcessList = new ArrayList<AlternativeProcess>();
        for (AlternativeProcess item2 : alternativeProcesses) {
            if (StringUtils.isEmpty((CharSequence)item2.getStartCondition())) {
                noConditionProcessList.add(item2);
                continue;
            }
            hasConditionProcessList.add(item2);
        }
        List enableProcessList = hasConditionProcessList.stream().filter(item -> Boolean.TRUE.equals(item.getStartConditionStatus())).collect(Collectors.toList());
        if (enableProcessList.size() > 1) {
            payload = enableProcessList.stream().map(AlternativeProcess::getProcessKey).collect(Collectors.toList());
            ReasonPayload reasonPayload = new ReasonPayload();
            reasonPayload.setReason(ProcessNotExistReasonEnum.CONFLICT);
            reasonPayload.setData(payload);
            poJo.setPayload(reasonPayload);
            poJo.setErrorReason(ProcessNotExistReasonEnum.CONFLICT);
            return poJo;
        }
        if (noConditionProcessList.size() > 1) {
            payload = noConditionProcessList.stream().map(AlternativeProcess::getProcessKey).collect(Collectors.toList());
            ReasonPayload reasonPayload = new ReasonPayload();
            reasonPayload.setReason(ProcessNotExistReasonEnum.CONFLICT);
            reasonPayload.setData(payload);
            poJo.setPayload(reasonPayload);
            poJo.setErrorReason(ProcessNotExistReasonEnum.CONFLICT);
            return poJo;
        }
        return this.buildNotFind(poJo);
    }
}

