/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.domain.model;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.workflow.api.IWorkflowService;
import kd.bos.workflow.bpmn.converter.util.ModelConfigUtil;
import kd.bos.workflow.engine.RepositoryService;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.persistence.entity.design.ModelEntity;
import kd.bos.workflow.engine.impl.persistence.entity.design.ResourceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.ProcessDefinitionEntity;
import kd.bos.workflow.engine.impl.util.BpmnModelUtil;
import kd.bos.workflow.service.WorkflowService;
import kd.bos.workflow.service.impl.ServiceFactory;

public class NodeLifecycleUtil {
    public static final String LIFE_CYCLE_LISTENER = "lifecycleListener";
    public static final String METHOD_LIFECYCLE_PUBLISH = "afterPublish";
    public static final String METHOD_LIFECYCLE_SAVE = "afterSave";
    public static final String METHOD_LIFECYCLE_IMPORT = "afterImport";
    public static final String METHOD_LIFECYCLE_EXPORT = "afterExport";
    public static final String METHOD_LIFECYCLE_SUSPEND = "afterSuspend";
    public static final String METHOD_LIFECYCLE_ACTIVATE = "afterActivate";
    public static final String METHOD_LIFECYCLE_IMPORTSCHEME = "afterImportScheme";
    public static final String METHOD_LIFECYCLE_EXPORTSCHEME = "afterExportScheme";
    private static final String LIFECYCLECONFIG_NOT_FOUND = "LifecycleConfig not found. entrabillid: %s";
    private static final String PROCESSDEFINITION_NOT_FOUND = "ProcessDefinition not found. processDefinitionId: %s";
    private static final String CLAZZ = "clazz";
    private static final String APP_ID = "appId";
    private static Log log = LogFactory.getLog(NodeLifecycleUtil.class);

    private NodeLifecycleUtil() {
    }

    private static RepositoryService getRepositoryService() {
        WorkflowService service = (WorkflowService)ServiceFactory.getService(WorkflowService.class);
        return service.getRepositoryService();
    }

    public static void executeLifecyclePublishListener(Long deploymentId) {
        QFilter[] filters = new QFilter[]{new QFilter("deploymentid", "=", (Object)deploymentId)};
        List entities = NodeLifecycleUtil.getRepositoryService().findEntitiesByFilters("wf_processdefinition", filters);
        if (entities.isEmpty()) {
            log.debug(String.format("ProcessDefinition not found. deploymentId: %s", deploymentId));
            return;
        }
        for (ProcessDefinitionEntity entity : entities) {
            Map<String, Object> returnDate = NodeLifecycleUtil.getLifecycleConfig(entity.getEntraBillId(), "publish");
            if (returnDate == null) continue;
            NodeLifecycleUtil.executePlugin(returnDate, METHOD_LIFECYCLE_PUBLISH, entity.getId(), NodeLifecycleUtil.getProcessVariable(entity.getResourceId()));
        }
    }

    public static void executeLifecycleSaveListener(ModelEntity model, String modelJson) {
        Map<String, Object> returnDate = NodeLifecycleUtil.getLifecycleConfig(model.getEntraBillId(), "save");
        if (returnDate == null) {
            return;
        }
        HashMap<String, String> paramter = new HashMap<String, String>(5);
        paramter.put("modelJson", modelJson);
        NodeLifecycleUtil.executePlugin(returnDate, METHOD_LIFECYCLE_SAVE, model.getId(), model.getKey(), paramter);
    }

    public static void executeLifecycleImportListener(DynamicObject model) {
        String processNumber = model.getString("key");
        String entrabillid = model.getString("entrabillid_id");
        Map<String, Object> returnDate = NodeLifecycleUtil.getLifecycleConfig(entrabillid, "import");
        if (returnDate == null) {
            return;
        }
        HashMap paramter = new HashMap(5);
        NodeLifecycleUtil.executePlugin(returnDate, METHOD_LIFECYCLE_IMPORT, processNumber, paramter);
    }

    public static void executeLifecycleExportListener(DynamicObject model) {
        String entrabillid = model.getString("entrabillid_id");
        String processNumber = model.getString("key");
        Map<String, Object> returnDate = NodeLifecycleUtil.getLifecycleConfig(entrabillid, "export");
        if (returnDate == null) {
            return;
        }
        HashMap paramter = new HashMap(5);
        NodeLifecycleUtil.executePlugin(returnDate, METHOD_LIFECYCLE_EXPORT, processNumber, paramter);
    }

    public static void executeLifecycleSuspendListener(Long procDefId) {
        ProcessDefinitionEntity entity = NodeLifecycleUtil.getRepositoryService().getProcessdefineById(procDefId);
        if (entity == null) {
            log.debug(String.format(PROCESSDEFINITION_NOT_FOUND, procDefId));
            return;
        }
        Map<String, Object> returnDate = NodeLifecycleUtil.getLifecycleConfig(entity.getEntraBillId(), "suspend");
        if (returnDate == null) {
            return;
        }
        HashMap paramter = new HashMap(5);
        NodeLifecycleUtil.executePlugin(returnDate, METHOD_LIFECYCLE_SUSPEND, procDefId, paramter);
    }

    public static void executeLifecycleActivateListener(Long procDefId) {
        ProcessDefinitionEntity entity = NodeLifecycleUtil.getRepositoryService().getProcessdefineById(procDefId);
        if (entity == null) {
            log.debug(String.format(PROCESSDEFINITION_NOT_FOUND, procDefId));
            return;
        }
        Map<String, Object> returnDate = NodeLifecycleUtil.getLifecycleConfig(entity.getEntraBillId(), "activate");
        if (returnDate == null) {
            return;
        }
        HashMap paramter = new HashMap(5);
        NodeLifecycleUtil.executePlugin(returnDate, METHOD_LIFECYCLE_ACTIVATE, procDefId, paramter);
    }

    public static void executeLifecycleExportSchemeListener(Long procDefId) {
        ProcessDefinitionEntity entity = NodeLifecycleUtil.getRepositoryService().getProcessdefineById(procDefId);
        if (entity == null) {
            log.debug(String.format(PROCESSDEFINITION_NOT_FOUND, procDefId));
            return;
        }
        Map<String, Object> returnDate = NodeLifecycleUtil.getLifecycleConfig(entity.getEntraBillId(), "exportScheme");
        if (returnDate == null) {
            return;
        }
        HashMap paramter = new HashMap(5);
        NodeLifecycleUtil.executePlugin(returnDate, METHOD_LIFECYCLE_EXPORTSCHEME, procDefId, paramter);
    }

    public static void executeLifecycleImportSchemesListener(Long procDefId) {
        ProcessDefinitionEntity entity = NodeLifecycleUtil.getRepositoryService().getProcessdefineById(procDefId);
        if (entity == null) {
            log.debug(String.format(PROCESSDEFINITION_NOT_FOUND, procDefId));
            return;
        }
        Map<String, Object> returnDate = NodeLifecycleUtil.getLifecycleConfig(entity.getEntraBillId(), "importScheme");
        if (returnDate == null) {
            return;
        }
        HashMap paramter = new HashMap(5);
        NodeLifecycleUtil.executePlugin(returnDate, METHOD_LIFECYCLE_IMPORTSCHEME, procDefId, paramter);
    }

    public static Map<String, Object> getProcessVariable(Long resourceId) {
        QFilter[] filters = new QFilter[]{new QFilter("id", "=", (Object)resourceId)};
        List resources = NodeLifecycleUtil.getRepositoryService().findEntitiesByFilters("wf_resource", filters, "data", null);
        if (resources == null || resources.isEmpty()) {
            return new HashMap<String, Object>();
        }
        JSONObject data = JSON.parseObject((String)((ResourceEntity)resources.get(0)).getData());
        JSONObject properties = data.getJSONObject("properties");
        List variables = (List)BpmnModelUtil.getProperty((Map<String, Object>)properties, String.format("%s.%s", "variableGroup", "variables"));
        if (variables == null || variables.isEmpty()) {
            log.debug("variables is empty.");
            return new HashMap<String, Object>();
        }
        HashMap<String, Object> result = new HashMap<String, Object>(variables.size());
        for (Map variable : variables) {
            result.put((String)variable.get("name"), variable.get("defaultvalue"));
        }
        return result;
    }

    public static Object executePlugin(Map<String, Object> config, String method, Object ... args) {
        if (WfUtils.isEmptyForMap(config)) {
            return null;
        }
        String plugin = (String)config.get(CLAZZ);
        String appId = (String)config.get(APP_ID);
        if (WfUtils.isEmpty(appId)) {
            appId = "wf";
        }
        Object result = null;
        result = DispatchServiceHelper.invokeBOSService((String)appId, (String)IWorkflowService.class.getSimpleName(), (String)"invokeBizPlugin", (Object[])new Object[]{plugin, method, args});
        return result;
    }

    public static Map<String, Object> getLifecycleConfig(String entityId, String operateKey) {
        JSONObject config = ModelConfigUtil.getStencilsLifecycleConfig("Diagram", entityId);
        if (config == null) {
            log.debug(String.format(LIFECYCLECONFIG_NOT_FOUND, entityId));
            return null;
        }
        String plugin = (String)BpmnModelUtil.getProperty((Map<String, Object>)config, "listeners." + operateKey);
        if (WfUtils.isEmpty(plugin)) {
            log.debug(String.format("lifecycleListener-%s not found.", operateKey));
            return null;
        }
        JSONObject data = JSON.parseObject((String)plugin);
        String appId = data.getString("appid");
        if (WfUtils.isEmpty(appId)) {
            appId = config.getString(APP_ID);
        }
        HashMap<String, Object> returnDate = new HashMap<String, Object>(2);
        returnDate.put(CLAZZ, data.getString("class"));
        returnDate.put(APP_ID, appId);
        return returnDate;
    }
}

