/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine;

import java.util.ArrayList;
import java.util.List;
import kd.bos.workflow.api.AgentExecution;
import kd.bos.workflow.bpmn.model.YunzhijiaTask;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.dynprocess.CustomizedAuditResult;
import kd.bos.workflow.engine.dynprocess.JointAuditInfo;
import kd.bos.workflow.engine.dynprocess.JointResultInfo;
import kd.bos.workflow.engine.extitf.ExtItfCallerType;
import kd.bos.workflow.engine.extitf.ExternalInterfaceUtil;
import kd.bos.workflow.engine.impl.cmd.GetLastAuditCountCmd;
import kd.bos.workflow.engine.impl.cmd.GetLastAuditParticipantsCmd;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;

public class AuditRuleForYzjUtil {
    public static boolean isAutoAuditForNoNeedCountersign(List<Long> particIds, AgentExecution execution, YunzhijiaTask yzjTask, int numForTotal, CommandContext commandContext) {
        return AuditRuleForYzjUtil.isAutoAuditForNoNeedCountersign(execution, yzjTask, numForTotal, commandContext, null);
    }

    public static boolean isAutoAuditForNoNeedCountersign(Long processInstanceId, YunzhijiaTask yzjTask, int numForTotal, CommandContext commandContext, int countForAudit, boolean isRepeatApprover, Long parentTaskId) {
        if (0 != numForTotal && 0 != countForAudit) {
            int countForTotal = isRepeatApprover ? countForAudit : 0;
            switch (yzjTask.getBusinessModel()) {
                case "passByOne": {
                    return countForAudit > 0;
                }
                case "oneVoteVeto": {
                    return numForTotal == countForAudit;
                }
                case "allVote": {
                    if (0 == countForTotal) {
                        int n = WfUtils.isEmpty(parentTaskId) ? countForAudit : (countForTotal = new GetLastAuditCountCmd(processInstanceId, yzjTask.getId(), null, null != parentTaskId ? parentTaskId.toString() : null).execute(commandContext).intValue());
                    }
                    if (numForTotal == countForTotal) {
                        return AuditRuleForYzjUtil.isThroughVotePercentage(countForAudit, countForTotal, yzjTask, "approve");
                    }
                    return false;
                }
                case "voteOnProportion": {
                    double vp;
                    if (0 == countForTotal) {
                        int n = WfUtils.isEmpty(parentTaskId) ? countForAudit : (countForTotal = new GetLastAuditCountCmd(processInstanceId, yzjTask.getId(), null, null != parentTaskId ? parentTaskId.toString() : null).execute(commandContext).intValue());
                    }
                    if ((vp = (double)(countForTotal * 100) / Double.parseDouble(String.valueOf(numForTotal))) >= yzjTask.getVotePercentage()) {
                        return AuditRuleForYzjUtil.isThroughVotePercentage(countForAudit, countForTotal, yzjTask, "approve");
                    }
                    return false;
                }
                case "voteByPassProportion": {
                    return AuditRuleForYzjUtil.isThroughPassPercent(countForAudit, numForTotal, yzjTask, "approve");
                }
            }
            return false;
        }
        return false;
    }

    public static boolean isAutoAuditForNoNeedCountersign(List<Long> particIds, AgentExecution execution, YunzhijiaTask yzjTask, int numForTotal, CommandContext commandContext, int numForVote, boolean isRepeatApprover, Long parentTaskId) {
        if ("custom".equals(yzjTask.getBusinessModel())) {
            return AuditRuleForYzjUtil.isThroughCustom(execution, numForTotal, numForVote, yzjTask, particIds);
        }
        Long processInstanceId = execution.getProcessInstanceId();
        return AuditRuleForYzjUtil.isAutoAuditForNoNeedCountersign(processInstanceId, yzjTask, numForTotal, commandContext, numForVote, isRepeatApprover, parentTaskId);
    }

    private static boolean isThroughCustom(AgentExecution execution, int numForTotal, int numForVote, YunzhijiaTask yzjTask, List<Long> particIds) {
        ArrayList<JointAuditInfo> auditInfos = new ArrayList<JointAuditInfo>(numForVote);
        AuditRuleForYzjUtil.constructJointAuditInfoList(particIds, auditInfos);
        JointResultInfo jointResultInfo = new JointResultInfo(numForTotal, numForVote, numForTotal - numForVote, auditInfos);
        CustomizedAuditResult customizedAuditResult = (CustomizedAuditResult)ExternalInterfaceUtil.executeExtItf(ExtItfCallerType.CUSTOMBUSINESS, yzjTask.getCustomClassName(), execution, jointResultInfo);
        return customizedAuditResult != null && customizedAuditResult.isOver();
    }

    private static void constructJointAuditInfoList(List<Long> particIds, List<JointAuditInfo> auditInfos) {
        for (Long particId : particIds) {
            JointAuditInfo jointAuditInfo = new JointAuditInfo();
            jointAuditInfo.setDesicisionType("approve");
            jointAuditInfo.setResultNumber("Consent");
            jointAuditInfo.setUserId(particId);
            auditInfos.add(jointAuditInfo);
        }
    }

    public static boolean isThroughPassPercent(int numForVote, int numForTotal, YunzhijiaTask yzjTask, String auditType) {
        boolean passProportion;
        double passPercent = AuditRuleForYzjUtil.getPassPercent(yzjTask);
        boolean bl = passProportion = (double)(numForVote * 100) / Double.parseDouble(String.valueOf(numForTotal)) >= passPercent;
        return passProportion && "approve".equals(auditType);
    }

    private static double getPassPercent(YunzhijiaTask yzjTask) {
        double passPercent = 0.0;
        String passType = yzjTask.getPasstype();
        if (WfUtils.isEmpty(passType) || "passByPercent".equals(passType)) {
            passPercent = yzjTask.getPassPercentage();
        } else {
            String[] passFractionArr = yzjTask.getPassfraction().split("/");
            int passFractionOne = Integer.parseInt(passFractionArr[0]);
            int passFractionTwo = Integer.parseInt(passFractionArr[1]);
            passPercent = (double)(passFractionOne * 100) / Double.parseDouble(String.valueOf(passFractionTwo));
        }
        return passPercent;
    }

    public static boolean isThroughVotePercentage(int numForVote, int numForTotal, YunzhijiaTask yzjTask, String auditType) {
        return WfUtils.isPassForVote(yzjTask.getPasstype(), yzjTask.getPassPercentage(), yzjTask.getPassfraction(), numForVote, numForTotal);
    }

    public static boolean isAutoAuditForNoNeedCountersign(AgentExecution execution, YunzhijiaTask yzjTask, int numForTotal, CommandContext commandContext, Long parentTaskId) {
        Long processInstanceId = execution.getProcessInstanceId();
        int countForAudit = new GetLastAuditCountCmd(processInstanceId, yzjTask.getId(), "approve", null != parentTaskId ? parentTaskId.toString() : null).execute(commandContext);
        Object particIds = new GetLastAuditParticipantsCmd(processInstanceId, yzjTask.getId(), "approve").execute(commandContext);
        return AuditRuleForYzjUtil.isAutoAuditForNoNeedCountersign((List<Long>)particIds, execution, yzjTask, numForTotal, commandContext, countForAudit, false, parentTaskId);
    }
}

