/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.AttachmentProp;
import kd.bos.form.FormConfig;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.plugin.utils.MobileFormUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.session.EncreptSessionUtils;
import kd.bos.url.UrlService;
import kd.bos.workflow.engine.ManagementService;
import kd.bos.workflow.engine.WfMultiLangUtils;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.persistence.entity.management.DynamicFormMappingEntity;
import kd.bos.workflow.engine.impl.util.BillSummaryType;
import kd.bos.workflow.engine.impl.util.BpmnModelUtil;
import kd.bos.workflow.service.WorkflowService;
import kd.bos.workflow.service.impl.ServiceFactory;
import org.apache.commons.lang.math.NumberUtils;

public class BillPagePluginUtil {
    public static final String MODEITYPE = "modelType";
    public static final String MODEITYPE_MOBILEFORMMODEL = "&mfm";
    public static final String MODEITYPE_DYNAMICFORMMODEL = "&dfm";
    private static final String NUMBER = "number";
    private static final Log logger = LogFactory.getLog(BillPagePluginUtil.class);
    public static final String SELECTEDVALUE = "selectedvalue";
    public static final String DATAITEMS = "dataitems";
    public static final String SELECTVALUES = "selectValues";
    public static final String NEWMBILLSUMMARYKEY = "$";
    public static final String SPLITCHAR = "_@_";
    private static final String QUERYNAME = "name";
    private static final String BILL_TYPE = "billtype";
    private static final String DYNAMIC_FORM_NUMBER_NAME = "dynamicformnumber.name";
    private static Log log = LogFactory.getLog(BillPagePluginUtil.class);

    public static Map<String, Object> getBillPagesForPC(String formKey, String entityId) {
        if (entityId == null) {
            log.debug("NodeTemplate,There is't entityId");
            return new HashMap<String, Object>();
        }
        ManagementService service = ((WorkflowService)ServiceFactory.getService(WorkflowService.class)).getManagementService();
        List<Map<String, Object>> items = service.getBillPageByType(entityId, "BillFormModel");
        return BillPagePluginUtil.getBillPages(items, formKey);
    }

    public static Map<String, Object> getBillPagesForMob(String nodeType, String formKey, String mobileFormKey, String entityId, String entityNumber, String entityName, List<Map<String, Object>> billPagesForPC) {
        if (entityId == null) {
            log.debug("NodeTemplate,There is't entityId");
            return new HashMap<String, Object>();
        }
        List<Map<String, Object>> mobileItems = BillPagePluginUtil.getBillPagesForMob(billPagesForPC, entityId, BpmnModelUtil.instanceofAuditTask(nodeType), entityNumber, mobileFormKey);
        return BillPagePluginUtil.getBillPages(mobileItems, mobileFormKey);
    }

    public static List<Map<String, Object>> getBillPagesForMob(List<Map<String, Object>> billPagesForPC, String entityId, boolean addBillSummary, String entityNumber, String mobileFormKey) {
        ManagementService service = ((WorkflowService)ServiceFactory.getService(WorkflowService.class)).getManagementService();
        if (null == billPagesForPC || 0 == billPagesForPC.size()) {
            billPagesForPC = service.getBillPageByType(entityId, "BillFormModel");
        }
        ArrayList<Map<String, Object>> mobileItems = new ArrayList<Map<String, Object>>(2);
        String mobilePageId = null;
        HashMap<String, String> item = null;
        Object name = null;
        for (Map<String, Object> map : billPagesForPC) {
            item = new HashMap<String, String>();
            mobilePageId = map.get("id") + "_mob";
            if (!BillPagePluginUtil.isExistForFormId(mobilePageId)) continue;
            item.put("id", mobilePageId);
            name = map.get("nameOnly");
            item.put(QUERYNAME, String.format(ResManager.loadKDString((String)"%1$s_\u79fb\u52a8\u8868\u5355(%2$s)", (String)"BillPagePluginUtil_1", (String)"bos-wf-engine", (Object[])new Object[0]), BillPagePluginUtil.getCaptainForFormPage(mobilePageId, null == name ? null : name.toString()), mobilePageId));
            mobileItems.add(item);
        }
        List<Map<String, Object>> items = service.getBillPageByType(entityId, "MobileBillFormModel");
        mobileItems.addAll(items);
        HashSet<String> entryBills = new HashSet<String>(1);
        entryBills.add(entityNumber);
        List<DynamicFormMappingEntity> entityNumbers = service.getEnableDynamicFormMappingEntitiesByEntityNumbers(entryBills);
        Object dynamicFormNumber = null;
        DynamicObject dynamicFormNumberObj = null;
        for (DynamicFormMappingEntity entity : entityNumbers) {
            item = new HashMap();
            if (null == entity || null == (dynamicFormNumberObj = entity.getDynamicFormNumber())) continue;
            dynamicFormNumber = dynamicFormNumberObj.get(NUMBER);
            item.put("id", dynamicFormNumber + MODEITYPE_MOBILEFORMMODEL);
            item.put(QUERYNAME, String.format(ResManager.loadKDString((String)"%1$s_\u79fb\u52a8\u7248\u7684\u52a8\u6001\u8868\u5355(%2$s)", (String)"BillPagePluginUtil_3", (String)"bos-wf-engine", (Object[])new Object[0]), dynamicFormNumberObj.getLocaleString(QUERYNAME).getLocaleValue(), dynamicFormNumber));
            mobileItems.add(item);
        }
        try {
            DynamicObject[] dynamicObjects;
            if (!addBillSummary) {
                return mobileItems;
            }
            Map billSummarys = MobileFormUtils.getBillSummarys((String)entityNumber);
            if (null != billSummarys && 0 != billSummarys.size()) {
                Set billEntrySet = billSummarys.entrySet();
                Iterator billIterator = billEntrySet.iterator();
                String billSummaryKey = null;
                boolean isSetSelecedValue = false;
                while (billIterator.hasNext()) {
                    Map.Entry billEntry = billIterator.next();
                    billSummaryKey = "billSummary_@_" + (String)billEntry.getKey();
                    item = new HashMap();
                    item.put("id", billSummaryKey);
                    item.put(QUERYNAME, String.format(ResManager.loadKDString((String)"%1$s_\u5355\u636e\u6458\u8981(%2$s)", (String)"BillPagePluginUtil_2", (String)"bos-wf-engine", (Object[])new Object[0]), billEntry.getValue(), billEntry.getKey()));
                    mobileItems.add(item);
                    if (isSetSelecedValue || !WfUtils.isNotEmpty(mobileFormKey) || !mobileFormKey.equals("billSummary")) continue;
                    mobileFormKey = billSummaryKey;
                    isSetSelecedValue = true;
                }
            }
            QFilter qfilter1 = new QFilter(BILL_TYPE, "=", (Object)entityNumber);
            QFilter qfilter2 = new QFilter("enable", "=", (Object)"1");
            QFilter qfilter3 = new QFilter("scene", "=", (Object)BillSummaryType.mobileSummary.name());
            for (DynamicObject dynamicObject : dynamicObjects = BusinessDataServiceHelper.load((String)"wf_mbillsummary_cfg", (String)"number,name,summarytpl", (QFilter[])new QFilter[]{qfilter1, qfilter2, qfilter3})) {
                item = new HashMap();
                item.put("id", dynamicObject.get(NUMBER) + NEWMBILLSUMMARYKEY);
                item.put(QUERYNAME, String.format(ResManager.loadKDString((String)"%1$s_\u5355\u636e\u6458\u8981(%2$s)", (String)"BillPagePluginUtil_2", (String)"bos-wf-engine", (Object[])new Object[0]), dynamicObject.getLocaleString(QUERYNAME).getLocaleValue(), dynamicObject.get(NUMBER)));
                mobileItems.add(item);
            }
        }
        catch (Exception e) {
            logger.info(WfUtils.getExceptionStacktrace(e));
        }
        return mobileItems;
    }

    public static ILocaleString getBillPageMulLanNameByTypeForMob(ILocaleString billPagesForPC, String entityId, String entityNumber, String comboId) {
        int idx;
        String dynamicFormNumber;
        ILocaleString mapName;
        if (WfUtils.isNotEmpty(billPagesForPC)) {
            String mobilePageId = entityNumber + "_mob";
            LocaleString nameTpl = ResManager.getLocaleString((String)"%1$s_\u79fb\u52a8\u8868\u5355(%2$s)", (String)"BillPagePluginUtil_1", (String)"bos-wf-engine");
            ILocaleString mulMmobilePageId = WfMultiLangUtils.getMultiLangValue(new ILocaleString[]{new LocaleString(mobilePageId)});
            return WfMultiLangUtils.replaceILocaleString((ILocaleString)nameTpl, BillPagePluginUtil.getMulCaptainForFormPage(mobilePageId, billPagesForPC), mulMmobilePageId);
        }
        ILocaleString billPagesForMob = BillPagePluginUtil.getBillPageMulLanNameByType(entityId, "MobileBillFormModel", entityNumber);
        if (WfUtils.isNotEmpty(billPagesForMob)) {
            return billPagesForMob;
        }
        if (comboId.endsWith(MODEITYPE_MOBILEFORMMODEL) && WfUtils.isNotEmpty(mapName = BillPagePluginUtil.getEnableDynamicFormMappingEntitieNameByEntityNumberAndDyFormNum(entityNumber, dynamicFormNumber = comboId.substring(0, idx = comboId.length() - MODEITYPE_MOBILEFORMMODEL.length())))) {
            LocaleString nameTpl = ResManager.getLocaleString((String)"%1$s_\u79fb\u52a8\u7248\u7684\u52a8\u6001\u8868\u5355(%2$s)", (String)"BillPagePluginUtil_3", (String)"bos-wf-engine");
            ILocaleString dynamicFormNumberMul = WfMultiLangUtils.getMultiLangValue(new ILocaleString[]{new LocaleString(dynamicFormNumber)});
            return WfMultiLangUtils.replaceILocaleString((ILocaleString)nameTpl, mapName, dynamicFormNumberMul);
        }
        try {
            String number;
            ILocaleString queryName;
            String num;
            String[] split = comboId.split(SPLITCHAR);
            if (split.length > NumberUtils.INTEGER_ONE && WfUtils.isNotEmpty(mapName = BillPagePluginUtil.getBillSummaryNameByBillTypeNum(entityNumber, num = split[1]))) {
                LocaleString nameTpl = ResManager.getLocaleString((String)"%1$s_\u5355\u636e\u6458\u8981(%2$s)", (String)"BillPagePluginUtil_2", (String)"bos-wf-engine");
                ILocaleString mulNum = WfMultiLangUtils.getMultiLangValue(new ILocaleString[]{new LocaleString(num)});
                return WfMultiLangUtils.replaceILocaleString((ILocaleString)nameTpl, mapName, mulNum);
            }
            if (comboId.endsWith(MODEITYPE_MOBILEFORMMODEL) && WfUtils.isNotEmpty(queryName = BillPagePluginUtil.getMBillSummaryMulNameByEntityNumNum(entityNumber, number = comboId.substring(0, comboId.length() - MODEITYPE_MOBILEFORMMODEL.length())))) {
                LocaleString nameTpl = ResManager.getLocaleString((String)"%1$s_\u5355\u636e\u6458\u8981(%2$s)", (String)"BillPagePluginUtil_2", (String)"bos-wf-engine");
                ILocaleString mulNum = WfMultiLangUtils.getMultiLangValue(new ILocaleString[]{new LocaleString(number)});
                return WfMultiLangUtils.replaceILocaleString((ILocaleString)nameTpl, queryName, mulNum);
            }
        }
        catch (Exception e) {
            logger.info(WfUtils.getExceptionStacktrace(e));
        }
        return null;
    }

    public static ILocaleString getBillPageMulLanNameByType(String entityId, String modelType, String number) {
        QFilter entityIdFilter = new QFilter("basedatafield", "=", (Object)entityId);
        QFilter billFormModelFilter = new QFilter(MODEITYPE, "=", (Object)modelType);
        if ("BillFormModel".equals(modelType)) {
            billFormModelFilter.or(new QFilter(MODEITYPE, "=", (Object)"BaseFormModel"));
        }
        QFilter billTypeFilter = new QFilter("type", "!=", (Object)"2");
        QFilter numberFilter = new QFilter(NUMBER, "=", (Object)number);
        QFilter[] billFilters = new QFilter[]{entityIdFilter, billFormModelFilter, numberFilter, billTypeFilter};
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)"bos_formmeta", (String)QUERYNAME, (QFilter[])billFilters);
        if (WfUtils.isNullObject(dynamicObject)) {
            return null;
        }
        ILocaleString billPages = dynamicObject.getLocaleString(QUERYNAME);
        billPages.entrySet().forEach(t -> t.setValue((String)t.getValue() + "(" + number + ")"));
        return billPages;
    }

    public static ILocaleString getEnableDynamicFormMappingEntitieNameByEntityNumberAndDyFormNum(String entityNumber, String dynamicFormNumber) {
        QFilter qfilter1 = new QFilter("entitynumber", "=", (Object)entityNumber);
        QFilter qfilter2 = new QFilter("enable", "=", (Object)"1");
        QFilter qfilter3 = new QFilter("status", "!=", (Object)"0");
        QFilter qfilter4 = new QFilter("dynamicformnumber.number", "=", (Object)dynamicFormNumber);
        QFilter[] qFilters = new QFilter[]{qfilter1, qfilter2, qfilter4, qfilter3};
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)"wf_dynamicformmapping", (String)DYNAMIC_FORM_NUMBER_NAME, (QFilter[])qFilters);
        if (WfUtils.isNullObject(dynamicObject)) {
            return null;
        }
        return dynamicObject.getLocaleString(DYNAMIC_FORM_NUMBER_NAME);
    }

    public static ILocaleString getBillSummaryNameByBillTypeNum(String formNumber, String number) {
        QFilter filter = new QFilter(BILL_TYPE, "=", (Object)formNumber);
        QFilter numFilter = new QFilter(NUMBER, "=", (Object)number);
        QFilter statusFilter = new QFilter("status", "=", (Object)"C");
        QFilter[] qFilters = new QFilter[]{filter, numFilter, statusFilter};
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)"bos_mobileformconfig", (String)QUERYNAME, (QFilter[])qFilters);
        if (WfUtils.isNullObject(dynamicObject)) {
            return null;
        }
        return dynamicObject.getLocaleString(QUERYNAME);
    }

    public static ILocaleString getMBillSummaryMulNameByEntityNumNum(String entityNumber, String number) {
        QFilter qfilter1 = new QFilter(BILL_TYPE, "=", (Object)entityNumber);
        QFilter qfilter2 = new QFilter("enable", "=", (Object)"1");
        QFilter qfilter3 = new QFilter("scene", "=", (Object)BillSummaryType.mobileSummary.name());
        QFilter qfilter4 = new QFilter(NUMBER, "=", (Object)number);
        QFilter[] qFilters = new QFilter[]{qfilter1, qfilter2, qfilter3, qfilter4};
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)"wf_mbillsummary_cfg", (String)QUERYNAME, (QFilter[])qFilters);
        if (WfUtils.isNullObject(dynamicObject)) {
            return null;
        }
        return dynamicObject.getLocaleString(QUERYNAME);
    }

    private static Map<String, Object> getBillPages(List<Map<String, Object>> items, String value) {
        HashMap<String, Object> billPages = new HashMap<String, Object>();
        billPages.put(SELECTEDVALUE, BillPagePluginUtil.getSelectedValue(items, value));
        billPages.put(DATAITEMS, items);
        return billPages;
    }

    private static Object getSelectedValue(List<Map<String, Object>> items, String value) {
        Object selectedValue = "";
        if (!items.isEmpty()) {
            selectedValue = WfUtils.isEmptyString(value) ? items.get(0).get("id") : value;
        }
        return selectedValue;
    }

    public static Map<String, Object> getParamstersOperation(Object formKey, Object entityId, FormShowParameter parameter, Boolean showSelChexkbox, String selectValues) {
        HashMap context = new HashMap();
        HashMap<String, Object> nodeProperties = new HashMap<String, Object>();
        nodeProperties.put("formKey", formKey);
        nodeProperties.put("entityId", entityId);
        context.put("nodeProperties", nodeProperties);
        Map params = parameter.getCustomParams();
        params.put("context", context);
        params.put("selchexkbox", showSelChexkbox);
        params.put(SELECTVALUES, selectValues);
        return params;
    }

    public static String getOperationInfosFromReturnValues(Object value, String fieldName) {
        String operationInfo = null;
        StringBuilder sb = new StringBuilder();
        if (value instanceof List) {
            List realValue = (List)value;
            for (Map map : realValue) {
                sb.append((String)map.get(fieldName)).append(',');
            }
        } else if (value instanceof Map) {
            Map map = (Map)value;
            sb.append((String)map.get(fieldName)).append(',');
        }
        if (WfUtils.isNotEmpty(sb.toString())) {
            String sbString = sb.toString();
            operationInfo = sbString.substring(0, sbString.length() - 1);
        }
        return operationInfo;
    }

    public static Map<String, Object> getParamstersForBillPageAttrCfg(Object entityName, Object entityNumber, Object formKey, Object formKeyText, FormShowParameter parameter, Boolean fieldModified, Boolean isMobile, Object selectedValues) {
        HashMap<String, Object> context = new HashMap<String, Object>();
        HashMap<String, Object> nodeProperties = new HashMap<String, Object>();
        nodeProperties.put("entityName", entityName);
        nodeProperties.put("entityNumber", entityNumber);
        if (isMobile.booleanValue()) {
            nodeProperties.put("mobilFormKey", formKey);
        } else {
            nodeProperties.put("formKey", formKey);
        }
        nodeProperties.put("formKeyText", formKeyText);
        nodeProperties.put("billSetting.fieldModified", fieldModified);
        context.put("nodeProperties", nodeProperties);
        String openPageType = isMobile != false ? "mobile" : "pc";
        context.put("openPageType", openPageType);
        Map params = parameter.getCustomParams();
        params.put("context", context);
        params.put("value", selectedValues);
        return params;
    }

    public static boolean isExistForFormId(String formId) {
        boolean exist = false;
        try {
            if (WfUtils.isNotEmpty(formId)) {
                FormConfig config = FormMetadataCache.getFormConfig((String)formId);
                return null != config;
            }
        }
        catch (Exception e) {
            logger.info(WfUtils.getExceptionStacktrace(e));
        }
        return exist;
    }

    public static String getCaptainForFormPage(String formKey, String defaultCaptain) {
        String wfCaptain = "";
        if (WfUtils.isNotEmpty(formKey)) {
            try {
                LocaleString captain;
                FormConfig config = FormMetadataCache.getFormConfig((String)formKey);
                if (null != config && null != (captain = config.getCaption())) {
                    wfCaptain = captain.getLocaleValue();
                }
            }
            catch (Exception e) {
                logger.info(e.getMessage());
            }
        }
        if (WfUtils.isEmpty(wfCaptain)) {
            wfCaptain = defaultCaptain;
        }
        return wfCaptain;
    }

    public static ILocaleString getMulCaptainForFormPage(String formKey, ILocaleString defaultCaptain) {
        LocaleString wfCaptain = new LocaleString();
        if (WfUtils.isNotEmpty(formKey)) {
            try {
                LocaleString captain;
                FormConfig config = FormMetadataCache.getFormConfig((String)formKey);
                if (null != config && null != (captain = config.getCaption())) {
                    wfCaptain = captain;
                }
            }
            catch (Exception e) {
                logger.info(e.getMessage());
            }
        }
        if (WfUtils.isEmpty((ILocaleString)wfCaptain)) {
            return defaultCaptain;
        }
        return wfCaptain;
    }

    public static List<DynamicObject> getAttachments(String formId, Object pkId) {
        List<Object> resultLists = new ArrayList();
        QFilter[] filters = new QFilter[]{new QFilter("FInterID", "=", pkId), new QFilter("FBillType", "=", (Object)formId)};
        DynamicObject[] objs = BusinessDataServiceHelper.load((String)"bos_attachment", (String)"FNUMBER,FATTACHMENTNAME,FATTACHMENTSIZE,FEXTNAME,FFILEID,fcreatetime", (QFilter[])filters);
        resultLists = Arrays.asList(objs);
        if (resultLists.size() > 0) {
            for (DynamicObject dynamicObject : resultLists) {
                String url = null;
                try {
                    url = URLEncoder.encode(AttachmentServiceHelper.removeUrlVersion((String)String.valueOf(dynamicObject.get("FFileId"))), StandardCharsets.UTF_8.name());
                }
                catch (UnsupportedEncodingException e) {
                    logger.info(WfUtils.getExceptionStacktrace(e));
                }
                String attUrl = EncreptSessionUtils.encryptSession((String)UrlService.getAttachmentFullUrl(url));
                dynamicObject.set("FFILEID", (Object)attUrl);
            }
        }
        return resultLists;
    }

    public static List<DynamicObject> getAttachment(String formId, Object pkId) {
        ArrayList<DynamicObject> resultLists = new ArrayList<DynamicObject>();
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)formId);
        Map propCollections = type.getFields();
        for (Map.Entry propMap : propCollections.entrySet()) {
            if (!(propMap.getValue() instanceof AttachmentProp)) continue;
            String tableName = ((AttachmentProp)propMap.getValue()).getAlias();
            DBRoute dBRoute = new DBRoute(type.getDBRouteKey());
            SqlParameter[] params = new SqlParameter[]{new SqlParameter(":FId", -5, pkId)};
            String sql = "SELECT FBasedataId FROM " + tableName + " WHERE FId = ?";
            List<Object> listBaseDataIds = BillPagePluginUtil.getQueryResult(dBRoute, sql, params);
            if (listBaseDataIds.size() <= 0) continue;
            Object[] objs = listBaseDataIds.toArray();
            QFilter[] filters = new QFilter[]{new QFilter("id", "in", (Object)objs)};
            DynamicObject[] objAtts = BusinessDataServiceHelper.load((String)"bd_attachment", (String)"uid,name,size,type,url,createtime", (QFilter[])filters);
            for (int i = 0; i < objAtts.length; ++i) {
                String path = objAtts[i].getString("url");
                if (!path.startsWith("/")) continue;
                String url = null;
                try {
                    url = URLEncoder.encode(path, StandardCharsets.UTF_8.name());
                }
                catch (UnsupportedEncodingException e) {
                    logger.info(WfUtils.getExceptionStacktrace(e));
                }
                String attUrl = EncreptSessionUtils.encryptSession((String)UrlService.getAttachmentFullUrl((String)url));
                objAtts[i].set("url", (Object)attUrl);
            }
            List<DynamicObject> attFieldLits = Arrays.asList(objAtts);
            resultLists.addAll(attFieldLits);
        }
        return resultLists;
    }

    private static List<Object> getQueryResult(DBRoute dBRoute, String sql, SqlParameter[] params) {
        List listBaseDataIds = (List)DB.query((DBRoute)dBRoute, (String)sql, (Object[])params, (ResultSetHandler)new ResultSetHandler<List<Object>>(){

            public List<Object> handle(ResultSet rs) {
                ArrayList<Object> list = new ArrayList<Object>();
                try {
                    while (rs.next()) {
                        list.add(rs.getLong(1));
                    }
                }
                catch (SQLException e) {
                    logger.info(WfUtils.getExceptionStacktrace(e));
                }
                return list;
            }
        });
        return listBaseDataIds;
    }
}

