/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.context.Context;
import kd.bos.workflow.engine.impl.persistence.entity.AbstractEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.Entity;

public class EntityUtil {
    private static final String CREATEDATE = "createDate";
    private static final String CREATETIME = "createtime";
    private static final String MODIFYDATE = "modifyDate";
    private static final String MODIFYTIME = "modifytime";

    public static <T extends Entity> T createEntity(Class<? extends Entity> managedEntityClass) {
        return (T)((Entity)TypesContainer.createInstance(managedEntityClass));
    }

    public static <T extends Entity> T createEntity(Class<? extends Entity> managedEntityClass, DynamicObject dynamicObject) {
        if (managedEntityClass == null) {
            throw new RuntimeException(" failed to  Create Instance,Class is Null.");
        }
        try {
            return (T)managedEntityClass.getConstructor(DynamicObject.class).newInstance(dynamicObject);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException arg1) {
            throw new RuntimeException(String.format("%s failed to  Create Instance: %s", managedEntityClass.getName(), arg1.getMessage()), arg1);
        }
    }

    public static <T extends Entity> List<T> toEntityCollection(Class<? extends Entity> clazz, DynamicObjectCollection dynamicObjectCollection) {
        if (dynamicObjectCollection == null || dynamicObjectCollection.isEmpty()) {
            return new ArrayList();
        }
        AbstractEntityManager manager = null;
        ArrayList ret = new ArrayList();
        for (DynamicObject dynamicObject : dynamicObjectCollection) {
            if (manager == null) {
                manager = Context.getCommandContext().getProcessEngineConfiguration().getEntityManagerByEntityClass(clazz);
            }
            ret.add(manager.create(dynamicObject));
        }
        return ret;
    }

    public static DynamicObject addCreateAndModifyInfo(DynamicObject dynObj, boolean flag) {
        String entityName = dynObj.getDynamicObjectType().getName();
        if (EntityUtil.entityInNotModifyList(entityName)) {
            return dynObj;
        }
        DataEntityPropertyCollection dc = dynObj.getDataEntityType().getProperties();
        if (flag) {
            if (dc.get((Object)"creatorId") != null) {
                dynObj.set("creatorId", (Object)WfUtils.getCurrentUser());
            }
            if (dc.get((Object)CREATEDATE) != null) {
                dynObj.set(CREATEDATE, (Object)WfUtils.now());
            }
            if (dc.get((Object)CREATETIME) != null) {
                dynObj.set(CREATETIME, (Object)WfUtils.now());
            }
        }
        if (dc.get((Object)"modifierId") != null) {
            dynObj.set("modifierId", (Object)WfUtils.getCurrentUser());
        }
        if (dc.get((Object)MODIFYDATE) != null) {
            dynObj.set(MODIFYDATE, (Object)WfUtils.now());
        }
        if (dc.get((Object)MODIFYTIME) != null) {
            dynObj.set(MODIFYTIME, (Object)WfUtils.now());
        }
        return dynObj;
    }

    private static boolean entityInNotModifyList(String entityName) {
        switch (entityName) {
            case "wf_historicjobrecord": 
            case "evt_hijob": 
            case "evt_hiabnormalsubs": 
            case "wf_hicomment": {
                return true;
            }
        }
        return false;
    }
}

