/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine;

import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.workflow.engine.HistoryService;
import kd.bos.workflow.engine.ManagementService;
import kd.bos.workflow.engine.ProcessEngine;
import kd.bos.workflow.engine.ProcessEngineLifecycleListener;
import kd.bos.workflow.engine.RepositoryService;
import kd.bos.workflow.engine.RuntimeService;
import kd.bos.workflow.engine.TaskService;
import kd.bos.workflow.engine.impl.agenda.DefaultActivitiAgenda;
import kd.bos.workflow.engine.impl.asyncexecutor.AsyncExecutor;
import kd.bos.workflow.engine.impl.cfg.ProcessEngineConfigurationImpl;
import kd.bos.workflow.engine.impl.cfg.multitenant.MultiSchemaMultiTenantProcessEngineConfiguration;
import kd.bos.workflow.engine.impl.history.HistoryLevel;
import kd.bos.workflow.engine.impl.runtime.ActivitiAgenda;
import kd.bos.workflow.engine.msg.MessageService;
import kd.bos.workflow.engine.msg.quantitysum.MessageQuantitySummaryServcie;
import kd.bos.workflow.engine.runtime.Clock;
import kd.bos.workflow.exception.WFEngineException;

public abstract class ProcessEngineConfiguration {
    protected static Log logger = LogFactory.getLog(ProcessEngineConfiguration.class);
    public static final String DB_SCHEMA_UPDATE_FALSE = "false";
    public static final String DB_SCHEMA_UPDATE_CREATE_DROP = "create-drop";
    public static final String DB_SCHEMA_UPDATE_TRUE = "false";
    public static final String NO_TENANT_ID = "";
    protected String processEngineName = "default";
    protected String history = HistoryLevel.AUDIT.getKey();
    protected boolean asyncExecutorActivate;
    protected HistoryLevel historyLevel;
    protected Clock clock;
    protected AsyncExecutor asyncExecutor;
    protected int lockTimeAsyncJobWaitTime = 60;
    protected int defaultFailedJobWaitTime = 3;
    protected int asyncFailedJobWaitTime = 3;
    protected boolean createDiagramOnDeploy = false;
    protected String xmlEncoding = "UTF-8";
    protected String defaultCamelContext = "camelContext";
    protected ClassLoader classLoader;
    protected boolean useClassForNameClassLoading = true;
    protected ProcessEngineLifecycleListener processEngineLifecycleListener;
    protected boolean enableProcessDefinitionInfoCache = false;

    protected ProcessEngineConfiguration() {
    }

    public abstract ProcessEngine buildProcessEngine();

    public static ProcessEngineConfigurationImpl createMultiTenantProcessEngineConfiguration() {
        logger.debug("createMultiTenantProcessEngineConfiguration in ProcessEngineConfiguration");
        MultiSchemaMultiTenantProcessEngineConfiguration configuration = new MultiSchemaMultiTenantProcessEngineConfiguration();
        return configuration;
    }

    public abstract RepositoryService getRepositoryService();

    public abstract RuntimeService getRuntimeService();

    public abstract TaskService getTaskService();

    public abstract HistoryService getHistoryService();

    public abstract ManagementService getManagementService();

    public abstract MessageService getMessageService();

    public abstract MessageQuantitySummaryServcie getMessageQuantitySummaryService();

    public abstract ProcessEngineConfiguration getProcessEngineConfiguration();

    public String getProcessEngineName() {
        return this.processEngineName;
    }

    public ProcessEngineConfiguration setProcessEngineName(String processEngineName) {
        this.processEngineName = processEngineName;
        return this;
    }

    public String getHistory() {
        return this.history;
    }

    public ProcessEngineConfiguration setHistory(String history) {
        this.history = history;
        return this;
    }

    public HistoryLevel getHistoryLevel() {
        return this.historyLevel;
    }

    public ProcessEngineConfiguration setHistoryLevel(HistoryLevel historyLevel) {
        this.historyLevel = historyLevel;
        return this;
    }

    public boolean isAsyncExecutorActivate() {
        return this.asyncExecutorActivate;
    }

    public ProcessEngineConfiguration setAsyncExecutorActivate(boolean asyncExecutorActivate) {
        this.asyncExecutorActivate = asyncExecutorActivate;
        return this;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public ProcessEngineConfiguration setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
        return this;
    }

    public boolean isUseClassForNameClassLoading() {
        return this.useClassForNameClassLoading;
    }

    public ProcessEngineConfiguration setUseClassForNameClassLoading(boolean useClassForNameClassLoading) {
        this.useClassForNameClassLoading = useClassForNameClassLoading;
        return this;
    }

    public String getDefaultCamelContext() {
        return this.defaultCamelContext;
    }

    public ProcessEngineConfiguration setDefaultCamelContext(String defaultCamelContext) {
        this.defaultCamelContext = defaultCamelContext;
        return this;
    }

    public boolean isCreateDiagramOnDeploy() {
        return this.createDiagramOnDeploy;
    }

    public ProcessEngineConfiguration setCreateDiagramOnDeploy(boolean createDiagramOnDeploy) {
        this.createDiagramOnDeploy = createDiagramOnDeploy;
        return this;
    }

    public ProcessEngineConfiguration setProcessEngineLifecycleListener(ProcessEngineLifecycleListener processEngineLifecycleListener) {
        this.processEngineLifecycleListener = processEngineLifecycleListener;
        return this;
    }

    public ProcessEngineLifecycleListener getProcessEngineLifecycleListener() {
        return this.processEngineLifecycleListener;
    }

    public String getXmlEncoding() {
        return this.xmlEncoding;
    }

    public ProcessEngineConfiguration setXmlEncoding(String xmlEncoding) {
        this.xmlEncoding = xmlEncoding;
        return this;
    }

    public Clock getClock() {
        return this.clock;
    }

    public ProcessEngineConfiguration setClock(Clock clock) {
        this.clock = clock;
        return this;
    }

    public AsyncExecutor getAsyncExecutor() {
        return this.asyncExecutor;
    }

    public ProcessEngineConfiguration setAsyncExecutor(AsyncExecutor asyncExecutor) {
        this.asyncExecutor = asyncExecutor;
        return this;
    }

    public int getLockTimeAsyncJobWaitTime() {
        return this.lockTimeAsyncJobWaitTime;
    }

    public ProcessEngineConfiguration setLockTimeAsyncJobWaitTime(int lockTimeAsyncJobWaitTime) {
        this.lockTimeAsyncJobWaitTime = lockTimeAsyncJobWaitTime;
        return this;
    }

    public int getDefaultFailedJobWaitTime() {
        return this.defaultFailedJobWaitTime;
    }

    public ProcessEngineConfiguration setDefaultFailedJobWaitTime(int defaultFailedJobWaitTime) {
        this.defaultFailedJobWaitTime = defaultFailedJobWaitTime;
        return this;
    }

    public int getAsyncFailedJobWaitTime() {
        return this.asyncFailedJobWaitTime;
    }

    public ProcessEngineConfiguration setAsyncFailedJobWaitTime(int asyncFailedJobWaitTime) {
        this.asyncFailedJobWaitTime = asyncFailedJobWaitTime;
        return this;
    }

    public boolean isEnableProcessDefinitionInfoCache() {
        return this.enableProcessDefinitionInfoCache;
    }

    public ProcessEngineConfiguration setEnableProcessDefinitionInfoCache(boolean enableProcessDefinitionInfoCache) {
        this.enableProcessDefinitionInfoCache = enableProcessDefinitionInfoCache;
        return this;
    }

    public ActivitiAgenda createAgenda() {
        try {
            return new DefaultActivitiAgenda();
        }
        catch (Exception e) {
            throw new WFEngineException("Unable to create agenda.", e);
        }
    }

    public void refreshAccountConfig() {
    }
}

