/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.workflow.engine.ProcessEngine;
import kd.bos.workflow.engine.ProcessEngineConfiguration;
import kd.bos.workflow.engine.ProcessEngineInfo;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.delegate.event.ActivitiEventListener;
import kd.bos.workflow.engine.delegate.event.ActivitiEventType;
import kd.bos.workflow.engine.impl.ProcessEngineInfoImpl;
import kd.bos.workflow.engine.impl.cfg.ProcessEngineConfigurationImpl;
import kd.bos.workflow.engine.listener.JobFinishExecuteTestingPlanListener;
import kd.bos.workflow.engine.runtime.EnterBoundaryErrorListener;
import kd.bos.workflow.engine.task.center.EntityCreateListener;
import kd.bos.workflow.engine.task.center.EntityDeleteListener;
import kd.bos.workflow.engine.task.center.EntityUpdateListener;
import kd.bos.workflow.engine.task.center.ProcessCreateListener;
import kd.bos.workflow.engine.task.center.ProcessDeleteListener;
import kd.bos.workflow.engine.task.center.TaskAssignListener;
import kd.bos.workflow.engine.task.center.TaskCompleteListener;
import kd.bos.workflow.engine.task.center.TaskCoordinateListener;
import kd.bos.workflow.engine.task.center.TaskCreateListener;
import kd.bos.workflow.engine.task.center.TaskDelegateListener;
import kd.bos.workflow.engine.task.center.TaskDelegateResumeListener;
import kd.bos.workflow.engine.task.center.TaskDeleteListener;
import kd.bos.workflow.engine.task.center.TaskSkipListener;
import kd.bos.workflow.engine.task.center.TaskTransferListener;
import kd.bos.workflow.engine.task.center.TaskTransferWithdrawListener;
import kd.bos.workflow.engine.task.center.TaskWithdrawDeleteListener;
import kd.bos.workflow.engine.task.center.TaskWithdrawRestoreListener;
import kd.bos.workflow.exception.WFErrorCode;
import kd.bos.workflow.exception.WFException;

public abstract class ProcessEngines {
    protected static Log log = LogFactory.getLog(ProcessEngines.class);
    public static final String NAME_DEFAULT = "default";
    protected static Map<String, ProcessEngine> processEnginesMap = new HashMap<String, ProcessEngine>();
    protected static Map<String, ProcessEngineInfo> processEngineInfosByName = new HashMap<String, ProcessEngineInfo>();
    protected static Map<String, ProcessEngineInfo> processEngineInfosByResourceUrl = new HashMap<String, ProcessEngineInfo>();
    protected static List<ProcessEngineInfo> processEngineInfos = new ArrayList<ProcessEngineInfo>();

    public static synchronized void init() {
        ProcessEngines.init(NAME_DEFAULT);
    }

    public static synchronized void init(String engineName) {
        if (!ProcessEngines.isInitialized(engineName)) {
            if (processEnginesMap == null) {
                processEnginesMap = new HashMap<String, ProcessEngine>();
            }
            try {
                ProcessEngines.initProcessEngineFromDefault(engineName);
            }
            catch (Exception e) {
                throw new KDBizException((Throwable)e, WFErrorCode.engineStartErrored(), new Object[]{e.getMessage()});
            }
        } else {
            log.info("Process engines already initialized");
        }
    }

    public static void registerProcessEngine(ProcessEngine processEngine) {
        processEnginesMap.put(processEngine.getName(), processEngine);
    }

    public static void unregister(ProcessEngine processEngine) {
        processEnginesMap.remove(processEngine.getName());
    }

    private static ProcessEngineInfo initProcessEngineFromDefault(String engineName) {
        ProcessEngineInfo processEngineInfo = processEngineInfosByResourceUrl.get(engineName);
        if (processEngineInfo != null) {
            processEngineInfos.remove(processEngineInfo);
            if (processEngineInfo.getException() == null) {
                String processEngineName = processEngineInfo.getName();
                processEnginesMap.remove(processEngineName);
                processEngineInfosByName.remove(processEngineName);
            }
            processEngineInfosByResourceUrl.remove(processEngineInfo.getResourceUrl());
        }
        try {
            ProcessEngine processEngine = null;
            processEngine = ProcessEngines.buildProcessEngine();
            processEngine.setInitialized(true);
            String processEngineName = processEngine.getName();
            log.info(String.format("initialised process engine %s", processEngineName));
            processEngineInfo = new ProcessEngineInfoImpl(processEngineName, engineName, null);
            processEnginesMap.put(processEngineName, processEngine);
            processEngineInfosByName.put(processEngineName, processEngineInfo);
        }
        catch (Exception e) {
            log.error(String.format("Exception while initializing process engine: %s", e.getMessage()), (Throwable)e);
            throw new WFException(e.getMessage(), e);
        }
        processEngineInfosByResourceUrl.put(engineName, processEngineInfo);
        processEngineInfos.add(processEngineInfo);
        return processEngineInfo;
    }

    private static ProcessEngine buildProcessEngine() {
        ProcessEngineConfigurationImpl processEngineConfiguration = null;
        processEngineConfiguration = ProcessEngineConfiguration.createMultiTenantProcessEngineConfiguration();
        processEngineConfiguration.setAsyncExecutorActivate(true);
        processEngineConfiguration.setAsyncExecutorMessageQueueMode(true);
        processEngineConfiguration.setTypedEventListeners(ProcessEngines.getTypeListeners());
        processEngineConfiguration.setTestingEventListeners(ProcessEngines.getTestingListeners());
        int limit = WfConfigurationUtil.getProcessModelCacheLimit();
        if (limit > 0) {
            processEngineConfiguration.setProcessDefinitionCacheLimit(limit);
        } else {
            processEngineConfiguration.setProcessDefinitionCacheLimit(300);
        }
        processEngineConfiguration.setTestingPlanEventListeners(ProcessEngines.getTestingPlanListeners());
        processEngineConfiguration.setEnableEventDispatcher(!WfConfigurationUtil.disableInnerEvent());
        processEngineConfiguration.setEnableBecEventDispatcher(!WfConfigurationUtil.disableBecEventTrigger());
        processEngineConfiguration.setEnableDatabaseEventLogging(!WfConfigurationUtil.disableEventLog());
        processEngineConfiguration.setEnableOperationLogging(!WfConfigurationUtil.disableOperationLog());
        ProcessEngine engine = processEngineConfiguration.buildProcessEngine();
        return engine;
    }

    private static Map<String, List<ActivitiEventListener>> getTypeListeners() {
        HashMap<String, List<ActivitiEventListener>> typedListeners = new HashMap<String, List<ActivitiEventListener>>(16);
        ArrayList<ActivitiEventListener> listeners = null;
        listeners = new ArrayList<ActivitiEventListener>();
        listeners.add(new EnterBoundaryErrorListener());
        typedListeners.put(ActivitiEventType.NODE_ENTERBOUNDARYERROR.name(), listeners);
        listeners = new ArrayList();
        listeners.add(new EntityCreateListener());
        typedListeners.put(ActivitiEventType.ENTITY_CREATED.name(), listeners);
        listeners = new ArrayList();
        listeners.add(new EntityDeleteListener());
        typedListeners.put(ActivitiEventType.ENTITY_DELETED.name(), listeners);
        listeners = new ArrayList();
        listeners.add(new EntityUpdateListener());
        typedListeners.put(ActivitiEventType.ENTITY_UPDATED.name(), listeners);
        listeners = new ArrayList();
        listeners.add(new TaskTransferListener());
        typedListeners.put(ActivitiEventType.TASK_TRANSFER.name(), listeners);
        listeners = new ArrayList();
        listeners.add(new TaskTransferWithdrawListener());
        typedListeners.put(ActivitiEventType.TASK_WITHDRAWTRANSFER.name(), listeners);
        listeners = new ArrayList();
        listeners.add(new TaskCoordinateListener());
        typedListeners.put(ActivitiEventType.TASK_COORDINATE.name(), listeners);
        listeners = new ArrayList();
        listeners.add(new TaskDelegateListener());
        typedListeners.put(ActivitiEventType.TASK_DELEGATE.name(), listeners);
        listeners = new ArrayList();
        listeners.add(new TaskDelegateResumeListener());
        typedListeners.put(ActivitiEventType.TASK_DELEGATERESUME.name(), listeners);
        listeners = new ArrayList();
        listeners.add(new TaskWithdrawDeleteListener());
        typedListeners.put(ActivitiEventType.TASKWITHDRAW_DELETE.name(), listeners);
        listeners = new ArrayList();
        listeners.add(new TaskWithdrawRestoreListener());
        typedListeners.put(ActivitiEventType.TASKWITHDRAW_RESTORE.name(), listeners);
        listeners = new ArrayList();
        listeners.add(new TaskCreateListener());
        typedListeners.put(ActivitiEventType.TASK_CREATED.name(), listeners);
        listeners = new ArrayList();
        listeners.add(new TaskAssignListener());
        typedListeners.put(ActivitiEventType.TASK_ASSIGN.name(), listeners);
        listeners = new ArrayList();
        listeners.add(new TaskSkipListener());
        typedListeners.put(ActivitiEventType.TASK_SKIP.name(), listeners);
        listeners = new ArrayList();
        listeners.add(new TaskCompleteListener());
        typedListeners.put(ActivitiEventType.TASK_COMPLETED.name(), listeners);
        listeners = new ArrayList();
        listeners.add(new TaskDeleteListener());
        typedListeners.put(ActivitiEventType.TASK_DELETED.name(), listeners);
        listeners = new ArrayList();
        listeners.add(new ProcessCreateListener());
        typedListeners.put(ActivitiEventType.PROCESS_STARTED.name(), listeners);
        listeners = new ArrayList();
        listeners.add(new ProcessDeleteListener());
        typedListeners.put(ActivitiEventType.PROCESS_DELETE.name(), listeners);
        return typedListeners;
    }

    private static Map<String, List<ActivitiEventListener>> getTestingListeners() {
        HashMap<String, List<ActivitiEventListener>> testingListeners = new HashMap<String, List<ActivitiEventListener>>();
        return testingListeners;
    }

    private static Map<String, List<ActivitiEventListener>> getTestingPlanListeners() {
        HashMap<String, List<ActivitiEventListener>> testingPlanListeners = new HashMap<String, List<ActivitiEventListener>>();
        ArrayList<JobFinishExecuteTestingPlanListener> listeners = new ArrayList<JobFinishExecuteTestingPlanListener>();
        listeners.add(new JobFinishExecuteTestingPlanListener());
        testingPlanListeners.put(ActivitiEventType.JOB_FINISH_DOTESTINGPLAN.name(), listeners);
        return testingPlanListeners;
    }

    public static List<ProcessEngineInfo> getProcessEngineInfos() {
        return processEngineInfos;
    }

    public static ProcessEngineInfo getProcessEngineInfo(String processEngineName) {
        return processEngineInfosByName.get(processEngineName);
    }

    public static ProcessEngine getDefaultProcessEngine() {
        return ProcessEngines.getProcessEngine(NAME_DEFAULT);
    }

    public static ProcessEngine getProcessEngine(String processEngineName) {
        if (!ProcessEngines.isInitialized(processEngineName)) {
            ProcessEngines.init(processEngineName);
        }
        return processEnginesMap.get(processEngineName);
    }

    public static Map<String, ProcessEngine> getProcessEngines() {
        return processEnginesMap;
    }

    public static synchronized void destroy() {
        HashMap<String, ProcessEngine> engines = new HashMap<String, ProcessEngine>(processEnginesMap);
        processEnginesMap = new HashMap<String, ProcessEngine>();
        for (Map.Entry entry : engines.entrySet()) {
            String processEngineName = (String)entry.getKey();
            ProcessEngine processEngine = (ProcessEngine)entry.getValue();
            try {
                processEngine.close();
            }
            catch (Exception e) {
                log.error(String.format("exception while closing %s", processEngineName == null ? "the default process engine" : "process engine " + processEngineName), (Throwable)e);
            }
        }
        processEngineInfosByName.clear();
        processEngineInfosByResourceUrl.clear();
        processEngineInfos.clear();
    }

    public static boolean isInitialized(String engineName) {
        ProcessEngine processEngine = processEnginesMap.get(engineName);
        return processEngine != null && processEngine.isInitialized();
    }

    public static boolean isInitialized() {
        ProcessEngine processEngine = processEnginesMap.get(NAME_DEFAULT);
        return processEngine != null && processEngine.isInitialized();
    }
}

