/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine;

import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.license.api.LicenseCheckResult;
import kd.bos.servicehelper.license.LicenseServiceHelper;
import kd.bos.thread.ThreadTruck;
import kd.bos.workflow.exception.WFEngineException;
import kd.bos.workflow.exception.WFErrorCode;
import kd.bos.workflow.nocode.NoCodeFlowUtil;

public class WFLicenseUtil {
    private static final String CPWFS = "CP_WFS";
    private static final String CPWFSFLOWLIMIT = "CP_WFS_N";
    private static final Long CPWFSFLOWLIMITID = 441L;

    private static boolean isFlowLimitLicense() {
        return WFLicenseUtil.checkLicense(CPWFSFLOWLIMIT) && !WFLicenseUtil.isProfessionalLicense();
    }

    private static boolean isProfessionalLicense() {
        return WFLicenseUtil.checkLicense(CPWFS);
    }

    private static void checkWfLicense() {
        if (!WFLicenseUtil.isProfessionalLicense() && !WFLicenseUtil.isFlowLimitLicense()) {
            throw new WFEngineException(WFErrorCode.licenseVerifyException(), null);
        }
    }

    private static boolean checkLicense(String groupNumber) {
        LicenseCheckResult ret = LicenseServiceHelper.checkPerformGroup((String)groupNumber);
        return ret.getHasLicense();
    }

    private static int getLicenseAllowCount(Object groupId) {
        return LicenseServiceHelper.getTotalNumber((Object)groupId);
    }

    private static int getFlowLimitLicenseAllowCount() {
        return WFLicenseUtil.getLicenseAllowCount(CPWFSFLOWLIMITID);
    }

    public static void checkLicenseAllowCount(long num) {
        WFLicenseUtil.checkLicenseAllowCount(num, Boolean.TRUE, Boolean.TRUE);
    }

    public static void checkLicenseAllowCount(long num, Boolean canEquals, Boolean checkLicense) {
        Object separateStorageKey = ThreadTruck.get((Object)"separateStorageKey");
        if ("nocode".equals(separateStorageKey)) {
            boolean isNoLoginRequired = Boolean.TRUE.equals(ThreadTruck.get((Object)"noLoginRequired"));
            if (!isNoLoginRequired && !NoCodeFlowUtil.hasNoCodeLicense()) {
                throw new KDBizException(ResManager.loadKDString((String)"\u6ca1\u6709\u65e0\u4ee3\u7801\u670d\u52a1\u8fd0\u884c\u65f6\u8bb8\u53ef\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"LicenseUtil_2", (String)"bos-wf-engine", (Object[])new Object[0]));
            }
            return;
        }
        if (checkLicense.booleanValue()) {
            WFLicenseUtil.checkWfLicense();
        }
        if (WFLicenseUtil.isFlowLimitLicense() && (canEquals.booleanValue() && num >= (long)WFLicenseUtil.getFlowLimitLicenseAllowCount() || !canEquals.booleanValue() && num > (long)WFLicenseUtil.getFlowLimitLicenseAllowCount())) {
            throw new WFEngineException(WFErrorCode.licenseExceedLimitException(), null);
        }
    }

    public static String getExceedLimitNotice() {
        return ResManager.loadKDString((String)"\u8d85\u51fa\u6d41\u91cf\u7248\u8bb8\u53ef\u6388\u6743\u6d41\u7a0b\u4f7f\u7528\u6761\u6570\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"LicenseUtil_0", (String)"bos-wf-engine", (Object[])new Object[0]);
    }

    public static String getVersionTooLowNotice() {
        return ResManager.loadKDString((String)"\u5ba2\u6237\u6ca1\u6709\u8d2d\u4e70\u6d41\u7a0b\u670d\u52a1\u7684\u4ea7\u54c1\u8bb8\u53ef\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"LicenseUtil_1", (String)"bos-wf-engine", (Object[])new Object[0]);
    }
}

