/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.cache.WfCacheHelper;

public class WfAdminUtil {
    private static final Log log = LogFactory.getLog(WfAdminUtil.class);
    private static final String WFMANAGER_ROLE_ID = "1GB7AW=QYD2S";
    public static final String KEY_ALLSUPERIORBYCONF = "allSuperiorByConf";
    public static final String KEY_WITHSUBORDINATEBYCONF = "withSubordinateByConf";
    private static final String KEY = "key";
    private static final String USERID = "userid";
    private static final String ORGUNITID = "orgunitid";
    private static final String CATEGORYID = "categoryid";
    protected static final Set<String> NEEDFILTERFORMIDS = new HashSet<String>();

    public static Map<String, HashSet<Long>> getWfOrgUnitsByUserId(Long userId) {
        HashMap<String, HashSet<Long>> ret = null;
        try {
            QFilter[] filters = new QFilter[]{new QFilter(USERID, "=", (Object)userId)};
            DynamicObject wfAdmin = BusinessDataServiceHelper.loadSingleFromCache((String)"wf_administrator", (QFilter[])filters);
            if (null != wfAdmin) {
                ret = new HashMap<String, HashSet<Long>>();
                HashSet allSuperiorByConf = new HashSet();
                HashSet<Long> withSubordinateByConf = new HashSet<Long>();
                long rootOrgId = OrgUnitServiceHelper.getRootOrgId();
                Object orgEntry = wfAdmin.get("orgentry");
                if (null != orgEntry) {
                    for (DynamicObject o : (DynamicObjectCollection)orgEntry) {
                        DynamicObject org = (DynamicObject)o.get("orgid");
                        if (org == null) continue;
                        Long currentOrgId = (Long)org.getPkValue();
                        String orgType = o.getString("orgtype");
                        if (WfUtils.isEmpty(currentOrgId) || WfUtils.isEmpty(orgType)) continue;
                        if (rootOrgId == currentOrgId) {
                            withSubordinateByConf.add(rootOrgId);
                            ret.put(KEY_WITHSUBORDINATEBYCONF, withSubordinateByConf);
                            return ret;
                        }
                        List parentIds = OrgUnitServiceHelper.getAllSuperiorOrgs((String)orgType, (long)currentOrgId);
                        allSuperiorByConf.addAll(parentIds);
                        if (WfUtils.isEmpty(orgType)) {
                            orgType = "15";
                        }
                        ArrayList<Long> input = new ArrayList<Long>(1);
                        input.add(currentOrgId);
                        List subOrgIds = OrgUnitServiceHelper.getAllSubordinateOrgs((String)orgType, input, (boolean)true);
                        withSubordinateByConf.addAll(subOrgIds);
                    }
                }
                ret.put(KEY_ALLSUPERIORBYCONF, allSuperiorByConf);
                ret.put(KEY_WITHSUBORDINATEBYCONF, withSubordinateByConf);
            }
        }
        catch (Exception e) {
            log.error("WfAdminUtil.getWfOrgUnitsByUserId error " + WfUtils.getExceptionStacktrace(e));
        }
        return ret;
    }

    public static void addWfOrgFilter(SetFilterEvent e, String billFormId) {
        if (!WfConfigurationUtil.isFilterDataByOrg()) {
            return;
        }
        if (NEEDFILTERFORMIDS.contains(billFormId)) {
            long userId = Long.parseLong(RequestContext.get().getUserId());
            List allSuperiorByConf = new ArrayList();
            List<Long> withSubordinateByConf = new ArrayList<Long>();
            Map<String, Object> ret = WfAdminUtil.getWfAdminCache(userId + "");
            if (null != ret) {
                withSubordinateByConf = (List)WfUtils.stringToCollection((String)ret.get(KEY_WITHSUBORDINATEBYCONF), ",");
                allSuperiorByConf = (List)WfUtils.stringToCollection((String)ret.get(KEY_ALLSUPERIORBYCONF), ",");
            }
            long rootOrgId = OrgUnitServiceHelper.getRootOrgId();
            if (WfUtils.isNotEmptyForCollection(withSubordinateByConf)) {
                if (withSubordinateByConf.contains(rootOrgId)) {
                    return;
                }
            } else {
                withSubordinateByConf.add(-1L);
            }
            ArrayList orgInner = new ArrayList();
            orgInner.addAll(allSuperiorByConf);
            orgInner.addAll(withSubordinateByConf);
            List qFilters = e.getQFilters();
            if ("wf_processdefinition".equals(billFormId)) {
                qFilters.add(new QFilter(ORGUNITID, "in", orgInner));
            } else if ("wf_model".equals(billFormId)) {
                qFilters.add(new QFilter(ORGUNITID, "in", withSubordinateByConf));
            } else if ("wf_execution".equals(billFormId) || "wf_historicalprocesses".equals(billFormId)) {
                qFilters.add(new QFilter("mainorgid", "in", withSubordinateByConf));
            } else if ("wf_role".equals(billFormId)) {
                qFilters.add(new QFilter("orgunit", "in", orgInner));
            } else if ("wf_processinfo".equals(billFormId)) {
                qFilters.add(new QFilter("orgid", "in", withSubordinateByConf));
            } else {
                qFilters.add(new QFilter(ORGUNITID, "in", withSubordinateByConf));
            }
            e.setQFilters(qFilters);
        }
    }

    public static Map<String, Object> getWfAdminCache(String userId) {
        HashMap<String, Object> ret = null;
        String value1 = WfCacheHelper.getWfAdminCache(KEY_WITHSUBORDINATEBYCONF, userId);
        if (null != value1) {
            String value2 = WfCacheHelper.getWfAdminCache(KEY_ALLSUPERIORBYCONF, userId);
            ret = new HashMap<String, Object>();
            ret.put(KEY, userId);
            ret.put(KEY_WITHSUBORDINATEBYCONF, value1);
            ret.put(KEY_ALLSUPERIORBYCONF, value2);
        } else {
            Map<String, HashSet<Long>> dataFromDb = WfAdminUtil.getWfOrgUnitsByUserId(Long.parseLong(userId));
            if (null != dataFromDb) {
                HashSet<Long> withSubordinateByConf = dataFromDb.get(KEY_WITHSUBORDINATEBYCONF);
                HashSet<Long> allSuperiorByConf = dataFromDb.get(KEY_ALLSUPERIORBYCONF);
                String v1 = WfUtils.listToString(withSubordinateByConf, ",");
                String v2 = WfUtils.listToString(allSuperiorByConf, ",");
                WfCacheHelper.putWfAdminCache(KEY_WITHSUBORDINATEBYCONF, userId, v1);
                WfCacheHelper.putWfAdminCache(KEY_ALLSUPERIORBYCONF, userId, v2);
                ret = new HashMap();
                ret.put(KEY, userId);
                ret.put(KEY_WITHSUBORDINATEBYCONF, v1);
                ret.put(KEY_ALLSUPERIORBYCONF, v2);
            }
        }
        return ret;
    }

    public static boolean isWfAdmin(Long userId) {
        String cacheValue = WfCacheHelper.getWfAdminUserIdsCache();
        if (WfUtils.isNotEmpty(cacheValue)) {
            List valueList = (List)WfUtils.stringToCollection(cacheValue, ",");
            return valueList.contains(userId);
        }
        ArrayList<Long> results = new ArrayList<Long>();
        StringBuilder sql = new StringBuilder();
        sql.append("select fuserid from t_wf_admins");
        try (DataSet ds = DB.queryDataSet((String)"wf.engine.getPrivateProcess", (DBRoute)DBRoute.workflow, (String)sql.toString(), null);){
            for (Row row : ds) {
                results.add(row.getLong("fuserid"));
            }
        }
        String resultStr = WfUtils.listToString(results, ",");
        WfCacheHelper.putWfAdminUserIdsCache(resultStr);
        return results.contains(userId);
    }

    public static boolean isAdminForOrg(Long userId, Long orgId) {
        boolean ret = false;
        Map<String, Object> data = WfAdminUtil.getWfAdminCache(userId + "");
        if (null != data) {
            List withSubordinateByConf = (List)WfUtils.stringToCollection((String)data.get(KEY_WITHSUBORDINATEBYCONF), ",");
            long rootOrgId = OrgUnitServiceHelper.getRootOrgId();
            if (null != withSubordinateByConf && (withSubordinateByConf.contains(rootOrgId) || withSubordinateByConf.contains(orgId))) {
                return true;
            }
        }
        return ret;
    }

    public static boolean isWfManager(Long userId) {
        boolean ret = false;
        Set roleIds = PermissionServiceHelper.getRolesByUser((Long)userId);
        if (roleIds.contains(WFMANAGER_ROLE_ID)) {
            return true;
        }
        return ret;
    }

    public static boolean controlBtnByAdmin(Long userId) {
        return WfConfigurationUtil.isFilterDataByOrg() && !WfAdminUtil.isWfAdmin(userId);
    }

    public static boolean canDoOperation(Long userId, Long orgId) {
        if (!WfConfigurationUtil.isFilterDataByOrg()) {
            return true;
        }
        return WfAdminUtil.isAdminForOrg(userId, orgId);
    }

    public static void removeWfAdminCache(String userId) {
        WfCacheHelper.removeWfAdminCache(KEY_WITHSUBORDINATEBYCONF, userId);
        WfCacheHelper.removeWfAdminCache(KEY_ALLSUPERIORBYCONF, userId);
    }

    public static boolean needFilterData() {
        Object needFilter = WfConfigurationUtil.getConfigCenterVal("workflow.processdata.filter");
        return "true".equals(needFilter);
    }

    public static List<Long> getUserIdsFromAppEntry(Long procDefId) {
        ArrayList<Long> userIds = new ArrayList<Long>();
        Long categoryId = null;
        if (WfUtils.isNotEmpty(procDefId)) {
            QFilter qFilter1 = new QFilter("id", "=", (Object)procDefId);
            QFilter[] qFilters = new QFilter[]{qFilter1};
            DynamicObject obj = BusinessDataServiceHelper.loadSingle((String)"wf_processdefinition", (String)CATEGORYID, (QFilter[])qFilters);
            if (null != obj) {
                categoryId = obj.getLong(CATEGORYID);
            }
        }
        if (WfUtils.isNotEmpty(categoryId)) {
            StringBuilder sb = new StringBuilder();
            sb.append("select t1.fuserid from t_wf_admins t1 left join t_wf_adminsappentry t2 on t1.fid=t2.fid ");
            sb.append("where t1.fstatus='1' and t2.freceivemsg='1' and t2.fappids like '%");
            sb.append(categoryId).append("%'");
            try (DataSet ds = DB.queryDataSet((String)"getUserIdsFromAppEntry", (DBRoute)DBRoute.workflow, (String)sb.toString());){
                for (Row row : ds) {
                    userIds.add(row.getLong("fuserid"));
                }
            }
        }
        return userIds;
    }

    static {
        NEEDFILTERFORMIDS.add("wf_model");
        NEEDFILTERFORMIDS.add("wf_processdefinition");
        NEEDFILTERFORMIDS.add("wf_execution");
        NEEDFILTERFORMIDS.add("wf_historicalprocesses");
        NEEDFILTERFORMIDS.add("wf_taskmonitoring");
        NEEDFILTERFORMIDS.add("wf_deadletterjob");
        NEEDFILTERFORMIDS.add("wf_role");
        NEEDFILTERFORMIDS.add("wf_processinfo");
    }
}

