/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.workflow.bpmn.model.AfterAuditModel;
import kd.bos.workflow.bpmn.model.Process;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.context.Context;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.IdentityLinkEntity;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskEntity;
import kd.bos.workflow.engine.impl.util.ProcessDefinitionUtil;

public class WfAfterAuditUtil {
    private WfAfterAuditUtil() {
    }

    public static Set<Long> getPersonByKeyAuditor(List<Long> keyAuditor) {
        CommandContext commandContext = Context.getCommandContext();
        return commandContext.getKeyAuditorEntityManager().getPersonByKeyAuditor(keyAuditor);
    }

    public static Boolean canDoAfterAudit(TaskEntity task) {
        if ("AuditTask".equals(task.getCategory())) {
            List<IdentityLinkEntity> identityList = task.getIdentityLinks();
            HashSet<Long> participants = new HashSet<Long>(identityList.size());
            for (IdentityLinkEntity identity : identityList) {
                if (!WfUtils.isEmpty(identity.getDelegateId())) continue;
                participants.add(identity.getUserId());
            }
            Process process = ProcessDefinitionUtil.getProcess(task.getProcessDefinitionId(), task.getProcessInstanceId());
            return WfAfterAuditUtil.canDoAfterAudit(participants, process);
        }
        return Boolean.FALSE;
    }

    public static Boolean canDoAfterAudit(Set<Long> participants, Process process) {
        if (participants == null || participants.size() != 1) {
            return Boolean.FALSE;
        }
        AfterAuditModel model = process.getAfterAudit();
        if (model == null) {
            return Boolean.FALSE;
        }
        Boolean btn = model.getAfterAuditbtn();
        if (!btn.booleanValue()) {
            return Boolean.FALSE;
        }
        String range = model.getPersonRange();
        if ("auditor".equals(range)) {
            List<Long> keyAuditor = model.getKeyAuditor();
            if (keyAuditor.isEmpty()) {
                return Boolean.FALSE;
            }
            Set<Long> personInKeyAuditor = WfAfterAuditUtil.getPersonByKeyAuditor(keyAuditor);
            if (personInKeyAuditor.isEmpty()) {
                return Boolean.FALSE;
            }
            Long participant = participants.iterator().next();
            if ("auditor".equals(range) && !personInKeyAuditor.contains(participant)) {
                return Boolean.FALSE;
            }
        }
        return Boolean.TRUE;
    }
}

