/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.param.AppParam;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.ConfigServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.workflow.engine.ProcessEngines;
import kd.bos.workflow.engine.WFMultiLangConstants;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.cmd.task.dto.FilterApprovalRecordPluginData;
import kd.bos.workflow.engine.msg.MessageService;
import kd.bos.workflow.engine.msg.MessageServiceConfig;
import kd.bos.workflow.engine.msg.MessageServiceUtil;
import kd.bos.workflow.engine.msg.handler.StandardChannel;
import kd.bos.workflow.exception.WFConfigurationException;
import kd.bos.workflow.exception.WFErrorCode;
import kd.bos.workflow.util.WfComConfigurationUtil;
import org.apache.commons.lang.BooleanUtils;

public class WfConfigurationUtil {
    protected static Log logger = LogFactory.getLog(WfConfigurationUtil.class);
    public static final String KEY_ENGINE_VERSION = "workflow.engine.version";
    public static final String KEY_SYNC_RUNNING = "workflow.runtime.sync";
    public static final String KEY_IDEMPOTENT_EXECUTE = "workflow.runtime.idempotent";
    public static final String KEY_MICROSERVICE_EXECUTE = "workflow.runtime.microservice";
    public static final String KEY_BATCHSETTING_INITIALIZE = "workflow.initialize.batchSetting";
    public static final String KEY_SCHEDULE_DELETER3TABLEDATAS = "workflow.schedule.deleteR3TableDatas";
    public static final String KEY_SCHEDULE_DELETER3TABLEDATAS_COUNT = "workflow.schedule.deleteR3TableDatasCount";
    public static final String KEY_BILLRELATIONGRAPH_SERVERRENDER = "workflow.relationGraph.serverRender";
    public static final String KEY_BILLRELATIONGRAPH_STACKSIZE = "workflow.relationGraph.stackSize";
    public static final String KEY_BILLRELATIONGRAPH_STACKIDSLIMIT = "workflow.relationGraph.stackIdsLimit";
    public static final String KEY_BILLRELATIONGRAPH_MAXLEVEL = "workflow.relationGraph.maxLevel";
    public static final String KEY_BILLRELATIONGRAPH_LEVELMAXCOUNT = "workflow.relationGraph.levelMaxCount";
    public static final String KEY_BILLRELATIONGRAPH_RECORDRELATIONDATA = "workflow.relationGraph.recordRelationData";
    public static final String KEY_PROCTEMPLATE_CONTROLINTENSITY = "workflow.procTemplate.controlIntensity";
    public static final String KEY_ANALYSIS_FILTERITEMSIZELIMIT = "workflow.analysis.filterItemSizeLimit";
    public static final String KEY_EXTENSION_FLOWCHART = "workflow.extension.flowchart";
    public static final String KEY_OPERATION_OPTIONVARIABLEVALUELEN_LIMIT = "workflow.config.operationVariableValueLenLimit";
    public static final String ENGINESTART = "workflow.engine.start";
    public static final String TENANTSID = "workflow.tenant.ids";
    public static final String ASYMSGMODEL = "workflow.async.schedule";
    public static final String PERFORMANCETEST = "workflow.performance.test";
    public static final String WORKFLOWPROCESSLIMIT = "workflow.processcache.limit";
    public static final String KEY_AUTOTEST_ENABLE = "workflow.autotest.enable";
    public static final String KEY_FILTER_PROCESSDATA = "workflow.processdata.filter";
    public static final String KEY_FILTER_CONFLICTINGTASKS = "workflow.filter.conflictingTasks";
    public static final String KEY_TIMERJOBQUERYLIMIT = "workflow.timerjob.querylimit";
    public static final String KEY_TIMING_TIMERJOBQUERYLIMIT = "workflow.timerjob.timingquerylimit";
    public static final String KEY_CHOOSEPERSONLIMIT = "workflow.chooseperson.limit";
    public static final String KEY_MAINORGDEFAULT = "workflow.relation.mainorgdefault";
    public static final String KEY_MULTIINSTMAXSIZE = "workflow.multiinst.maxsize";
    public static final String YZJ_GENERATE_TODO_URL = "yzj_generatetodo";
    public static final String YZJ_HANDLE_TODO_URL = "yzj_handletodo";
    public static final String LIGHTAPPID = "task_appid";
    public static final String LIGHTAPPSECRET = "task_appsecret";
    public static final String YZJ_PUB_MESSAGE_URL = "pub_messageurl";
    public static final String EID = "yzj_eid";
    public static final String YZJ_AUTH_URL = "yzj_auth";
    public static final String YZJ_PUB_APP_ICON = "pub_appicon";
    public static final String YZJ_PUB_APP_NAME = "pub_appname";
    public static final String YZJ_PUB_ID = "yzjpub";
    public static final String YZJ_PUB_SERCET = "pub_sercet";
    public static final String WFPATH = "application/WFS/wf";
    public static final String DIRECTLY_CLEAR_JOB = "workflow.runtime.directlyClearJob";
    public static final String USE_CLEAN_FRAME = "workflow.runtime.usecleanFrame";
    public static final String ENABLED_ZIP_PROCDEFID = "workflow.runtime.enabledZipProcDefId";
    public static final String ALLOW_CHANGE_VALUE_PROPERTIES = "workflow.runtime.allowChangeValueProperties";
    public static final String ENABLE_FIND_CIRCLEPATH_LIMIT = "workflow.config.enableFindCirclePathLimit";
    public static final String FIND_CIRCLEPATH_TIMES_LIMIT = "workflow.config.findCirclePathTimesLimit";
    public static final String FIND_CIRCLEPATH_METHOD_CONTROL = "workflow.config.findCirclePathMethodControl";
    public static final String ADMIN_ABANDON_OPTION_CONFIG = "workflow.config.abandonOption";
    public static final String CONTINUE_WHEN_VALIDATE_FAILED = "workflow.config.continueWhenValidateFailed";
    public static final String ENTITY_APPLICATION_MAPPING_CONFIG = "workflow.config.entityApplicationMapping";
    public static final String THREE_TIMER_TASKS = "workflow.jobs.splitMultiTimerTasks";
    public static final String ISRECORDSORTDESC = "isrecordsortdesc";
    public static final String ISRETURNTOYZJTODO = "isreturntoyzjtodo";
    public static final String IFSTRONGCONTROL = "issupportstrongcontrol";
    public static final String DISPLAYSETTING = "displaysetting";
    public static final String DISPLAYINFO = "displayinfo";
    public static final String ISQUERYSUPER = "isquerysuper";
    public static final String ISSHOWTABFEEDBACK = "isshowtabfeedback";
    public static final String ALLOWNEXTPARTICIPANT = "isallownextparticipant";
    public static final String DENYRETRY = "denyRetry";
    public static final String ACQUIRESTEP = "acquireStep";
    public static final String ACQUIRESTEPBEC = "acquireStepBec";
    public static final String ACQUIRECOUNTBEC = "acquireCountBec";
    public static final String SHOWRECORDSIDEBAR = "isshowrecordsidebar";
    private static final String SHOWMOBRECORDTABBAR = "isshowmobrecoedtabbar";
    public static final String CURRENCYFORMAT = "iscurrencyformat";
    public static final String IGNORENOTHROUGHNODE = "isignorenothroughnode";
    public static final String CANCELDEFAULTDECISION = "iscanceldefaultdecision";
    public static final String USEAUTOTESTING = "canuseautotesting";
    public static final String PRODENVIRONMENT = "env.type";
    public static final String BECEVENTDISABLE = "workflow.engine.disableBecEventTrigger";
    public static final String EVENTDISABLE = "workflow.engine.disableInnerEvent";
    public static final String JOBLOGDISABLE = "workflow.engine.disableJobLog";
    public static final String OPERATIONLOGDISABLE = "workflow.engine.disableOperationLog";
    public static final String ENGINEDEPLOYIDEPENDENT = "workflow.engine.independent";
    private static final String NEEDWITHDRAWMSGFIELD = "needwithdrawmsg";
    private static final String NEEDENDPROCMSGFIELD = "needprocendmsg";
    private static final String NEEDCOORDINATEREQMSGFIELD = "needcoordinatereqmsg";
    private static final String NEEDCOORDINATEREPLYMSGFIELD = "needcoordinatereplymsg";
    private static final String NEEDPREADDSIGNMSGFIELD = "needpreaddsignmsg";
    private static final String NEEDDATASIGNED = "needdatasigned";
    public static final String APPROVALBILLPAGE = "approvalbillpage";
    public static final String APPROVALBILLPAGE_PC = "approvalbillpage_pc";
    public static final String APPROVALBILLPAGE_MOB = "approvalbillpage_mob";
    public static final String APPROVALVIEWPAGE = "approvalviewpage";
    public static final String APPROVALVIEWPAGE_PC = "approvalviewpage_pc";
    public static final String APPROVALVIEWPAGE_MOB = "approvalviewpage_mob";
    public static final String SHOWINTERACTIONMSG = "showinteractionmsg";
    public static final String BILLNOWITHNAME = "billnowithname";
    public static final String VIEWCHARTWITHOUTSUBMIT = "viewchartwithoutsubmit";
    private static final String MUSTSTARTUPCONDITION = "muststartupcondition";
    public static final String FILTERDATABYORG = "filterdatabyorg";
    public static final String PROCESSADDRESSBYORG = "addressbyorg";
    public static final String FINDTHEONLYPROCESS = "findtheonlyprocess";
    public static final String ISOPENWORKCALENDAR = "isopenworkcalendar";
    public static final String STOPPROCESSWHENNEXTPERSONEMPTY = "stopProcessWhenNextPersonEmpty";
    public static final String STOPPROCESSWHENNEXTPERSONEMPTY_KEY_ENTITYNUMBER = "entityNumber";
    public static final String STOPPROCESSWHENNEXTPERSONEMPTY_VALUE_ENTITYNUMBER_ALL = "all";
    public static final String DEPTPRINCIPALPREFER = "deptprincipalprefer";
    public static final String USEPRINCIPALWHENSUPERIOREMPTY = "useplwhensupempty";
    private static final String OPERATIONDELAYTRIGGER = "operationdelaytrigger";
    private static final String NET_MUTUALLY_EXCLUSIVE = "workflow.scheme.netMutuallyExclusive";
    private static final String ERRORCODESTRATEGY = "workflow.error.errorCodeStrategy";
    private static final String VALUE = "value";
    private static final String KEYWORD = "key";
    private static final String ENABLEPRECOMPUTORSTORAGE = "enablePreComputorStorage";
    private static final String ENABLEAFTERAUDITPRECOMPUTORSTORAGE = "enableAfterAuditPreComputorStorage";
    public static final String APPROVALFORMKEY = "approvalFormKey";
    public static final String ENABLEUSERNAMEREPEATFORMAT = "enableUserNameRepeatFormat";
    public static final String SHOWTRDAPPROVALRECORD = "showTrdApprovalRecord";
    public static final String PRINTTRDAPPROVALRECORD = "printTrdApprovalRecord";
    private static final String STARTBIZFLOW = "startbizflow";
    public static final String HIVARINSTKEEPFIELDS = "db.wf.hivarinst.keepFields";
    private static final String CONTROLCIRTHPATHNUM = "controlCirthPathNum";
    public static final String REPAIRTASKSTEP = "support.history.repairTaskStep";
    public static final String CHECKRIGHTAPPIDS = "workflow.task.checkRightAppIds";
    public static final String MSG_NEEDCHECKRIGHTAPPID = "msg.needCheckRightAppId";
    public static final String SENSITIVEFIELDCOUNT = "workflow.sensitiveField.selectcount";
    public static final String MAXBATCHDEALCOUNT = "workflow.batch.maxcount";
    public static final String SHOWSENSITIVECHANGE = "showsensitivechange";
    public static final String SENSITIVECHANGECWITCH = "sensitiveswitch";
    public static final String SENSITIVEFIELDSENTRYTHRESHOLD = "workflow.sensitiveField.sensitiveFieldsEntrythreshold";
    public static final String SENSITIVEPERMIOPERATELIST = "workflow.sensitiveField.sensitivePermiOperateList";
    public static final String ENABLESENSITIVEFIELD = "workflow.sensitiveField.enableSensitiveField";
    public static final String REPEATERCONTROL = "repeaterControl";
    private static final String CLOSEDIMENSIONRECORD = "closedimensionrecord";
    private static final String CHOOSEPERSON = "chooseperson";
    private static final String NONEEDCHECKADDSIGNNODETYPES = "noNeedCheckAddSignNodeTypes";
    private static final String SUSPEND = "workflow.config.suspend";
    private static final String WFARCHIVESERVICE = "wfarchiveservice";
    private static final String ALLWOEXTENDTASKBUSINESSFIELD = "workflow.task.allwoExtendTaskBusinessField";
    private static final String REPAIREHICOMMENTCOMPLETE = "workflow.hitaskinst.repaireHiCommentComplete";
    private static final String REPAIREHICOMMENTDISPLAYPROPERTYCOMPLETE = "workflow.hitaskinst.repaireHiCommentDisplayProperty";
    private static final String REPAIREMSGRECEIVERCOMPLETE = "msg.msgreceiver.repaireMsgReceiverFinish";
    private static final String REPAIREMSGCONTENTSUMMARYFINISH = "msg.msgreceiver.repaireMsgContentSummaryFinish";
    private static final String ISENABLEOTHERLANG = "workflow.isEnableOtherLang";
    private static final String SINGLETABLEQUERY = "workflow.hitaskinst.singleTableQuery";
    private static final String ENABLEHITASKINSTBUSINESSFIELD = "workflow.hitaskinst.enableHitaskBusinessField";
    private static final String NEEDUPDATEEXTFIELDENTITYNUMBERS = "workflow.task.needUpdateExtFieldEntitynumbers";
    public static final String DISABLEUSERAVATARBADGE = "msg.disableUserAvatarBadge";
    public static final String OPENCHANNELEXTRALURLBYOPENURL = "msg.channel.openextralurl";
    private static final String SHOWBILLAPPROVALRECORD = "showBillApprovalRecord";
    private static final String OPTIMIZELOGICFORLINKMESSAGE = "optimizeLogicForLinkMessage";
    public static final String SHOWURLINWFSMSMSG = "showurlinwfsms";
    private static final String VARBLACKLIST = "workflow.runtime.varblacklist";
    private static final String ISAUTOREPAIRSYSERRORPROCESSINSTANCES = "workflow.devops.isAutoRepairSysErrorProcessInstances";
    private static final String REMOVINGTIMEJOBLOG = "workflow.runtime.removeTimingLogImmediately";
    private static final String NEXT_NODE_PRECOMPUTATION = "next_node_precomputation";
    private static final String DISABLEAPIPERM = "workflow.api.disableApiPerm";
    private static final String DISABLEAPIPERMV1 = "workflow.api.disableApiPermV1";
    private static final String DISABLEAPIORGPERM = "workflow.api.disableApiORGPerm";
    private static final String REPAIRSYSERRORPROCESSINSTANCESSIZE = "workflow.devops.repairSysErrorProcessInstancesSize";
    private static final String ISAUTOREPAIRSYSERRORRECORDJOB = "workflow.devops.isAutoRepairSysErrorRecordJob";
    private static final String FIRSTADDRESSASSIGNPERSONPROCESS = "workflow.runtime.firstAddressAssignPersonProcess";
    private static final String ENABLELOCKFORUPDATECONCURRENTDATA = "workflow.runtime.enableLockForUpdate";
    private static final String NOTRESTARTBYREJECTBACKTONODE = "workflow.addressing.notRestartByRejectBackToNode";
    private static final String RESTART = "workflow.addressing.restart";
    private static final String RESTARTADDRESSBYTIME = "workflow.addressing.restartAddressByTime";
    private static final String ALLOWHTMLTAGCHANNELS = "msg.channel.allowhtmltagchannels";
    public static final String ENGINESENDEVTTHRESHOLD = "bec.engine.sendEvtMqThreshold";
    private static final String KEEPUNDEALTASK = "keepUndealTask";
    private static final String REJECTTOBACKANDRECALCULATIONPARTICIPANT = "workflow.runtime.rejectToBackAndRecalculationParticipant";
    private static final String REJECTTOBACKANDAUTOMATICPROCESSINGFAILURE = "workflow.runtime.rejectToBackAndAutomaticProcessingFailure";
    private static final String BILLWITHDRAWJUMPTOUSERNODE = "workflow.runtime.billWithdrawJumpToUserNode";
    private static final String SERVICEAPIDISABLE = "workflow.serviceapi.disableApiPerm";
    public static final String ENGINEIFNEEDSUBAPP = "bec.engine.ifNeedSubApp";
    private static final String ALLOWSELECTDEVOPSINDICATORCOUNT = "workflow.devops.allowselectdevopsindicatorcount";
    private static final String ALLOWONCEQUERYDEVOPSINDICATORCOUNT = "workflow.devops.once.allowselectdevopsindicatorcount";
    private static final String ISENABLEDEVOPSDATACOLLECTED = "workflow.devops.isEnableDevopsDataCollected";
    public static final String DISABLEAPPROVALRECORDOPTIMIZATION = "wf.approval.disableApprovalRecordOptimization";
    private static final String ENABLEGETCOMMENTFROMBASEDATA = "wf.commonauditcommenttree.enablegetcommentfrombasedata";
    private static final String DISABLERUNTIMEPARSELOGCOLLECT = "workflow.runtime.disableRuntimeParseLogCollect";
    public static final String BUSINESSFIELDISSUPPORTBIGINTFIELD = "wf.task.businessfield.isShowBigIntField";
    public static final String ALLOWBILLUNSUBMITAFTERUSERNODE = "allowunsubmitbacknode";
    public static final String USEROLDWITHDRAW = "wf.task.withdraw.useOld";
    private static final String MAXIMUMOFCYCLESNUMBER = "workflow.engine.maximumOfCyclesNumber";
    public static final String HIDEUNUSECONTROLS = "wf.bizflow.hideUnUseControls";
    private static final String MSG_DISABLEUSEQUANTITYSUMMARY = "msg.disableUseQuantitySummary";
    private static final String MSG_ISASYNCCOMPENSATIONENABLE = "msg.isAsyncCompensationEnable";
    private static final String MSG_ISCOMPENSATIONDELEGATEANDFILE = "msg.isCompensationOfDelegateAndFile";
    private static final String MSG_ISCORRECTQSINFOSBYLOGIN = "msg.isCorrectQSInfosByLogin";
    private static final String MSG_CORRECTUSERQSINF = "msg.userLoginCorrectQSInfoConfig";
    private static final String MSG_CORRECTHANDLEDQS = "msg.correctHandledQS";
    private static final String MSG_MAXDEALQSINFOSCOUNT = "msg.maxDealQSInfosCount";
    private static final String WFDEVOPSASYNCMESSAGETIMINGSTARTTIME = "wf.devops.asyncmessage.timing.starttime";
    public static final String BECENGINETRANSFORM = "bec.engine.transformConfig";
    private static final String SEPARATESTORAGEMASTERSWITCH = "workflow.separateStorage.masterSwitch";
    private static final String MAXIMUMOFPKSINPAGECACHE = "workflow.separateStorage.maximumOfPksInPageCache";
    private static final String JUDGEBIZFLOWWHENASSIGNPERSON = "workflow.engine.judgeBizWhenAssignPerson";
    private static final String RETRYERRORCODES = "workflow.engine.retryErrorCodes";
    private static final String RETRYERRORMSG = "workflow.engine.retryErrorMsgs";
    private static final String ALWAYSRETRYERRORCODE = "workflow.engine.alwaysRetryErrorCode";
    private static final String ALWAYSRETRYCOUNT = "workflow.engine.alwaysRetryThreshold";
    private static final String WFDEVOPSINDICATORRETENTIONDAYS = "wf.devops.devopsindicator.retention.days";
    private static final String ENABLEMSGBECEVENT = "msg.enableMsgBecEvent";
    private static final String DISABLEPRECOMPUTEPARTICIPANTPOSITION = "workflow.approval.disablePreComputeParticipantPosition";
    private static final String WFDEVOPSENABLEGROUPSMODEL = "wf.devops.enableIndicatorGroups";
    public static final String WFBIZFLOWSTARTBILLOPERATIONONLYHASONE = "wf.bizflow.start.billoperation.onlyhasone";
    public static final String BUSINESSEVENTSTART = "workflow.businessevent.start";
    private static final String IFSENDMQDIRECT = "workflow.engine.ifSendMqDirect";
    private static final String ENABLENEWRARTRELATIONFORM = "workflow.participant.enableNewRartRelationForm";
    public static final String FILTERAPPROVALRECORDBYAUTH = "workflow.monitor.filterPluginRecordByAuth";
    public static final String WF_ADMIN_LANG = "wf.admin.lang";
    public static final String REPAIREIDENTITYLINKCOMPLETE = "workflow.taskentity.repaireIdentityLinkComplete";
    public static final String REPAIRETASKHANDLELOGCOMPLETE = "workflow.taskentity.repaireTaskHandleLogComplete";
    public static final String ISNOTQUERYDATABYNEWSQL = "workflow.isnotquerydatabynewsql";
    private static final String ISREPAIRWORKFLOWROLEINCLUDEADMINSUBCOMPLETE = "workflow.role.isRepairWorkflowRoleIncludeAdminSubComplete";
    public static final String ISTRUSTHANDLE = "workflow.delegate.isTrustHandle";
    public static final String EXPIRESENDMSGCARRYURL = "workflow.expireSendMsgCarryUrl";
    private static final String HIDECOMPENSATETASKCONFIG = "workflow.designer.hideCompensateTaskConfig";
    public static final String CANWITHDRAWWHENREJECTTOUSERTASK = "wf.task.withdrawWhenRejectToUserTask";
    public static final String ALLOWWITHDRAWUSERTASK = "allowwithdrawusertask";
    private static final String JUMPEMBEDDEDPAGEBYBILLTYPE = "jumpEmbeddedPageByBillType";
    public static final String GROUPNAMEFORAPPROVALRECORD = "workflow.groupNameForApprovalRecord";
    public static final String BYVERIFYSQL = "workflow.executeJob.notSaveByVerifySql";
    private static final String ISCALCULATECROSSTENANT = "workflow.crossTenant.isCalculateCrossTenant";
    public static final String FORKJOINMEETINGSUPPLEMENTARYRULES = "workflow.forkjoin.meetJoinCondition.supplementaryRules";
    private static final String CROSSTENANTENTITYNUMBERWHITELIST = "workflow.crossTenant.entityNumberWhiteList";
    private static final String RETRYSLOWQUEUE = "bec.engine.retrySlowQueue";
    private static final String ALLOWDYNAMICFORMVALUETHANSPECIFIED = "workflow.nodeTemplate.allowDynamicFormValueThanSpecified";
    public static final String APPROVALFORDOCUMENTLIST = "workflow.feature.approvalForDocumentList";
    public static final String EXISTSDELEGATEANDNOTTRANSFER = "workflow.existsDelegateAndNotTransfer";
    private static final String SUBPROCDISPLAYTERMINATEDECISIONSCENE = "workflow.subProcess.displayTerminateDecisionScene";
    public static final String ISNONRECURSIONFINDTARGETPARTICIPANT = "workflow.delegate.isNonRecursionFindTargetParticipant";
    private static final String ISNOTDELETETOHANDLEGROUP = "workflow.isNotDeleteToHandleGroup";
    private static final String WORKFLOW_ROLE_ALTERNATETYPE_NULLVALUE = "wf.role.alternatetype.defaultValueNull";
    private static final String KEY_ISENABLESHOWMUTILANGLOG = "workflow.isEnableShowMutiLangLog";
    public static final String WORKFLOW_PROCESSKEY_MAXLENGTH = "workflow.processkey.maxLength";

    private WfConfigurationUtil() {
    }

    public static Boolean isNotDeleteToHandleGroup() {
        try {
            return WfConfigurationUtil.getBooleanConfigCenterVal(ISNOTDELETETOHANDLEGROUP);
        }
        catch (Exception e) {
            return Boolean.FALSE;
        }
    }

    public static boolean isHideUnUseControls() {
        Object configCenterVal = WfConfigurationUtil.getConfigCenterVal(HIDEUNUSECONTROLS);
        if (configCenterVal == null) {
            return true;
        }
        String trim = ((String)configCenterVal).trim();
        return !"false".equalsIgnoreCase(trim);
    }

    public static String fetchFilterApprovalRecordPlugin(String entityNumber) {
        if (StringUtils.isBlank((CharSequence)entityNumber)) {
            return "";
        }
        Object configCenterVal = WfConfigurationUtil.getConfigCenterVal(FILTERAPPROVALRECORDBYAUTH);
        if (!(configCenterVal instanceof String)) {
            return "";
        }
        List list = SerializationUtils.fromJsonStringToList((String)((String)configCenterVal), FilterApprovalRecordPluginData.class);
        for (FilterApprovalRecordPluginData item : list) {
            if (!entityNumber.equals(item.getEntityNumber())) continue;
            item.setType("class");
            item.setEntityNumber(null);
            return SerializationUtils.toJsonString((Object)item);
        }
        return "";
    }

    public static Lang getWFAdminLang() {
        Object configCenterVal = WfConfigurationUtil.getConfigCenterVal(WF_ADMIN_LANG);
        if (configCenterVal == null) {
            return Lang.defaultLang();
        }
        if (configCenterVal instanceof String) {
            String lang = (String)configCenterVal;
            return Lang.from((String)lang);
        }
        return Lang.defaultLang();
    }

    public static boolean getNextNodePrecomputation() {
        Object configCenterVal = WfConfigurationUtil.getConfigCenterVal(NEXT_NODE_PRECOMPUTATION);
        if (configCenterVal == null) {
            return true;
        }
        String trim = ((String)configCenterVal).trim();
        return !"false".equalsIgnoreCase(trim);
    }

    public static LocaleString getAddSignNameLocaleString() {
        LocaleString addsignDefualutName = new LocaleString();
        JSONObject configCenterValStr = JSONObject.parseObject((String)((String)WfConfigurationUtil.getConfigCenterVal("addSignName")));
        if (configCenterValStr != null) {
            for (Lang lang : WfUtils.getSupportLangs()) {
                String key = lang.name();
                addsignDefualutName.put(key, (Object)configCenterValStr.getString(key));
            }
        } else {
            ILocaleString defaultAddSignName = WFMultiLangConstants.getAddSignAuditName();
            for (Lang lang : WfUtils.getSupportLangs()) {
                String key = lang.name();
                addsignDefualutName.put(key, defaultAddSignName.get((Object)key));
            }
        }
        return addsignDefualutName;
    }

    public static boolean getRepeaterApprovalConfig(List<Long> userIds) {
        boolean repeaterApprovalConfig = WfConfigurationUtil.getBooleanConfigCenterVal("repeaterApproval");
        return repeaterApprovalConfig ? Boolean.TRUE : userIds.size() == 1;
    }

    public static String getCustomApprovalRecordClass() {
        return (String)WfConfigurationUtil.getConfigCenterVal("customApprovalRecord");
    }

    public static boolean getMBillSummaryIsSupportExtendBtns() {
        return WfConfigurationUtil.getBooleanConfigCenterVal("mBillSummaryIsSupportExtendBtns");
    }

    public static boolean getMBillSummaryIsEdit() {
        return WfConfigurationUtil.getBooleanConfigCenterVal("mBillSummaryIsEdit");
    }

    public static String getCoordinateName() {
        return WfConfigurationUtil.getCoordinateName((String)WfConfigurationUtil.getConfigCenterVal("coordinateName"));
    }

    public static String getCoordinateName(String coordinateNameStr) {
        JSONObject configCenterValStr = JSONObject.parseObject((String)coordinateNameStr);
        String value = "";
        if (configCenterValStr != null) {
            value = (String)configCenterValStr.get((Object)RequestContext.get().getLang().toString());
        }
        return WfUtils.isNotEmpty(value) ? value : ResManager.loadKDString((String)"\u534f\u529e", (String)"WfConfigurationUtil_5", (String)"bos-wf-engine", (Object[])new Object[0]);
    }

    public static String getCoordinateNameByLanguage(String language) {
        JSONObject configCenterValStr = JSONObject.parseObject((String)((String)WfConfigurationUtil.getConfigCenterVal("coordinateName")));
        String value = "";
        if (configCenterValStr != null) {
            value = (String)configCenterValStr.get((Object)language);
        }
        return WfUtils.isNotEmpty(value) ? value : ResManager.loadKDString((String)"\u534f\u529e", (String)"WfConfigurationUtil_5", (String)"bos-wf-engine", (Object[])new Object[0]);
    }

    public static ILocaleString getCoordinateNameFromConfig() {
        LocaleString result = new LocaleString();
        JSONObject configCenterValStr = JSONObject.parseObject((String)((String)WfConfigurationUtil.getConfigCenterVal("coordinateName")));
        if (configCenterValStr != null) {
            result = LocaleString.fromMap((Map)((Map)SerializationUtils.fromJsonString((String)String.valueOf(configCenterValStr), Map.class)));
        }
        return WfUtils.isNotEmpty((ILocaleString)result) ? result : WfUtils.getPromptWordLocaleString("\u534f\u529e", "WfConfigurationUtil_5", "bos-wf-engine");
    }

    public static String getTransferName() {
        return WfConfigurationUtil.getTransferName((String)WfConfigurationUtil.getConfigCenterVal("transferName"));
    }

    public static String getTransferName(String transferNameStr) {
        JSONObject configCenterValStr = JSONObject.parseObject((String)transferNameStr);
        String value = "";
        if (configCenterValStr != null) {
            value = (String)configCenterValStr.get((Object)RequestContext.get().getLang().toString());
        }
        return WfUtils.isNotEmpty(value) ? value : ResManager.loadKDString((String)"\u8f6c\u4ea4", (String)"WfConfigurationUtil_6", (String)"bos-wf-engine", (Object[])new Object[0]);
    }

    public static String getTransferNameByLanguage(String language) {
        JSONObject configCenterValStr = JSONObject.parseObject((String)((String)WfConfigurationUtil.getConfigCenterVal("transferName")));
        String value = "";
        if (configCenterValStr != null) {
            value = (String)configCenterValStr.get((Object)language);
        }
        return WfUtils.isNotEmpty(value) ? value : ResManager.loadKDString((String)"\u8f6c\u4ea4", (String)"WfConfigurationUtil_6", (String)"bos-wf-engine", (Object[])new Object[0]);
    }

    public static ILocaleString getLocaleStringTransferName() {
        LocaleString transferName = new LocaleString();
        for (Lang lang : WfUtils.getSupportLangs()) {
            transferName.put((Object)lang.name(), (Object)WfConfigurationUtil.getTransferNameByLanguage(lang.name()));
        }
        return transferName;
    }

    public static String getCirculationName() {
        String value = WfConfigurationUtil.getCirculationNameFromConfigCenter();
        return WfUtils.isNotEmpty(value) ? value : ResManager.loadKDString((String)"\u4f20\u9605", (String)"WfConfigurationUtil_7", (String)"bos-wf-engine", (Object[])new Object[0]);
    }

    public static String getCirculationNameFromConfigCenter() {
        JSONObject configCenterValStr = JSONObject.parseObject((String)((String)WfConfigurationUtil.getConfigCenterVal("circulationName")));
        String value = "";
        if (configCenterValStr != null) {
            value = (String)configCenterValStr.get((Object)RequestContext.get().getLang().toString());
        }
        return value;
    }

    public static String getCirculationNameByLanguage(String language) {
        LocaleString localString;
        JSONObject configCenterValStr = JSONObject.parseObject((String)((String)WfConfigurationUtil.getConfigCenterVal("circulationName")));
        String value = "";
        if (configCenterValStr != null) {
            value = (String)configCenterValStr.get((Object)language);
        }
        if (WfUtils.isEmpty(value) && null != (localString = ResManager.getLocaleString((String)"\u4f20\u9605", (String)"WfConfigurationUtil_7", (String)"bos-wf-engine"))) {
            value = (String)localString.getItem(language);
        }
        return value;
    }

    public static ILocaleString getLocalCirculationName() {
        JSONObject obj = JSONObject.parseObject((String)((String)WfConfigurationUtil.getConfigCenterVal("circulationName")));
        LocaleString circulationName = new LocaleString();
        if (obj != null) {
            for (Map.Entry entry : obj.entrySet()) {
                String value = StringUtils.isNotBlank(entry.getValue()) ? (String)entry.getValue() : "";
                circulationName.setItem((String)entry.getKey(), (Object)value);
            }
        }
        if (WfUtils.isEmpty((ILocaleString)circulationName)) {
            return ResManager.getLocaleString((String)"\u4f20\u9605", (String)"WfConfigurationUtil_7", (String)"bos-wf-engine");
        }
        return circulationName;
    }

    public static ILocaleString getLocalTransferName() {
        JSONObject obj = JSONObject.parseObject((String)((String)WfConfigurationUtil.getConfigCenterVal("transferName")));
        LocaleString transferName = new LocaleString();
        if (obj != null) {
            for (Map.Entry entry : obj.entrySet()) {
                String value = StringUtils.isNotBlank(entry.getValue()) ? (String)entry.getValue() : "";
                transferName.setItem((String)entry.getKey(), (Object)value);
            }
        }
        if (WfUtils.isEmpty((ILocaleString)transferName)) {
            return ResManager.getLocaleString((String)"\u8f6c\u4ea4", (String)"WfConfigurationUtil_6", (String)"bos-wf-engine");
        }
        return transferName;
    }

    public static String getUrgeName() {
        JSONObject configCenterValStr = JSONObject.parseObject((String)((String)WfConfigurationUtil.getConfigCenterVal("urgeName")));
        String value = "";
        if (configCenterValStr != null) {
            value = (String)configCenterValStr.get((Object)RequestContext.get().getLang().toString());
        }
        return WfUtils.isNotEmpty(value) ? value : ResManager.loadKDString((String)"\u50ac\u529e", (String)"WfConfigurationUtil_8", (String)"bos-wf-engine", (Object[])new Object[0]);
    }

    public static String getUrgeName(String language) {
        LocaleString localString;
        JSONObject configCenterValStr = JSONObject.parseObject((String)((String)WfConfigurationUtil.getConfigCenterVal("urgeName")));
        String value = "";
        if (configCenterValStr != null) {
            value = (String)configCenterValStr.get((Object)language);
        }
        if (WfUtils.isEmpty(value) && null != (localString = ResManager.getLocaleString((String)"\u50ac\u529e\u5ba1\u6279\uff1a", (String)"WFMessageServiceHelper_13", (String)"bos-wf-engine"))) {
            value = (String)localString.getItem(language);
        }
        return value;
    }

    public static boolean isPerformanceTesting() {
        return WfConfigurationUtil.getBooleanConfigCenterVal(PERFORMANCETEST);
    }

    public static boolean canRunWorkflow() {
        Object obj = ConfigServiceHelper.getGlobalConfiguration((String)ENGINESTART);
        if (obj != null) {
            return "true".equals(obj);
        }
        Object val = WfConfigurationUtil.getConfigCenterVal(ENGINESTART);
        return val == null || "true".equals(val);
    }

    public static boolean isProdEnvironment() {
        Object obj = ConfigServiceHelper.getGlobalConfiguration((String)PRODENVIRONMENT);
        return "prod".equals(obj);
    }

    public static int getProcessModelCacheLimit() {
        Object obj = ConfigServiceHelper.getGlobalConfiguration((String)WORKFLOWPROCESSLIMIT);
        if (obj == null) {
            obj = WfConfigurationUtil.getConfigCenterVal(WORKFLOWPROCESSLIMIT);
        }
        if (obj != null) {
            return Integer.parseInt((String)obj);
        }
        return 0;
    }

    public static boolean disableInnerEvent() {
        Object obj = ConfigServiceHelper.getGlobalConfiguration((String)EVENTDISABLE);
        if (obj != null) {
            return "true".equals(obj);
        }
        return WfConfigurationUtil.getBooleanConfigCenterVal(EVENTDISABLE);
    }

    public static boolean disableBecEventTrigger() {
        Object obj = ConfigServiceHelper.getGlobalConfiguration((String)BECEVENTDISABLE);
        if (obj != null) {
            return "true".equals(obj);
        }
        return WfConfigurationUtil.getBooleanConfigCenterVal(BECEVENTDISABLE);
    }

    public static boolean disableEventLog() {
        Object obj = ConfigServiceHelper.getGlobalConfiguration((String)JOBLOGDISABLE);
        if (obj != null) {
            return "true".equals(obj);
        }
        return WfConfigurationUtil.getBooleanConfigCenterVal(JOBLOGDISABLE);
    }

    public static boolean disableOperationLog() {
        Object obj = ConfigServiceHelper.getGlobalConfiguration((String)OPERATIONLOGDISABLE);
        if (obj != null) {
            return "true".equals(obj);
        }
        return WfConfigurationUtil.getBooleanConfigCenterVal(OPERATIONLOGDISABLE);
    }

    public static String getEid() {
        long userId = Long.parseLong(RequestContext.get().getUserId());
        DynamicObject user = BusinessDataServiceHelper.loadSingle((Object)userId, (String)"bos_user");
        String eid = user.getString("eid");
        if (WfUtils.isEmpty(eid)) {
            throw new WFConfigurationException(null, WFErrorCode.configurationError(), new Object[]{ResManager.loadKDString((String)"\u5de5\u4f5c\u5708\u672a\u914d\u7f6e\u3002", (String)"WfConfigurationUtil_1", (String)"bos-wf-engine", (Object[])new Object[0])});
        }
        return eid;
    }

    public static String getAuthURL(String type, String pubaccNumber, String entityNumber) {
        return WfConfigurationUtil.getMobileAppConfig(type, "accrediturl", pubaccNumber, entityNumber);
    }

    public static String getGenerateTodoUrl(String type, String pubaccNumber, String entityNumber) {
        return WfConfigurationUtil.getMobileAppConfig(type, "createtodourl", pubaccNumber, entityNumber);
    }

    public static String getHandleTodoUrl(String type, String pubaccNumber, String entityNumber) {
        return WfConfigurationUtil.getMobileAppConfig(type, "handletodourl", pubaccNumber, entityNumber);
    }

    public static String getCheckTodoUrl(String type, String pubaccNumber, String entityNumber) {
        return WfConfigurationUtil.getMobileAppConfig(type, "checktodourl", pubaccNumber, entityNumber);
    }

    public static String getLightAppId(String type, String pubaccNumber, String entityNumber) {
        return WfConfigurationUtil.getMobileAppConfig(type, "appid", pubaccNumber, entityNumber);
    }

    public static String getLightAppSecret(String type, String pubaccNumber, String entityNumber) {
        return WfConfigurationUtil.getMobileAppConfig(type, "appkey", pubaccNumber, entityNumber);
    }

    public static String getPub(String type, String pubaccNumber, String entityNumber) {
        return WfConfigurationUtil.getMobileAppConfig(type, "pubaccid", pubaccNumber, entityNumber);
    }

    public static String getPubSercet(String type, String pubaccNumber, String entityNumber) {
        return WfConfigurationUtil.getMobileAppConfig(type, "pubacckey", pubaccNumber, entityNumber);
    }

    public static String getPubMessageUrl(String type, String pubaccNumber, String entityNumber) {
        return WfConfigurationUtil.getMobileAppConfig(type, "pubaccapiurl", pubaccNumber, entityNumber);
    }

    public static String getPubAppName(String type, String pubaccNumber, String entityNumber) {
        return WfConfigurationUtil.getMobileAppConfig(type, "pubaccname", pubaccNumber, entityNumber);
    }

    public static String getPubAppIcon(String type, String pubaccNumber, String entityNumber) {
        return WfConfigurationUtil.getMobileAppConfig(type, "pubaccicon", pubaccNumber, entityNumber);
    }

    public static String getEcoSecret(String type, String pubaccNumber, String entityNumber) {
        return WfConfigurationUtil.getMobileAppConfig(type, "ecologysecret", pubaccNumber, entityNumber);
    }

    public static String getEcoMainEid(String type, String pubaccNumber, String entityNumber) {
        return WfConfigurationUtil.getMobileAppConfig(type, "maineid", pubaccNumber, entityNumber);
    }

    public static String getLightAppName(String type, String pubaccNumber, String entityNumber) {
        return WfConfigurationUtil.getMobileAppConfig(type, "appname", pubaccNumber, entityNumber);
    }

    public static String getDomainName(String type, String pubaccNumber, String entityNumber) {
        return WfConfigurationUtil.getMobileAppConfig(type, "domainname", pubaccNumber, entityNumber);
    }

    public static String getLightAppEid(String type, String pubaccNumber, String entityNumber) {
        return WfConfigurationUtil.getMobileAppConfig(type, "eid", pubaccNumber, entityNumber);
    }

    public static String getLightApprovalAppId(String type, String pubaccNumber, String entityNumber) {
        return WfConfigurationUtil.getMobileAppConfig(type, "approveappid", pubaccNumber, entityNumber);
    }

    public static String getLightApprovalAppKey(String type, String pubaccNumber, String entityNumber) {
        return WfConfigurationUtil.getMobileAppConfig(type, "approveappkey", pubaccNumber, entityNumber);
    }

    public static boolean isEnabled(String type) {
        List<MessageServiceConfig> configs;
        if (WfConfigurationUtil.canRunWorkflow() && (configs = MessageServiceUtil.getMessageService().getMessageServiceConfigs()) != null && !configs.isEmpty()) {
            for (MessageServiceConfig config : configs) {
                if (!config.getServiceKey().equalsIgnoreCase(type) && !config.getId().equalsIgnoreCase(type)) continue;
                return config.isAvaliable();
            }
        }
        return false;
    }

    public static boolean isEnabledStrandardChannel(String type) {
        if (WfConfigurationUtil.canRunWorkflow()) {
            if (StandardChannel.getStandardChannel(type) == null) {
                return true;
            }
            List<MessageServiceConfig> configs = MessageServiceUtil.getMessageService().getMessageServiceConfigs();
            if (configs != null && !configs.isEmpty()) {
                for (MessageServiceConfig config : configs) {
                    if (!config.getServiceKey().equalsIgnoreCase(type) && !config.getId().equalsIgnoreCase(type)) continue;
                    return config.isAvaliable();
                }
            }
        }
        return false;
    }

    public static boolean isEnableAnyMessageChannel() {
        List<MessageServiceConfig> configs;
        if (WfConfigurationUtil.canRunWorkflow() && (configs = MessageServiceUtil.getMessageService().getMessageServiceConfigs()) != null && !configs.isEmpty()) {
            for (MessageServiceConfig config : configs) {
                if (!config.isAvaliable()) continue;
                return true;
            }
        }
        return false;
    }

    public static Map<String, Object> getNotifyConfigs(String notifyType) {
        List<MessageServiceConfig> configs;
        HashMap<String, String> map = null;
        if (WfConfigurationUtil.canRunWorkflow() && (configs = MessageServiceUtil.getMessageService().getMessageServiceConfigs()) != null && !configs.isEmpty()) {
            MessageServiceConfig targetConfig = null;
            for (MessageServiceConfig config : configs) {
                if (!config.getServiceKey().equalsIgnoreCase(notifyType) && !config.getId().equalsIgnoreCase(notifyType)) continue;
                targetConfig = config;
                break;
            }
            if (targetConfig != null) {
                map = new HashMap<String, String>(2);
                map.put("channelName", targetConfig.getMessageServiceName().getLocaleValue());
                map.put("serviceClass", targetConfig.getServiceClass());
            }
        }
        return map;
    }

    public static boolean isYunzhijiaEnable() {
        boolean yunzhijiaEnable = WfConfigurationUtil.isEnabled("yunzhijia") || WfConfigurationUtil.isEnabled("yunzhijiaeco") || WfConfigurationUtil.isEnabled("yunzhijiaup");
        logger.info("yunzhijiaEnable:" + yunzhijiaEnable);
        return yunzhijiaEnable;
    }

    public static boolean isDDEnable() {
        return WfConfigurationUtil.isEnabled("dingding");
    }

    public static boolean isSmsEnable() {
        return WfConfigurationUtil.isEnabled("sms");
    }

    public static boolean isEmailEnable() {
        return WfConfigurationUtil.isEnabled("email");
    }

    public static boolean isYunzhijiaECO() {
        return WfConfigurationUtil.isEnabled("yunzhijiaeco");
    }

    public static boolean isYunzhijiaUP() {
        return WfConfigurationUtil.isEnabled("yunzhijiaup");
    }

    public static String getFileServerUrl() {
        String fileServerUrl = (String)ConfigServiceHelper.getGlobalConfiguration((String)"fileserver");
        if (WfUtils.isEmpty(fileServerUrl)) {
            throw new WFConfigurationException(null, WFErrorCode.configurationError(), new Object[]{ResManager.loadKDString((String)"\u8bf7\u914d\u7f6e\u6587\u4ef6\u670d\u52a1\u5668\u5730\u5740\u3002", (String)"WfConfigurationUtil_2", (String)"bos-wf-engine", (Object[])new Object[0])});
        }
        return fileServerUrl;
    }

    public static boolean isAsyncMsgModel() {
        Object obj = ConfigServiceHelper.getGlobalConfiguration((String)ASYMSGMODEL);
        return obj == null || !"false".equalsIgnoreCase(obj.toString());
    }

    public static String getLockTag() {
        return System.getProperty("mq.debug.queue.tag");
    }

    private static synchronized void lazyLoadConfigs() {
    }

    public static String getConfigValue(String key) {
        String value = (String)WfConfigurationUtil.safeGetValue(key);
        if (WfUtils.isEmpty(value)) {
            logger.info("\u672a\u627e\u5230[" + key + "]\u6240\u5bf9\u5e94\u7684\u503c!");
        }
        return value;
    }

    public static boolean getRecordSortDesc() {
        try {
            return (Boolean)WfConfigurationUtil.safeGetValue(ISRECORDSORTDESC);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean getReturnToYjzTodo() {
        try {
            return (Boolean)WfConfigurationUtil.safeGetValue(ISRETURNTOYZJTODO);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isSupportStrongControl() {
        try {
            return (Boolean)WfConfigurationUtil.safeGetValue(IFSTRONGCONTROL);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isDisplaySetting() {
        try {
            return BooleanUtils.toBoolean((String)WfConfigurationUtil.safeGetValue(DISPLAYSETTING).toString());
        }
        catch (Exception e) {
            return false;
        }
    }

    public static String getDisplayInfo() {
        try {
            return (String)WfConfigurationUtil.safeGetValue(DISPLAYINFO);
        }
        catch (Exception e) {
            return " ";
        }
    }

    public static boolean getQuerySuperWhenOrgManager() {
        try {
            return (Boolean)WfConfigurationUtil.safeGetValue(ISQUERYSUPER);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean getShowTabFeedback() {
        try {
            return (Boolean)WfConfigurationUtil.safeGetValue(ISSHOWTABFEEDBACK);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isAllowNextParticipant() {
        Boolean confVal = WfConfigurationUtil.getBooleanConfigCenterVal(ALLOWNEXTPARTICIPANT);
        try {
            Boolean value = (Boolean)WfConfigurationUtil.safeGetValue(ALLOWNEXTPARTICIPANT);
            return value != false || confVal != false;
        }
        catch (Exception e) {
            return confVal;
        }
    }

    public static boolean isAuthTaskRelatePersion() {
        boolean isAuth = Boolean.TRUE;
        try {
            Object authTaskRelatePerson = WfConfigurationUtil.safeGetValue("authtaskrelateperson");
            if (StringUtils.isNotBlank((Object)authTaskRelatePerson)) {
                isAuth = (Boolean)authTaskRelatePerson;
            }
        }
        catch (Exception e) {
            logger.warn(String.format("WfConfigurationUtils-%s-%s", "isAuthTaskRelatePersion", e.getMessage()));
        }
        return isAuth;
    }

    private static boolean getBooleanConfigCenterVal(String key) {
        Object val = WfConfigurationUtil.getConfigCenterVal(key);
        return val != null ? "true".equals(val) : false;
    }

    public static boolean getBooleanConfigValue(String key) {
        return (Boolean)WfConfigurationUtil.safeGetValue(key);
    }

    public static void refresh() {
        WfConfigurationUtil.lazyLoadConfigs();
    }

    public static Boolean ignoreNextNode(String key) {
        Boolean value = (Boolean)WfConfigurationUtil.safeGetValue(key);
        if (value == null) {
            value = Boolean.FALSE;
        }
        return value;
    }

    private static Object safeGetValue(String key) {
        return WfConfigurationUtil.safeGetValue(key, "a479ec06000000ac");
    }

    private static Object safeGetValue(String key, String appId) {
        AppParam param = new AppParam();
        param.setAppId(appId);
        String userId = RequestContext.get().getUserId();
        Long mainOrgId = UserServiceHelper.getUserMainOrgId((long)Long.parseLong(userId));
        if (WfUtils.isEmpty(mainOrgId)) {
            param.setOrgId(Long.valueOf(OrgUnitServiceHelper.getRootOrgId()));
        } else {
            param.setOrgId(mainOrgId);
        }
        param.setViewType("01");
        return SystemParamServiceHelper.loadAppParameterFromCache((AppParam)param, (String)key);
    }

    public static String getMobileAppConfig(String type, String configName, String pubaccNumber, String entityNumber) {
        MessageService service = MessageServiceUtil.getMessageService();
        return service.getCacheConfigValue(type, configName, pubaccNumber, entityNumber);
    }

    public static void refreshMsgConfig() {
        ProcessEngines.getDefaultProcessEngine().getProcessEngineConfiguration().refreshAccountConfig();
    }

    public static Object getConfigCenterVal(String key) {
        return WfComConfigurationUtil.getConfigCenterVal((String)key);
    }

    public static Map<String, Object> getConfigCenterVals(String ... keys) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            QFilter[] filters = new QFilter[]{new QFilter(KEYWORD, "in", (Object)keys)};
            Map ret = BusinessDataServiceHelper.loadFromCache((String)"wf_confcenter", (String)String.format("%s, %s", VALUE, KEYWORD), (QFilter[])filters);
            if (ret != null && !ret.isEmpty()) {
                for (DynamicObject obj : ret.values()) {
                    if (obj == null) continue;
                    map.put(obj.getString(KEYWORD), obj.get(VALUE));
                }
            }
        }
        catch (Exception e) {
            logger.warn(String.format("there is error on getting configcenter value: %s", WfUtils.getExceptionStacktrace(e)));
        }
        return map;
    }

    public static int getMaxEntryCount(String entityNumber) {
        return WfComConfigurationUtil.getMaxEntryCount((String)entityNumber);
    }

    public static boolean isShowRecordSidebar() {
        try {
            return (Boolean)WfConfigurationUtil.safeGetValue(SHOWRECORDSIDEBAR);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isShowMobRecoedTabBar() {
        try {
            return (Boolean)WfConfigurationUtil.safeGetValue(SHOWMOBRECORDTABBAR);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isCurrencyFormat() {
        try {
            return (Boolean)WfConfigurationUtil.safeGetValue(CURRENCYFORMAT);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isIgnoreNoThroughNode() {
        try {
            return (Boolean)WfConfigurationUtil.safeGetValue(IGNORENOTHROUGHNODE);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isCancelDefaultDecision() {
        try {
            return (Boolean)WfConfigurationUtil.safeGetValue(CANCELDEFAULTDECISION);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean canUseAutoTesting() {
        return WfConfigurationUtil.getBooleanConfigCenterVal(KEY_AUTOTEST_ENABLE);
    }

    public static boolean canViewChartWithoutSubmit() {
        try {
            return (Boolean)WfConfigurationUtil.safeGetValue(VIEWCHARTWITHOUTSUBMIT);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isDeployIdependent() {
        Object obj = ConfigServiceHelper.getGlobalConfiguration((String)ENGINEDEPLOYIDEPENDENT);
        if (obj != null) {
            return "true".equals(obj);
        }
        return WfConfigurationUtil.getBooleanConfigCenterVal(ENGINEDEPLOYIDEPENDENT);
    }

    public static boolean needWithdrawMsg() {
        try {
            return (Boolean)WfConfigurationUtil.safeGetValue(NEEDWITHDRAWMSGFIELD);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean needPreAddSignMsg() {
        try {
            return (Boolean)WfConfigurationUtil.safeGetValue(NEEDPREADDSIGNMSGFIELD);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean needEndProcMsg() {
        try {
            return (Boolean)WfConfigurationUtil.safeGetValue(NEEDENDPROCMSGFIELD);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean needCoordinateReqMsg() {
        try {
            return (Boolean)WfConfigurationUtil.safeGetValue(NEEDCOORDINATEREQMSGFIELD);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean needCoordinateReplyMsg() {
        try {
            return (Boolean)WfConfigurationUtil.safeGetValue(NEEDCOORDINATEREPLYMSGFIELD);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean needDataSigned() {
        try {
            return (Boolean)WfConfigurationUtil.safeGetValue(NEEDDATASIGNED);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static String getApprovalViewPageByDeviceType(String deviceType) {
        Object val = WfConfigurationUtil.getConfigCenterVal(APPROVALVIEWPAGE);
        if (null != val && WfUtils.isNotEmptyString(val)) {
            try {
                JSONObject valJson = JSONObject.parseObject((String)val.toString());
                return valJson.getString(deviceType);
            }
            catch (Exception e) {
                logger.warn("WfConfigurationUtil.getApprovalViewPageByDeviceType -- JSONObject.parseObject:" + WfUtils.getExceptionStacktrace(e));
            }
        }
        return null;
    }

    public static String getJsonValueFromConfCenter(String confCenterKey, String jsonKey) {
        Object val = WfConfigurationUtil.getValueFromConfCenterJSON(confCenterKey, jsonKey);
        return null == val ? null : val.toString();
    }

    public static Object getValueFromConfCenterJSON(String confCenterKey, String jsonKey) {
        Object val = WfConfigurationUtil.getConfigCenterVal(confCenterKey);
        if (null != val && WfUtils.isNotEmptyString(val)) {
            try {
                JSONObject valJson = JSONObject.parseObject((String)val.toString());
                return valJson.get((Object)jsonKey);
            }
            catch (Exception e) {
                logger.warn("WfConfigurationUtil.getJsonValueFromConfCenter -- JSONObject.parseObject:" + WfUtils.getExceptionStacktrace(e));
            }
        }
        return null;
    }

    public static boolean isProcessAddressByOrg() {
        try {
            return (Boolean)WfConfigurationUtil.safeGetValue(PROCESSADDRESSBYORG);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isFindTheOnlyProcess() {
        try {
            return (Boolean)WfConfigurationUtil.safeGetValue(FINDTHEONLYPROCESS);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isMustStartupCondition() {
        try {
            return (Boolean)WfConfigurationUtil.safeGetValue(MUSTSTARTUPCONDITION);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static String getValueForStopSubmitWhenNextPersonEmpty(String key) {
        Object val = WfConfigurationUtil.getConfigCenterVal(STOPPROCESSWHENNEXTPERSONEMPTY);
        if (null != val && WfUtils.isNotEmptyString(val)) {
            try {
                JSONObject valJson = JSONObject.parseObject((String)val.toString());
                return valJson.getString(key);
            }
            catch (Exception e) {
                logger.warn("WfConfigurationUtil.getApprovalViewPageByDeviceType -- JSONObject.parseObject:" + WfUtils.getExceptionStacktrace(e));
            }
        }
        return null;
    }

    public static boolean isStopSubmitWhenNextPersonEmpty(String formId) {
        String formIdForStopProcess;
        return WfUtils.isNotEmpty(formId) && null != (formIdForStopProcess = WfConfigurationUtil.getValueForStopSubmitWhenNextPersonEmpty(STOPPROCESSWHENNEXTPERSONEMPTY_KEY_ENTITYNUMBER)) && WfUtils.isNotEmpty(formIdForStopProcess) && (STOPPROCESSWHENNEXTPERSONEMPTY_VALUE_ENTITYNUMBER_ALL.equals(formIdForStopProcess) || formIdForStopProcess.contains(formId));
    }

    public static boolean isEnableMicroservice() {
        boolean microservice = true;
        Object value = WfConfigurationUtil.getConfigCenterVal(KEY_MICROSERVICE_EXECUTE);
        if (value != null) {
            return "true".equals(value);
        }
        return microservice;
    }

    public static boolean isDeptPrincipalPrefer() {
        try {
            return (Boolean)WfConfigurationUtil.safeGetValue(DEPTPRINCIPALPREFER);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isUsePrincipalWhenSuperiorEmpty() {
        try {
            return (Boolean)WfConfigurationUtil.safeGetValue(USEPRINCIPALWHENSUPERIOREMPTY);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isFilterDataByOrg() {
        try {
            return (Boolean)WfConfigurationUtil.safeGetValue(FILTERDATABYORG);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isShowInteractionMessage() {
        try {
            return (Boolean)WfConfigurationUtil.safeGetValue(SHOWINTERACTIONMSG);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isBillNoWithName() {
        try {
            return BooleanUtils.toBoolean((String)WfConfigurationUtil.safeGetValue(BILLNOWITHNAME).toString());
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isNetMutuallyExclusiveOpened() {
        boolean isOpened = false;
        Object value = WfConfigurationUtil.getConfigCenterVal(NET_MUTUALLY_EXCLUSIVE);
        if (value != null) {
            return "true".equals(value);
        }
        return isOpened;
    }

    public static String getErrorCodeStrategy() {
        return (String)WfConfigurationUtil.getConfigCenterVal(ERRORCODESTRATEGY);
    }

    public static boolean enablePreComputorStorage() {
        Object value = WfConfigurationUtil.getConfigCenterVal(ENABLEPRECOMPUTORSTORAGE);
        return value != null && "true".equalsIgnoreCase(value.toString());
    }

    public static boolean enableAfterAuditPreComputorStorage() {
        Object value = WfConfigurationUtil.getConfigCenterVal(ENABLEAFTERAUDITPRECOMPUTORSTORAGE);
        if (value != null) {
            return "true".equals(value);
        }
        return Boolean.TRUE;
    }

    public static boolean isNotDelayTriggerOperation() {
        return WfConfigurationUtil.getConfigCenterVal(OPERATIONDELAYTRIGGER) == null;
    }

    public static String getBillRelationGraphStackType() {
        return (String)WfConfigurationUtil.safeGetValue("stacktype", "194JD185SVFC");
    }

    public static boolean isBillRelationGraphCrossTenant() {
        return Boolean.TRUE.equals(WfConfigurationUtil.safeGetValue("crosstenant", "194JD185SVFC"));
    }

    public static String getApprovalFormKey(String entityNumber) {
        Object val = WfConfigurationUtil.getConfigCenterVal(APPROVALFORMKEY);
        if (null != val && WfUtils.isNotEmptyString(val)) {
            try {
                JSONObject valJson = JSONObject.parseObject((String)val.toString());
                return valJson.getString(entityNumber);
            }
            catch (Exception e) {
                logger.warn("WfConfigurationUtil.getApprovalFormKey -- JSONObject.parseObject:" + WfUtils.getExceptionStacktrace(e));
            }
        }
        return null;
    }

    public static boolean isEnableUserNameRepeatFormat() {
        Object val = WfConfigurationUtil.getConfigCenterVal(ENABLEUSERNAMEREPEATFORMAT);
        if (null != val && WfUtils.isNotEmptyString(val)) {
            return Boolean.parseBoolean(val.toString());
        }
        return true;
    }

    public static boolean showTrdApprovalRecord() {
        Boolean confVal = WfConfigurationUtil.getBooleanConfigCenterVal(SHOWTRDAPPROVALRECORD);
        try {
            Boolean value = (Boolean)WfConfigurationUtil.safeGetValue(SHOWTRDAPPROVALRECORD);
            return value != false || confVal != false;
        }
        catch (Exception e) {
            return confVal;
        }
    }

    public static boolean printTrdApprovalRecord() {
        Boolean confVal = WfConfigurationUtil.getBooleanConfigCenterVal(PRINTTRDAPPROVALRECORD);
        try {
            Boolean value = (Boolean)WfConfigurationUtil.safeGetValue(PRINTTRDAPPROVALRECORD);
            return value != false || confVal != false;
        }
        catch (Exception e) {
            return confVal;
        }
    }

    public static boolean isStartBizFlow() {
        Object val = WfConfigurationUtil.getConfigCenterVal(STARTBIZFLOW);
        if (null != val && WfUtils.isNotEmptyString(val)) {
            return Boolean.parseBoolean(val.toString());
        }
        return false;
    }

    public static String getKeepFieldsInVariable() {
        String presetFields = "appnumber,bootNodeId,bootNodePrevNodeIds,pageParameter,businessModel,passPercentage,passFraction,showThroughRules,throughRulesType,rulesContent";
        try {
            String fields = (String)WfConfigurationUtil.getConfigCenterVal(HIVARINSTKEEPFIELDS);
            return WfUtils.isEmpty(fields) ? presetFields : fields + "," + presetFields;
        }
        catch (Exception e) {
            logger.warn(String.format("getKeepFieldsInVariable error %s", WfUtils.getExceptionStacktrace(e)));
            return presetFields;
        }
    }

    public static boolean needControlCirthPathNum(String processKey, String nodeId) {
        Object val = WfConfigurationUtil.getConfigCenterVal(CONTROLCIRTHPATHNUM);
        if (null != val && WfUtils.isNotEmptyString(val)) {
            try {
                JSONObject valJson = JSONObject.parseObject((String)val.toString());
                if (valJson != null) {
                    return valJson.getBooleanValue(processKey) || valJson.getBooleanValue(nodeId);
                }
            }
            catch (Exception e) {
                return false;
            }
        }
        return false;
    }

    public static Integer getSensitiveFieldsCount() {
        Integer result = 0;
        try {
            Object val = WfConfigurationUtil.getConfigCenterVal(SENSITIVEFIELDCOUNT);
            if (null != val && WfUtils.isNotEmptyString(val)) {
                return Integer.valueOf(val.toString());
            }
        }
        catch (Exception e) {
            return result;
        }
        return result;
    }

    public static Integer getMaxBatchDealCount() {
        Integer result = 100;
        try {
            Object val = WfConfigurationUtil.getConfigCenterVal(MAXBATCHDEALCOUNT);
            if (null != val && WfUtils.isNotEmptyString(val)) {
                Integer maxCount = Integer.valueOf(val.toString());
                return maxCount > 500 ? Integer.valueOf(500) : maxCount;
            }
        }
        catch (Exception e) {
            return result;
        }
        return result;
    }

    public static Integer getSensitiveFieldsEntrythreshold() {
        Object val = WfConfigurationUtil.getConfigCenterVal(SENSITIVEFIELDSENTRYTHRESHOLD);
        if (null != val && WfUtils.isNotEmptyString(val)) {
            return Integer.valueOf(val.toString());
        }
        return null;
    }

    public static boolean isShowSensitiveChange() {
        try {
            return (Boolean)WfConfigurationUtil.safeGetValue(SHOWSENSITIVECHANGE);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean sensitiveChangeSwitch() {
        boolean result = Boolean.FALSE;
        try {
            Object val = WfConfigurationUtil.getConfigCenterVal(ENABLESENSITIVEFIELD);
            if (null != val && WfUtils.isNotEmptyString(val)) {
                result = Boolean.parseBoolean((String)val);
            }
        }
        catch (Exception e) {
            return Boolean.FALSE;
        }
        return result;
    }

    public static String sensitivePermiOperateList() {
        Object val = WfConfigurationUtil.getConfigCenterVal(SENSITIVEPERMIOPERATELIST);
        if (null != val && WfUtils.isNotEmptyString(val)) {
            return val.toString();
        }
        return "submit";
    }

    @Deprecated
    public static boolean checkByAdmin() {
        return false;
    }

    public static boolean checkRepeaterControl() {
        Object val = WfConfigurationUtil.getConfigCenterVal(REPEATERCONTROL);
        if (null != val && WfUtils.isNotEmptyString(val)) {
            return Boolean.parseBoolean(val.toString());
        }
        return false;
    }

    public static boolean closeDimensionRecord() {
        Boolean confVal = WfConfigurationUtil.getBooleanConfigCenterVal(CLOSEDIMENSIONRECORD);
        try {
            Boolean value = (Boolean)WfConfigurationUtil.safeGetValue(CLOSEDIMENSIONRECORD);
            return value != false || confVal != false;
        }
        catch (Exception e) {
            return confVal;
        }
    }

    public static boolean getChoosePerson() {
        try {
            return (Boolean)WfConfigurationUtil.safeGetValue(CHOOSEPERSON);
        }
        catch (Exception e) {
            return true;
        }
    }

    public static Map<String, String> getSuspendConfigInfo() {
        HashMap<String, String> mapping = new HashMap<String, String>(16);
        String config = (String)WfConfigurationUtil.getConfigCenterVal(SUSPEND);
        if (WfUtils.isNotEmpty(config)) {
            try {
                JSONObject ret = JSON.parseObject((String)config);
                for (Map.Entry entry : ret.entrySet()) {
                    mapping.put((String)entry.getKey(), String.valueOf(entry.getValue()));
                }
            }
            catch (Exception e) {
                logger.warn(WfUtils.getExceptionStacktrace(e));
            }
        }
        return mapping;
    }

    public static Map<String, String> noNeedCheckAddSignNodeTypes() {
        HashMap<String, String> mapping = new HashMap<String, String>(16);
        String config = (String)WfConfigurationUtil.getConfigCenterVal(NONEEDCHECKADDSIGNNODETYPES);
        if (WfUtils.isNotEmpty(config)) {
            try {
                JSONObject ret = JSON.parseObject((String)config);
                for (Map.Entry entry : ret.entrySet()) {
                    mapping.put((String)entry.getKey(), String.valueOf(entry.getValue()));
                }
            }
            catch (Exception e) {
                logger.warn(WfUtils.getExceptionStacktrace(e));
            }
        }
        return mapping;
    }

    public static String getAppIdForEntityNumber(String entityNumber) {
        String appId = "";
        String config = (String)WfConfigurationUtil.getConfigCenterVal(CHECKRIGHTAPPIDS);
        if (WfUtils.isNotEmpty(config)) {
            try {
                JSONObject ret = JSON.parseObject((String)config);
                for (Map.Entry entry : ret.entrySet()) {
                    if (null == entry.getKey() || !((String)entry.getKey()).equals(entityNumber)) continue;
                    appId = String.valueOf(entry.getValue());
                    break;
                }
            }
            catch (Exception e) {
                logger.warn(WfUtils.getExceptionStacktrace(e));
            }
        }
        return appId;
    }

    public static Boolean isHiTaskSingleTableQuery() {
        try {
            Object val = WfConfigurationUtil.getConfigCenterVal(SINGLETABLEQUERY);
            return StringUtils.isBlank((Object)val) || "true".equals(val);
        }
        catch (Exception e) {
            return Boolean.TRUE;
        }
    }

    public static Boolean isUpdateHiTaskToHiCommentComplete() {
        try {
            return WfConfigurationUtil.getBooleanConfigCenterVal(REPAIREHICOMMENTCOMPLETE) && WfConfigurationUtil.getBooleanConfigCenterVal(REPAIREHICOMMENTDISPLAYPROPERTYCOMPLETE);
        }
        catch (Exception e) {
            return Boolean.FALSE;
        }
    }

    public static Boolean isRepaireMsgReceiverComplete() {
        try {
            return WfConfigurationUtil.getBooleanConfigCenterVal(REPAIREMSGRECEIVERCOMPLETE);
        }
        catch (Exception e) {
            return Boolean.FALSE;
        }
    }

    public static Boolean isRepaireMsgContentSummaryFinish() {
        try {
            return WfConfigurationUtil.getBooleanConfigCenterVal(REPAIREMSGCONTENTSUMMARYFINISH);
        }
        catch (Exception e) {
            return Boolean.FALSE;
        }
    }

    public static Boolean isEnableOtherLang() {
        try {
            return WfConfigurationUtil.getBooleanConfigCenterVal(ISENABLEOTHERLANG);
        }
        catch (Exception e) {
            return Boolean.FALSE;
        }
    }

    public static boolean isEnableArchive() {
        try {
            return (Boolean)WfConfigurationUtil.safeGetValue(WFARCHIVESERVICE);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static Boolean isAllowExtendTaskFields() {
        try {
            return WfConfigurationUtil.getBooleanConfigCenterVal(ALLWOEXTENDTASKBUSINESSFIELD);
        }
        catch (Exception e) {
            return Boolean.FALSE;
        }
    }

    public static Boolean isEnableHitaskBusinessFieldShow() {
        try {
            return WfConfigurationUtil.getBooleanConfigCenterVal(ENABLEHITASKINSTBUSINESSFIELD);
        }
        catch (Exception e) {
            return Boolean.FALSE;
        }
    }

    public static String getNeedUpdateExtFieldEntitynumbers() {
        try {
            return (String)WfConfigurationUtil.getConfigCenterVal(NEEDUPDATEEXTFIELDENTITYNUMBERS);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Boolean isOpenUrl() {
        try {
            return WfConfigurationUtil.getBooleanConfigCenterVal(OPENCHANNELEXTRALURLBYOPENURL);
        }
        catch (Exception e) {
            return Boolean.FALSE;
        }
    }

    public static boolean isShowBillApprovalRecord(boolean pcShow) {
        String jsonKey = pcShow ? "pc" : "mob";
        Object value = WfConfigurationUtil.getValueFromConfCenterJSON(SHOWBILLAPPROVALRECORD, jsonKey);
        return null == value ? false : (Boolean)value;
    }

    public static boolean isOptimizeLogicForLinkMessage() {
        Object value = WfConfigurationUtil.getConfigCenterVal(OPTIMIZELOGICFORLINKMESSAGE);
        return null == value ? true : "true".equals(value);
    }

    public static boolean isShowUrlInWFSmsMessgae() {
        boolean showUrl = true;
        try {
            showUrl = (Boolean)WfConfigurationUtil.safeGetValue(SHOWURLINWFSMSMSG);
        }
        catch (Exception e) {
            logger.warn(String.format("get isShowUrlInWFSmsMessgae system params is error: %s", WfUtils.getExceptionStacktrace(e)));
        }
        return showUrl;
    }

    public static String getVarsBlackList() {
        try {
            return (String)WfConfigurationUtil.getConfigCenterVal(VARBLACKLIST);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static boolean getIsOpenWorkCalendarForOrg(Long orgId) {
        try {
            AppParam param = new AppParam();
            param.setAppId("a479ec06000000ac");
            if (WfUtils.isEmpty(orgId)) {
                String userId = RequestContext.get().getUserId();
                Long mainOrgId = UserServiceHelper.getUserMainOrgId((long)Long.parseLong(userId));
                if (WfUtils.isEmpty(mainOrgId)) {
                    param.setOrgId(Long.valueOf(OrgUnitServiceHelper.getRootOrgId()));
                } else {
                    param.setOrgId(mainOrgId);
                }
            } else {
                param.setOrgId(orgId);
            }
            param.setViewType("01");
            return (Boolean)SystemParamServiceHelper.loadAppParameterFromCache((AppParam)param, (String)ISOPENWORKCALENDAR);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean getIsOpenWorkCalendar() {
        try {
            return (Boolean)WfConfigurationUtil.safeGetValue(ISOPENWORKCALENDAR);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isAutoRepairSysErrorProcessInstances() {
        try {
            Object val = WfConfigurationUtil.getConfigCenterVal(ISAUTOREPAIRSYSERRORPROCESSINSTANCES);
            return val != null ? "true".equals(val) : true;
        }
        catch (Exception e) {
            return true;
        }
    }

    public static boolean removeTimingLogImmediately() {
        try {
            return WfConfigurationUtil.getBooleanConfigCenterVal(REMOVINGTIMEJOBLOG);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean disableCheckV2Api() {
        try {
            return WfConfigurationUtil.getBooleanConfigCenterVal(DISABLEAPIPERM);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean disableCheckV1Api() {
        try {
            return WfConfigurationUtil.getBooleanConfigCenterVal(DISABLEAPIPERMV1);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean disableCheckApiOrgPer() {
        try {
            return WfConfigurationUtil.getBooleanConfigCenterVal(DISABLEAPIORGPERM);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean disableServiceApiPer() {
        try {
            return WfConfigurationUtil.getBooleanConfigCenterVal(SERVICEAPIDISABLE);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static int getRepairSysErrorProcessInstancesSize() {
        try {
            Object obj = WfConfigurationUtil.getConfigCenterVal(REPAIRSYSERRORPROCESSINSTANCESSIZE);
            if (obj != null && WfUtils.isNotEmptyString(obj)) {
                return Integer.parseInt((String)obj);
            }
            return 0;
        }
        catch (Exception e) {
            return 0;
        }
    }

    public static boolean firstAddressAssignPersonProcess() {
        try {
            return WfConfigurationUtil.getBooleanConfigCenterVal(FIRSTADDRESSASSIGNPERSONPROCESS);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean getKeepUndealTask() {
        try {
            return WfConfigurationUtil.getBooleanConfigCenterVal(KEEPUNDEALTASK);
        }
        catch (Exception e) {
            return Boolean.FALSE;
        }
    }

    public static boolean isAutoRepairSysErrorRecordJob() {
        try {
            return WfConfigurationUtil.getBooleanConfigCenterVal(ISAUTOREPAIRSYSERRORRECORDJOB);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean enableWorkCalendar() {
        try {
            return WfConfigurationUtil.getBooleanConfigCenterVal("workflow.enable.workCalendar");
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isNeedRestart() {
        try {
            return WfConfigurationUtil.getBooleanConfigCenterVal(RESTART);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean restartAddressByTime() {
        try {
            return WfConfigurationUtil.getBooleanConfigCenterVal(RESTARTADDRESSBYTIME);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static String getAllowHtmlATagChannels() {
        try {
            return (String)WfConfigurationUtil.getConfigCenterVal(ALLOWHTMLTAGCHANNELS);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static boolean isEnableLockForUpdateConcurrentData() {
        try {
            return WfConfigurationUtil.getBooleanConfigCenterVal(ENABLELOCKFORUPDATECONCURRENTDATA);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static String getSendEvtMqThreshold() {
        try {
            return (String)WfConfigurationUtil.getConfigCenterVal(ENGINESENDEVTTHRESHOLD);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static boolean isEvtNeedSubApp() {
        try {
            return WfConfigurationUtil.getBooleanConfigCenterVal(ENGINEIFNEEDSUBAPP);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean rejectToBackAndRecalculationParticipant() {
        try {
            return WfConfigurationUtil.getBooleanConfigCenterVal(REJECTTOBACKANDRECALCULATIONPARTICIPANT);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean rejectToBackAndAutomaticProcessingFailure() {
        try {
            return WfConfigurationUtil.getBooleanConfigCenterVal(REJECTTOBACKANDAUTOMATICPROCESSINGFAILURE);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isBillWithdrawJumpToUserNode() {
        Object val = WfConfigurationUtil.getConfigCenterVal(BILLWITHDRAWJUMPTOUSERNODE);
        if (null != val && WfUtils.isNotEmptyString(val)) {
            return Boolean.parseBoolean(val.toString());
        }
        return false;
    }

    public static int getAllowQueryDevopsIndicatorCount() {
        try {
            Object count = WfConfigurationUtil.getConfigCenterVal(ALLOWSELECTDEVOPSINDICATORCOUNT);
            if (count != null && WfUtils.isNotEmptyString(count)) {
                return Integer.parseInt((String)count);
            }
            return 0;
        }
        catch (Exception e) {
            return 0;
        }
    }

    public static int getAllowOnceQueryDevopsIndicatorCount() {
        try {
            Object count = WfConfigurationUtil.getConfigCenterVal(ALLOWONCEQUERYDEVOPSINDICATORCOUNT);
            if (WfUtils.isNotEmptyString(count)) {
                return Integer.parseInt((String)count);
            }
            return 0;
        }
        catch (Exception e) {
            return 0;
        }
    }

    public static boolean disableApprovalRecordOptimization() {
        Object val = WfConfigurationUtil.getConfigCenterVal(DISABLEAPPROVALRECORDOPTIMIZATION);
        if (null != val && WfUtils.isNotEmptyString(val)) {
            return Boolean.parseBoolean(val.toString());
        }
        return false;
    }

    public static boolean ifNeedAddUrgentQueue(Long eventId) {
        try {
            if (WfUtils.isEmpty(eventId)) {
                return false;
            }
            Object quickEventQueue = WfConfigurationUtil.getConfigCenterVal("bec.engine.urgentEventQueue");
            if (quickEventQueue != null && WfUtils.isNotEmptyString(quickEventQueue)) {
                List<String> result = Arrays.asList(((String)quickEventQueue).split(","));
                return result.contains(eventId.toString());
            }
        }
        catch (Exception e) {
            logger.warn(String.format("get quickEventQueue system params is error: %s", WfUtils.getExceptionStacktrace(e)));
            return false;
        }
        return false;
    }

    public static boolean enableGetCommentFromBasedata() {
        Object val = WfConfigurationUtil.getConfigCenterVal(ENABLEGETCOMMENTFROMBASEDATA);
        if (val != null && WfUtils.isNotEmptyString(val)) {
            return Boolean.parseBoolean(val.toString());
        }
        return false;
    }

    public static boolean getDisableParseLogCollect() {
        try {
            return WfConfigurationUtil.getBooleanConfigCenterVal(DISABLERUNTIMEPARSELOGCOLLECT);
        }
        catch (Exception e) {
            return false;
        }
    }

    @Deprecated
    public static boolean isNeedRestartByRejectBackToNode() {
        try {
            return WfConfigurationUtil.getBooleanConfigCenterVal(NOTRESTARTBYREJECTBACKTONODE);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isNotNeedRestartByRejectBackToNode() {
        try {
            return WfConfigurationUtil.getBooleanConfigCenterVal(NOTRESTARTBYREJECTBACKTONODE);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isAllowBillUnsubmitAfterUserNode() {
        try {
            return (Boolean)WfConfigurationUtil.safeGetValue(ALLOWBILLUNSUBMITAFTERUSERNODE);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean userOldWithdraw() {
        try {
            return WfConfigurationUtil.getBooleanConfigCenterVal(USEROLDWITHDRAW);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isDirectlyClearJob() {
        Object val = WfConfigurationUtil.getConfigCenterVal(DIRECTLY_CLEAR_JOB);
        if (val != null && WfUtils.isNotEmptyString(val)) {
            return Boolean.parseBoolean(val.toString());
        }
        return false;
    }

    public static boolean isTaskBusinessFieldSupportBigIntField() {
        try {
            Object val = WfConfigurationUtil.getConfigCenterVal(BUSINESSFIELDISSUPPORTBIGINTFIELD);
            return "true".equals(val);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isEnableDevopsDataCollected() {
        try {
            Object val = WfConfigurationUtil.getConfigCenterVal(ISENABLEDEVOPSDATACOLLECTED);
            return val == null || "true".equals(val);
        }
        catch (Exception e) {
            return true;
        }
    }

    public static int getMaximumOfCyclesNumber() {
        try {
            Object maximum = WfConfigurationUtil.getConfigCenterVal(MAXIMUMOFCYCLESNUMBER);
            if (maximum != null && WfUtils.isNotEmptyString(maximum)) {
                return Integer.parseInt((String)maximum);
            }
            return -1;
        }
        catch (Exception e) {
            return -1;
        }
    }

    public static boolean useCleanFrame() {
        Object val = WfConfigurationUtil.getConfigCenterVal(USE_CLEAN_FRAME);
        if (val != null && WfUtils.isNotEmptyString(val)) {
            return Boolean.parseBoolean(val.toString());
        }
        return false;
    }

    public static boolean diableUseQuantitySummary() {
        boolean disableUseQuantitySummary = false;
        try {
            Object ret = WfConfigurationUtil.getConfigCenterVal(MSG_DISABLEUSEQUANTITYSUMMARY);
            if (ret != null) {
                disableUseQuantitySummary = Boolean.parseBoolean((String)ret);
            }
        }
        catch (Exception e) {
            logger.warn("diableUseQuantitySummary function has exception:" + WfUtils.getExceptionStacktrace(e));
        }
        return disableUseQuantitySummary;
    }

    public static boolean canCorrectLoginUserQSInfos() {
        boolean canCorrectQSInfos = true;
        try {
            Object ret = WfConfigurationUtil.getConfigCenterVal(MSG_ISCORRECTQSINFOSBYLOGIN);
            if (ret != null) {
                canCorrectQSInfos = Boolean.parseBoolean((String)ret);
            }
        }
        catch (Exception e) {
            logger.warn("isCorrectQSInfosByLogin has exception:" + WfUtils.getExceptionStacktrace(e));
        }
        return canCorrectQSInfos;
    }

    public static String getLoginUserCorrectConfig() {
        try {
            Object ret = WfConfigurationUtil.getConfigCenterVal(MSG_CORRECTUSERQSINF);
            if (ret != null) {
                return (String)ret;
            }
        }
        catch (Exception e) {
            logger.warn("getUserLoginCorrectConfig function has exception:" + WfUtils.getExceptionStacktrace(e));
        }
        return null;
    }

    public static boolean isCorrectHandleQSData() {
        boolean correctHandledQSData = false;
        try {
            Object ret = WfConfigurationUtil.getConfigCenterVal(MSG_CORRECTHANDLEDQS);
            if (ret != null) {
                correctHandledQSData = Boolean.parseBoolean((String)ret);
            }
        }
        catch (Exception e) {
            logger.warn("isCorrectHandleQSData has exception:" + WfUtils.getExceptionStacktrace(e));
        }
        return correctHandledQSData;
    }

    public static boolean canAsyncCompensationEnable() {
        boolean isCompensationEnable = true;
        try {
            Object ret = WfConfigurationUtil.getConfigCenterVal(MSG_ISASYNCCOMPENSATIONENABLE);
            if (ret != null) {
                isCompensationEnable = Boolean.parseBoolean((String)ret);
            }
        }
        catch (Exception e) {
            logger.warn("canAsyncCompensationEnable has exception:" + WfUtils.getExceptionStacktrace(e));
        }
        return isCompensationEnable;
    }

    public static boolean canCompensationOfDelegateAndFile() {
        boolean isCompensationOfDelegateAndFile = false;
        try {
            Object ret = WfConfigurationUtil.getConfigCenterVal(MSG_ISCOMPENSATIONDELEGATEANDFILE);
            if (ret != null) {
                isCompensationOfDelegateAndFile = Boolean.parseBoolean((String)ret);
            }
        }
        catch (Exception e) {
            logger.warn("isCompensationOfDelegateAndFile has exception:" + WfUtils.getExceptionStacktrace(e));
        }
        return isCompensationOfDelegateAndFile;
    }

    public static int getMaxDealQSInfos() {
        int max_dealQSInfosCount = 500000;
        try {
            Object ret = WfConfigurationUtil.getConfigCenterVal(MSG_MAXDEALQSINFOSCOUNT);
            if (ret != null) {
                max_dealQSInfosCount = Integer.parseInt((String)ret);
            }
        }
        catch (Exception e) {
            logger.warn("getMaxDealQSInfos function has exception:" + WfUtils.getExceptionStacktrace(e));
        }
        return max_dealQSInfosCount;
    }

    public static boolean ifNeedDegrade(Long executionId) {
        try {
            if (WfUtils.isEmpty(executionId)) {
                return false;
            }
            Object executionIds = WfConfigurationUtil.getConfigCenterVal("bec.engine.ifNeedDegrade");
            if (executionIds != null && WfUtils.isNotEmptyString(executionIds)) {
                List<String> result = Arrays.asList(((String)executionIds).split(","));
                return result.contains(executionId.toString());
            }
        }
        catch (Exception e) {
            return false;
        }
        return false;
    }

    public static boolean ifMoveToHiJob() {
        try {
            Object ifMoveToHiJob = WfConfigurationUtil.getConfigCenterVal("bec.engine.ifMoveToHiJob");
            if (ifMoveToHiJob != null && ifMoveToHiJob.toString().trim().length() > 0) {
                return Boolean.parseBoolean((String)ifMoveToHiJob);
            }
        }
        catch (Exception e) {
            return true;
        }
        return true;
    }

    public static boolean ifEvtOpreationCatchAllErr() {
        try {
            Object ifMoveToHiJob = WfConfigurationUtil.getConfigCenterVal("bec.engine.ifEvtOpreationCatchAllErr");
            if (ifMoveToHiJob != null && ifMoveToHiJob.toString().trim().length() > 0) {
                return Boolean.parseBoolean((String)ifMoveToHiJob);
            }
        }
        catch (Exception e) {
            return false;
        }
        return false;
    }

    public static Object getAsyncMessageBeginCollectTime() {
        try {
            return WfConfigurationUtil.getConfigCenterVal(WFDEVOPSASYNCMESSAGETIMINGSTARTTIME);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static boolean enableZipProcessData(Long processDefinitionId) {
        try {
            if (WfUtils.isEmpty(processDefinitionId)) {
                return false;
            }
            Object procDefIdsObject = WfConfigurationUtil.getConfigCenterVal(ENABLED_ZIP_PROCDEFID);
            if (procDefIdsObject != null) {
                List<String> enabledZipProcDefIds = Arrays.asList(procDefIdsObject.toString().trim().split(","));
                return enabledZipProcDefIds.contains(String.valueOf(processDefinitionId));
            }
        }
        catch (Exception e) {
            return false;
        }
        return false;
    }

    public static List<Long> getEnableZipProcess() {
        ArrayList<Long> result = new ArrayList<Long>(10);
        try {
            Object procDefIdsObject = WfConfigurationUtil.getConfigCenterVal(ENABLED_ZIP_PROCDEFID);
            if (procDefIdsObject != null) {
                List<String> enabledZipProcDefIds = Arrays.asList(procDefIdsObject.toString().trim().split(","));
                for (String procDefId : enabledZipProcDefIds) {
                    if (!WfUtils.isNotEmpty(procDefId)) continue;
                    result.add(Long.valueOf(procDefId.trim()));
                }
            }
        }
        catch (Exception e) {
            logger.warn(String.format("get enabledZipProcDefId system params is error: %s", WfUtils.getExceptionStacktrace(e)));
        }
        return result;
    }

    public static Set<String> getAllowChangeProperties() {
        HashSet<String> allowChangeProperties = new HashSet<String>(10);
        try {
            Object allowChangePropertiesObject = WfConfigurationUtil.getConfigCenterVal(ALLOW_CHANGE_VALUE_PROPERTIES);
            if (allowChangePropertiesObject != null) {
                List<String> allowChangePropertyList = Arrays.asList(allowChangePropertiesObject.toString().trim().split(","));
                for (String property : allowChangePropertyList) {
                    allowChangeProperties.add(property);
                }
            }
        }
        catch (Exception e) {
            logger.warn(String.format("get allowChangeValueProperties system params is error: %s", WfUtils.getExceptionStacktrace(e)));
        }
        return allowChangeProperties;
    }

    public static int getMaxSizeOfMultiInstances() {
        try {
            Object maximum = WfConfigurationUtil.getConfigCenterVal(KEY_MULTIINSTMAXSIZE);
            if (maximum != null && WfUtils.isNotEmptyString(maximum)) {
                return Integer.parseInt((String)maximum);
            }
            return 20;
        }
        catch (Exception e) {
            return 20;
        }
    }

    public static int[] getBecTransformConfig() {
        try {
            String config;
            String[] configs;
            Object ret = WfConfigurationUtil.getConfigCenterVal(BECENGINETRANSFORM);
            if (ret != null && (configs = (config = (String)ret).split(",")) != null && configs.length == 2) {
                return new int[]{Integer.parseInt(configs[0]), Integer.parseInt(configs[1])};
            }
        }
        catch (Exception e) {
            logger.warn("getBecTransformConfig function has exception:" + WfUtils.getExceptionStacktrace(e));
        }
        return new int[]{5, 1800};
    }

    public static int getMaximumOfPksInPageCache() {
        try {
            Object maximum = WfConfigurationUtil.getConfigCenterVal(MAXIMUMOFPKSINPAGECACHE);
            if (maximum != null && WfUtils.isNotEmptyString(maximum)) {
                return Integer.parseInt((String)maximum);
            }
            return 1000;
        }
        catch (Exception e) {
            return 1000;
        }
    }

    public static boolean enableSeparateStorage() {
        Object val = WfConfigurationUtil.getConfigCenterVal(SEPARATESTORAGEMASTERSWITCH);
        if (null != val && WfUtils.isNotEmptyString(val)) {
            return Boolean.parseBoolean(val.toString());
        }
        return true;
    }

    public static boolean judgeBizFlowWhenAssignPerson() {
        return WfConfigurationUtil.getBooleanConfigCenterVal(JUDGEBIZFLOWWHENASSIGNPERSON);
    }

    public static String getRetryErrorCodes() {
        Object val = WfConfigurationUtil.getConfigCenterVal(RETRYERRORCODES);
        return val == null ? "" : (String)val;
    }

    public static String getRetryErrorMsgs() {
        Object val = WfConfigurationUtil.getConfigCenterVal(RETRYERRORMSG);
        return val == null ? "" : (String)val;
    }

    public static String getAlwaysRetryErrorCode() {
        Object val = WfConfigurationUtil.getConfigCenterVal(ALWAYSRETRYERRORCODE);
        return val == null ? "" : (String)val;
    }

    public static int getAlwaysRetryCount() {
        Object val = WfConfigurationUtil.getConfigCenterVal(ALWAYSRETRYCOUNT);
        if (val == null) {
            return 0;
        }
        try {
            return Integer.parseInt((String)val);
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            return 0;
        }
    }

    public static int getDevopsIndicatorRetentionDays() {
        int retentionDays = 1;
        try {
            Object ret = WfConfigurationUtil.getConfigCenterVal(WFDEVOPSINDICATORRETENTIONDAYS);
            if (ret != null) {
                retentionDays = Integer.parseInt((String)ret);
            }
        }
        catch (Exception e) {
            logger.warn("getDevopsIndicatorRetentionDays function has exception:" + WfUtils.getExceptionStacktrace(e));
        }
        return retentionDays;
    }

    public static Boolean isEnableMsgBecEvent() {
        try {
            return WfConfigurationUtil.getBooleanConfigCenterVal(ENABLEMSGBECEVENT);
        }
        catch (Exception e) {
            return Boolean.FALSE;
        }
    }

    public static Object getDevopsEnbleIndicatorGroupsModel() {
        try {
            return WfConfigurationUtil.getConfigCenterVal(WFDEVOPSENABLEGROUPSMODEL);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static boolean canRunBusinessEvent() {
        Object obj = ConfigServiceHelper.getGlobalConfiguration((String)BUSINESSEVENTSTART);
        if (obj != null) {
            return "true".equals(obj);
        }
        Object val = WfConfigurationUtil.getConfigCenterVal(BUSINESSEVENTSTART);
        if (null == val || WfUtils.isNotEmptyString(val)) {
            return true;
        }
        return Boolean.parseBoolean(val.toString());
    }

    public static boolean disablePreComputeParticipantPosition() {
        try {
            return WfConfigurationUtil.getBooleanConfigCenterVal(DISABLEPRECOMPUTEPARTICIPANTPOSITION);
        }
        catch (Exception e) {
            return Boolean.FALSE;
        }
    }

    public static Boolean ifSendMqDirect() {
        try {
            return WfConfigurationUtil.getBooleanConfigCenterVal(IFSENDMQDIRECT);
        }
        catch (Exception e) {
            return Boolean.FALSE;
        }
    }

    public static boolean ifShowFormOperation() {
        try {
            Object ifShowFormOperation = WfConfigurationUtil.getConfigCenterVal("workflow.engine.ifShowFormOperation");
            if (ifShowFormOperation != null && ifShowFormOperation.toString().trim().length() > 0) {
                return Boolean.parseBoolean((String)ifShowFormOperation);
            }
        }
        catch (Exception e) {
            return false;
        }
        return false;
    }

    public static boolean isNotQueryByNewSql() {
        try {
            return WfConfigurationUtil.getBooleanConfigCenterVal(ISNOTQUERYDATABYNEWSQL);
        }
        catch (Exception e) {
            return Boolean.FALSE;
        }
    }

    public static boolean isEnableNewPartRelationForm() {
        try {
            Object val = WfConfigurationUtil.getConfigCenterVal(ENABLENEWRARTRELATIONFORM);
            return val == null || "true".equals(val);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean ifNeedAddSlowQueue(Long eventId) {
        try {
            if (WfUtils.isEmpty(eventId)) {
                return false;
            }
            Object slowEventQueue = WfConfigurationUtil.getConfigCenterVal("bec.engine.slowEventQueue");
            if (slowEventQueue != null && WfUtils.isNotEmptyString(slowEventQueue)) {
                List<String> result = Arrays.asList(((String)slowEventQueue).split(","));
                return result.contains(eventId.toString());
            }
        }
        catch (Exception e) {
            return false;
        }
        return false;
    }

    public static boolean ifNeedDownGrade(Long eventId) {
        try {
            if (WfUtils.isEmpty(eventId)) {
                return false;
            }
            Object downGradeQueue = WfConfigurationUtil.getConfigCenterVal("bec.engine.downGradeQueue");
            if (downGradeQueue != null && WfUtils.isNotEmptyString(downGradeQueue)) {
                List<String> result = Arrays.asList(((String)downGradeQueue).split(","));
                if (result.size() < 3) {
                    return false;
                }
                int hour = LocalDateTime.now().getHour();
                int low = Integer.parseInt(result.get(0));
                int high = Integer.parseInt(result.get(1));
                if (hour > low && hour < high) {
                    return result.contains(eventId.toString());
                }
            }
        }
        catch (Exception e) {
            return false;
        }
        return false;
    }

    public static Boolean isUpdateTaskToParticipantComplete() {
        try {
            return WfConfigurationUtil.getBooleanConfigCenterVal(REPAIREIDENTITYLINKCOMPLETE);
        }
        catch (Exception e) {
            return Boolean.FALSE;
        }
    }

    public static Boolean isUpdateTaskHandleLogComplete() {
        try {
            return WfConfigurationUtil.getBooleanConfigCenterVal(REPAIRETASKHANDLELOGCOMPLETE);
        }
        catch (Exception e) {
            return Boolean.FALSE;
        }
    }

    public static boolean isRepairWorkflowRoleIncludeAdminSubComplete() {
        try {
            Object val = WfConfigurationUtil.getConfigCenterVal(ISREPAIRWORKFLOWROLEINCLUDEADMINSUBCOMPLETE);
            if (val != null) {
                return Boolean.parseBoolean(val.toString());
            }
        }
        catch (Exception e) {
            logger.warn(String.format("isRepairWorkflowRoleIncludeAdminSubComplete_error : %s", WfUtils.getExceptionStacktrace(e)));
        }
        return false;
    }

    public static boolean isTrustHandle() {
        try {
            return WfConfigurationUtil.getBooleanConfigCenterVal(ISTRUSTHANDLE);
        }
        catch (Exception e) {
            return Boolean.FALSE;
        }
    }

    public static boolean expireSendMsgCarryUrl() {
        try {
            Object configCenterVal = WfConfigurationUtil.getConfigCenterVal(EXPIRESENDMSGCARRYURL);
            if (configCenterVal == null) {
                return true;
            }
            String trim = ((String)configCenterVal).trim();
            return !"false".equalsIgnoreCase(trim);
        }
        catch (Exception e) {
            return true;
        }
    }

    public static boolean isHideCompensateTaskConfig() {
        Object val = WfConfigurationUtil.getConfigCenterVal(HIDECOMPENSATETASKCONFIG);
        if (null != val && WfUtils.isNotEmptyString(val)) {
            return Boolean.parseBoolean(val.toString());
        }
        return true;
    }

    public static boolean canWithdrawWhenRejectToUserTask() {
        try {
            return WfConfigurationUtil.getBooleanConfigCenterVal(CANWITHDRAWWHENREJECTTOUSERTASK) || (Boolean)WfConfigurationUtil.safeGetValue(ALLOWWITHDRAWUSERTASK) != false;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isJumpEmbeddedPageByBillType() {
        Object value = WfConfigurationUtil.getConfigCenterVal(JUMPEMBEDDEDPAGEBYBILLTYPE);
        logger.info("isJumpEmbeddedPageByBillType:" + (null == value ? false : "true".equals(value)));
        return null == value ? false : "true".equals(value);
    }

    public static boolean isResetGroupName() {
        try {
            Object configCenterVal = WfConfigurationUtil.getConfigCenterVal(GROUPNAMEFORAPPROVALRECORD);
            if (WfUtils.isNotNullObject(configCenterVal)) {
                return true;
            }
        }
        catch (Exception e) {
            return false;
        }
        return false;
    }

    public static boolean notSaveByVerifySql() {
        try {
            return WfConfigurationUtil.getBooleanConfigCenterVal(BYVERIFYSQL);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isCalculateCrossTenant() {
        Object val = WfConfigurationUtil.getConfigCenterVal(ISCALCULATECROSSTENANT);
        if (null != val && WfUtils.isNotEmptyString(val)) {
            return Boolean.parseBoolean(val.toString());
        }
        return false;
    }

    public static boolean enableForkJoinMeetingSupplementaryRules() {
        try {
            Object val = WfConfigurationUtil.getConfigCenterVal(FORKJOINMEETINGSUPPLEMENTARYRULES);
            return val == null || "true".equals(val);
        }
        catch (Exception e) {
            return true;
        }
    }

    public static String getCrossTenantEntityNumberWhiteList() {
        try {
            return String.valueOf(WfConfigurationUtil.getConfigCenterVal(CROSSTENANTENTITYNUMBERWHITELIST));
        }
        catch (Exception e) {
            return null;
        }
    }

    public static void updateCrossTenantEntityNumberWhiteList(String entityNumber) {
        String value;
        String entityNumberWhiteList = CROSSTENANTENTITYNUMBERWHITELIST;
        QFilter selectValueFilter = new QFilter(KEYWORD, "=", (Object)entityNumberWhiteList);
        QFilter[] selectValueFilters = new QFilter[]{selectValueFilter};
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)"wf_confcenter", (String)"id,value", (QFilter[])selectValueFilters);
        if (dynamicObject == null) {
            dynamicObject = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"wf_confcenter"));
            dynamicObject.set(KEYWORD, (Object)entityNumberWhiteList);
        }
        if (StringUtils.isBlank((CharSequence)(value = dynamicObject.getString(VALUE)))) {
            value = entityNumber;
        } else {
            List<String> whiteList = Arrays.asList(value.split(","));
            if (!whiteList.contains(entityNumber)) {
                value = String.format("%s,%s", value, entityNumber);
            }
        }
        dynamicObject.set(VALUE, (Object)value);
        DynamicObject[] dynObjs = new DynamicObject[]{dynamicObject};
        SaveServiceHelper.save((DynamicObject[])dynObjs);
    }

    public static boolean retryIfSlowQueue() {
        try {
            return WfConfigurationUtil.getBooleanConfigCenterVal(RETRYSLOWQUEUE);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isAllowLengthThanSpecified() {
        try {
            return WfConfigurationUtil.getBooleanConfigCenterVal(ALLOWDYNAMICFORMVALUETHANSPECIFIED);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isOpenApprovalForDocumentList() {
        try {
            return WfConfigurationUtil.getBooleanConfigCenterVal(APPROVALFORDOCUMENTLIST);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean existsDelegateAndNotTransfer() {
        try {
            return WfConfigurationUtil.getBooleanConfigCenterVal(EXISTSDELEGATEANDNOTTRANSFER);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean subProcDisplayTerminateDecisionScene() {
        Object val = WfConfigurationUtil.getConfigCenterVal(SUBPROCDISPLAYTERMINATEDECISIONSCENE);
        if (null != val && WfUtils.isNotEmptyString(val)) {
            return Boolean.parseBoolean(val.toString());
        }
        return false;
    }

    public static boolean isNonRecursionFindTargetParticipant() {
        try {
            return WfConfigurationUtil.getBooleanConfigCenterVal(ISNONRECURSIONFINDTARGETPARTICIPANT);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static int getWorkflowProcessKeyMaxLength() {
        int maxKeyLength = 50;
        try {
            Object val = WfConfigurationUtil.getConfigCenterVal(WORKFLOW_PROCESSKEY_MAXLENGTH);
            if (val != null && StringUtils.isNumeric((CharSequence)val.toString())) {
                return Integer.parseInt(val.toString());
            }
        }
        catch (Exception e) {
            return maxKeyLength;
        }
        return maxKeyLength;
    }

    public static boolean wfRoleAlternateTypeNullValue() {
        Object needFilter = WfConfigurationUtil.getConfigCenterVal(WORKFLOW_ROLE_ALTERNATETYPE_NULLVALUE);
        return "true".equals(needFilter);
    }

    public static boolean isEnableShowMutiLangLog() {
        Object value = WfConfigurationUtil.getConfigCenterVal(KEY_ISENABLESHOWMUTILANGLOG);
        if (value != null) {
            return "true".equals(value);
        }
        return false;
    }
}

