/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import kd.bos.workflow.engine.WfDateRange;

public class WfDateUtil {
    public static final String DEFAULT_PATTERN = "MM/dd/yyyy HH:mm:ss";

    public static WfDateRange getMonthRange(Date date) {
        Calendar startCalendar = Calendar.getInstance();
        startCalendar.setTime(date);
        startCalendar.set(5, 1);
        WfDateUtil.setMaxTime(startCalendar);
        Calendar endCalendar = Calendar.getInstance();
        endCalendar.setTime(date);
        endCalendar.set(5, endCalendar.getActualMaximum(5));
        WfDateUtil.setMaxTime(endCalendar);
        return new WfDateRange(startCalendar.getTime(), endCalendar.getTime());
    }

    public static WfDateRange getThisQuarter() {
        Calendar startCalendar = Calendar.getInstance();
        startCalendar.set(2, startCalendar.get(2) / 3 * 3);
        startCalendar.set(5, 1);
        WfDateUtil.setMinTime(startCalendar);
        Calendar endCalendar = Calendar.getInstance();
        endCalendar.set(2, startCalendar.get(2) / 3 * 3 + 2);
        endCalendar.set(5, endCalendar.getActualMaximum(5));
        WfDateUtil.setMaxTime(endCalendar);
        return new WfDateRange(startCalendar.getTime(), endCalendar.getTime());
    }

    public static WfDateRange getCurrentdayRange() {
        Calendar startCalendar = Calendar.getInstance();
        startCalendar.add(5, 0);
        WfDateUtil.setMinTime(startCalendar);
        Calendar endCalendar = Calendar.getInstance();
        endCalendar.add(5, 0);
        WfDateUtil.setMaxTime(endCalendar);
        return new WfDateRange(startCalendar.getTime(), endCalendar.getTime());
    }

    public static WfDateRange getYesterdayRange() {
        Calendar startCalendar = Calendar.getInstance();
        startCalendar.add(5, -1);
        WfDateUtil.setMinTime(startCalendar);
        Calendar endCalendar = Calendar.getInstance();
        endCalendar.add(5, -1);
        WfDateUtil.setMaxTime(endCalendar);
        return new WfDateRange(startCalendar.getTime(), endCalendar.getTime());
    }

    public static WfDateRange getWeekdayRange() {
        Calendar startCalendar = Calendar.getInstance();
        startCalendar.add(5, -6);
        WfDateUtil.setMinTime(startCalendar);
        Calendar endCalendar = Calendar.getInstance();
        endCalendar.add(5, 0);
        WfDateUtil.setMaxTime(endCalendar);
        return new WfDateRange(startCalendar.getTime(), endCalendar.getTime());
    }

    public static WfDateRange getThisMonth() {
        Calendar startCalendar = Calendar.getInstance();
        startCalendar.set(5, 1);
        WfDateUtil.setMinTime(startCalendar);
        Calendar endCalendar = Calendar.getInstance();
        endCalendar.set(5, endCalendar.getActualMaximum(5));
        WfDateUtil.setMaxTime(endCalendar);
        return new WfDateRange(startCalendar.getTime(), endCalendar.getTime());
    }

    public static WfDateRange getLastMonth() {
        Calendar startCalendar = Calendar.getInstance();
        startCalendar.add(2, -1);
        startCalendar.set(5, 1);
        WfDateUtil.setMinTime(startCalendar);
        Calendar endCalendar = Calendar.getInstance();
        endCalendar.add(2, -1);
        endCalendar.set(5, endCalendar.getActualMaximum(5));
        WfDateUtil.setMaxTime(endCalendar);
        return new WfDateRange(startCalendar.getTime(), endCalendar.getTime());
    }

    public static WfDateRange getLastQuarter() {
        Calendar startCalendar = Calendar.getInstance();
        startCalendar.set(2, (startCalendar.get(2) / 3 - 1) * 3);
        startCalendar.set(5, 1);
        WfDateUtil.setMinTime(startCalendar);
        Calendar endCalendar = Calendar.getInstance();
        endCalendar.set(2, (endCalendar.get(2) / 3 - 1) * 3 + 2);
        endCalendar.set(5, endCalendar.getActualMaximum(5));
        WfDateUtil.setMaxTime(endCalendar);
        return new WfDateRange(startCalendar.getTime(), endCalendar.getTime());
    }

    private static void setMinTime(Calendar calendar) {
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
    }

    private static void setMaxTime(Calendar calendar) {
        calendar.set(11, calendar.getActualMaximum(11));
        calendar.set(12, calendar.getActualMaximum(12));
        calendar.set(13, calendar.getActualMaximum(13));
        calendar.set(14, calendar.getActualMaximum(14));
    }

    public static String format(Date date) {
        SimpleDateFormat sdf = new SimpleDateFormat(DEFAULT_PATTERN);
        return sdf.format(date);
    }
}

