/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.cache.PromptWordCacheNew;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.MuliLangTextProp;
import kd.bos.inte.api.EnabledLang;
import kd.bos.lang.Lang;
import kd.bos.servicehelper.inte.InteServiceHelper;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.util.WfComMultiLangUtil;

public class WfMultiLangUtils {
    public static final String GLANG = "GLang";

    private WfMultiLangUtils() {
    }

    public static String getGeneralLangSQL(String entityNumber, String masterTableAlias, String multiLangTableAlias, String fieldName, String fieldNameAlias, String propertyName) {
        StringBuilder sql = new StringBuilder();
        String masterTableSQL = masterTableAlias + "." + fieldName;
        String multiLangTableSQL = multiLangTableAlias + "." + fieldName;
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        DynamicProperty property = entityType.getProperty(propertyName);
        if (property instanceof MuliLangTextProp && !property.isDbIgnore()) {
            sql.append("case when ").append(multiLangTableSQL).append(" is null then ").append(masterTableSQL).append(" when ").append(multiLangTableSQL).append(" = ' ' THEN ").append(masterTableSQL).append(" else ").append(multiLangTableSQL).append(" end ").append(fieldNameAlias);
            return sql.toString();
        }
        return sql.append(multiLangTableSQL).append(" ").append(fieldNameAlias).toString();
    }

    public static String getUserDefaultLang(Long userId) {
        String lang = "";
        try {
            EnabledLang enabledLang = InteServiceHelper.getUserLang((Long)userId);
            lang = enabledLang.getNumber();
            if (WfUtils.isEmpty(lang)) {
                lang = InteServiceHelper.getDefaultLangNumber();
            }
            if (WfUtils.isEmpty(lang)) {
                lang = Lang.en_US.toString();
            }
        }
        catch (Exception e) {
            lang = InteServiceHelper.getDefaultLangNumber();
        }
        return lang;
    }

    public static ILocaleString jointILocaleString(ILocaleString str1, ILocaleString str2, String delimiter) {
        if (WfUtils.isEmpty(str1)) {
            return str2;
        }
        if (WfUtils.isEmpty(str2)) {
            return str1;
        }
        LocaleString newStr = new LocaleString();
        for (Lang lang : WfUtils.getSupportLangs()) {
            String lan = lang.toString();
            String arg1 = WfUtils.isEmpty((String)str1.get((Object)lan)) ? str1.toString() : (String)str1.get((Object)lan);
            String arg2 = WfUtils.isEmpty((String)str2.get((Object)lan)) ? str2.toString() : (String)str2.get((Object)lan);
            newStr.setItem(lan, (Object)String.format("%s%s%s", arg1, delimiter, arg2));
        }
        return newStr;
    }

    public static ILocaleString getFormatMergeValue(List<ILocaleString> formatLocalStringList) {
        LocaleString formatLocalString = new LocaleString();
        for (Lang lang : WfUtils.getSupportLangs()) {
            StringBuilder userNameFormatLang = new StringBuilder();
            for (ILocaleString format : formatLocalStringList) {
                if (WfUtils.isNotEmpty((String)format.get((Object)lang.toString()))) {
                    userNameFormatLang.append((String)format.get((Object)lang.toString())).append(',');
                    continue;
                }
                String defaultString = WfMultiLangUtils.getValueFromLocalString(format, lang.toString());
                defaultString = WfUtils.isNotEmpty(defaultString) ? defaultString + "," : "";
                userNameFormatLang.append(defaultString);
            }
            String userNameFormatLangStr = userNameFormatLang.toString();
            if (WfUtils.isNotEmpty(userNameFormatLangStr)) {
                userNameFormatLangStr = userNameFormatLang.substring(0, userNameFormatLang.length() - 1);
            }
            formatLocalString.setItem(lang.toString(), (Object)userNameFormatLangStr);
        }
        return formatLocalString;
    }

    public static ILocaleString replaceILocaleString(ILocaleString str1, ILocaleString ... str2) {
        LocaleString newStr = new LocaleString();
        if (WfUtils.isEmpty(str1)) {
            return newStr;
        }
        if (str2 == null || str2.length == 0) {
            return str1;
        }
        for (Map.Entry entry : str1.entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            if (!StringUtils.isNotBlank((CharSequence)value)) continue;
            ArrayList<Object> itemValues = new ArrayList<Object>(str1.size());
            for (int i = 0; i < str2.length; ++i) {
                if (WfUtils.isNotEmpty(str2[i]) && StringUtils.isNotBlank((CharSequence)((CharSequence)str2[i].getItem(key)))) {
                    itemValues.add(str2[i].getItem(key));
                    continue;
                }
                itemValues.add("");
            }
            newStr.setItem(key, (Object)String.format(value, itemValues.toArray()));
        }
        return newStr;
    }

    public static LocaleString changeILocaleStringToLocaleString(ILocaleString obj) {
        LocaleString ls = new LocaleString();
        if (WfUtils.isNotEmpty(obj)) {
            for (Map.Entry entry : obj.entrySet()) {
                ls.put((String)entry.getKey(), entry.getValue());
            }
        }
        return ls;
    }

    public static ILocaleString jointILocaleString(ILocaleString str1, ILocaleString str2, String delimiter, String startSign, String endSign) {
        if (WfUtils.isEmpty(str1)) {
            return str2;
        }
        if (WfUtils.isEmpty(str2)) {
            return str1;
        }
        if (WfUtils.isEmpty(startSign)) {
            startSign = "";
        }
        if (WfUtils.isEmpty(endSign)) {
            endSign = "";
        }
        LocaleString newStr = new LocaleString();
        for (Lang lang : WfUtils.getSupportLangs()) {
            String lan = lang.toString();
            String arg1 = WfUtils.isEmpty((String)str1.get((Object)lan)) ? str1.toString() : (String)str1.get((Object)lan);
            String arg2 = WfUtils.isEmpty((String)str2.get((Object)lan)) ? str2.toString() : (String)str2.get((Object)lan);
            newStr.setItem(lan, (Object)String.format("%s%s%s%s%s", startSign, arg1, delimiter, arg2, endSign));
        }
        return newStr;
    }

    public static ILocaleString subString(ILocaleString str, int start, int end) {
        if (str != null) {
            str.forEach((lang, value) -> {
                String cfr_ignored_0 = (String)str.put(lang, (Object)StringUtils.substring((String)value, (int)start, (int)end));
            });
        }
        return str;
    }

    public static ILocaleString jointCollectionLocaleString(Collection<ILocaleString> currentAssigenList, String delimiter) {
        LocaleString currentAssigen = new LocaleString();
        if (currentAssigenList == null || currentAssigenList.isEmpty()) {
            return currentAssigen;
        }
        for (ILocaleString t : currentAssigenList) {
            if (WfUtils.isEmpty((ILocaleString)currentAssigen)) {
                for (Lang lang : WfMultiLangUtils.getSupportLangs()) {
                    String lan = lang.toString();
                    currentAssigen.setItem(lan, t.get((Object)lan));
                }
                continue;
            }
            currentAssigen = WfMultiLangUtils.jointILocaleString((ILocaleString)currentAssigen, t, delimiter);
        }
        return currentAssigen;
    }

    @Deprecated
    public static ILocaleString getPromptWordLocaleString(String srcTran, String resId, String projectNum) {
        LocaleString result = new LocaleString();
        for (Lang lang : WfMultiLangUtils.getSupportLangs()) {
            result.put((Object)lang.name(), (Object)WfMultiLangUtils.getPromptWord(srcTran, resId, lang.name(), projectNum));
        }
        return result;
    }

    @Deprecated
    public static String getPromptWord(String srcTran, String resId, String language, String projectNum) {
        PromptWordCacheNew promptWordCacheNew = new PromptWordCacheNew();
        return promptWordCacheNew.getPromptWord(srcTran, resId, language, projectNum);
    }

    public static Lang[] getSupportLangs() {
        return WfComMultiLangUtil.getSupportLangs();
    }

    public static String getValueFromLocalString(ILocaleString value, String language) {
        if (WfUtils.isEmpty(value)) {
            return "";
        }
        String localeValue = (String)value.get((Object)language);
        if (WfUtils.isNotEmpty(localeValue)) {
            return localeValue;
        }
        String glValue = value.toString();
        if (WfUtils.isNotEmpty(glValue)) {
            return glValue;
        }
        String defaultLang = InteServiceHelper.getDefaultLangNumber();
        String defaultValue = (String)value.get((Object)defaultLang);
        if (WfUtils.isNotEmpty(defaultValue)) {
            return defaultValue;
        }
        return value.getLocaleValue_zh_CN();
    }

    public static ILocaleString getMultiLangValue(String value) {
        return new LocaleString(value);
    }

    public static ILocaleString getMultiLangValue(ILocaleString ... strs) {
        LocaleString result = new LocaleString();
        int length = strs.length;
        if (length < 1) {
            return result;
        }
        for (Lang lang : WfMultiLangUtils.getSupportLangs()) {
            String key = lang.name();
            Object[] args = new Object[length - 1];
            for (int i = 1; i < length; ++i) {
                args[i - 1] = WfMultiLangUtils.getValueFromLocalString(strs[i], key);
            }
            result.put((Object)key, (Object)String.format(WfMultiLangUtils.getValueFromLocalString(strs[0], key), args));
        }
        return result;
    }

    public static ILocaleString getMultiLangValue(Map<String, Object> map) {
        LocaleString result = new LocaleString();
        if (WfUtils.isEmptyForMap(map)) {
            return result;
        }
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            result.put((Object)entry.getKey(), (Object)String.valueOf(entry.getValue()));
        }
        return result;
    }

    public static ILocaleString getMultiLangValueCaption(ILocaleString bizApplier, ILocaleString entityName) {
        LocaleString result = new LocaleString();
        for (Lang lang : WfMultiLangUtils.getSupportLangs()) {
            String key = lang.name();
            String name = WfMultiLangUtils.getValueFromLocalString(entityName, key);
            String applier = WfMultiLangUtils.getValueFromLocalString(bizApplier, key);
            if (WfUtils.isNotEmpty(applier)) {
                result.put((Object)key, (Object)String.format(ResManager.loadKDString((String)"%1$s\u7684%2$s", (String)"WfMultiLangUtils_1", (String)"bos-wf-engine", (Object[])new Object[0]), applier, name));
                continue;
            }
            result.put((Object)key, (Object)name);
        }
        return result;
    }

    public static ILocaleString getMessageContentMultiLangValue(ILocaleString content, ILocaleString tips, String url) {
        LocaleString result = new LocaleString();
        for (Lang lang : WfMultiLangUtils.getSupportLangs()) {
            String key = lang.name();
            result.put((Object)key, (Object)((String)content.get((Object)key) + (String)tips.get((Object)key) + url));
        }
        return result;
    }

    public static LocaleString getLocaleString(String description, String resourceID, String systemType, Object ... args) {
        Lang[] enableLangList;
        LocaleString localeString = new LocaleString();
        for (Lang lang : enableLangList = WfMultiLangUtils.getSupportLangs()) {
            localeString.setItem(lang.toString(), (Object)PromptWordCacheNew.getPromptWord((String)description, (String)resourceID, (Lang)lang, (String)systemType, (Object[])args));
        }
        return localeString;
    }

    public static String getCurrentLang(ILocaleString description, String lang) {
        String desc = "";
        if (WfUtils.isNotEmpty(lang) && WfUtils.isEmpty(desc = (String)description.get((Object)lang))) {
            desc = (String)description.get((Object)GLANG);
        }
        if (WfUtils.isEmpty(desc)) {
            desc = description.toString();
        }
        return desc;
    }

    public static void mergeCurLan2Entity(DynamicObject obj, String key, String val) {
        ILocaleString localeString = obj.getLocaleString(key);
        if (WfUtils.isNullObject(localeString)) {
            localeString = new LocaleString();
        }
        if (Objects.equals(localeString.getLocaleValue(), localeString.getItem(GLANG))) {
            localeString.setItem(GLANG, (Object)val);
        }
        localeString.setLocaleValue(val);
        obj.set(key, (Object)localeString);
    }
}

