/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.workflow.engine.EntityNumberConstant;
import kd.bos.workflow.engine.TaskService;
import kd.bos.workflow.engine.WfAdminUtil;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricIdentityLinkEntity;
import kd.bos.workflow.service.WorkflowService;
import kd.bos.workflow.service.impl.ServiceFactory;
import org.apache.commons.collections.CollectionUtils;

public class WfPermUtils {
    private static Log logger = LogFactory.getLog(WfPermUtils.class);
    private static final String EVENT = "2UUANFAEM+C1";
    private static final String ADDSIGN = "2UUAHJMC6=0A";
    private static final String PROCESSRELATIONPERSON = "49I1LZY4HGA2";
    public static final String APIV1 = "api_v1";
    public static final String APIV2 = "api_v2";
    public static final String ALWAYS = "always";
    private static final String FORMATSTRING_TWO = "%s,%s";
    private static final String TASTID_USERID = String.format("%s,%s", "taskid", "userid");
    private static final String PERMID_COMPLETECALLACTIVITY = "4A6/FWC0ODBY";
    private static final String PERMID_ABANDONPROCESS = "4A6/U06R/2FL";
    private static final String PERMID_TRYTRIGGERPROCESS = "4A6+Z9K1=2F0";
    private static final String PERMID_GETNEXTNODEWHENREJECTTOPARENT = "4A6/NU=Y5V2/";

    private WfPermUtils() {
    }

    @Deprecated
    public static boolean isOperateByAdmin() {
        return true;
    }

    public static boolean hasTaskHandlerPerm(String apiVersion) {
        if (!WfPermUtils.isNeedCheckApiPer(apiVersion)) {
            return true;
        }
        return WfAdminUtil.isWfAdmin(RequestContext.get().getCurrUserId()) || PermissionServiceHelper.checkPermission((Long)RequestContext.get().getCurrUserId(), (String)"a479ec06000000ac", (String)"wf_participant", (String)"018JWO8RKN3U");
    }

    public static boolean hasToHandlerTaskQueryPerm(String apiVersion) {
        if (!WfPermUtils.isNeedCheckApiPer(apiVersion)) {
            return true;
        }
        return WfAdminUtil.isWfAdmin(RequestContext.get().getCurrUserId()) || PermissionServiceHelper.checkPermission((Long)RequestContext.get().getCurrUserId(), (String)"a479ec06000000ac", (String)"wf_participant", (String)"47150e89000000ac");
    }

    public static boolean hasMessageHandlerPerm(String apiVersion) {
        if (!WfPermUtils.isNeedCheckApiPer(apiVersion)) {
            return true;
        }
        return WfAdminUtil.isWfAdmin(RequestContext.get().getCurrUserId()) || PermissionServiceHelper.checkPermission((Long)RequestContext.get().getCurrUserId(), (String)"a479ec06000000ac", (String)"wf_msg_receiver", (String)"018JWO8RKN3U");
    }

    public static boolean hasMessageQueryPerm(String apiVersion) {
        if (!WfPermUtils.isNeedCheckApiPer(apiVersion)) {
            return true;
        }
        return WfAdminUtil.isWfAdmin(RequestContext.get().getCurrUserId()) || PermissionServiceHelper.checkPermission((Long)RequestContext.get().getCurrUserId(), (String)"a479ec06000000ac", (String)"wf_msg_receiver", (String)"47150e89000000ac");
    }

    public static boolean hasHandlerTaskQueryPerm(String apiVersion) {
        if (!WfPermUtils.isNeedCheckApiPer(apiVersion)) {
            return true;
        }
        return WfAdminUtil.isWfAdmin(RequestContext.get().getCurrUserId()) || PermissionServiceHelper.checkPermission((Long)RequestContext.get().getCurrUserId(), (String)"a479ec06000000ac", (String)"wf_hicomment", (String)"47150e89000000ac");
    }

    public static boolean hasToHandlerProcessQueryPerm(String apiVersion) {
        if (!WfPermUtils.isNeedCheckApiPer(apiVersion)) {
            return true;
        }
        return WfAdminUtil.isWfAdmin(RequestContext.get().getCurrUserId()) || PermissionServiceHelper.checkPermission((Long)RequestContext.get().getCurrUserId(), (String)"a479ec06000000ac", (String)"wf_execution", (String)"47150e89000000ac");
    }

    public static boolean hasHandlerProcessQueryPerm(String apiVersion) {
        if (!WfPermUtils.isNeedCheckApiPer(apiVersion)) {
            return true;
        }
        return WfAdminUtil.isWfAdmin(RequestContext.get().getCurrUserId()) || PermissionServiceHelper.checkPermission((Long)RequestContext.get().getCurrUserId(), (String)"a479ec06000000ac", (String)"wf_hiprocinst", (String)"47150e89000000ac");
    }

    public static boolean hasProcessQueryPerm(String apiVersion) {
        if (!WfPermUtils.isNeedCheckApiPer(apiVersion)) {
            return true;
        }
        return WfAdminUtil.isWfAdmin(RequestContext.get().getCurrUserId()) || PermissionServiceHelper.checkPermission((Long)RequestContext.get().getCurrUserId(), (String)"a479ec06000000ac", (String)"wf_processdefinition", (String)"47150e89000000ac");
    }

    public static boolean hasExecutionQueryPerm(String apiVersion) {
        if (!WfPermUtils.isNeedCheckApiPer(apiVersion)) {
            return true;
        }
        return WfAdminUtil.isWfAdmin(RequestContext.get().getCurrUserId()) || PermissionServiceHelper.checkPermission((Long)RequestContext.get().getCurrUserId(), (String)"a479ec06000000ac", (String)"wf_execution", (String)"47150e89000000ac");
    }

    public static boolean hasProcessAbandonPerm(String apiVersion) {
        if (!WfPermUtils.isNeedCheckApiPer(apiVersion)) {
            return true;
        }
        return WfAdminUtil.isWfAdmin(RequestContext.get().getCurrUserId()) || PermissionServiceHelper.checkPermission((Long)RequestContext.get().getCurrUserId(), (String)"a479ec06000000ac", (String)"wf_execution", (String)"/8M3RG6213GO");
    }

    public static boolean hasProcessJumpPerm(String apiVersion) {
        if (!WfPermUtils.isNeedCheckApiPer(apiVersion)) {
            return true;
        }
        return WfAdminUtil.isWfAdmin(RequestContext.get().getCurrUserId()) || PermissionServiceHelper.checkPermission((Long)RequestContext.get().getCurrUserId(), (String)"a479ec06000000ac", (String)"wf_execution", (String)"/8M3P61RNHXZ");
    }

    public static boolean hasProcessAddSignPerm(String apiVersion) {
        if (!WfPermUtils.isNeedCheckApiPer(apiVersion)) {
            return true;
        }
        return WfAdminUtil.isWfAdmin(RequestContext.get().getCurrUserId()) || PermissionServiceHelper.checkPermission((Long)RequestContext.get().getCurrUserId(), (String)"a479ec06000000ac", (String)"wf_execution", (String)ADDSIGN);
    }

    public static boolean hasProcessSuspendPerm(String apiVersion) {
        if (!WfPermUtils.isNeedCheckApiPer(apiVersion)) {
            return true;
        }
        return WfAdminUtil.isWfAdmin(RequestContext.get().getCurrUserId()) || PermissionServiceHelper.checkPermission((Long)RequestContext.get().getCurrUserId(), (String)"a479ec06000000ac", (String)"wf_execution", (String)"0YS1GTBP53D6");
    }

    public static boolean hasProcessRevokeSuspendPerm(String apiVersion) {
        if (!WfPermUtils.isNeedCheckApiPer(apiVersion)) {
            return true;
        }
        return WfAdminUtil.isWfAdmin(RequestContext.get().getCurrUserId()) || PermissionServiceHelper.checkPermission((Long)RequestContext.get().getCurrUserId(), (String)"a479ec06000000ac", (String)"wf_execution", (String)"/8M3MNJNJZE5");
    }

    public static boolean hasProcessEnablePerm(String apiVersion) {
        if (!WfPermUtils.isNeedCheckApiPer(apiVersion)) {
            return true;
        }
        return WfAdminUtil.isWfAdmin(RequestContext.get().getCurrUserId()) || PermissionServiceHelper.checkPermission((Long)RequestContext.get().getCurrUserId(), (String)"a479ec06000000ac", (String)"wf_processdefinition", (String)"4730fc5d000000ac");
    }

    public static boolean hasProcessDisablePerm(String apiVersion) {
        if (!WfPermUtils.isNeedCheckApiPer(apiVersion)) {
            return true;
        }
        return WfAdminUtil.isWfAdmin(RequestContext.get().getCurrUserId()) || PermissionServiceHelper.checkPermission((Long)RequestContext.get().getCurrUserId(), (String)"a479ec06000000ac", (String)"wf_processdefinition", (String)"47160c2b000000ac");
    }

    public static boolean hasUpdateFlowRolesPerm(String apiVersion) {
        if (!WfPermUtils.isNeedCheckApiPer(apiVersion)) {
            return true;
        }
        return WfAdminUtil.isWfAdmin(RequestContext.get().getCurrUserId()) || PermissionServiceHelper.checkPermission((Long)RequestContext.get().getCurrUserId(), (String)"a479ec06000000ac", (String)"wf_role", (String)"4715a0df000000ac");
    }

    public static boolean hasTrigEventPerm(String apiVersion) {
        if (!WfPermUtils.isNeedCheckApiPer(apiVersion)) {
            return true;
        }
        return WfAdminUtil.isWfAdmin(RequestContext.get().getCurrUserId()) || PermissionServiceHelper.checkPermission((Long)RequestContext.get().getCurrUserId(), (String)"a479ec06000000ac", (String)"evt_job", (String)EVENT);
    }

    public static boolean hasUserPermOrg(Long userId, String entityNumber, String permItemId) {
        if (!WfConfigurationUtil.disableCheckApiOrgPer()) {
            HasPermOrgResult hasPermOrgResult = PermissionServiceHelper.getAllPermOrgs((long)RequestContext.get().getCurrUserId(), (String)"01", (String)"a479ec06000000ac", (String)entityNumber, (String)permItemId);
            if (hasPermOrgResult == null) {
                return false;
            }
            if (hasPermOrgResult.hasAllOrgPerm()) {
                return true;
            }
            List permOrgs = hasPermOrgResult.getHasPermOrgs();
            if (WfUtils.isEmptyForCollection(permOrgs)) {
                return false;
            }
            for (Long org : permOrgs) {
                if (!UserServiceHelper.isUserBelongTo((Long)userId, (Long)org)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    public static boolean hasHandlerProcessQueryPerm(String apiVersion, Long userId) {
        if (!WfPermUtils.isNeedCheckApiPer(apiVersion)) {
            return true;
        }
        return WfAdminUtil.isWfAdmin(RequestContext.get().getCurrUserId()) || PermissionServiceHelper.checkPermission((Long)RequestContext.get().getCurrUserId(), (String)"a479ec06000000ac", (String)"wf_hiprocinst", (String)"47150e89000000ac") && WfPermUtils.hasUserPermOrg(userId, "wf_hiprocinst", "47150e89000000ac");
    }

    public static boolean hasToHandlerTaskQueryPerm(String apiVersion, Long userId) {
        if (!WfPermUtils.isNeedCheckApiPer(apiVersion)) {
            return true;
        }
        return WfAdminUtil.isWfAdmin(RequestContext.get().getCurrUserId()) || PermissionServiceHelper.checkPermission((Long)RequestContext.get().getCurrUserId(), (String)"a479ec06000000ac", (String)"wf_participant", (String)"47150e89000000ac") && WfPermUtils.hasUserPermOrg(userId, "wf_participant", "47150e89000000ac");
    }

    public static boolean hasMessageQueryPerm(String apiVersion, Long userId) {
        if (!WfPermUtils.isNeedCheckApiPer(apiVersion)) {
            return true;
        }
        return WfAdminUtil.isWfAdmin(RequestContext.get().getCurrUserId()) || PermissionServiceHelper.checkPermission((Long)RequestContext.get().getCurrUserId(), (String)"a479ec06000000ac", (String)"wf_msg_receiver", (String)"47150e89000000ac") && WfPermUtils.hasUserPermOrg(userId, "wf_msg_receiver", "47150e89000000ac");
    }

    public static boolean hasHandlerTaskQueryPerm(String apiVersion, Long userId) {
        if (!WfPermUtils.isNeedCheckApiPer(apiVersion)) {
            return true;
        }
        return WfAdminUtil.isWfAdmin(RequestContext.get().getCurrUserId()) || PermissionServiceHelper.checkPermission((Long)RequestContext.get().getCurrUserId(), (String)"a479ec06000000ac", (String)"wf_hicomment", (String)"47150e89000000ac") && WfPermUtils.hasUserPermOrg(userId, "wf_hicomment", "47150e89000000ac");
    }

    public static boolean hasProcessQueryPerm(String apiVersion, Long userId) {
        if (!WfPermUtils.isNeedCheckApiPer(apiVersion)) {
            return true;
        }
        return WfAdminUtil.isWfAdmin(RequestContext.get().getCurrUserId()) || PermissionServiceHelper.checkPermission((Long)RequestContext.get().getCurrUserId(), (String)"a479ec06000000ac", (String)"wf_processdefinition", (String)"47150e89000000ac") && WfPermUtils.hasUserPermOrg(userId, "wf_processdefinition", "47150e89000000ac");
    }

    public static boolean hasToHandlerProcessQueryPerm(String apiVersion, Long userId) {
        if (!WfPermUtils.isNeedCheckApiPer(apiVersion)) {
            return true;
        }
        return WfAdminUtil.isWfAdmin(RequestContext.get().getCurrUserId()) || PermissionServiceHelper.checkPermission((Long)RequestContext.get().getCurrUserId(), (String)"a479ec06000000ac", (String)"wf_execution", (String)"47150e89000000ac") && WfPermUtils.hasUserPermOrg(userId, "wf_execution", "47150e89000000ac");
    }

    public static boolean hasExecutionQueryPerm(String apiVersion, Long userId) {
        if (!WfPermUtils.isNeedCheckApiPer(apiVersion)) {
            return true;
        }
        return WfAdminUtil.isWfAdmin(RequestContext.get().getCurrUserId()) || PermissionServiceHelper.checkPermission((Long)RequestContext.get().getCurrUserId(), (String)"a479ec06000000ac", (String)"wf_execution", (String)"47150e89000000ac") && WfPermUtils.hasUserPermOrg(userId, "wf_execution", "47150e89000000ac");
    }

    public static boolean isTaskHiparticipant(Long taskId, Long userId) {
        QFilter q1 = new QFilter("taskid", "=", (Object)taskId);
        QFilter q2 = new QFilter("userid", "=", (Object)userId);
        return QueryServiceHelper.exists((String)"wf_hiparticipant", (QFilter[])new QFilter[]{q1, q2});
    }

    public static boolean isTaskParticipantByType(Long taskId, Long userId, String type) {
        QFilter q1 = new QFilter("taskid", "=", (Object)taskId);
        QFilter q2 = new QFilter("userid", "=", (Object)userId);
        QFilter q3 = new QFilter("type", "=", (Object)type);
        return QueryServiceHelper.exists((String)"wf_participant", (QFilter[])new QFilter[]{q1, q2, q3});
    }

    public static boolean isTaskParticipant(Long taskId, Long userId) {
        QFilter q1 = new QFilter("taskid", "=", (Object)taskId);
        QFilter q2 = new QFilter("userid", "=", (Object)userId);
        return QueryServiceHelper.exists((String)"wf_participant", (QFilter[])new QFilter[]{q1, q2});
    }

    public static boolean isTaskParticipant(List<Long> taskIds, Long userId) {
        QFilter q1 = new QFilter("taskid", "in", taskIds);
        QFilter q2 = new QFilter("userid", "=", (Object)userId);
        DynamicObjectCollection col = QueryServiceHelper.query((String)"wf_participant", (String)TASTID_USERID, (QFilter[])new QFilter[]{q1, q2});
        return col != null && !col.isEmpty() && taskIds.size() == col.size();
    }

    public static boolean isTaskParticipantByType(List<Long> taskIds, Long userId, String type) {
        QFilter q1 = new QFilter("taskid", "in", taskIds);
        QFilter q2 = new QFilter("userid", "=", (Object)userId);
        QFilter q3 = new QFilter("type", "=", (Object)type);
        DynamicObjectCollection col = QueryServiceHelper.query((String)"wf_participant", (String)TASTID_USERID, (QFilter[])new QFilter[]{q1, q2, q3});
        return col != null && !col.isEmpty() && taskIds.size() == col.size();
    }

    public static boolean isTaskHiparticipant(List<Long> taskIds, Long userId) {
        QFilter q1 = new QFilter("taskId", "in", taskIds);
        QFilter q2 = new QFilter("userId", "=", (Object)userId);
        DynamicObjectCollection col = QueryServiceHelper.query((String)"wf_hiparticipant", (String)TASTID_USERID, (QFilter[])new QFilter[]{q1, q2});
        return col != null && !col.isEmpty() && taskIds.size() == col.size();
    }

    public static boolean isTaskRelationship(List<Long> taskIds, Long userId) {
        Map<Long, Set<Long>> allUserId = WfPermUtils.collectAllPerson(taskIds);
        for (Long task : taskIds) {
            if (!CollectionUtils.isEmpty((Collection)allUserId.get(task)) && allUserId.get(task).contains(userId)) continue;
            return false;
        }
        return true;
    }

    private static Map<Long, Set<Long>> collectAllPerson(List<Long> taskIds) {
        HashMap<Long, Set<Long>> ret = new HashMap<Long, Set<Long>>();
        QFilter q1 = new QFilter("id", "in", taskIds);
        DynamicObjectCollection col = QueryServiceHelper.query((String)EntityNumberConstant.getHiTaskInstEntityNumber(), (String)"id,starterid", (QFilter[])new QFilter[]{q1});
        WfPermUtils.singleCollectionUserIds(ret, col, "id", new String[]{"starterid"});
        q1 = new QFilter("id", "in", taskIds);
        col = QueryServiceHelper.query((String)EntityNumberConstant.getHiTaskInstEntityNumber(), (String)"id,assigneeid", (QFilter[])new QFilter[]{q1});
        WfPermUtils.singleCollectionUserIds(ret, col, "id", new String[]{"assigneeid"});
        q1 = new QFilter("taskId", "in", taskIds);
        col = QueryServiceHelper.query((String)EntityNumberConstant.getHiIdentityLinkEntityNumber(), (String)TASTID_USERID, (QFilter[])new QFilter[]{q1});
        WfPermUtils.singleCollectionUserIds(ret, col, "taskId", new String[]{"userid"});
        q1 = new QFilter("taskId", "in", taskIds);
        col = QueryServiceHelper.query((String)"wf_taskhandlelog", (String)"taskid,ownerid,assigneeid", (QFilter[])new QFilter[]{q1});
        WfPermUtils.singleCollectionUserIds(ret, col, "taskId", new String[]{"ownerid", "assigneeid"});
        return ret;
    }

    private static void singleCollectionUserIds(Map<Long, Set<Long>> ret, DynamicObjectCollection col, String key, String[] userFields) {
        if (col != null && !col.isEmpty()) {
            for (DynamicObject op : col) {
                Long taskid = op.getLong(key);
                Set<Long> t = ret.get(taskid);
                if (t == null) {
                    t = new HashSet<Long>();
                }
                for (String p : userFields) {
                    Long tmp = op.getLong(p);
                    if (!WfUtils.isNotEmpty(tmp)) continue;
                    t.add(tmp);
                }
                ret.put(taskid, t);
            }
        }
    }

    public static boolean isTaskStarter(Long processInsId, Long userId) {
        QFilter q1 = new QFilter("id", "=", (Object)processInsId);
        QFilter q2 = new QFilter("startuserid", "=", (Object)userId);
        return QueryServiceHelper.exists((String)"wf_hiprocinst", (QFilter[])new QFilter[]{q1, q2});
    }

    public static boolean isTaskCoordinate(Long taskId, Long userId) {
        QFilter q1 = new QFilter("type", "=", (Object)"coordinate");
        QFilter q2 = new QFilter("taskId", "=", (Object)taskId);
        QFilter q3 = new QFilter("assigneeid", "=", (Object)userId);
        return QueryServiceHelper.exists((String)"wf_taskhandlelog", (QFilter[])new QFilter[]{q2, q1, q3});
    }

    public static boolean isTaskTransfer(Long taskId, Long userId) {
        QFilter q1 = new QFilter("type", "=", (Object)"transfer");
        QFilter q2 = new QFilter("taskId", "=", (Object)taskId);
        QFilter q4 = new QFilter("ownerid", "=", (Object)userId);
        return QueryServiceHelper.exists((String)"wf_taskhandlelog", (QFilter[])new QFilter[]{q2, q1, q4});
    }

    public static boolean isTaskAssignee(Long taskId, Long userId) {
        QFilter q1 = new QFilter("userId", "=", (Object)userId);
        QFilter q2 = new QFilter("taskId", "=", (Object)taskId);
        QFilter q4 = new QFilter("endtime", "is not null", null);
        return QueryServiceHelper.exists((String)"wf_hiparticipant", (QFilter[])new QFilter[]{q2, q1, q4});
    }

    public static boolean isNeedCheckApiPer(String apiVersion) {
        if (APIV1.equalsIgnoreCase(apiVersion)) {
            return !WfConfigurationUtil.disableCheckV1Api();
        }
        if (APIV2.equalsIgnoreCase(apiVersion)) {
            return !WfConfigurationUtil.disableCheckV2Api();
        }
        return true;
    }

    public static boolean isRelatedPerson(String businessKey, Long userId) {
        ArrayList<Long> procInstIds = new ArrayList<Long>(10);
        HashSet<Long> relatedPersons = new HashSet<Long>(16);
        QFilter instFilter = new QFilter("businessKey", "=", (Object)businessKey);
        DynamicObjectCollection instCols = QueryServiceHelper.query((String)"wf_hiprocinst", (String)String.format(FORMATSTRING_TWO, "processInstanceId", "startUserId"), (QFilter[])new QFilter[]{instFilter});
        if (WfUtils.isNotEmptyForCollection((Collection)instCols)) {
            for (DynamicObject dynamicObject : instCols) {
                Long startUserId;
                Long procInstId = dynamicObject.getLong("processInstanceId");
                if (WfUtils.isNotEmpty(procInstId)) {
                    procInstIds.add(procInstId);
                }
                if (!WfUtils.isNotEmpty(startUserId = Long.valueOf(dynamicObject.getLong("startUserId")))) continue;
                relatedPersons.add(startUserId);
            }
        }
        if (WfUtils.isNotEmptyForCollection(procInstIds)) {
            relatedPersons.addAll(WfPermUtils.getTaskRelatedPersons(procInstIds));
        }
        if (relatedPersons.isEmpty()) {
            return false;
        }
        return relatedPersons.contains(userId);
    }

    private static Set<Long> getTaskRelatedPersons(List<Long> procInstIds) {
        HashSet<Long> relatedPersons = new HashSet<Long>(16);
        QFilter filter = new QFilter("processInstanceId", "in", procInstIds);
        DynamicObjectCollection participantCols = new DynamicObjectCollection();
        WorkflowService wfService = (WorkflowService)ServiceFactory.getService(WorkflowService.class);
        TaskService taskService = wfService.getTaskService();
        List<HistoricIdentityLinkEntity> participants = taskService.findParticipantsByProcInstIds(procInstIds, "userId");
        if (WfUtils.isNotEmptyForCollection(participants)) {
            for (HistoricIdentityLinkEntity entity : participants) {
                participantCols.add((Object)entity.getDynamicObject());
            }
        }
        WfPermUtils.singleCollectionUserIds(relatedPersons, participantCols, "userId");
        DynamicObjectCollection handleLogCols = QueryServiceHelper.query((String)"wf_taskhandlelog", (String)String.format(FORMATSTRING_TWO, "ownerId", "assigneeid"), (QFilter[])new QFilter[]{filter});
        WfPermUtils.singleCollectionUserIds(relatedPersons, handleLogCols, "ownerId", "assigneeid");
        return relatedPersons;
    }

    public static boolean checkUserIsReceiver(List<Long> messageIds, Long userId) {
        boolean result = Boolean.FALSE;
        StringBuilder sql = new StringBuilder();
        sql.append("select count(1) count from t_wf_msgreceiver a");
        sql.append(" where a.fmessageid in (?) ");
        sql.append(" and a.freceiverid = ").append(userId);
        int count = 0;
        String newSql = sql.toString().replaceAll("\\?", WfUtils.getQuestionMarkList(messageIds.size()));
        try (DataSet dataSet = DB.queryDataSet((String)"checkUserIsReceiver", (DBRoute)DBRoute.workflow, (String)newSql, (Object[])messageIds.toArray());){
            Iterator iterator;
            if (!dataSet.isEmpty() && (iterator = dataSet.iterator()).hasNext()) {
                count = ((Row)iterator.next()).getInteger("count");
            }
            if (count == messageIds.size()) {
                result = Boolean.TRUE;
            }
        }
        return result;
    }

    private static void singleCollectionUserIds(Set<Long> ret, DynamicObjectCollection col, String ... userFields) {
        if (col != null && !col.isEmpty()) {
            for (DynamicObject op : col) {
                for (String p : userFields) {
                    Long tmp = op.getLong(p);
                    if (!WfUtils.isNotEmpty(tmp)) continue;
                    ret.add(tmp);
                }
            }
        }
    }

    public static boolean isProcessStartUser(Long procInstId, Long userId) {
        QFilter q1 = new QFilter("id", "=", (Object)procInstId);
        QFilter q2 = new QFilter("creatorid", "=", (Object)userId);
        return QueryServiceHelper.exists((String)EntityNumberConstant.getHiProcInstEntityNumber(), (QFilter[])new QFilter[]{q1, q2});
    }

    public static boolean isMyDelegateUser(Long delegateId, Long userId) {
        QFilter filter1 = new QFilter("id", "=", (Object)delegateId);
        QFilter filter2 = new QFilter("assignorid", "=", (Object)userId);
        return QueryServiceHelper.exists((String)"wf_delegatesetting", (QFilter[])new QFilter[]{filter1, filter2});
    }

    public static boolean isTaskCoordinates(List<Long> taskIds, Long userId) {
        QFilter q1 = new QFilter("type", "=", (Object)"coordinate");
        QFilter q2 = new QFilter("taskId", "in", taskIds);
        QFilter q3 = new QFilter("assigneeid", "=", (Object)userId);
        return QueryServiceHelper.exists((String)"wf_taskhandlelog", (QFilter[])new QFilter[]{q2, q1, q3});
    }

    public static List<Map<String, Object>> isCanClickButtonForSpecialScene(List<Long> taskIds) {
        String selectedFields = "batchop,control,processtype";
        QFilter qFilter = new QFilter("id", "in", taskIds);
        ArrayList<Map<String, Object>> dataList = new ArrayList<Map<String, Object>>(16);
        DynamicObjectCollection dynamicObjectCollection = QueryServiceHelper.query((String)"wf_task", (String)selectedFields, (QFilter[])new QFilter[]{qFilter});
        if (dynamicObjectCollection != null && dynamicObjectCollection.size() > 0) {
            HashMap<String, Object> data = new HashMap<String, Object>(8);
            for (DynamicObject dyObj : dynamicObjectCollection) {
                data.put("batchop", dyObj.get("batchop"));
                data.put("control", dyObj.get("control"));
                data.put("processtype", dyObj.get("processtype"));
                dataList.add(data);
            }
        }
        return dataList;
    }

    public static boolean canUpdateDelegateSetting(String apiVersion) {
        if (!WfPermUtils.isNeedCheckApiPer(apiVersion)) {
            return true;
        }
        return WfAdminUtil.isWfAdmin(RequestContext.get().getCurrUserId()) || PermissionServiceHelper.checkPermission((Long)RequestContext.get().getCurrUserId(), (String)"a479ec06000000ac", (String)"wf_delegatesetting", (String)"4715a0df000000ac") || PermissionServiceHelper.checkPermission((Long)RequestContext.get().getCurrUserId(), (String)"a479ec06000000ac", (String)"wf_delegatesetting", (String)"4730fc5d000000ac");
    }

    public static boolean canDeleteDelegateSetting(String apiVersion) {
        if (!WfPermUtils.isNeedCheckApiPer(apiVersion)) {
            return true;
        }
        return WfAdminUtil.isWfAdmin(RequestContext.get().getCurrUserId()) || PermissionServiceHelper.checkPermission((Long)RequestContext.get().getCurrUserId(), (String)"a479ec06000000ac", (String)"wf_delegatesetting", (String)"4715e1f1000000ac");
    }

    public static boolean hasProcessRelationPersonPerm(String apiVersion) {
        if (!WfPermUtils.isNeedCheckApiPer(apiVersion)) {
            return true;
        }
        return WfAdminUtil.isWfAdmin(RequestContext.get().getCurrUserId()) || PermissionServiceHelper.checkPermission((Long)RequestContext.get().getCurrUserId(), (String)"a479ec06000000ac", (String)"wf_execution", (String)PROCESSRELATIONPERSON);
    }

    public static boolean hasProcessTryTriggerProcessPerm(String apiVersion) {
        if (!WfPermUtils.isNeedCheckApiPer(apiVersion)) {
            return true;
        }
        return WfAdminUtil.isWfAdmin(RequestContext.get().getCurrUserId()) || PermissionServiceHelper.checkPermission((Long)RequestContext.get().getCurrUserId(), (String)"a479ec06000000ac", (String)"wf_execution", (String)PERMID_TRYTRIGGERPROCESS);
    }

    public static boolean hasCompleteCallActivityPerm(String apiVersion) {
        if (!WfPermUtils.isNeedCheckApiPer(apiVersion)) {
            return true;
        }
        return WfAdminUtil.isWfAdmin(RequestContext.get().getCurrUserId()) || PermissionServiceHelper.checkPermission((Long)RequestContext.get().getCurrUserId(), (String)"a479ec06000000ac", (String)"wf_execution", (String)PERMID_COMPLETECALLACTIVITY);
    }
}

