/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.calculator.RoleDimension;

public class WfRoleDimensionUtil {
    private static Log logger = LogFactory.getLog(WfRoleDimensionUtil.class);
    private static final String WFDIMENSIONSLIST = "dimensions";
    private static final String APPROVALPOSITION = "approvalposition";
    private static final String USER = "user";

    private WfRoleDimensionUtil() {
    }

    public static DynamicObject getObjectType(String entityNumber) {
        try {
            return new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)entityNumber));
        }
        catch (KDException e) {
            return null;
        }
    }

    public static List<DynamicObject> getUserFromRoleEntryCoreFieldByRoleType(DynamicObject roleEntry, String roleType) {
        ArrayList<DynamicObject> userObjs = new ArrayList<DynamicObject>();
        if (APPROVALPOSITION.equalsIgnoreCase(roleType)) {
            HashSet<Long> positionIds = new HashSet<Long>(1);
            DynamicObject position = roleEntry.getDynamicObject(APPROVALPOSITION);
            if (position == null) {
                return userObjs;
            }
            positionIds.add(position.getLong("id"));
            Map peoplesUnderPosition = UserServiceHelper.getPeopleUnderPosition(positionIds);
            if (WfUtils.isNotEmptyForMap(peoplesUnderPosition)) {
                peoplesUnderPosition.values().stream().filter(Objects::nonNull).forEach(userObjs::addAll);
            }
        } else if (USER.equalsIgnoreCase(roleType)) {
            DynamicObject user = roleEntry.getDynamicObject(USER);
            if (user != null) {
                userObjs.add(user);
            }
        } else {
            logger.debug("add a new roleType? or roleType is null? " + roleType);
        }
        return userObjs;
    }

    public static DynamicObject getRoleEntryRoleEntryCoreObjByRoleType(DynamicObject roleEntry, String roleType) {
        if (APPROVALPOSITION.equals(roleType)) {
            return roleEntry.getDynamicObject(APPROVALPOSITION);
        }
        return roleEntry.getDynamicObject(USER);
    }

    public static Map<String, Object> getDimensionInfos(String SerializationDatas) {
        Map<String, Object> dimensionInfos = new HashMap<String, Object>(1);
        if (WfUtils.isEmpty(SerializationDatas)) {
            return dimensionInfos;
        }
        try {
            if (SerializationDatas.contains(WFDIMENSIONSLIST)) {
                dimensionInfos = (Map)SerializationUtils.fromJsonString((String)SerializationDatas, Map.class);
                dimensionInfos.put(WFDIMENSIONSLIST, SerializationUtils.fromJsonStringToList((String)((String)dimensionInfos.get(WFDIMENSIONSLIST)), RoleDimension.class));
            } else {
                List list = SerializationUtils.fromJsonStringToList((String)SerializationDatas, RoleDimension.class);
                dimensionInfos.put(WFDIMENSIONSLIST, list);
            }
        }
        catch (Exception e) {
            logger.info("WF_ROLE toJson is fail, the reason is :" + WfUtils.getExceptionStacktrace(e));
        }
        return dimensionInfos;
    }
}

