/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine;

import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.workflow.api.SuspendInfo;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.WfConstanst;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.extitf.ExtItfCallerType;
import kd.bos.workflow.engine.extitf.ExternalInterfaceUtil;
import kd.bos.workflow.engine.impl.cmd.system.SendMessageToAdminsCmd;
import kd.bos.workflow.engine.impl.cmd.system.SendMessageToStartUser;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.job.JobEntity;
import kd.bos.workflow.exception.WFEngineException;

public class WfSuspendUtil {
    private WfSuspendUtil() {
    }

    public static void invokeSuspendOrActiveProcess(SuspendInfo suspendInfo, ExtItfCallerType type) {
        String className = WfSuspendUtil.getSuspendConfigInfo(type);
        if (WfUtils.isNotEmpty(className)) {
            WfSuspendUtil.invokeExtItfMethod(suspendInfo, type, className);
        }
    }

    public static String getSuspendConfigInfo(ExtItfCallerType type) {
        Map<String, String> suspendConfigInfo = WfConfigurationUtil.getSuspendConfigInfo();
        return suspendConfigInfo.get(type.name());
    }

    public static void invokeExtItfMethod(SuspendInfo suspendInfo, ExtItfCallerType type, String className) {
        HashMap<String, String> map = new HashMap<String, String>(2);
        map.put("type", "class");
        map.put("value", className);
        ExternalInterfaceUtil.executeExtItf(type, SerializationUtils.toJsonString(map), suspendInfo);
    }

    public static void sendMessageToAdmin(CommandContext commandContext, JobEntity job, WFEngineException engineException) {
        String className = WfSuspendUtil.getSuspendConfigInfo(ExtItfCallerType.AFTERSUSPENDPROCESS);
        if (WfUtils.isNotEmpty(className)) {
            WfSuspendUtil.invokeAfterSuspendProcess(job, engineException, className);
        } else {
            new SendMessageToAdminsCmd(job, true, engineException).execute(commandContext);
        }
    }

    public static void sendMessageToStartUser(CommandContext commandContext, JobEntity job) {
        new SendMessageToStartUser(job).execute(commandContext);
    }

    private static void invokeAfterSuspendProcess(JobEntity job, WFEngineException engineException, String className) {
        SuspendInfo suspendInfo = new SuspendInfo();
        suspendInfo.setBusinessKey(job.getBusinessKey());
        suspendInfo.setEntityNumber(job.getEntityNumber());
        suspendInfo.setElementId(job.getElementId());
        suspendInfo.setProcessInstanceId(job.getProcessInstanceId());
        suspendInfo.setProcessDefinitionId(job.getProcessDefinitionId());
        suspendInfo.setErrMsg(engineException.getMessage());
        suspendInfo.setUserId(WfConstanst.ADMIN);
        WfSuspendUtil.invokeExtItfMethod(suspendInfo, ExtItfCallerType.AFTERSUSPENDPROCESS, className);
    }
}

