/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.billconv;

import java.util.ArrayList;
import java.util.List;
import kd.bos.entity.botp.ConvertBill;
import kd.bos.entity.botp.ConvertOpType;
import kd.bos.entity.botp.ConvertRuleCache;
import kd.bos.entity.botp.ConvertRuleElement;
import kd.bos.entity.botp.runtime.ConvertOpParameter;
import kd.bos.entity.botp.runtime.ConvertOpRule;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.workflow.bpmn.model.BillRelationshipModel;
import kd.bos.workflow.bpmn.model.BillTask;
import kd.bos.workflow.bpmn.model.BpmnModel;
import kd.bos.workflow.bpmn.model.SequenceFlow;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricActivityInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.ManagementConstants;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskEntity;
import kd.bos.workflow.engine.impl.util.CollectionUtil;
import kd.bos.workflow.engine.impl.util.ProcessDefinitionUtil;
import kd.bos.workflow.exception.WFErrorCode;
import kd.bos.workflow.exception.WFTaskException;

public class GetBillConvertOpParameter
implements Command<ConvertOpParameter> {
    private List<Long> taskIds;

    public GetBillConvertOpParameter(List<Long> taskIds) {
        this.taskIds = taskIds;
    }

    @Override
    public ConvertOpParameter execute(CommandContext commandContext) {
        ConvertOpParameter opParameter = new ConvertOpParameter();
        opParameter.setOpType(ConvertOpType.Push);
        List<TaskEntity> taskEntities = commandContext.getTaskEntityManager().findByTaskIds(this.taskIds);
        for (TaskEntity taskEntity : taskEntities) {
            if (ManagementConstants.ACTIVE.getStateCode().equals(taskEntity.getSuspensionState())) continue;
            throw new WFTaskException(WFErrorCode.taskSuspendedError());
        }
        if (taskEntities == null || taskEntities.size() == 0) {
            throw new WFTaskException(WFErrorCode.taskNotFound());
        }
        TaskEntity task = taskEntities.get(0);
        HistoricActivityInstanceEntity taskActivityInstanceEntity = commandContext.getHistoricActivityInstanceEntityManager().findActivityByTaskId(task.getId());
        HistoricActivityInstanceEntity seqActivityInstanceEntity = (HistoricActivityInstanceEntity)commandContext.getHistoricActivityInstanceEntityManager().findById(taskActivityInstanceEntity.getSourceElementId());
        String seqId = seqActivityInstanceEntity.getActivityId();
        BpmnModel bpmnModel = ProcessDefinitionUtil.getBpmnModelByProcInstId(task.getProcessInstanceId());
        SequenceFlow sequenceFlow = (SequenceFlow)bpmnModel.getFlowElement(seqId);
        BillRelationshipModel billConversionInfo = sequenceFlow.getBillRelationshipModel();
        String conversionMethod = billConversionInfo.getConversionMethod();
        String conversionMode = billConversionInfo.getConversionMode();
        BillTask billTask = (BillTask)bpmnModel.getFlowElement(task.getTaskDefinitionKey());
        String targetEntityNumber = billTask.getEntityNumber();
        String targetEntityName = billTask.getEntityName();
        String sourceEntityNumber = task.getEntityNumber();
        opParameter.setEntityNumber(sourceEntityNumber);
        List<ConvertBill> bills = this.loadTargetBills(sourceEntityNumber, targetEntityNumber, targetEntityName, conversionMethod, conversionMode);
        opParameter.getBills().addAll(bills);
        ListSelectedRowCollection rows = new ListSelectedRowCollection();
        for (TaskEntity taskEntity : taskEntities) {
            ListSelectedRow row = new ListSelectedRow((Object)Long.parseLong(taskEntity.getBusinessKey()));
            rows.add((Object)row);
        }
        opParameter.setSelectedRows(rows);
        opParameter.setDefTargetBill(targetEntityNumber);
        if ("manualpush".equals(conversionMode)) {
            opParameter.setDefRuleId("@all");
        } else {
            opParameter.setDefRuleId(sequenceFlow.getBillRelationshipModel().getConversionMethod());
        }
        return opParameter;
    }

    private List<ConvertBill> loadTargetBills(String sourceEntityNumber, String targetEntityNumber, String targetEntityName, String conversionMethod, String conversionMode) {
        ArrayList<ConvertBill> list = new ArrayList<ConvertBill>();
        ConvertBill convertBill = new ConvertBill();
        convertBill.setEntityName(targetEntityName);
        convertBill.setEntityNumber(targetEntityNumber);
        List<ConvertRuleElement> rules = this.loadRules(sourceEntityNumber, targetEntityNumber, conversionMethod, conversionMode);
        if (CollectionUtil.isEmpty(rules)) {
            return list;
        }
        List<ConvertOpRule> opRules = this.getConvertOpRules(rules);
        if (opRules.isEmpty()) {
            return list;
        }
        convertBill.getRules().addAll(opRules);
        list.add(convertBill);
        return list;
    }

    private List<ConvertOpRule> getConvertOpRules(List<ConvertRuleElement> rules) {
        ArrayList<ConvertOpRule> opRules = new ArrayList<ConvertOpRule>(rules.size());
        for (ConvertRuleElement rule : rules) {
            ConvertOpRule opRule = new ConvertOpRule(rule.getId(), rule.getName().toString());
            opRule.setVisibled(rule.isVisibled());
            opRules.add(opRule);
        }
        return opRules;
    }

    private List<ConvertRuleElement> loadRules(String sourceEntityNumber, String targetEntityNumber, String conversionMethod, String conversionMode) {
        List rules = ConvertRuleCache.loadRules((String)sourceEntityNumber, (String)targetEntityNumber);
        ArrayList<ConvertRuleElement> enableRules = new ArrayList<ConvertRuleElement>(rules.size());
        if ("manualpush".equals(conversionMode) || "auto".equals(conversionMode) && "automatch".equals(conversionMethod)) {
            for (ConvertRuleElement rule : rules) {
                if (!rule.isEnabled()) continue;
                enableRules.add(rule);
            }
        } else {
            for (ConvertRuleElement rule : rules) {
                if (!conversionMethod.equals(rule.getId())) continue;
                enableRules.add(rule);
                break;
            }
        }
        return enableRules;
    }
}

