/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.billconv;

import java.util.ArrayList;
import java.util.List;
import kd.bos.entity.botp.ConvertBill;
import kd.bos.entity.botp.ConvertOpType;
import kd.bos.entity.botp.ConvertRuleCache;
import kd.bos.entity.botp.ConvertRuleElement;
import kd.bos.entity.botp.runtime.ConvertOpParameter;
import kd.bos.entity.botp.runtime.ConvertOpRule;
import kd.bos.servicehelper.botp.ConvertMetaServiceHelper;
import kd.bos.workflow.bpmn.converter.util.CollectionUtils;
import kd.bos.workflow.bpmn.model.BillTask;
import kd.bos.workflow.bpmn.model.BpmnModel;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricTaskInstanceEntity;
import kd.bos.workflow.engine.impl.util.ProcessDefinitionUtil;

public class GetBillDrawOpParameter
implements Command<ConvertOpParameter> {
    private Long taskId;
    private String pageId;

    public GetBillDrawOpParameter(Long taskId, String pageId) {
        this.taskId = taskId;
        this.pageId = pageId;
    }

    @Override
    public ConvertOpParameter execute(CommandContext commandContext) {
        ConvertOpParameter opParameter = new ConvertOpParameter();
        opParameter.setOpType(ConvertOpType.Draw);
        opParameter.setTargetBillPageId(this.pageId);
        HistoricTaskInstanceEntity task = (HistoricTaskInstanceEntity)commandContext.getHistoricTaskInstanceEntityManager().findById(this.taskId);
        BpmnModel bpmnModel = ProcessDefinitionUtil.getBpmnModelByProcInstId(task.getProcessInstanceId());
        BillTask billTask = (BillTask)bpmnModel.getFlowElement(task.getTaskDefinitionKey());
        String targetEntityNumber = billTask.getEntityNumber();
        opParameter.setEntityNumber(targetEntityNumber);
        String sourceEntityNumber = task.getEntityNumber();
        opParameter.setDefSourceBill(sourceEntityNumber);
        List<ConvertBill> bills = this.loadSourceBills(targetEntityNumber, sourceEntityNumber);
        if (CollectionUtils.isNotEmpty(bills)) {
            opParameter.getBills().addAll(bills);
        }
        return opParameter;
    }

    private List<ConvertBill> loadSourceBills(String targetEntityNumber, String sourceEntityNumber) {
        ArrayList<ConvertBill> list = new ArrayList<ConvertBill>(20);
        List bills = ConvertMetaServiceHelper.loadConvertBills((String)targetEntityNumber, (ConvertOpType)ConvertOpType.Draw);
        for (ConvertBill bill : bills) {
            List<ConvertOpRule> opRules;
            List<ConvertRuleElement> rules;
            if (!sourceEntityNumber.equals(bill.getEntityNumber()) || (rules = this.loadRules(bill.getEntityNumber(), targetEntityNumber)).isEmpty() || (opRules = this.filterBillType(rules)).isEmpty()) continue;
            bill.getRules().addAll(opRules);
            list.add(bill);
        }
        return list;
    }

    private List<ConvertRuleElement> loadRules(String sourceEntityNumber, String targetEntityNumber) {
        List rules = ConvertRuleCache.loadRules((String)sourceEntityNumber, (String)targetEntityNumber);
        ArrayList<ConvertRuleElement> enableRules = new ArrayList<ConvertRuleElement>();
        for (ConvertRuleElement rule : rules) {
            if (!rule.isEnabled()) continue;
            enableRules.add(rule);
        }
        return enableRules;
    }

    private List<ConvertOpRule> filterBillType(List<ConvertRuleElement> rules) {
        ArrayList<ConvertOpRule> opRules = new ArrayList<ConvertOpRule>(rules.size());
        for (ConvertRuleElement rule : rules) {
            if (!rule.isEnabled()) continue;
            ConvertOpRule opRule = new ConvertOpRule(rule.getId(), rule.getName().toString());
            opRule.setVisibled(rule.isVisibled());
            opRule.setAllBillType(true);
            opRules.add(opRule);
        }
        return opRules;
    }
}

