/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.billconv;

import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.workflow.bpmn.model.BillRelationshipModel;
import kd.bos.workflow.bpmn.model.BillTask;
import kd.bos.workflow.bpmn.model.BpmnModel;
import kd.bos.workflow.bpmn.model.SequenceFlow;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricActivityInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricActivityInstanceEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskEntity;
import kd.bos.workflow.engine.impl.util.ProcessDefinitionUtil;

public class GetTargetEntityNumberByTasdkIdCmd
implements Command<Map<String, Object>> {
    private Long taskId;

    public GetTargetEntityNumberByTasdkIdCmd(Long taskId) {
        this.taskId = taskId;
    }

    @Override
    public Map<String, Object> execute(CommandContext commandContext) {
        HistoricActivityInstanceEntity activityEntity;
        HashMap<String, Object> params = new HashMap<String, String>();
        TaskEntity task = (TaskEntity)commandContext.getTaskEntityManager().findById(this.taskId);
        BpmnModel bpmnModel = ProcessDefinitionUtil.getBpmnModelByProcInstId(task.getProcessInstanceId());
        BillTask billTask = (BillTask)bpmnModel.getFlowElement(task.getTaskDefinitionKey());
        HistoricActivityInstanceEntityManager historicActivityInstanceEntityManager = commandContext.getHistoricActivityInstanceEntityManager();
        HistoricActivityInstanceEntity sequenceActivityEntity = (HistoricActivityInstanceEntity)historicActivityInstanceEntityManager.findById((activityEntity = historicActivityInstanceEntityManager.findActivityByTaskId(this.taskId)).getSourceElementId());
        SequenceFlow sequenceFlow = (SequenceFlow)bpmnModel.getFlowElement(sequenceActivityEntity.getActivityId());
        BillRelationshipModel billRelationshipModel = sequenceFlow.getBillRelationshipModel();
        String drawParameter = billRelationshipModel.getDrawParameter();
        if (WfUtils.isNotEmpty(drawParameter)) {
            params = (Map)SerializationUtils.fromJsonString((String)drawParameter, Map.class);
        }
        params.put("entityNumber", billTask.getEntityNumber());
        return params;
    }
}

