/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.comparetype;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.filter.CompareTypeDto;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.inte.InteServiceHelper;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.comparetype.CompareTypeEnum;
import kd.bos.workflow.engine.comparetype.WfCompareTypeDto;

public class CompareTypesUtils {
    private Log logger = LogFactory.getLog(this.getClass());
    public static final String STRINGTYPE = "0";
    public static final String NUMBERTYPE = "1";
    public static final String DATETIMETYPE = "2";
    public static final String BOOLEANTYPE = "3";
    public static final String ENUMTYPE = "9";
    public static final String BASEDATATYPE = "14";
    public static final String USERTYPE = "15";
    public static final String ORGTYPE = "16";
    public static final String COLLECTION = "collection";
    public static final String ENTRY = "entry";
    public static final String EQUAL = "==";
    public static final String NOTEQUAL = "!=";
    public static final String LT = "<";
    public static final String GT = ">";
    public static final String GTEQUAL = ">=";
    public static final String LTEQUAL = "<=";
    public static final String CLK = "CL";
    public static final String CNL = "NC";
    public static final String LK = "LK";
    public static final String NL = "NL";
    public static final String BELONG = "BL";
    public static final String NOTBELONG = "NB";
    public static final String CBELONG = "IN";
    public static final String CNOTBELONG = "NI";
    public static final String ISTRUE = "ISTRUE";
    public static final String ISFALSE = "ISFALSE";
    public static final String EMPTY = "empty";
    public static final String NOTEMPTY = "notempty";
    public static final String BS = "BS";
    public static final String BO = "BO";
    public static final String CS = "CS";
    public static final String BR = "BR";
    public static final String NR = "NR";
    private HashMap<String, List<CompareTypeDto>> compareTypeMap = new HashMap();
    private HashMap<String, CompareTypeDto> compareTypeItemMap = new HashMap();
    private HashMap<String, List<CompareTypeDto>> multiInstanceCompareTypes = new HashMap();
    private HashMap<String, List<WfCompareTypeDto>> entityIdMapCompareTypes = new HashMap();
    private HashMap<String, List<WfCompareTypeDto>> multiCompareTypes = new HashMap();
    private static CompareTypesUtils instance = null;

    private CompareTypesUtils() {
        this.createCompareTypeDtoMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CompareTypesUtils get() {
        Class<CompareTypesUtils> clazz = CompareTypesUtils.class;
        synchronized (CompareTypesUtils.class) {
            if (instance == null) {
                instance = new CompareTypesUtils();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public void registExtCompareType(String type, WfCompareTypeDto dto) {
        String extendedKey = dto.getExtendedKey();
        HashMap<String, List<WfCompareTypeDto>> registMap = this.entityIdMapCompareTypes;
        if (WfUtils.isNotEmpty(extendedKey)) {
            List<WfCompareTypeDto> wfdtos;
            if ("multi".equals(type)) {
                registMap = this.multiCompareTypes;
            }
            if ((wfdtos = registMap.get(extendedKey)) == null) {
                wfdtos = new ArrayList<WfCompareTypeDto>();
            }
            wfdtos.add(dto);
            registMap.put(extendedKey, wfdtos);
        }
        this.logger.info("[registExtCompareType]\u6ce8\u518c\u6bd4\u8f83\u7b26\u5b8c\u6bd5\uff1aId:" + dto.getId() + "\uff0cextendedKey:" + extendedKey);
    }

    private void createCompareTypeDtoMap() {
        CompareTypeDto equalsDto = new CompareTypeDto(EQUAL, ResManager.getLocaleString((String)"\u7b49\u4e8e", (String)"CompareTypesUtils_1", (String)"bos-wf-engine"), true, "", 0, 0, false, false, false, false);
        this.compareTypeItemMap.put(equalsDto.getId(), equalsDto);
        try {
            StringBuilder sb = new StringBuilder();
            LocaleString eqName = equalsDto.getName();
            List list = InteServiceHelper.getEnabledLang();
            sb.append("requestContext:").append(RequestContext.get() == null ? "nullreq" : RequestContext.get().getAccountId()).append(";zh_CN:").append((String)eqName.get((Object)"zh_CN")).append(";zh_TW:").append((String)eqName.get((Object)"zh_TW")).append(";en_US:").append((String)eqName.get((Object)"en_US"));
            sb.append(";EnabledLanguage:").append(list.size());
            this.logger.info("createCompareTypeDtoMap_equalsDto_name: " + sb);
        }
        catch (Exception e) {
            this.logger.error("createCompareTypeDtoMap_equalsDto_name: ", (Throwable)e);
        }
        CompareTypeDto notEqualsDto = new CompareTypeDto(NOTEQUAL, ResManager.getLocaleString((String)"\u4e0d\u7b49\u4e8e", (String)"CompareTypesUtils_2", (String)"bos-wf-engine"), true, "", 0, 0, false, false, false, false);
        this.compareTypeItemMap.put(notEqualsDto.getId(), notEqualsDto);
        CompareTypeDto ltDto = new CompareTypeDto(LT, ResManager.getLocaleString((String)"\u5c0f\u4e8e", (String)"CompareTypesUtils_3", (String)"bos-wf-engine"), true, "", 0, 0, false, false, false, false);
        this.compareTypeItemMap.put(ltDto.getId(), ltDto);
        CompareTypeDto gtDto = new CompareTypeDto(GT, ResManager.getLocaleString((String)"\u5927\u4e8e", (String)"CompareTypesUtils_4", (String)"bos-wf-engine"), true, "", 0, 0, false, false, false, false);
        this.compareTypeItemMap.put(gtDto.getId(), gtDto);
        CompareTypeDto gtEqualsDto = new CompareTypeDto(GTEQUAL, ResManager.getLocaleString((String)"\u5927\u4e8e\u7b49\u4e8e", (String)"CompareTypesUtils_5", (String)"bos-wf-engine"), true, "", 0, 0, false, false, false, false);
        this.compareTypeItemMap.put(gtEqualsDto.getId(), gtEqualsDto);
        CompareTypeDto ltEqualsDto = new CompareTypeDto(LTEQUAL, ResManager.getLocaleString((String)"\u5c0f\u4e8e\u7b49\u4e8e", (String)"CompareTypesUtils_6", (String)"bos-wf-engine"), true, "", 0, 0, false, false, false, false);
        this.compareTypeItemMap.put(ltEqualsDto.getId(), ltEqualsDto);
        CompareTypeDto containsDto = new CompareTypeDto(LK, ResManager.getLocaleString((String)"\u5305\u542b", (String)"CompareTypesUtils_7", (String)"bos-wf-engine"), true, "", 0, 0, false, true, false, false);
        this.compareTypeItemMap.put(containsDto.getId(), containsDto);
        CompareTypeDto notContainsDto = new CompareTypeDto(NL, ResManager.getLocaleString((String)"\u4e0d\u5305\u542b", (String)"CompareTypesUtils_8", (String)"bos-wf-engine"), true, "", 0, 0, false, true, false, false);
        this.compareTypeItemMap.put(notContainsDto.getId(), notContainsDto);
        CompareTypeDto belongDto = new CompareTypeDto(BELONG, ResManager.getLocaleString((String)"\u5c5e\u4e8e", (String)"CompareTypesUtils_9", (String)"bos-wf-engine"), true, "", 0, 0, false, true, false, false);
        CompareTypeDto notBelongDto = new CompareTypeDto(NOTBELONG, ResManager.getLocaleString((String)"\u4efb\u4e00\u4e0d\u5c5e\u4e8e", (String)"CompareTypesUtils_10", (String)"bos-wf-engine"), true, "", 0, 0, false, true, false, false);
        CompareTypeDto collContainsDto = new CompareTypeDto(CLK, ResManager.getLocaleString((String)"\u5305\u542b", (String)"CompareTypesUtils_7", (String)"bos-wf-engine"), true, "", 0, 0, false, true, false, false);
        CompareTypeDto collNotContainsDto = new CompareTypeDto(CNL, ResManager.getLocaleString((String)"\u4e0d\u5305\u542b", (String)"CompareTypesUtils_8", (String)"bos-wf-engine"), true, "", 0, 0, false, true, false, false);
        this.compareTypeItemMap.put(notContainsDto.getId(), notContainsDto);
        CompareTypeDto collBelongDto = new CompareTypeDto(CBELONG, ResManager.getLocaleString((String)"\u5c5e\u4e8e\u96c6\u5408", (String)"CompareTypesUtils_11", (String)"bos-wf-engine"), true, "", 0, 0, false, true, false, false);
        CompareTypeDto collNotBelongDto = new CompareTypeDto(CNOTBELONG, ResManager.getLocaleString((String)"\u4e0d\u5c5e\u4e8e\u96c6\u5408", (String)"CompareTypesUtils_12", (String)"bos-wf-engine"), true, "", 0, 0, false, true, false, false);
        this.compareTypeItemMap.put(collBelongDto.getId(), collBelongDto);
        this.compareTypeItemMap.put(collNotBelongDto.getId(), collNotBelongDto);
        this.compareTypeItemMap.put(notContainsDto.getId(), notContainsDto);
        CompareTypeDto emptyDto = new CompareTypeDto(EMPTY, ResManager.getLocaleString((String)"\u4e3a\u7a7a", (String)"CompareTypesUtils_13", (String)"bos-wf-engine"), false, "", 0, 0, false, false, false, false);
        this.compareTypeItemMap.put(emptyDto.getId(), emptyDto);
        CompareTypeDto notEmptyDto = new CompareTypeDto(NOTEMPTY, ResManager.getLocaleString((String)"\u4e0d\u4e3a\u7a7a", (String)"CompareTypesUtils_14", (String)"bos-wf-engine"), false, "", 0, 0, false, false, false, false);
        this.compareTypeItemMap.put(notEmptyDto.getId(), notEmptyDto);
        CompareTypeDto belongOrgDto = new CompareTypeDto(BO, ResManager.getLocaleString((String)"\u5c5e\u4e8e\u7ec4\u7ec7", (String)"CompareTypesUtils_15", (String)"bos-wf-engine"), true, "", 0, 10002, false, false, false, false);
        this.compareTypeItemMap.put(belongOrgDto.getId(), belongOrgDto);
        CompareTypeDto belongWfRoleDto = new CompareTypeDto(BR, ResManager.getLocaleString((String)"\u5c5e\u4e8e\u5de5\u4f5c\u6d41\u89d2\u8272", (String)"CompareTypesUtils_16", (String)"bos-wf-engine"), true, "", 0, 10003, false, false, false, false);
        this.compareTypeItemMap.put(belongWfRoleDto.getId(), belongWfRoleDto);
        CompareTypeDto notBelongWfRoleDto = new CompareTypeDto(NR, ResManager.getLocaleString((String)"\u4e0d\u5c5e\u4e8e\u5de5\u4f5c\u6d41\u89d2\u8272", (String)"CompareTypesUtils_21", (String)"bos-wf-engine"), true, "", 0, 10003, false, false, false, false);
        this.compareTypeItemMap.put(notBelongWfRoleDto.getId(), notBelongWfRoleDto);
        CompareTypeDto belongSuperiorDto = new CompareTypeDto(BS, ResManager.getLocaleString((String)"\u5c5e\u4e8e\u4e0a\u7ea7", (String)"CompareTypesUtils_17", (String)"bos-wf-engine"), true, "", 0, 0, false, false, false, false);
        this.compareTypeItemMap.put(belongSuperiorDto.getId(), belongSuperiorDto);
        CompareTypeDto containsLowerDto = new CompareTypeDto(CS, ResManager.getLocaleString((String)"\u5305\u542b\u4e0b\u7ea7", (String)"CompareTypesUtils_18", (String)"bos-wf-engine"), true, "", 0, 0, false, false, false, false);
        this.compareTypeItemMap.put(containsLowerDto.getId(), containsLowerDto);
        ArrayList<CompareTypeDto> commonCompareTypes = new ArrayList<CompareTypeDto>();
        commonCompareTypes.add(equalsDto);
        commonCompareTypes.add(notEqualsDto);
        commonCompareTypes.add(gtDto);
        commonCompareTypes.add(ltDto);
        commonCompareTypes.add(gtEqualsDto);
        commonCompareTypes.add(ltEqualsDto);
        commonCompareTypes.add(emptyDto);
        commonCompareTypes.add(notEmptyDto);
        this.compareTypeMap.put(NUMBERTYPE, commonCompareTypes);
        ArrayList<CompareTypeDto> dateCompareTypes = new ArrayList<CompareTypeDto>();
        dateCompareTypes.addAll(commonCompareTypes);
        this.compareTypeMap.put(DATETIMETYPE, dateCompareTypes);
        ArrayList<CompareTypeDto> strCompareTypes = new ArrayList<CompareTypeDto>();
        strCompareTypes.addAll(commonCompareTypes);
        strCompareTypes.add(containsDto);
        strCompareTypes.add(notContainsDto);
        strCompareTypes.add(collBelongDto);
        strCompareTypes.add(collNotBelongDto);
        this.compareTypeMap.put(STRINGTYPE, strCompareTypes);
        ArrayList<CompareTypeDto> baseDataCompareTypes = new ArrayList<CompareTypeDto>();
        baseDataCompareTypes.add(equalsDto);
        baseDataCompareTypes.add(notEqualsDto);
        baseDataCompareTypes.add(emptyDto);
        baseDataCompareTypes.add(notEmptyDto);
        baseDataCompareTypes.add(collBelongDto);
        baseDataCompareTypes.add(collNotBelongDto);
        this.compareTypeMap.put(BASEDATATYPE, baseDataCompareTypes);
        ArrayList<CompareTypeDto> booleanCompareTypes = new ArrayList<CompareTypeDto>();
        booleanCompareTypes.add(equalsDto);
        booleanCompareTypes.add(notEqualsDto);
        this.compareTypeMap.put(BOOLEANTYPE, booleanCompareTypes);
        ArrayList<CompareTypeDto> userCompareTypes = new ArrayList<CompareTypeDto>();
        userCompareTypes.addAll(baseDataCompareTypes);
        userCompareTypes.add(belongOrgDto);
        userCompareTypes.add(belongWfRoleDto);
        this.compareTypeMap.put(USERTYPE, userCompareTypes);
        ArrayList<CompareTypeDto> orgCompareTypes = new ArrayList<CompareTypeDto>();
        orgCompareTypes.addAll(baseDataCompareTypes);
        orgCompareTypes.add(belongSuperiorDto);
        orgCompareTypes.add(containsLowerDto);
        this.compareTypeMap.put(ORGTYPE, orgCompareTypes);
        ArrayList<CompareTypeDto> enumCompareTypes = new ArrayList<CompareTypeDto>();
        enumCompareTypes.addAll(strCompareTypes);
        this.compareTypeMap.put(ENUMTYPE, enumCompareTypes);
        ArrayList<CompareTypeDto> collectionCompareTypes = new ArrayList<CompareTypeDto>();
        collectionCompareTypes.add(emptyDto);
        collectionCompareTypes.add(notEmptyDto);
        collectionCompareTypes.add(collContainsDto);
        collectionCompareTypes.add(collNotContainsDto);
        collectionCompareTypes.add(collBelongDto);
        collectionCompareTypes.add(collNotBelongDto);
        this.compareTypeMap.put(COLLECTION, collectionCompareTypes);
    }

    public List<CompareTypeDto> getCompareTypesByArgs(String type, String entityNumber, int multiKey) {
        if (multiKey > 0) {
            return this.getMultiCompareTypes(type, entityNumber);
        }
        return this.getCompareTypesByType(type, entityNumber);
    }

    private CompareTypeDto cloneCompareTypeDto(WfCompareTypeDto dto, String controlType) {
        WfCompareTypeDto clone = new WfCompareTypeDto();
        clone.setControlType(controlType);
        clone.setBetween(dto.isBetween());
        clone.setEntityId(dto.getEntityId());
        clone.setExtendedKey(dto.getExtendedKey());
        clone.setFieldCompare(dto.isFieldCompare());
        clone.setGroupId(dto.getGroupId());
        clone.setId(dto.getId());
        clone.setInputCtlType(dto.getInputCtlType());
        clone.setItems(dto.getItems());
        clone.setMulti(dto.isMulti());
        clone.setName(dto.getName());
        clone.setNeedInput(dto.isNeedInput());
        clone.setNumber(dto.isNumber());
        clone.setValue(dto.getValue());
        return clone;
    }

    private List<CompareTypeDto> getMultiCompareTypes(String type, String entityNumber) {
        List<Object> compareTypeDtos;
        ArrayList tmp = new ArrayList();
        switch (type) {
            case "boolean": {
                compareTypeDtos = this.multiInstanceCompareTypes.get("boolean");
                if (compareTypeDtos != null && !compareTypeDtos.isEmpty()) break;
                compareTypeDtos = new ArrayList(100);
                tmp.addAll(this.multiCompareTypes.get("boolean"));
                for (WfCompareTypeDto i : tmp) {
                    compareTypeDtos.add(this.cloneCompareTypeDto(i, "enum"));
                }
                this.multiInstanceCompareTypes.put("boolean", compareTypeDtos);
                break;
            }
            case "date": {
                compareTypeDtos = this.multiInstanceCompareTypes.get("date");
                if (compareTypeDtos != null && !compareTypeDtos.isEmpty()) break;
                compareTypeDtos = new ArrayList(100);
                tmp.addAll(this.multiCompareTypes.get("boolean"));
                tmp.addAll(this.multiCompareTypes.get("number"));
                for (WfCompareTypeDto i : tmp) {
                    compareTypeDtos.add(this.cloneCompareTypeDto(i, "date"));
                }
                this.multiInstanceCompareTypes.put("date", compareTypeDtos);
                break;
            }
            case "number": {
                compareTypeDtos = this.multiInstanceCompareTypes.get("number");
                if (compareTypeDtos != null && !compareTypeDtos.isEmpty()) break;
                compareTypeDtos = new ArrayList(100);
                tmp.addAll(this.multiCompareTypes.get("boolean"));
                tmp.addAll(this.multiCompareTypes.get("number"));
                for (WfCompareTypeDto i : tmp) {
                    compareTypeDtos.add(this.cloneCompareTypeDto(i, "number"));
                }
                this.multiInstanceCompareTypes.put("number", compareTypeDtos);
                break;
            }
            case "F7": 
            case "collection": {
                compareTypeDtos = new ArrayList(100);
                compareTypeDtos.addAll((Collection<Object>)this.multiCompareTypes.get("F7"));
                compareTypeDtos.add(this.compareTypeItemMap.get(EMPTY));
                compareTypeDtos.add(this.compareTypeItemMap.get(NOTEMPTY));
                compareTypeDtos.add(this.compareTypeItemMap.get(CBELONG));
                compareTypeDtos.add(this.compareTypeItemMap.get(CNOTBELONG));
                if (this.entityIdMapCompareTypes.get(entityNumber) == null) break;
                ArrayList extCompareTypes = new ArrayList(this.entityIdMapCompareTypes.get(entityNumber));
                compareTypeDtos.addAll(extCompareTypes);
                break;
            }
            default: {
                compareTypeDtos = new ArrayList<CompareTypeDto>();
                compareTypeDtos.add(this.compareTypeItemMap.get(EMPTY));
                compareTypeDtos.add(this.compareTypeItemMap.get(NOTEMPTY));
                compareTypeDtos.add(this.compareTypeItemMap.get(LK));
                compareTypeDtos.add(this.compareTypeItemMap.get(NL));
            }
        }
        this.resetCompareTypeName(compareTypeDtos);
        return compareTypeDtos;
    }

    public List<CompareTypeDto> getCompareTypesById(String id) {
        if (this.compareTypeMap.get(id) == null) {
            return this.compareTypeMap.get(ENUMTYPE);
        }
        return this.compareTypeMap.get(id);
    }

    public List<CompareTypeDto> getCompareTypesByType(String type, String entityNumber) {
        ArrayList<CompareTypeDto> compareTypeDtos = null;
        boolean isEntry = false;
        String type2 = type;
        if (type.contains(".")) {
            type2 = type.split("\\.")[1];
            isEntry = true;
        }
        this.logger.debug("getCompareTypesByType \u7c7b\u578b\uff1a" + type2);
        switch (type2) {
            case "boolean": {
                compareTypeDtos = this.compareTypeMap.get(BOOLEANTYPE);
                break;
            }
            case "date": {
                compareTypeDtos = this.compareTypeMap.get(DATETIMETYPE);
                break;
            }
            case "number": {
                compareTypeDtos = this.compareTypeMap.get(NUMBERTYPE);
                break;
            }
            case "F7": {
                List<CompareTypeDto> compareTypeMapClone = this.compareTypeMap.get(BASEDATATYPE);
                compareTypeDtos = new ArrayList(100);
                for (CompareTypeDto dto : compareTypeMapClone) {
                    compareTypeDtos.add(dto);
                }
                this.addDtosFromEntityF7(entityNumber, compareTypeDtos);
                break;
            }
            case "collection": {
                compareTypeDtos = new ArrayList();
                compareTypeDtos.addAll((Collection)this.compareTypeMap.get(COLLECTION));
                this.addDtosFromEntityF7(entityNumber, compareTypeDtos);
                break;
            }
            default: {
                compareTypeDtos = this.compareTypeMap.get(STRINGTYPE);
            }
        }
        if (isEntry) {
            compareTypeDtos = this.remove(compareTypeDtos);
        }
        this.resetCompareTypeName(compareTypeDtos);
        return compareTypeDtos;
    }

    public List<CompareTypeDto> remove(List<CompareTypeDto> dtos) {
        for (int i = dtos.size() - 1; i > 0; --i) {
            if (!CLK.equals(dtos.get(i).getId()) && !CNL.equals(dtos.get(i).getId()) && !LK.equals(dtos.get(i).getId()) && !NL.equals(dtos.get(i).getId()) && !BELONG.equals(dtos.get(i).getId()) && !NOTBELONG.equals(dtos.get(i).getId()) && !CBELONG.equals(dtos.get(i).getId()) && !CNOTBELONG.equals(dtos.get(i).getId())) continue;
            dtos.remove(i);
        }
        return dtos;
    }

    private void addDtosFromEntityF7(String entityNumber, List<CompareTypeDto> compareTypeDtos) {
        if (this.entityIdMapCompareTypes.get(entityNumber) != null) {
            List<WfCompareTypeDto> dtos = this.entityIdMapCompareTypes.get(entityNumber);
            HashSet<String> compareTypeIds = new HashSet<String>(dtos.size());
            for (WfCompareTypeDto dto : dtos) {
                if (!compareTypeIds.contains(dto.getId())) {
                    compareTypeDtos.add(dto);
                }
                compareTypeIds.add(dto.getId());
            }
        }
    }

    public HashMap<String, CompareTypeDto> getCompareTypeItemMap() {
        return this.compareTypeItemMap;
    }

    private void resetCompareTypeName(List<CompareTypeDto> compareTypeDtos) {
        if (WfUtils.isEmptyForCollection(compareTypeDtos)) {
            return;
        }
        compareTypeDtos.forEach(compareTypeDto -> {
            CompareTypeEnum type = CompareTypeEnum.getCompareTypeByNumber(compareTypeDto.getId());
            if (type != null) {
                compareTypeDto.setName(type.getName().toLocaleString());
            }
        });
    }
}

