/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.delegate;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.workflow.bpmn.model.BpmnModel;
import kd.bos.workflow.bpmn.model.ExtensionElement;
import kd.bos.workflow.bpmn.model.FieldExtension;
import kd.bos.workflow.bpmn.model.FlowElement;
import kd.bos.workflow.bpmn.model.Process;
import kd.bos.workflow.bpmn.model.SequenceFlow;
import kd.bos.workflow.bpmn.model.TaskWithFieldExtensions;
import kd.bos.workflow.engine.delegate.DelegateExecution;
import kd.bos.workflow.engine.delegate.DelegateTask;
import kd.bos.workflow.engine.delegate.Expression;
import kd.bos.workflow.engine.impl.context.Context;
import kd.bos.workflow.engine.impl.el.ExpressionManager;
import kd.bos.workflow.engine.impl.el.FixedValue;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;
import kd.bos.workflow.engine.impl.util.ProcessDefinitionUtil;
import kd.bos.workflow.exception.WFEngineException;
import org.apache.commons.lang.StringUtils;

public class DelegateHelper {
    public static void leaveDelegate(DelegateExecution delegateExecution) {
        Context.getAgenda().planTakeOutgoingSequenceFlowsOperation((ExecutionEntity)delegateExecution, true);
    }

    public static void leaveDelegate(DelegateExecution delegateExecution, String sequenceFlowId) {
        Long processDefinitionId = delegateExecution.getProcessDefinitionId();
        Process process = ProcessDefinitionUtil.getProcess(processDefinitionId, delegateExecution.getProcessInstanceId());
        FlowElement flowElement = process.getFlowElement(sequenceFlowId);
        if (!(flowElement instanceof SequenceFlow)) {
            throw new WFEngineException(sequenceFlowId + " does not match a sequence flow");
        }
        delegateExecution.setCurrentFlowElement(flowElement);
        Context.getAgenda().planTakeOutgoingSequenceFlowsOperation((ExecutionEntity)delegateExecution, false);
    }

    public static BpmnModel getBpmnModel(DelegateExecution execution) {
        if (execution == null) {
            throw new WFEngineException("Null execution passed");
        }
        return ProcessDefinitionUtil.getBpmnModel(execution.getProcessDefinitionId(), execution.getProcessInstanceId());
    }

    public static FlowElement getFlowElement(DelegateExecution execution) {
        BpmnModel bpmnModel = DelegateHelper.getBpmnModel(execution);
        FlowElement flowElement = bpmnModel.getFlowElement(execution.getCurrentActivityId());
        if (flowElement == null) {
            throw new WFEngineException("Could not find a FlowElement for activityId " + execution.getCurrentActivityId());
        }
        return flowElement;
    }

    public static boolean isExecutingExecutionListener(DelegateExecution execution) {
        return execution.getCurrentActivitiListener() != null;
    }

    public static Map<String, List<ExtensionElement>> getExtensionElements(DelegateExecution execution) {
        if (DelegateHelper.isExecutingExecutionListener(execution)) {
            return DelegateHelper.getListenerExtensionElements(execution);
        }
        return DelegateHelper.getFlowElementExtensionElements(execution);
    }

    public static Map<String, List<ExtensionElement>> getFlowElementExtensionElements(DelegateExecution execution) {
        return DelegateHelper.getFlowElement(execution).getExtensionElements();
    }

    public static Map<String, List<ExtensionElement>> getListenerExtensionElements(DelegateExecution execution) {
        return execution.getCurrentActivitiListener().getExtensionElements();
    }

    public static List<FieldExtension> getFields(DelegateExecution execution) {
        if (DelegateHelper.isExecutingExecutionListener(execution)) {
            return DelegateHelper.getListenerFields(execution);
        }
        return DelegateHelper.getFlowElementFields(execution);
    }

    public static List<FieldExtension> getFlowElementFields(DelegateExecution execution) {
        FlowElement flowElement = DelegateHelper.getFlowElement(execution);
        if (flowElement instanceof TaskWithFieldExtensions) {
            return ((TaskWithFieldExtensions)flowElement).getFieldExtensions();
        }
        return new ArrayList<FieldExtension>();
    }

    public static List<FieldExtension> getListenerFields(DelegateExecution execution) {
        return execution.getCurrentActivitiListener().getFieldExtensions();
    }

    public static FieldExtension getField(DelegateExecution execution, String fieldName) {
        if (DelegateHelper.isExecutingExecutionListener(execution)) {
            return DelegateHelper.getListenerField(execution, fieldName);
        }
        return DelegateHelper.getFlowElementField(execution, fieldName);
    }

    public static FieldExtension getFlowElementField(DelegateExecution execution, String fieldName) {
        List<FieldExtension> fieldExtensions = DelegateHelper.getFlowElementFields(execution);
        if (fieldExtensions == null || fieldExtensions.size() == 0) {
            return null;
        }
        for (FieldExtension fieldExtension : fieldExtensions) {
            if (fieldExtension.getFieldName() == null || !fieldExtension.getFieldName().equals(fieldName)) continue;
            return fieldExtension;
        }
        return null;
    }

    public static FieldExtension getListenerField(DelegateExecution execution, String fieldName) {
        List<FieldExtension> fieldExtensions = DelegateHelper.getListenerFields(execution);
        if (fieldExtensions == null || fieldExtensions.size() == 0) {
            return null;
        }
        for (FieldExtension fieldExtension : fieldExtensions) {
            if (fieldExtension.getFieldName() == null || !fieldExtension.getFieldName().equals(fieldName)) continue;
            return fieldExtension;
        }
        return null;
    }

    public static Expression createExpressionForField(FieldExtension fieldExtension) {
        if (StringUtils.isNotEmpty((String)fieldExtension.getExpression())) {
            ExpressionManager expressionManager = Context.getProcessEngineConfiguration().getExpressionManager();
            return expressionManager.createExpression(fieldExtension.getExpression());
        }
        return new FixedValue(fieldExtension.getStringValue());
    }

    public static Expression getFieldExpression(DelegateExecution execution, String fieldName) {
        if (DelegateHelper.isExecutingExecutionListener(execution)) {
            return DelegateHelper.getListenerFieldExpression(execution, fieldName);
        }
        return DelegateHelper.getFlowElementFieldExpression(execution, fieldName);
    }

    public static Expression getFieldExpression(DelegateTask task, String fieldName) {
        if (task.getCurrentActivitiListener() != null) {
            List<FieldExtension> fieldExtensions = task.getCurrentActivitiListener().getFieldExtensions();
            if (fieldExtensions == null || fieldExtensions.isEmpty()) {
                return null;
            }
            for (FieldExtension fieldExtension : fieldExtensions) {
                if (!fieldName.equals(fieldExtension.getFieldName())) continue;
                return DelegateHelper.createExpressionForField(fieldExtension);
            }
        }
        return null;
    }

    public static Expression getFlowElementFieldExpression(DelegateExecution execution, String fieldName) {
        FieldExtension fieldExtension = DelegateHelper.getFlowElementField(execution, fieldName);
        if (fieldExtension != null) {
            return DelegateHelper.createExpressionForField(fieldExtension);
        }
        return null;
    }

    public static Expression getListenerFieldExpression(DelegateExecution execution, String fieldName) {
        FieldExtension fieldExtension = DelegateHelper.getListenerField(execution, fieldName);
        if (fieldExtension != null) {
            return DelegateHelper.createExpressionForField(fieldExtension);
        }
        return null;
    }
}

