/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.delegate.event.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.workflow.bpmn.model.FlowElement;
import kd.bos.workflow.bpmn.model.FlowNode;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.delegate.DelegateExecution;
import kd.bos.workflow.engine.delegate.DelegateTaskEventProperties;
import kd.bos.workflow.engine.delegate.event.ActivitiActivityCancelledEvent;
import kd.bos.workflow.engine.delegate.event.ActivitiActivityEvent;
import kd.bos.workflow.engine.delegate.event.ActivitiCancelledEvent;
import kd.bos.workflow.engine.delegate.event.ActivitiEntityEvent;
import kd.bos.workflow.engine.delegate.event.ActivitiEntityWithVariablesEvent;
import kd.bos.workflow.engine.delegate.event.ActivitiErrorEvent;
import kd.bos.workflow.engine.delegate.event.ActivitiEvent;
import kd.bos.workflow.engine.delegate.event.ActivitiEventType;
import kd.bos.workflow.engine.delegate.event.ActivitiMembershipEvent;
import kd.bos.workflow.engine.delegate.event.ActivitiMessageEvent;
import kd.bos.workflow.engine.delegate.event.ActivitiProcessStartedEvent;
import kd.bos.workflow.engine.delegate.event.ActivitiSequenceFlowTakenEvent;
import kd.bos.workflow.engine.delegate.event.ActivitiSignalEvent;
import kd.bos.workflow.engine.delegate.event.CoordinateTaskEvent;
import kd.bos.workflow.engine.delegate.event.CoordinateTransferTaskEvent;
import kd.bos.workflow.engine.delegate.event.DelegateTaskEvent;
import kd.bos.workflow.engine.delegate.event.TaskEvent;
import kd.bos.workflow.engine.delegate.event.impl.ActivitiActivityCancelledEventImpl;
import kd.bos.workflow.engine.delegate.event.impl.ActivitiActivityEventImpl;
import kd.bos.workflow.engine.delegate.event.impl.ActivitiAsyncMessageEvent;
import kd.bos.workflow.engine.delegate.event.impl.ActivitiEntityEventImpl;
import kd.bos.workflow.engine.delegate.event.impl.ActivitiEntityExceptionEventImpl;
import kd.bos.workflow.engine.delegate.event.impl.ActivitiEntityWithVariablesEventImpl;
import kd.bos.workflow.engine.delegate.event.impl.ActivitiErrorEventImpl;
import kd.bos.workflow.engine.delegate.event.impl.ActivitiEventImpl;
import kd.bos.workflow.engine.delegate.event.impl.ActivitiMembershipEventImpl;
import kd.bos.workflow.engine.delegate.event.impl.ActivitiMessageEventImpl;
import kd.bos.workflow.engine.delegate.event.impl.ActivitiProcessCancelledEventImpl;
import kd.bos.workflow.engine.delegate.event.impl.ActivitiProcessStartedEventImpl;
import kd.bos.workflow.engine.delegate.event.impl.ActivitiSequenceFlowTakenEventImpl;
import kd.bos.workflow.engine.delegate.event.impl.ActivitiSignalEventImpl;
import kd.bos.workflow.engine.delegate.event.impl.BusinessExecuteEvent;
import kd.bos.workflow.engine.delegate.event.impl.CoordinateTaskEventImpl;
import kd.bos.workflow.engine.delegate.event.impl.CoordinateTransferTaskEventImpl;
import kd.bos.workflow.engine.delegate.event.impl.DelegateTaskEventImpl;
import kd.bos.workflow.engine.delegate.event.impl.ProcessJoinEventImpl;
import kd.bos.workflow.engine.delegate.event.impl.TaskEventImpl;
import kd.bos.workflow.engine.impl.persistence.entity.job.AbstractJobEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.IdentityLinkEntity;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskEntity;
import kd.bos.workflow.engine.repository.ProcessDefinition;
import kd.bos.workflow.engine.runtime.Job;
import kd.bos.workflow.engine.task.Task;
import kd.bos.workflow.engine.task.TaskCoordinateScene;

public class ActivitiEventBuilder {
    private static Log log = LogFactory.getLog(ActivitiEventBuilder.class);

    public static ActivitiEvent createGlobalEvent(ActivitiEventType type) {
        ActivitiEventImpl newEvent = new ActivitiEventImpl(type);
        return newEvent;
    }

    public static ActivitiEvent createEvent(ActivitiEventType type, Long executionId, Long processInstanceId, Long processDefinitionId) {
        ActivitiEventImpl newEvent = new ActivitiEventImpl(type);
        newEvent.setExecutionId(executionId);
        newEvent.setProcessDefinitionId(processDefinitionId);
        newEvent.setProcessInstanceId(processInstanceId);
        return newEvent;
    }

    public static ActivitiEntityEvent createEntityEvent(ActivitiEventType type, Object entity) {
        ActivitiEntityEventImpl newEvent = new ActivitiEntityEventImpl(entity, type);
        ActivitiEventBuilder.populateEventWithCurrentContext(newEvent);
        return newEvent;
    }

    public static TaskEvent createTaskEvent(ActivitiEventType type, TaskEntity taskEntity) {
        TaskEventImpl event = new TaskEventImpl(type, taskEntity);
        return event;
    }

    public static DelegateTaskEvent createDelegateTaskEvent(ActivitiEventType type, TaskEntity taskEntity, List<DelegateTaskEventProperties> eventProperties, String triggerScene) {
        DelegateTaskEventImpl event = new DelegateTaskEventImpl(type, taskEntity, eventProperties, triggerScene);
        return event;
    }

    public static CoordinateTaskEvent createCoordinateTaskEvent(ActivitiEventType type, TaskEntity taskEntity, List<Long> coordinateInitiatorIds, List<Long> coordinateUserIds, ILocaleString coordinateOpinion, TaskCoordinateScene coordinateScene) {
        CoordinateTaskEventImpl event = new CoordinateTaskEventImpl(type, taskEntity, coordinateInitiatorIds, coordinateUserIds, coordinateOpinion, coordinateScene);
        return event;
    }

    public static CoordinateTransferTaskEvent createCoordinateTransferTaskEvent(ActivitiEventType type, TaskEntity taskEntity, List<Long> coordinateUserIds, List<Long> coordinateTransferIds, ILocaleString transferOpinion, TaskCoordinateScene coordinateScene) {
        CoordinateTransferTaskEventImpl event = new CoordinateTransferTaskEventImpl(type, taskEntity, coordinateUserIds, coordinateTransferIds, transferOpinion, coordinateScene);
        return event;
    }

    public static ActivitiProcessStartedEvent createProcessStartedEvent(Object entity, Map variables, boolean localScope) {
        ActivitiProcessStartedEventImpl newEvent = new ActivitiProcessStartedEventImpl(entity, variables, localScope);
        ActivitiEventBuilder.populateEventWithCurrentContext(newEvent);
        return newEvent;
    }

    public static ActivitiEntityWithVariablesEvent createEntityWithVariablesEvent(ActivitiEventType type, Object entity, Map variables, boolean localScope) {
        ActivitiEntityWithVariablesEventImpl newEvent = new ActivitiEntityWithVariablesEventImpl(entity, variables, localScope, type);
        ActivitiEventBuilder.populateEventWithCurrentContext(newEvent);
        return newEvent;
    }

    public static ActivitiSequenceFlowTakenEvent createSequenceFlowTakenEvent(ExecutionEntity executionEntity, ActivitiEventType type, String sequenceFlowId, String sourceActivityId, String sourceActivityName, String sourceActivityType, Object sourceActivityBehavior, String targetActivityId, String targetActivityName, String targetActivityType, Object targetActivityBehavior) {
        ActivitiSequenceFlowTakenEventImpl newEvent = new ActivitiSequenceFlowTakenEventImpl(type);
        if (executionEntity != null) {
            newEvent.setExecutionId(executionEntity.getId());
            newEvent.setProcessInstanceId(executionEntity.getProcessInstanceId());
            newEvent.setProcessDefinitionId(executionEntity.getProcessDefinitionId());
            newEvent.setBusinessKey(executionEntity.getBusinessKey());
        }
        newEvent.setId(sequenceFlowId);
        newEvent.setSourceActivityId(sourceActivityId);
        newEvent.setSourceActivityName(sourceActivityName);
        newEvent.setSourceActivityType(sourceActivityType);
        newEvent.setSourceActivityBehaviorClass(sourceActivityBehavior != null ? sourceActivityBehavior.getClass().getCanonicalName() : null);
        newEvent.setTargetActivityId(targetActivityId);
        newEvent.setTargetActivityName(targetActivityName);
        newEvent.setTargetActivityType(targetActivityType);
        newEvent.setTargetActivityBehaviorClass(targetActivityBehavior != null ? targetActivityBehavior.getClass().getCanonicalName() : null);
        return newEvent;
    }

    public static ActivitiEntityEvent createEntityEvent(ActivitiEventType type, Object entity, Long executionId, Long processInstanceId, Long processDefinitionId) {
        ActivitiEntityEventImpl newEvent = new ActivitiEntityEventImpl(entity, type);
        newEvent.setExecutionId(executionId);
        newEvent.setProcessInstanceId(processInstanceId);
        newEvent.setProcessDefinitionId(processDefinitionId);
        return newEvent;
    }

    public static ActivitiEntityEvent createEntityExceptionEvent(ActivitiEventType type, Object entity, Throwable cause) {
        ActivitiEntityExceptionEventImpl newEvent = new ActivitiEntityExceptionEventImpl(entity, type, cause);
        ActivitiEventBuilder.populateEventWithCurrentContext(newEvent);
        return newEvent;
    }

    public static ActivitiEntityEvent createEntityExceptionEvent(ActivitiEventType type, Object entity, Throwable cause, Long executionId, Long processInstanceId, Long processDefinitionId) {
        ActivitiEntityExceptionEventImpl newEvent = new ActivitiEntityExceptionEventImpl(entity, type, cause);
        newEvent.setExecutionId(executionId);
        newEvent.setProcessInstanceId(processInstanceId);
        newEvent.setProcessDefinitionId(processDefinitionId);
        return newEvent;
    }

    public static ActivitiActivityEvent createActivityEvent(ActivitiEventType type, String activityId, String activityName, Long executionId, Long processInstanceId, Long processDefinitionId, String businessKey, FlowElement flowElement) {
        ActivitiActivityEventImpl newEvent = new ActivitiActivityEventImpl(type);
        newEvent.setActivityId(activityId);
        newEvent.setActivityName(activityName);
        newEvent.setExecutionId(executionId);
        newEvent.setProcessDefinitionId(processDefinitionId);
        newEvent.setProcessInstanceId(processInstanceId);
        newEvent.setBusinessKey(businessKey);
        if (flowElement instanceof FlowNode) {
            FlowNode flowNode = (FlowNode)flowElement;
            newEvent.setActivityType(ActivitiEventBuilder.parseActivityType(flowNode));
            Object behaviour = flowNode.getBehavior();
            if (behaviour != null) {
                newEvent.setBehaviorClass(behaviour.getClass().getCanonicalName());
            }
        }
        return newEvent;
    }

    public static ActivitiActivityEvent createProcessJoinEvent(ActivitiEventType type, String activityId, String activityName, Long executionId, Long processInstanceId, Long processDefinitionId, String businessKey, FlowElement flowElement, String affectNodeId) {
        ProcessJoinEventImpl newEvent = new ProcessJoinEventImpl(type);
        newEvent.setActivityId(activityId);
        newEvent.setActivityName(activityName);
        newEvent.setExecutionId(executionId);
        newEvent.setProcessDefinitionId(processDefinitionId);
        newEvent.setProcessInstanceId(processInstanceId);
        newEvent.setBusinessKey(businessKey);
        newEvent.setAffectNodeId(affectNodeId);
        if (flowElement instanceof FlowNode) {
            FlowNode flowNode = (FlowNode)flowElement;
            newEvent.setActivityType(ActivitiEventBuilder.parseActivityType(flowNode));
            Object behaviour = flowNode.getBehavior();
            if (behaviour != null) {
                newEvent.setBehaviorClass(behaviour.getClass().getCanonicalName());
            }
        }
        return newEvent;
    }

    public static BusinessExecuteEvent createBusinessExecuteEvent(ActivitiEventType type, Long executionId, Long processInstanceId, Long processDefinitionId, Long taskId, String businessKey, String operation, Object params, String msg) {
        BusinessExecuteEvent newEvent = new BusinessExecuteEvent(type);
        newEvent.setExecutionId(executionId);
        newEvent.setProcessDefinitionId(processDefinitionId);
        newEvent.setProcessInstanceId(processInstanceId);
        newEvent.setBusinessKey(businessKey);
        newEvent.setTaskId(taskId);
        newEvent.setOperation(operation);
        newEvent.setParams(params);
        newEvent.setMsg(msg);
        return newEvent;
    }

    protected static String parseActivityType(FlowNode flowNode) {
        String elementType = flowNode.getClass().getSimpleName();
        elementType = elementType.substring(0, 1).toLowerCase() + elementType.substring(1);
        return elementType;
    }

    public static ActivitiActivityCancelledEvent createActivityCancelledEvent(String activityId, String activityName, Long executionId, Long processInstanceId, Long processDefinitionId, String activityType, Object cause) {
        ActivitiActivityCancelledEventImpl newEvent = new ActivitiActivityCancelledEventImpl();
        newEvent.setActivityId(activityId);
        newEvent.setActivityName(activityName);
        newEvent.setExecutionId(executionId);
        newEvent.setProcessDefinitionId(processDefinitionId);
        newEvent.setProcessInstanceId(processInstanceId);
        newEvent.setActivityType(activityType);
        newEvent.setCause(cause);
        return newEvent;
    }

    public static ActivitiCancelledEvent createCancelledEvent(Long executionId, Long processInstanceId, Long processDefinitionId, Object cause, String businessKey) {
        ActivitiProcessCancelledEventImpl newEvent = new ActivitiProcessCancelledEventImpl();
        newEvent.setExecutionId(executionId);
        newEvent.setProcessDefinitionId(processDefinitionId);
        newEvent.setProcessInstanceId(processInstanceId);
        newEvent.setCause(cause);
        newEvent.setBusinessKey(businessKey);
        return newEvent;
    }

    public static ActivitiSignalEvent createSignalEvent(ActivitiEventType type, String activityId, String signalName, Object signalData, Long executionId, Long processInstanceId, Long processDefinitionId, String businessKey) {
        ActivitiSignalEventImpl newEvent = new ActivitiSignalEventImpl(type);
        newEvent.setActivityId(activityId);
        newEvent.setExecutionId(executionId);
        newEvent.setProcessDefinitionId(processDefinitionId);
        newEvent.setProcessInstanceId(processInstanceId);
        newEvent.setSignalName(signalName);
        newEvent.setSignalData(signalData);
        newEvent.setBusinessKey(businessKey);
        return newEvent;
    }

    public static ActivitiMessageEvent createMessageEvent(ActivitiEventType type, String activityId, String messageName, Object payload, Long executionId, Long processInstanceId, Long processDefinitionId, String businessKey) {
        ActivitiMessageEventImpl newEvent = new ActivitiMessageEventImpl(type);
        newEvent.setActivityId(activityId);
        newEvent.setExecutionId(executionId);
        newEvent.setProcessDefinitionId(processDefinitionId);
        newEvent.setProcessInstanceId(processInstanceId);
        newEvent.setMessageName(messageName);
        newEvent.setMessageData(payload);
        newEvent.setBusinessKey(businessKey);
        return newEvent;
    }

    public static ActivitiAsyncMessageEvent createAsyncMessageEvent(ActivitiEventType type, String messageName, Object payload, String activityId, Long executionId, Long processInstanceId, Long processDefinitionId, String businessKey, Long jobId, String entityNumber) {
        ActivitiAsyncMessageEvent newEvent = new ActivitiAsyncMessageEvent(type);
        newEvent.setActivityId(activityId);
        newEvent.setExecutionId(executionId);
        newEvent.setProcessDefinitionId(processDefinitionId);
        newEvent.setProcessInstanceId(processInstanceId);
        newEvent.setMessageName(messageName);
        newEvent.setMessageData(payload);
        newEvent.setBusinessKey(businessKey);
        newEvent.setJobId(jobId);
        newEvent.setEntityNumber(entityNumber);
        return newEvent;
    }

    public static ActivitiAsyncMessageEvent createAsyncMessageEvent(ActivitiEventType type, String messageName, Object payload, String activityId, Long executionId, Long processInstanceId, Long processDefinitionId, String businessKey, Long jobId, String entityNumber, Throwable e) {
        ActivitiAsyncMessageEvent newEvent = ActivitiEventBuilder.createAsyncMessageEvent(type, messageName, payload, activityId, executionId, processInstanceId, processDefinitionId, businessKey, jobId, entityNumber);
        newEvent.setCause(e);
        return newEvent;
    }

    public static ActivitiAsyncMessageEvent createAsyncMessageEvent(ActivitiEventType type, String messageName, Object payload, AbstractJobEntity job) {
        ActivitiAsyncMessageEvent newEvent = new ActivitiAsyncMessageEvent(type);
        newEvent.setActivityId(job == null ? null : job.getElementId());
        newEvent.setExecutionId(job == null ? null : job.getExecutionId());
        newEvent.setProcessDefinitionId(job == null ? null : job.getProcessDefinitionId());
        newEvent.setProcessInstanceId(job == null ? null : job.getProcessInstanceId());
        newEvent.setMessageName(messageName);
        newEvent.setMessageData(payload);
        newEvent.setBusinessKey(job == null ? null : job.getBusinessKey());
        newEvent.setJobId(job == null ? null : job.getId());
        newEvent.setEntityNumber(job == null ? null : job.getEntityNumber());
        ActivitiEventBuilder.setMessagePrimeryInfo(newEvent, job);
        return newEvent;
    }

    public static ActivitiAsyncMessageEvent createAsyncMessageEvent(ActivitiEventType type, String messageName, Object payload, AbstractJobEntity job, Throwable e) {
        ActivitiAsyncMessageEvent newEvent = new ActivitiAsyncMessageEvent(type);
        newEvent.setActivityId(job == null ? null : job.getElementId());
        newEvent.setExecutionId(job == null ? null : job.getExecutionId());
        newEvent.setProcessDefinitionId(job == null ? null : job.getProcessDefinitionId());
        newEvent.setProcessInstanceId(job == null ? null : job.getProcessInstanceId());
        newEvent.setMessageName(messageName);
        newEvent.setMessageData(payload);
        newEvent.setBusinessKey(job == null ? null : job.getBusinessKey());
        newEvent.setCause(e);
        newEvent.setJobId(job == null ? null : job.getId());
        newEvent.setEntityNumber(job == null ? null : job.getEntityNumber());
        ActivitiEventBuilder.setMessagePrimeryInfo(newEvent, job);
        return newEvent;
    }

    public static ActivitiMessageEvent createMessageEvent(ActivitiEventType type, String messageName, Object payload) {
        ActivitiMessageEventImpl newEvent = new ActivitiMessageEventImpl(type);
        newEvent.setMessageName(messageName);
        newEvent.setMessageData(payload);
        return newEvent;
    }

    public static ActivitiErrorEvent createErrorEvent(ActivitiEventType type, String activityId, String errorId, String errorCode, Long executionId, Long processInstanceId, Long processDefinitionId, String businessKey) {
        ActivitiErrorEventImpl newEvent = new ActivitiErrorEventImpl(type);
        newEvent.setActivityId(activityId);
        newEvent.setExecutionId(executionId);
        newEvent.setProcessDefinitionId(processDefinitionId);
        newEvent.setProcessInstanceId(processInstanceId);
        newEvent.setErrorId(errorId);
        newEvent.setErrorCode(errorCode);
        newEvent.setBusinessKey(businessKey);
        return newEvent;
    }

    public static ActivitiMembershipEvent createMembershipEvent(ActivitiEventType type, String groupId, String userId) {
        ActivitiMembershipEventImpl newEvent = new ActivitiMembershipEventImpl(type);
        newEvent.setUserId(userId);
        newEvent.setGroupId(groupId);
        return newEvent;
    }

    protected static void populateEventWithCurrentContext(ActivitiEventImpl event) {
        if (event instanceof ActivitiEntityEvent) {
            Object persistendObject = ((ActivitiEntityEvent)((Object)event)).getEntity();
            if (persistendObject instanceof Job) {
                event.setExecutionId(((Job)persistendObject).getExecutionId());
                event.setProcessInstanceId(((Job)persistendObject).getProcessInstanceId());
                event.setProcessDefinitionId(((Job)persistendObject).getProcessDefinitionId());
                event.setBusinessKey(((Job)persistendObject).getBusinessKey());
            } else if (persistendObject instanceof DelegateExecution) {
                event.setExecutionId(((DelegateExecution)persistendObject).getId());
                event.setProcessInstanceId(((DelegateExecution)persistendObject).getProcessInstanceId());
                event.setProcessDefinitionId(((DelegateExecution)persistendObject).getProcessDefinitionId());
                event.setBusinessKey(((DelegateExecution)persistendObject).getBusinessKey());
            } else if (persistendObject instanceof IdentityLinkEntity) {
                IdentityLinkEntity idLink = (IdentityLinkEntity)persistendObject;
                if (WfUtils.isNotEmpty(idLink.getProcessDefinitionId())) {
                    event.setProcessDefinitionId(idLink.getProcessDefId());
                } else if (idLink.getProcessInstance() != null) {
                    event.setProcessDefinitionId(idLink.getProcessInstance().getProcessDefinitionId());
                    event.setProcessInstanceId(idLink.getProcessInstanceId());
                    event.setExecutionId(idLink.getProcessInstanceId());
                } else if (idLink.getTask() != null) {
                    event.setProcessDefinitionId(idLink.getTask().getProcessDefinitionId());
                    event.setProcessInstanceId(idLink.getTask().getProcessInstanceId());
                    event.setExecutionId(idLink.getTask().getExecutionId());
                    event.setBusinessKey(idLink.getTask().getBusinessKey());
                }
            } else if (persistendObject instanceof Task) {
                event.setProcessInstanceId(((Task)persistendObject).getProcessInstanceId());
                event.setExecutionId(((Task)persistendObject).getExecutionId());
                event.setProcessDefinitionId(((Task)persistendObject).getProcessDefinitionId());
                event.setBusinessKey(((Task)persistendObject).getBusinessKey());
            } else if (persistendObject instanceof ProcessDefinition) {
                event.setProcessDefinitionId(((ProcessDefinition)persistendObject).getId());
            }
        }
    }

    private static void setMessagePrimeryInfo(ActivitiAsyncMessageEvent event, AbstractJobEntity job) {
        if (job == null) {
            return;
        }
        String handleCfg = job.getJobHandlerConfiguration();
        String handlerType = job.getJobHandlerType();
        if (WfUtils.isNotEmpty(handleCfg) && ("async-todo".equals(handlerType) || "async-msg".equals(handlerType))) {
            JSONObject model;
            String modelStr;
            StringBuilder messagePrimary = new StringBuilder();
            JSONObject configuration = null;
            try {
                configuration = JSON.parseObject((String)handleCfg);
            }
            catch (Exception exception) {
                log.error(String.format("ActivitiEventBuilder error: %s", WfUtils.getExceptionStacktrace(exception)));
            }
            if (configuration == null) {
                return;
            }
            if (WfUtils.isNotEmpty(configuration.getString("service"))) {
                messagePrimary.append("#").append(configuration.getString("service"));
            }
            if (WfUtils.isNotEmpty(modelStr = configuration.getString("model")) && "async-todo".equals(handlerType) && (model = JSON.parseObject((String)modelStr)) != null && WfUtils.isNotEmpty(model.getString("state"))) {
                messagePrimary.append("#").append(model.getString("state"));
            }
            event.setPrimaryInfo(messagePrimary.toString());
        }
    }
}

