/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.delegate.event.impl;

import kd.bos.workflow.bpmn.model.BpmnModel;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.delegate.event.ActivitiEntityEvent;
import kd.bos.workflow.engine.delegate.event.ActivitiEvent;
import kd.bos.workflow.engine.delegate.event.ActivitiEventDispatcher;
import kd.bos.workflow.engine.delegate.event.ActivitiEventListener;
import kd.bos.workflow.engine.delegate.event.ActivitiEventType;
import kd.bos.workflow.engine.delegate.event.impl.ActivitiEventSupport;
import kd.bos.workflow.engine.impl.context.Context;
import kd.bos.workflow.engine.impl.util.ProcessDefinitionUtil;
import kd.bos.workflow.engine.repository.ProcessDefinition;

public class ActivitiEventDispatcherImpl
implements ActivitiEventDispatcher {
    protected ActivitiEventSupport eventSupport = new ActivitiEventSupport();
    protected boolean enabled = true;

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void addEventListener(ActivitiEventListener listenerToAdd) {
        this.eventSupport.addEventListener(listenerToAdd);
    }

    @Override
    public void addEventListener(ActivitiEventListener listenerToAdd, ActivitiEventType ... types) {
        this.eventSupport.addEventListener(listenerToAdd, types);
    }

    @Override
    public void addTestingEventListener(ActivitiEventListener listenerToAdd, ActivitiEventType ... types) {
        this.eventSupport.addTestingListener(listenerToAdd, types);
    }

    @Override
    public void removeEventListener(ActivitiEventListener listenerToRemove) {
        this.eventSupport.removeEventListener(listenerToRemove);
    }

    @Override
    public void dispatchEvent(ActivitiEvent event) {
        ActivitiEntityEvent entityEvent;
        if (this.enabled) {
            this.eventSupport.dispatchEvent(event);
        }
        if (event.getType() == ActivitiEventType.ENTITY_DELETED && event instanceof ActivitiEntityEvent && (entityEvent = (ActivitiEntityEvent)event).getEntity() instanceof ProcessDefinition) {
            return;
        }
    }

    protected BpmnModel extractBpmnModelFromEvent(ActivitiEvent event) {
        ProcessDefinition processDefinition;
        BpmnModel result = null;
        if (WfUtils.isNotEmpty(event.getProcessInstanceId()) && WfUtils.isNotEmpty(event.getProcessDefinitionId())) {
            result = ProcessDefinitionUtil.getBpmnModel(event.getProcessDefinitionId(), event.getProcessInstanceId());
        } else if (WfUtils.isNotEmpty(event.getProcessDefinitionId()) && WfUtils.isEmpty(event.getProcessInstanceId()) && (processDefinition = ProcessDefinitionUtil.getProcessDefinition(event.getProcessDefinitionId(), true)) != null) {
            result = Context.getProcessEngineConfiguration().getDeploymentManager().resolveProcessDefinition(processDefinition, event.getProcessInstanceId()).getBpmnModel();
        }
        return result;
    }

    @Override
    public void addTestingPlanEventListener(ActivitiEventListener listenerToAdd, ActivitiEventType ... types) {
        this.eventSupport.addTestingPlanListener(listenerToAdd, types);
    }
}

